# Notes on the implementation
This repository contains implementations of Wordle solving algorithms. The guess words are represented as integer indices in their word lists to allow for fast computation. Early versions using String representation are still present in the codebase but are not maintained.  
An early python version of the Wordle logic and the entropy based heuristic still exists but are neither maintained nor commented.

### Class Structure
The class Wordle.java contains all the relevant logic for playing a game. This includes the handling of word lists and integer representation as well as guess feedback computation and handling.  
The WordleGuessFinder.java class contains the algorithms responsible for finding policies to solve a Wordle game.  
The executable classes WordleTest.java, PlayGame.java, TestPerformance.java and Experiment.java allow the user to interact with the Wordle game and the implemented Wordle soving algorithms.


# Usage of executable classes
To compile the implementations navigate to src/ and run "javac wordle/java/*.java.  
To run specific files navigate to src/ and run the file with java wordle.java.fileName agruments.  
  
### WordleTest
A class that allows for manual testing of the Wordle game logic by allowing the player to play a command line based Wordle game with a random solution.  
Navigate to src/ and run with: java wordle.java.WordleTest
### PlayGame
A class that allows for automatic gameplay of a single Wordle game with specified solution. To switch the used algrithm change the comment in the while loop of the playInt mehtod of the PlayGame class.  
Navigate to src/ and run with: java wordle.java.PlayGame solutionWord, where "solutionWord" is the solution word to the game.
### TestPerformance
A class to evaluate the average score of an algorithm across all possible Wordle games. To swith the used algorithm change the comment in the while loop of the testInt method of the TestPerformance class.  
Navigate to src/ and run with: java wordle.java.TestPerformance
### Experiment
A class to carry out experiments on the scicore cluster. Computes average score of specified algorithm according to command line arguments.  
Navigate to src/ and run with: java wordle.java.Experiment wordIndex algorithm nBest nRollouts nTasksForUCT optimize
 * wordIndex: opening guess according to firstGuess list (slurm task id)
 * algorithm: "heuristic", "rollout", "uct"
 * nBest: number of most promising guesses to be considered for rollout and uct
 * nRollouts: number of rollouts for uct
 * nTasksForUCT: split up run on cluster because uct's long runtime
 * optimize: apply optimizations for rollout and uct, experiments were only run with optimized uct  


## License

This project is licensed under the MIT License – see the [LICENSE](LICENSE) file for details.
