import os

import matplotlib.pyplot as plt
from prettytable import PrettyTable

import commandLine
import itemDataInterpreter
import solutionOperator

pathRecipe = os.path.dirname(__file__) + "/Recipe.txt"
worker = 0
nrOfBuildings = 0
fuelType = ''
items = []


def test():
    for item in items:
        objectValue, variablesValue, duration = solutionOperator.solveDistribution(item.name, items, True, True)
        printDistributionResult(objectValue, variablesValue, duration)


def solveDistribution(item, isLin, isCon):
    if itemInItems(item):
        objectValue, variablesValue, duration = solutionOperator.solveDistribution(item, items, isLin, isCon)
        printDistributionResult(objectValue, variablesValue, duration)
    else:
        print("Item { " + item + " } is not in items.")


def coinRanking(isLin, isCon):
    listOfLists = solutionOperator.calculateCoinRanking(items, isLin, isCon)

    for list in listOfLists:
        print("\nRanking " + getColor(solutionOperator.getItem(list[0][0], items).coinType) + " coins:")
        printRanking(list)


def plotCoinRanking():
    listOfListsLin = solutionOperator.calculateCoinRanking(items, True, True)
    listOfListsInt = solutionOperator.calculateCoinRanking(items, False, True)

    x = []
    y1 = []
    for list in listOfListsLin:
        for item in list:
            x.append(item[0])
            y1.append(item[5])

    y2 = y1.copy()
    for list in listOfListsInt:
        for item in list:
            pos = x.index(item[0])
            y2[pos] = item[5]

    plt.scatter(x, y1, label="LinCon", marker='o', color='red')
    plt.scatter(x, y2, label="IntCon", marker='.', color='blue')

    frame1 = plt.gca()
    frame1.axes.xaxis.set_ticklabels([])
    plt.xlabel("Items")

    plt.title("RankingLinCon vs. RankingIntCon")

    plt.legend()

    plt.show()


def maxCoin(color, isLin):
    coinsSum, workerSum, variables, time = solutionOperator.calculateMaxCoinDistribution(items, color, isLin)
    printMaxCoins(coinsSum, workerSum, variables, time)


def balanceCoins(balance, isLin):
    listOfInfos = solutionOperator.calculateBalanceCoins(items, balance, isLin)
    printBalance(listOfInfos)


def getColor(coinType):
    switcher = {
        "FFFFC000": "yellow",
        "FFC00000": "red",
        "FF0070C0": "blue",
        "FF7030A0": "purple"
    }
    return switcher.get(coinType)


def itemInItems(itemName):
    for item in items:
        if item.name == itemName:
            return True
    return False


def xStr(s):
    if s is None:
        return ''
    return str(s)


def printData():
    t = PrettyTable(
        ['Building', 'Item', 'unit/sec', 'sec/unit', 'coin/unit', 'Coin Type', 'Consumption Time', 'Category',
         'Recipes'])
    for item in items:
        t.add_row([item.building, item.name, xStr(item.unitsPerSecond), xStr(
            item.secondsPerUnit), str(item.coinPerUnit), item.coinType, xStr(item.consumptionTime), item.category,
                   item.recipe])
    print(t)


def printItemList():
    t = PrettyTable(['Item name'])
    for item in items:
        t.add_row([item.name])
    print(t)


def printRanking(list):
    t = PrettyTable(['Nr.', 'Item name', 'Objective value', 'Coins per unit', 'Coins per sec.', 'Nr. of used Worker',
                     'Coins/sec. per worker.'])
    for index, item in enumerate(list):
        t.add_row([index + 1, item[0], item[1], item[2], item[3], item[4], item[5]])
    print(t)


def printDistributionResult(objectValue, variablesValue, duration):
    if objectValue is None: return
    print('Solution:')
    print('Objective value =', objectValue)
    for var in variablesValue:
        print(" <-- ".join(var[0]) + ' =', var[1])

    print('\nAdvanced usage:')
    print('Problem solved in %f milliseconds' % duration)


def printMaxCoins(coinsSum, workerSum, variables, time):
    if coinsSum is None: return
    print('Solution:')
    print('Total coins =', coinsSum)
    print('Worker used =', workerSum)

    print('\nAdvanced usage:')
    print('Problem solved in %f milliseconds' % time)

    t = PrettyTable(['Item name', 'Coins per sec.', 'Nr. of used Worker', 'Faktor'])
    for item in variables:
        t.add_row([item[0], item[1], item[2], item[3]])
    print(t)


def printBalance(listOfInfos):
    if listOfInfos[0] is None: return
    print('Solution:')
    print('Total coins =', listOfInfos[0])
    print('Worker used =', listOfInfos[3])

    print('\nAdvanced usage:')
    print('Problem solved in %f milliseconds' % listOfInfos[4])

    for i, colorList in enumerate(listOfInfos[2]):
        colorName = getColor(solutionOperator.getItem(colorList[0][0][0], items).coinType)
        print("\nDetail Information about " + colorName + ":")
        print('Total ' + colorName + ' coins =', listOfInfos[1][i])
        print('Total worker used for ' + colorName + ' =', colorList[1])

        t = PrettyTable(['Item name', 'Coins per sec.', 'Nr. of used Worker', 'Faktor'])
        for item in colorList[0]:
            t.add_row([item[0], item[1], item[2], item[3]])
        print(t)


if __name__ == '__main__':
    try:
        items = itemDataInterpreter.generateItems()
    except:
        print("Error by generating items from: {" + "Database.xlsx" + "}.")
        quit()
    commandLine.repl()
