from openpyxl import load_workbook

import main


class Item:
    building = ''
    name = ''
    unitsPerSecond = 0.0
    secondsPerUnit = 0.0
    coinPerUnit = 0
    coinType = ''
    consumptionTime = 0
    category = ''

    recipe = []

    def __init__(self, building, name, unitsPerSecond, secondsPerUnit, coinPerUnit, coinType, consumptionTime, category,
                 recipe):
        self.building = building
        self.name = name
        self.unitsPerSecond = unitsPerSecond
        self.secondsPerUnit = secondsPerUnit
        self.coinPerUnit = coinPerUnit
        self.coinType = coinType
        self.consumptionTime = consumptionTime
        self.category = category
        self.recipe = recipe


dest_filename = 'Database.xlsx'


def generateItems():
    try:
        wb = load_workbook(dest_filename)
    except:
        print("Permission denied: {" + "Database.xlsx" + "}.")
        quit()
    ws = wb.active
    building = ''
    name = ''
    unitsPerSecond = 0.0
    secondsPerUnit = 0.0
    coinPerUnit = 0
    coinType = ''
    consumptionTime = 0
    category = ''
    recipe = []

    items = []

    for row_cells in ws.iter_rows(min_row=2):
        for i, cell in enumerate(row_cells):
            if i == 0 and cell.value is not None:
                building = cell.value.strip()
                break
            if i == 1:
                name = cell.value.strip()
            elif i == 2:
                unitsPerSecond = cell.value
            elif i == 3:
                secondsPerUnit = cell.value
            elif i == 4:
                coinPerUnit = cell.value
                if cell.value is not None:
                    coinType = cell.font.color.rgb
            elif i == 5:
                consumptionTime = cell.value
            elif i == 6:
                if cell.value is not None:
                    category = cell.value.strip()
            elif i > 6:
                if cell.value is None:
                    break
                recipe.append(cell.value.strip())
        if name != '' and name is not None:
            items.append(
                Item(building, name, unitsPerSecond, secondsPerUnit, coinPerUnit, coinType, consumptionTime, category,
                     recipe))
            name = ''
            recipe = []
            coinType = ''
            category = ''
    main.items = items
