import sys

import main

if sys.version > '3': raw_input = input
inLine = ""

commands = []


def classifyHouseLv(houseLv):
    switcher = {
        1: 2,
        2: 4,
        3: 6,
        4: 8,
        5: 10
    }
    return switcher.get(houseLv)


def classifyFuelType(fuelType):
    switcher = {
        "wood": "Wood",
        "coal": "Coal",
        "magma": "Magma",
        "fertilizer": "Fertilizer"
    }
    return switcher.get(fuelType.lower())


def classifyColorBalance(index):
    switcher = {
        0: "yellow",
        1: "red",
        2: "blue",
        3: "purple"
    }
    return switcher.get(index)


def classifyColor(color):
    switcher = {
        "yellow": "yellow",
        "red": "red",
        "blue": "blue",
        "purple": "purple"
    }
    return switcher.get(color.lower())


def getUserInfo():
    houseLv = None
    main.fuelType = None
    main.nrOfBuildings = None

    while houseLv is None:
        try:
            houseLv = classifyHouseLv(int(raw_input("Specify House lv.: ").strip()))
            if houseLv is None:
                print(" Invalid Number. Possible House lv.: 1, 2, 3, 4, 5")
        except:
            print("Invalid Input. House lv. should be a number. Try again.")
            print("Possible House lv.: 1, 2, 3, 4, 5")

    while main.nrOfBuildings is None:
        try:
            main.nrOfBuildings = int(raw_input("Specify Nr. of buildings: "))
            main.worker = 4 + main.nrOfBuildings * houseLv
        except:
            print("Invalid Input. Nr. of buildings has to be a number. Try again.")

    while main.fuelType is None:
        main.fuelType = classifyFuelType(raw_input("Specify Fuel Type: "))
        if main.fuelType is None:
            print("Possible Fuel Type.: Wood, Coal, Magma, Fertilizer")


def getCoinsWeight():
    list = [None, None, None, None]
    print("\nPls enter balance of Coins: ")
    for index, _ in enumerate(list):
        while list[index] is None:
            try:
                list[index] = int(raw_input("Specify balance of " + classifyColorBalance(index) + " coins: "))
            except:
                print("Invalid Input. Balance has to be a number. Try again.")
    return list


def getCoinColor():
    color = None
    while color is None:
        color = classifyColor(raw_input("Specify color: "))
        if color is None:
            print("Possible colors: yellow, red, blue, purple")
    return color


def handleInput(input):
    if input in commands:

        if input == "exit":
            print("See you.")
            sys.exit()

        elif input == "help":
            printCommands()

        elif input == "data":
            main.printData()

        elif input == "items":
            main.printItemList()

        elif input == "solve":
            main.test()

        elif input == "plot":
            main.plotCoinRanking()

        elif input == "solveLin":
            item = raw_input("Pls enter itemName: ")
            main.solveDistribution(item, True, False)

        elif input == "solveInt":
            item = raw_input("Pls enter itemName: ")
            main.solveDistribution(item, False, False)

        elif input == "solveLinCon":
            item = raw_input("Pls enter itemName: ")
            main.solveDistribution(item, True, True)

        elif input == "solveIntCon":
            item = raw_input("Pls enter itemName: ")
            main.solveDistribution(item, False, True)

        elif input == "coinRankingLin":
            main.coinRanking(True, False)

        elif input == "coinRankingInt":
            main.coinRanking(False, False)

        elif input == "coinRankingLinCon":
            main.coinRanking(True, True)

        elif input == "coinRankingIntCon":
            main.coinRanking(False, True)

        elif input == "maxCoinInt":
            main.maxCoin(getCoinColor(), False)

        elif input == "maxCoinLin":
            main.maxCoin(getCoinColor(), True)

        elif input == "weightedCoinsInt":
            main.balanceCoins(getCoinsWeight(), False)

        elif input == "weightedCoinsLin":
            main.balanceCoins(getCoinsWeight(), True)

    else:
        print("Unknown command: {" + input + "}.")


def createCommands():
    commands.append("help")
    commands.append("exit")
    commands.append("data")
    commands.append("items")
    commands.append("solve")
    commands.append("plot")
    commands.append("solveLin")
    commands.append("solveInt")
    commands.append("solveLinCon")
    commands.append("solveIntCon")
    commands.append("coinRankingLin")
    commands.append("coinRankingInt")
    commands.append("coinRankingLinCon")
    commands.append("coinRankingIntCon")
    commands.append("maxCoinInt")
    commands.append("maxCoinLin")
    commands.append("weightedCoinsInt")
    commands.append("weightedCoinsLin")


def printCommands():
    for command in commands:
        print(command)
    print()


def repl():
    global inLine
    createCommands()
    print("Welcome to FactoryTown Solver \n")
    print("Enter user information:")
    getUserInfo()
    print("\nEnter a command:")
    while True:
        if inLine == "":
            inLine = raw_input("Factory Town>")
            handleInput(inLine.strip())
            inLine = ""
