#! /usr/bin/env python


import os
import json
from collections import defaultdict

from pprint import pprint

properties = None
foundProperties = False

for fname in os.listdir('.'):    # change directory as needed
    if os.path.isfile(fname):    # make sure it's a file, not a directory entry
        with open(fname) as f:   # open file
            for line in f:       # process line by line
                if 'BaselSlurmEnvironment' in line:    # search for string
                    if os.path.basename(__file__) != fname:
                        fname = fname[:-3]
                        print 'found string in file %s' %fname
                        properties = json.load(open("./data/" + fname + "-eval/properties"))
                        print "trying to open file: " + "./data/" + fname + "-eval/properties"
                        foundProperties = True
                        break
                        
    if foundProperties:
        break


# inith[domain][problem][algorithm]
nested_dict = lambda: defaultdict(nested_dict)
data = nested_dict()

# value is somehow the same as run in lab reports
# key contains algorithm, domain and problem concatenated by "-"
for key, value in properties.iteritems(): 
    if value["algorithm"] == "timerep2sync":
        data[value["domain"]][value["id"][2]]["timerep2sync"] = value
    elif value["algorithm"] == "timerep4sync":
        data[value["domain"]][value["id"][2]]["timerep4sync"] = value
    elif value["algorithm"] == "timerep6sync":
        data[value["domain"]][value["id"][2]]["timerep6sync"] = value
    elif value["algorithm"] == "timerep10sync":
        data[value["domain"]][value["id"][2]]["timerep10sync"] = value
    elif value["algorithm"] == "timerep15sync":
        data[value["domain"]][value["id"][2]]["timerep15sync"] = value
    elif value["algorithm"] == "timerep2syncip":
        data[value["domain"]][value["id"][2]]["timerep2syncip"] = value
    elif value["algorithm"] == "timerep6syncip":
        data[value["domain"]][value["id"][2]]["timerep6syncip"] = value
    elif value["algorithm"] == "stateequ":
        data[value["domain"]][value["id"][2]]["stateequ"] = value
    elif value["algorithm"] == "lmcut":
        data[value["domain"]][value["id"][2]]["lmcut"] = value

# problemsSolved[algorithm]            
problemsSolved = dict()
# problemsImproved[algorithm]
problemsImproved = dict()
overallCount = 0
count = 0
mySum = 0
perfectCount = 0

for curDom in data.keys():
    for curPro in data[curDom].keys():
        for curAlg in data[curDom][curPro].keys():
            problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
            if curAlg == "timerep2sync" and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] < data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    print "fail"
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    count = count + 1
                    problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - (data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                overallCount = overallCount + 1
                if data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                    perfectCount = perfectCount + 1

print "timerep2vsstateequ"
print "count", count
print "avg", mySum/overallCount
print "overallCount", overallCount
print "overall domains:", len(data), " domains improved:", len(problemsImproved)
print "perfect count:", perfectCount

# problemsSolved[algorithm]            
problemsSolved = dict()
# problemsImproved[algorithm]
problemsImproved = dict()
overallCount = 0
count = 0
mySum = 0
perfectCount = 0

for curDom in data.keys():
    for curPro in data[curDom].keys():
        for curAlg in data[curDom][curPro].keys():
            problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
            if curAlg == "timerep6sync" and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    count = count + 1
                    problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - (data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                overallCount = overallCount + 1
                if data[curDom][curPro]["stateequ"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                    perfectCount = perfectCount + 1

print "timerep6vsstateequ"
print "count", count
print "avg", mySum/overallCount
print "overallCount", overallCount
print "overall domains:", len(data), " domains improved:", len(problemsImproved)
print "perfect count:", perfectCount

# problemsSolved[algorithm]            
problemsSolved = dict()
# problemsImproved[algorithm]
problemsImproved = dict()
overallCount = 0
count = 0
mySum = 0
perfectCount = 0

for curDom in data.keys():
    for curPro in data[curDom].keys():
        for curAlg in data[curDom][curPro].keys():
            problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
            if curAlg == "timerep10sync" and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > data[curDom][curPro]["timerep6sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    count = count + 1
                    problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - (data[curDom][curPro]["timerep6sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                overallCount = overallCount + 1
                if data[curDom][curPro]["timerep6sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                    perfectCount = perfectCount + 1

print "timerep10vs6"
print "count", count
print "avg", mySum/overallCount
print "overallCount", overallCount
print "overall domains:", len(data), " domains improved:", len(problemsImproved)
print "perfect count:", perfectCount

# problemsSolved[algorithm]            
problemsSolved = dict()
# problemsImproved[algorithm]
problemsImproved = dict()
overallCount = 0
count = 0
mySum = 0
perfectCount = 0

for curDom in data.keys():
    for curPro in data[curDom].keys():
        for curAlg in data[curDom][curPro].keys():
            problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
            if curAlg == "timerep15sync" and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > data[curDom][curPro]["timerep10sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    count = count + 1
                    problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - (data[curDom][curPro]["timerep10sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                overallCount = overallCount + 1
                if data[curDom][curPro]["timerep10sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                    perfectCount = perfectCount + 1

print "timerep15vs10"
print "count", count
print "avg", mySum/overallCount
print "overallCount", overallCount
print "overall domains:", len(data), " domains improved:", len(problemsImproved)
print "perfect count:", perfectCount

# problemsSolved[algorithm]            
problemsSolved = dict()
# problemsImproved[algorithm]
problemsImproved = dict()
overallCount = 0
count = 0
mySum = 0
perfectCount = 0

for curDom in data.keys():
    for curPro in data[curDom].keys():
        for curAlg in data[curDom][curPro].keys():
            problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
            if curAlg == "timerep2syncip" and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > data[curDom][curPro]["timerep2sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    count = count + 1
                    problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - (data[curDom][curPro]["timerep2sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                overallCount = overallCount + 1
                if data[curDom][curPro]["timerep2sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                    perfectCount = perfectCount + 1

print "timerep2ip"
print "count", count
print "avg", mySum/overallCount
print "overallCount", overallCount
print "overall domains:", len(data), " domains improved:", len(problemsImproved)
print "perfect count:", perfectCount

# problemsSolved[algorithm]            
problemsSolved = dict()
# problemsImproved[algorithm]
problemsImproved = dict()
overallCount = 0
count = 0
mySum = 0
perfectCount = 0

for curDom in data.keys():
    for curPro in data[curDom].keys():
        for curAlg in data[curDom][curPro].keys():
            problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
            if curAlg == "timerep6syncip" and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > data[curDom][curPro]["timerep6sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                    count = count + 1
                    problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - (data[curDom][curPro]["timerep6sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                overallCount = overallCount + 1
                if data[curDom][curPro]["timerep6sync"]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                    perfectCount = perfectCount + 1

print "timerep6ip"
print "count", count
print "avg", mySum/overallCount
print "overallCount", overallCount
print "overall domains:", len(data), " domains improved:", len(problemsImproved)
print "perfect count:", perfectCount

