#! /usr/bin/env python

"""Solve some tasks with A* and the LM-Cut heuristic."""

from __future__ import division
import os
import os.path
import platform
import re
import suites
import matplotlib as mpl

from lab.environments import BaselSlurmEnvironment

from downward.experiment import Experiment
from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport

exp = Experiment('data/combined-plotter')
exp.add_fetcher('../myexp32-iterative-final/data/time-heuristic-iterative_30m_unit_cost-eval')
exp.add_fetcher('../myexp28-fixed-unit-cost/data/time-heuristic-less-timesteps-eval')
exp.add_fetcher('../myexp25-iterative-30-mins-new/data/time-heuristic-iterative_30m_unit_cost-eval')

# myreport.html
exp.add_report(
    AbsoluteReport(attributes=["Unexplained Errors", "Info", "Summary", "cost", "coverage",
        "evaluations_until_last_jump", "expansions_until_last_jump", "generated_until_last_jump", 
        "initial_h_value", "memory", "reopened_until_last_jump", "search_time", "error", "my_timespent",
        "my_lpVars", "my_percInit", "my_lpCons", "my_peakMem", "my_tsrequired"]), outfile='myreport.html')
        
lmcut_costs = dict()

def init_lmcut_costs(run):
    if run["algorithm"] == "2-lmcut":
        if "plan_length" in run:
            lmcut_costs[run["domain"] + run["id"][2]] = run["plan_length"]
    return run


#exp.add_fetcher(name='parse-again', parsers=['./ownLogParser.py'])

def getPercentage(run):
    if(run["domain"] + run["id"][2] in lmcut_costs) and "initial_h_value" in run:
        run["percentage"] = run["initial_h_value"] / lmcut_costs[run["domain"] + run["id"][2]]
        if run["initial_h_value"] / lmcut_costs[run["domain"] + run["id"][2]] > 1:
            print "fail in", run["domain"], " ", run["problem"]
        return run
    return False


exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["1-ianot","timerep15sync"], xscale='linear', yscale='linear', filter=[init_lmcut_costs,getPercentage], get_category=lambda run1,run2:run1["domain"]+run1["problem"] if run1["percentage"] != run2["percentage"] else "uninteresting", format="png"),
    outfile='final_scatter_fixed15_dynamic.png')
        

exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["3-iatvrd", "2-stateequ"], xscale='linear', yscale='linear', filter=[init_lmcut_costs,getPercentage], format="tex"),
    outfile='FINALX_scatter_MATU_stateequ.tex')

exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["3-iatvrd", "2-lmcut"], xscale='linear', yscale='linear', filter=[init_lmcut_costs,getPercentage], format="tex"),
    outfile='FINALX_scatter_MATU_lmcut.tex')

exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["3-iaip", "3-iatvrd"], xscale='linear', yscale='linear', filter=[init_lmcut_costs,getPercentage], format="tex"),
    outfile='FINALX_scatter_ip_not.tex')

exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["3-iatvrd", "timerep6sync"], xscale='linear', yscale='linear', filter=[init_lmcut_costs,getPercentage], format="tex"),
    outfile='FINALX_scatter_MATU_6.tex')

# Parse the commandline and show or run experiment steps.
exp.run_steps()
