#! /usr/bin/env python

"""Solve some tasks with A* and the LM-Cut heuristic."""

from __future__ import division
import os
import os.path
import platform
import re
import suites
import matplotlib as mpl

from lab.environments import BaselSlurmEnvironment

from downward.experiment import Experiment
from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport

exp = Experiment('data/combined-plotter')
exp.add_fetcher('../myexp21-fixed-full/data/time-heuristic-full-5min-reformed-eval')
exp.add_fetcher('../myexp24-less-time-steps/data/time-heuristic-less-timesteps-eval')

# myreport.html
exp.add_report(
    AbsoluteReport(attributes=["Unexplained Errors", "Info", "Summary", "cost", "coverage",
        "evaluations_until_last_jump", "expansions_until_last_jump", "generated_until_last_jump", 
        "initial_h_value", "memory", "reopened_until_last_jump", "search_time", "error", "my_timespent",
        "my_lpVars", "my_percInit", "my_lpCons", "my_peakMem", "my_tsrequired"]), outfile='myreport.html')
        
lmcut_costs = dict()

def init_lmcut_costs(run):
    if run["algorithm"] == "lmcut":
        if "cost" in run:
            lmcut_costs[run["domain"] + run["id"][2]] = run["cost"]
    return run


#exp.add_fetcher(name='parse-again', parsers=['./ownLogParser.py'])

def getPercentage(run):
    if(run["domain"] + run["id"][2] in lmcut_costs) and "initial_h_value" in run:
        run["percentage"] = run["initial_h_value"] / lmcut_costs[run["domain"] + run["id"][2]]
        if run["initial_h_value"] / lmcut_costs[run["domain"] + run["id"][2]] > 1:
            print "fail in", run["domain"], " ", run["problem"]
        return run
    return False


# Percentage scatter plot of ATUR 10 and ATUR 15 vs one less time steps
exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["timerep10sync", "timerep6sync"], filter=[init_lmcut_costs,getPercentage], format="tex", xscale='linear', yscale='linear'),
    outfile='final_scatter_ATUR10_perc.tex')

exp.add_report(
    ScatterPlotReport(
        attributes=["percentage"], filter_algorithm=["timerep15sync", "timerep10sync"], filter=[init_lmcut_costs,getPercentage], format="tex", xscale='linear', yscale='linear'),
    outfile='final_scatter_ATUR15_perc.tex')

# Parse the commandline and show or run experiment steps.
exp.run_steps()
