#! /usr/bin/env python

"""Solve some tasks with A* and the LM-Cut heuristic."""

from __future__ import division
import os
import os.path
import platform
import re
import suites
import matplotlib as mpl

from lab.environments import BaselSlurmEnvironment

from downward.experiment import Experiment
from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport

exp = Experiment('data/combined-results')
exp.add_fetcher('../myexp01/data/lmcut-eval')
exp.add_fetcher('../myexp02/data/lmcut-eval')
exp.add_report(AbsoluteReport())

# myreport.html
exp.add_report(
    AbsoluteReport(attributes=["Unexplained Errors", "Info", "Summary", "cost", "coverage",
        "evaluations_until_last_jump", "expansions_until_last_jump", "generated_until_last_jump", 
        "initial_h_value", "memory", "reopened_until_last_jump", "search_time", "error", "my_timespent",
        "my_lpVars", "my_percInit", "my_lpCons", "my_peakMem", "my_tsrequired"]), outfile='myreport.html')

# Parse the commandline and show or run experiment steps.
exp.run_steps()
