#! /usr/bin/env python

from __future__ import division
import os
import json
from collections import defaultdict


from pprint import pprint

properties = None
foundProperties = False

for fname in os.listdir('.'):    # change directory as needed
    if os.path.isfile(fname):    # make sure it's a file, not a directory entry
        with open(fname) as f:   # open file
            for line in f:       # process line by line
                if 'BaselSlurmEnvironment' in line:    # search for string
                    if os.path.basename(__file__) != fname:
                        fname = fname[:-3]
                        print 'found string in file %s' %fname
                        properties = json.load(open("./data/" + fname + "-eval/properties"))
                        print "trying to open file: " + "./data/" + fname + "-eval/properties"
                        foundProperties = True
                        break
                        
    if foundProperties:
        break


# inith[domain][problem][algorithm]
nested_dict = lambda: defaultdict(nested_dict)
data = nested_dict()

def readProperties(properties):
    # value is somehow the same as run in lab reports
    # key contains algorithm, domain and problem concatenated by "-"
    for key, value in properties.iteritems():
        data[value["domain"]][value["id"][2]][value["algorithm"]] = value

readProperties(properties)

#print "Read file with more time steps"
# read other properties file
#readProperties(json.load(open("../myexp24-less-time-steps/data/time-heuristic-less-timesteps-eval/properties24")))

def calculatePercentages(base, competitor):
    # problemsSolved[algorithm]            
    problemsSolved = dict()
    # problemsImproved[algorithm]
    problemsImproved = dict()
    overallCount = 0
    count = 0
    mySum = 0
    perfectCount = 0

    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
                if curAlg == base and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                    if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > \
                        data[curDom][curPro][competitor]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                        count = count + 1
                        problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                    mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - \
                         (data[curDom][curPro][competitor]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                    overallCount = overallCount + 1
                    if data[curDom][curPro][competitor]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                        perfectCount = perfectCount + 1

    print base, " vs ", competitor
    print "count of improvements", count
    print "avg improvement", mySum/overallCount
    print "overall count of possible samples (where all required values are there)", overallCount
    print "overall domains:", len(data), " domains improved:", len(problemsImproved)
    print "already perfect count:", perfectCount
    print
    
def makeIAComparison(base, comparison):
    attributesToCompare = ["my_lpCons", "my_lpVars", "my_peakMem", "my_percInit", "my_timespent", "my_tsrequired", "search_time"]
    numberOfComparisons = [0] * len(attributesToCompare)
    sumCompare = [0] * len(attributesToCompare)
    sumBase = [0] * len(attributesToCompare)
    sumPerc = [0] * len(attributesToCompare)
    
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                for index, attribute in enumerate(attributesToCompare):
                    if curAlg == base and attribute in data[curDom][curPro][curAlg] and attribute in data[curDom][curPro][comparison]:
                        numberOfComparisons[index] += 1
                        sumCompare[index] += data[curDom][curPro][comparison][attribute]
                        sumBase[index] += data[curDom][curPro][curAlg][attribute]
                        sumPerc[index] += data[curDom][curPro][curAlg][attribute]/data[curDom][curPro][comparison][attribute]
    print "TV Comparison:"
    for index, attribute in enumerate(attributesToCompare):
        print attribute
        print "numberofComparisons", numberOfComparisons[index]
        print "Compare average (1): ", sumCompare[index]/numberOfComparisons[index]
        print "Base average (2): ", sumBase[index]/numberOfComparisons[index]
        print "(1)/(2): ",  (sumBase[index]/numberOfComparisons[index]) / (sumCompare[index]/numberOfComparisons[index])
        print "Averaged percentage of base/compare: ", sumPerc[index]/numberOfComparisons[index]
        print
print "No TV vs TV"
#makeIAComparison("1-iatv", "1-ianot")

#print "No RD vs RD"
#makeIAComparison("1-iard", "1-ianot")

def makeTVTimeComparisonFor0246():
    algos = ["timerep0sync", "timerep2sync", "timerep4sync", "timerep6sync"]
    attributesToCompare = ["my_lpCons", "my_lpVars", "my_peakMem", "my_percInit", "my_timespent", "search_time"]
    numberOfComparisons = [0] * len(attributesToCompare)
    sumNonOpt = [0] * len(attributesToCompare)
    sumOpt = [0] * len(attributesToCompare)
    sumPerc = [0] * len(attributesToCompare)
    
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                for index, attribute in enumerate(attributesToCompare):
                    if curAlg in algos and attribute in data[curDom][curPro][curAlg] and attribute in data[curDom][curPro][curAlg + "nottv"]:
                        numberOfComparisons[index] += 1
                        sumNonOpt[index] += data[curDom][curPro][curAlg + "nottv"][attribute]
                        sumOpt[index] += data[curDom][curPro][curAlg][attribute]
                        sumPerc[index] += data[curDom][curPro][curAlg][attribute]/data[curDom][curPro][curAlg + "nottv"][attribute] # opt/unopt
    print "TV Comparison:"
    for index, attribute in enumerate(attributesToCompare):
        print attribute
        print "numberofComparisons", numberOfComparisons[index]
        print "Non-opt average (1): ", sumNonOpt[index]/numberOfComparisons[index]
        print "Opt average (2): ", sumOpt[index]/numberOfComparisons[index]
        print "(1)/(2): ",  (sumOpt[index]/numberOfComparisons[index]) / (sumNonOpt[index]/numberOfComparisons[index])
        print "Averaged percentage of opt/non-opt: ", sumPerc[index]/numberOfComparisons[index]
        print

def makeIPTimeComparison(base, competitor):
    numberOfComparisons = 0
    sumBase = 0
    sumIP = 0
    sumPerc = 0
    
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                if curAlg == base and "my_timespent" in data[curDom][curPro][curAlg] and "my_timespent" in data[curDom][curPro][competitor]:
                    numberOfComparisons += 1
                    sumBase += data[curDom][curPro][curAlg]["my_timespent"]
                    sumIP += data[curDom][curPro][competitor]["my_timespent"]
                    sumPerc += data[curDom][curPro][curAlg]["my_timespent"]/data[curDom][curPro][competitor]["my_timespent"]
    print base, " vs ", competitor
    print "numberofComparisons", numberOfComparisons
    print "Base average time spent calculating initial h (1): ", sumBase/numberOfComparisons
    print "Competitor average time spent calculating initial h (2): ", sumIP/numberOfComparisons
    print "(1)/(2): ",  (sumBase/numberOfComparisons) / (sumIP/numberOfComparisons)
    print "Averaged percentage of base vs competitor: ", sumPerc/numberOfComparisons
    print


#calculatePercentages("timerep2sync", "stateequ")


#calculatePercentages("timerep6sync", "stateequ")


#calculatePercentages("timerep10sync", "timerep6sync")


#calculatePercentages("timerep15sync", "timerep10sync")


#calculatePercentages("timerep2syncip", "timerep2sync")


#calculatePercentages("timerep6syncip", "timerep6sync")


# IP non-IP time difference
#makeIPTimeComparisonFor0246()



#algos = ["timerep0sync", "timerep2sync", "timerep4sync", "timerep6sync"]
#for algo in algos:
#    makeIPTimeComparison(algo, algo + "ip")

# Make TV comparison
#makeTVTimeComparisonFor0246()

def analyzeAttribute(algo, value):
    mysum = 0
    count = 0
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                if curAlg == algo and value in data[curDom][curPro][curAlg]:
                    mysum += data[curDom][curPro][curAlg][value]
                    count += 1
    print "averaged init time", mysum/count
    
#print "non-ip"
#analyzeAttribute("1-ianot", "my_tsrequired")
#print "ip"
#analyzeAttribute("1-iaip", "my_tsrequired")

def analyzetsrequired(algo):
    mysum = 0
    mylengthsum = 0
    count = 0
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                if curAlg == algo and "my_tsrequired" in data[curDom][curPro][curAlg] and "plan_length" in data[curDom][curPro]["2-lmcut"]:
                    mysum += data[curDom][curPro][curAlg]["my_tsrequired"]
                    mylengthsum += data[curDom][curPro]["2-lmcut"]["plan_length"]
                    count += 1
    print "averaged ts required", mysum/count
    print "averaged plan length", mylengthsum/count

#analyzetsrequired("1-ianot")
#analyzetsrequired("1-iaip")

def analyzerdtv():
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                if curAlg == "3-iatvrd" and "initial_h_value" in data[curDom][curPro][curAlg]:
                    for otherAlgo in data[curDom][curPro].keys():
                        if otherAlgo != "3-iatvrd" and "ip" not in otherAlgo and "initial_h_value" in data[curDom][curPro][otherAlgo]:
                            print data[curDom][curPro]["3-iatvrd"]["initial_h_value"], " ", data[curDom][curPro][otherAlgo]["initial_h_value"]
                            if data[curDom][curPro]["3-iatvrd"]["initial_h_value"] != data[curDom][curPro][otherAlgo]["initial_h_value"]:
                                print "fail"

analyzerdtv()
'''
Backup - probably not needed anymore
if value["algorithm"] == "timerep2sync":
        data[value["domain"]][value["id"][2]]["timerep2sync"] = value
    elif value["algorithm"] == "timerep4sync":
        data[value["domain"]][value["id"][2]]["timerep4sync"] = value
    elif value["algorithm"] == "timerep6sync":
        data[value["domain"]][value["id"][2]]["timerep6sync"] = value
    elif value["algorithm"] == "timerep10sync":
        data[value["domain"]][value["id"][2]]["timerep10sync"] = value
    elif value["algorithm"] == "timerep15sync":
        data[value["domain"]][value["id"][2]]["timerep15sync"] = value
    elif value["algorithm"] == "timerep2syncip":
        data[value["domain"]][value["id"][2]]["timerep2syncip"] = value
    elif value["algorithm"] == "timerep6syncip":
        data[value["domain"]][value["id"][2]]["timerep6syncip"] = value
    elif value["algorithm"] == "stateequ":
        data[value["domain"]][value["id"][2]]["stateequ"] = value
    elif value["algorithm"] == "lmcut":
        data[value["domain"]][value["id"][2]]["lmcut"] = value
'''


