#! /usr/bin/env python

from __future__ import division
import os
import json
from collections import defaultdict


from pprint import pprint

properties = None
foundProperties = False

for fname in os.listdir('.'):    # change directory as needed
    if os.path.isfile(fname):    # make sure it's a file, not a directory entry
        with open(fname) as f:   # open file
            for line in f:       # process line by line
                if 'BaselSlurmEnvironment' in line:    # search for string
                    if os.path.basename(__file__) != fname:
                        fname = fname[:-3]
                        print 'found string in file %s' %fname
                        properties = json.load(open("./data/" + fname + "-eval/properties"))
                        print "trying to open file: " + "./data/" + fname + "-eval/properties"
                        foundProperties = True
                        break
                        
    if foundProperties:
        break


# inith[domain][problem][algorithm]
nested_dict = lambda: defaultdict(nested_dict)
data = nested_dict()

def readProperties(properties):
    # value is somehow the same as run in lab reports
    # key contains algorithm, domain and problem concatenated by "-"
    for key, value in properties.iteritems():
        data[value["domain"]][value["id"][2]][value["algorithm"]] = value

readProperties(properties)

print "Read file with more time steps"
# read other properties file
readProperties(json.load(open("../myexp24-less-time-steps/data/time-heuristic-less-timesteps-eval/properties24")))

def calculatePercentages(base, competitor):
    # problemsSolved[algorithm]            
    problemsSolved = dict()
    # problemsImproved[algorithm]
    problemsImproved = dict()
    overallCount = 0
    count = 0
    mySum = 0
    perfectCount = 0

    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                problemsSolved[curAlg] = problemsSolved.get(curAlg, 0) + 1
                if curAlg == base and "initial_h_value" in data[curDom][curPro][curAlg] and "cost" in data[curDom][curPro]["lmcut"]:
                    if data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] > \
                        data[curDom][curPro][competitor]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]:
                        count = count + 1
                        problemsImproved[curDom] = problemsImproved.get(curDom, 0) + 1
                    mySum += (data[curDom][curPro][curAlg]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"]) - \
                         (data[curDom][curPro][competitor]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"])
                    overallCount = overallCount + 1
                    if data[curDom][curPro][competitor]["initial_h_value"]/data[curDom][curPro]["lmcut"]["cost"] == 1:
                        perfectCount = perfectCount + 1

    print base, " vs ", competitor
    print "count of improvements", count
    print "avg improvement", mySum/overallCount
    print "overall count of possible samples (where all required values are there)", overallCount
    print "overall domains:", len(data), " domains improved:", len(problemsImproved)
    print "already perfect count:", perfectCount
    print

#calculatePercentages("timerep2sync","")

def makeIPTimeComparisonFor0246():
    algos = ["timerep0sync", "timerep2sync", "timerep4sync", "timerep6sync"]
    
    numberOfComparisons = 0
    sumNonIP = 0
    sumIP = 0
    sumPerc = 0
    
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                if curAlg in algos and "my_timespent" in data[curDom][curPro][curAlg] and "my_timespent" in data[curDom][curPro][curAlg + "ip"]:
                    numberOfComparisons += 1
                    sumNonIP += data[curDom][curPro][curAlg]["my_timespent"]
                    sumIP += data[curDom][curPro][curAlg + "ip"]["my_timespent"]
                    sumPerc += data[curDom][curPro][curAlg]["my_timespent"]/data[curDom][curPro][curAlg + "ip"]["my_timespent"]
    print "Time averages over 0, 2, 4 and 6 times steps"
    print "numberofComparisons", numberOfComparisons
    print "NON-IP average time spent calculating initial h (1): ", sumNonIP/numberOfComparisons
    print "IP average time spent calculating initial h (2): ", sumIP/numberOfComparisons
    print "(1)/(2): ",  (sumNonIP/numberOfComparisons) / (sumIP/numberOfComparisons)
    print "Averaged percentage of non-IP vs IP: ", sumPerc/numberOfComparisons
    print

def makeTVTimeComparisonFor0246():
    algos = ["timerep0sync", "timerep2sync", "timerep4sync", "timerep6sync"]
    attributesToCompare = ["my_lpCons", "my_lpVars", "my_peakMem", "my_percInit", "my_timespent", "search_time"]
    numberOfComparisons = [0] * len(attributesToCompare)
    sumNonOpt = [0] * len(attributesToCompare)
    sumOpt = [0] * len(attributesToCompare)
    sumPerc = [0] * len(attributesToCompare)
    
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                for index, attribute in enumerate(attributesToCompare):
                    if curAlg in algos and attribute in data[curDom][curPro][curAlg] and attribute in data[curDom][curPro][curAlg + "nottv"]:
                        numberOfComparisons[index] += 1
                        sumNonOpt[index] += data[curDom][curPro][curAlg + "nottv"][attribute]
                        sumOpt[index] += data[curDom][curPro][curAlg][attribute]
                        sumPerc[index] += data[curDom][curPro][curAlg][attribute]/data[curDom][curPro][curAlg + "nottv"][attribute] # opt/unopt
    print "TV Comparison:"
    for index, attribute in enumerate(attributesToCompare):
        print attribute
        print "numberofComparisons", numberOfComparisons[index]
        print "Non-opt average (1): ", sumNonOpt[index]/numberOfComparisons[index]
        print "Opt average (2): ", sumOpt[index]/numberOfComparisons[index]
        print "(1)/(2): ",  (sumOpt[index]/numberOfComparisons[index]) / (sumNonOpt[index]/numberOfComparisons[index])
        print "Averaged percentage of opt/non-opt: ", sumPerc[index]/numberOfComparisons[index]
        print

def makeIPTimeComparison(base, competitor):
    numberOfComparisons = 0
    sumBase = 0
    sumIP = 0
    sumPerc = 0
    
    for curDom in data.keys():
        for curPro in data[curDom].keys():
            for curAlg in data[curDom][curPro].keys():
                if curAlg == base and "my_timespent" in data[curDom][curPro][curAlg] and "my_timespent" in data[curDom][curPro][competitor]:
                    numberOfComparisons += 1
                    sumBase += data[curDom][curPro][curAlg]["my_timespent"]
                    sumIP += data[curDom][curPro][competitor]["my_timespent"]
                    sumPerc += data[curDom][curPro][curAlg]["my_timespent"]/data[curDom][curPro][competitor]["my_timespent"]
    print base, " vs ", competitor
    print "numberofComparisons", numberOfComparisons
    print "Base average time spent calculating initial h (1): ", sumBase/numberOfComparisons
    print "Competitor average time spent calculating initial h (2): ", sumIP/numberOfComparisons
    print "(1)/(2): ",  (sumBase/numberOfComparisons) / (sumIP/numberOfComparisons)
    print "Averaged percentage of base vs competitor: ", sumPerc/numberOfComparisons
    print


calculatePercentages("timerep2sync", "stateequ")


calculatePercentages("timerep6sync", "stateequ")


calculatePercentages("timerep10sync", "timerep6sync")


calculatePercentages("timerep15sync", "timerep10sync")


#calculatePercentages("timerep2syncip", "timerep2sync")


#calculatePercentages("timerep6syncip", "timerep6sync")


# IP non-IP time difference
#makeIPTimeComparisonFor0246()



#algos = ["timerep0sync", "timerep2sync", "timerep4sync", "timerep6sync"]
#for algo in algos:
#    makeIPTimeComparison(algo, algo + "ip")

# Make TV comparison
#makeTVTimeComparisonFor0246()

'''
Backup - probably not needed anymore
if value["algorithm"] == "timerep2sync":
        data[value["domain"]][value["id"][2]]["timerep2sync"] = value
    elif value["algorithm"] == "timerep4sync":
        data[value["domain"]][value["id"][2]]["timerep4sync"] = value
    elif value["algorithm"] == "timerep6sync":
        data[value["domain"]][value["id"][2]]["timerep6sync"] = value
    elif value["algorithm"] == "timerep10sync":
        data[value["domain"]][value["id"][2]]["timerep10sync"] = value
    elif value["algorithm"] == "timerep15sync":
        data[value["domain"]][value["id"][2]]["timerep15sync"] = value
    elif value["algorithm"] == "timerep2syncip":
        data[value["domain"]][value["id"][2]]["timerep2syncip"] = value
    elif value["algorithm"] == "timerep6syncip":
        data[value["domain"]][value["id"][2]]["timerep6syncip"] = value
    elif value["algorithm"] == "stateequ":
        data[value["domain"]][value["id"][2]]["stateequ"] = value
    elif value["algorithm"] == "lmcut":
        data[value["domain"]][value["id"][2]]["lmcut"] = value
'''


