#! /usr/bin/env python

from lab.parser import Parser
import sys
import re

Patterns = [('my_timespent', re.compile(r'^Time spent finding heuristic value for first state: (.+)\.'), int),
('my_lpVars', re.compile(r'^LP variables: (.+)'), int),
('my_percInit', re.compile(r'^Percentage of the time spent with initialization of first LP with calculated optimal solution: (.+) %\.'), float),
('my_lpCons', re.compile(r'^LP constraints: (.+)'), int),
('my_peakMem', re.compile(r'^Peak memory in KB: (.+)\.'), int)]

def searchPatterns(content, props):
    lines = content.splitlines()
    for line in lines:
        for name, pattern, cast in Patterns:
            match = pattern.search(line)
            if not match:
                continue
            print name, cast(match.group(1))
            break

parser = Parser()

parser.add_function(searchPatterns)

parser.parse()

