#! /usr/bin/env python

"""Solve some tasks with A* and the LM-Cut heuristic."""

import os
import os.path
import platform

from lab.environments import BaselSlurmEnvironment

from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport


SUITE = ['floortile-opt14-strips', 'freecell',
'ged-opt14-strips', 'grid', 'gripper', 'hiking-opt14-strips',
'logistics98', 'miconic', 'movie', 'mprime', 'mystery', 'openstacks-opt08-strips',
'parcprinter-opt11-strips', 'parking-opt14-strips', 'pathways-noneg',
'pegsol-opt11-strips', 'pipesworld-notankage', 'pipesworld-tankage',
'psr-small', 'rovers', 'satellite',
'scanalyzer-opt11-strips', 'sokoban-opt11-strips',
'storage', 'tetris-opt14-strips',
'tidybot-opt14-strips', 'tpp',
'transport-opt14-strips', 'trucks-strips', 'visitall-opt14-strips',
'woodworking-opt11-strips', 'zenotravel']
ENV = BaselSlurmEnvironment()
REPO = "/infai/oldphi00/master_code"
BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]

exp = FastDownwardExperiment(environment=ENV)
exp.add_suite(BENCHMARKS_DIR, SUITE)
exp.add_algorithm(
    'stateEqu', REPO, 'default', ['--search', 'astar(operatorcounting([state_equation_constraints()]))'], driver_options=["--search-time-limit", "1m", '--build', 'release64'], build_options=["release64"])
exp.add_algorithm(
    'timeit', REPO, 'default', ['--search', 'astar(time(ia=true))'], driver_options=["--search-time-limit", "1m", '--build', 'release64'], build_options=["release64"])
exp.add_algorithm(
    'timerep0', REPO, 'default', ['--search', 'astar(time(wr=true, ts=0))'], driver_options=["--search-time-limit", "10m", '--build', 'release64'], build_options=["release64"])
exp.add_algorithm(
    'timerep5', REPO, 'default', ['--search', 'astar(time(wr=true, ts=5))'], driver_options=["--search-time-limit", "1m", '--build', 'release64'], build_options=["release64"])
exp.add_algorithm(
    'timerep10', REPO, 'default', ['--search', 'astar(time(wr=true, ts=10))'], driver_options=["--search-time-limit", "1m", '--build', 'release64'], build_options=["release64"])
exp.add_algorithm(
    'lmcut', REPO, 'default', ['--search', 'astar(lmcut())'], driver_options=["--search-time-limit", "1m", '--build', 'release64'], build_options=["release64"])

# Make a report (AbsoluteReport is the standard report).
exp.add_report(
    AbsoluteReport())

# Compare the number of expansions in a scatter plot.
exp.add_report(
    ScatterPlotReport(
        attributes=["expansions"], filter_algorithm=["timeit", "timerep0"]),
    outfile='scatterplot.png')

# Parse the commandline and show or run experiment steps.
exp.run_steps()
