#ifndef MS_CP_MSCP_HEURISTIC_H
#define MS_CP_MSCP_HEURISTIC_H

#include "../heuristic.h"

#include "../merge_and_shrink/cp_mas.h"
#include "../merge_and_shrink/distances.h"
#include "../merge_and_shrink/factored_transition_system.h"
#include "../merge_and_shrink/shrink_strategy.h"
#include "../merge_and_shrink/transition_system.h"

#include "../utils/logging.h"

#include <queue>

namespace options {
class Options;
}

namespace mscp_heuristic {
// comparison function that takes into account an extra characterizing integer value
struct compare_pairs {
    bool operator()(const std::pair<double, std::pair<int, int>>& a, const std::pair<double, std::pair<int, int>>& b) const {
        return a.first < b.first;
    }
};

using PriorityQueue = std::priority_queue<std::pair<double, std::pair<int, int>>, std::vector<std::pair<double, std::pair<int, int>>>, compare_pairs>;

class MSCPHeuristic : public Heuristic {
    utils::Verbosity verbosity;
    merge_and_shrink::FactoredTransitionSystem fts;
    const double main_loop_max_time;
    const int merge_threshold;
    int max_states;
    int max_states_before_merge;
    bool check_shrink;
    bool perform_shrink;
    std::shared_ptr<merge_and_shrink::CostPartitioningFactory> cp_factory;
    std::unique_ptr<merge_and_shrink::CostPartitioning> cost_partitioning;
    int quality_threshold;
    int i_dist;
    int j_dist;
    int merged_dist;
    bool consider_size;
    bool nonlinear_merge;
    const bool prune;
    int max_occ_min_threshold;
    int prune_counter = 0;
    int shrink_counter = 0;
    std::shared_ptr<merge_and_shrink::ShrinkStrategy> shrink_strategy;

    void prepare_priority_queue(PriorityQueue &pq_merged_systems, const std::vector<int> &label_costs);
    void extend_priority_queue(PriorityQueue &pq_merged_systems, const std::vector<int> &label_costs, int last_merged_index);

protected:
    virtual int compute_heuristic(const GlobalState &global_state) override;

public:
    explicit MSCPHeuristic(const options::Options &opts);

    virtual bool dead_ends_are_reliable() const override;
};
}

#endif
