#! /usr/bin/env python

import glob
import os
import platform

from downward.reports.absolute import AbsoluteReport
from lab.experiment import Experiment
from downward.reports.scatter import ScatterPlotReport

def has_cost(run):
	return "cost" in run

def rename_alg(run):
	run["algorithm"] = "lmcut2"
	l = run["id"]
	l[0] = "lmcut2"
	run["id"] = l
	return run

exp = Experiment('')
exp.add_fetcher('init2',filter=rename_alg)
exp.add_fetcher('init',filter=has_cost)
exp.add_report(ScatterPlotReport(filter_domain=['airport',
     'blocks',
     'depot', 'driverlog',
    'freecell',
    'grid', 'gripper', 'hiking-opt14-strips',
    'logistics00', 'logistics98', 'miconic', 'movie', 'mprime',
    'mystery',
     'openstacks-strips', 'organic-synthesis-opt18-strips',
    'pipesworld-notankage', 'pipesworld-tankage', 'psr-small', 'rovers',
    'satellite',
    'snake-opt18-strips', 'storage',
    'termes-opt18-strips',
    'tidybot-opt11-strips', 'tidybot-opt14-strips', 'tpp',
    'trucks-strips', 'visitall-opt11-strips',
    'visitall-opt14-strips', 'zenotravel'], 
    show_missing=False,
    relative=False, 
    attributes=["expansions"],
    filter_algorithm=["lmcut", "lmcut2"], 
    format="tex" ))

exp.run_steps()
