#! /usr/bin/env python
# -*- coding: utf-8 -*-

from lab.environments import LocalEnvironment, BaselSlurmEnvironment
from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport

import os
import os.path
import platform

# change these variables to fit your environemnt
REPO_DIR = '../../'
HELVE_DIR = os.path.expanduser('~/helve')
BENCHMARKS_DIR = os.path.expanduser('~/downward-benchmarks-unitcost')
SUITE = [ 'airport',
     'blocks', 
     'depot', 'driverlog',
    'freecell',
    'grid', 'gripper', 'hiking-opt14-strips',
    'logistics00', 'logistics98', 'miconic', 'movie', 'mprime',
    'mystery',  
     'openstacks-strips', 'organic-synthesis-opt18-strips',
    'pipesworld-notankage', 'pipesworld-tankage', 'psr-small', 'rovers',
    'satellite', 
    'snake-opt18-strips', 'storage',
    'termes-opt18-strips',
    'tidybot-opt11-strips', 'tidybot-opt14-strips', 'tpp',
    'trucks-strips', 'visitall-opt11-strips',
    'visitall-opt14-strips', 'zenotravel']


def fd_finished(run):
    if 'error' not in run:
        print(run['run_dir'])
        run['fd_finished'] = 0
    elif(run['error'] == 'search-unsolvable-incomplete'):
        run['fd_finished'] = 1
    else:
        run['fd_finished'] = 0
    return run

def verify_timeout(run):    
    if('verify_returncode' in run and run['verify_returncode'] == 7):
        run['verify_timeout'] = 1
    else:
        run['verify_timeout'] = 0
    return run
def verify_oom(run):
    if('verify_returncode' in run and run['verify_returncode'] == 6):
        run['verify_oom'] = 1
    else:
        run['verify_oom'] = 0
    return run
def verify_finished(run):
    if(not run['unsolv_is_certificate'] == 'unknown'):
        run['verify_finished'] = 1
    else:
        run['verify_finished'] = 0 
    return run
def invalid_certificate(run):
    if(run['unsolv_is_certificate'] == 'no'):
        run['invalid_certificate'] = 1
    else:
        run['invalid_certificate'] = 0
    return run
def valid_certificate(run):
    if(run['unsolv_is_certificate'] == 'yes'):
        run['valid_certificate'] = 1
    else:
        run['valid_certificate'] = 0
    return run



NODE = platform.node()
if NODE.endswith(".scicore.unibas.ch") or NODE.endswith(".cluster.bc2.ch"):
    ENV = BaselSlurmEnvironment(partition="infai_1", email="esther.mugdan@unibas.ch")
else:
    SUITE = ['airport',
     'blocks',
     'depot', 'driverlog',
    'freecell',
    'grid', 'gripper', 'hiking-opt14-strips',
    'logistics00', 'logistics98', 'miconic', 'movie', 'mprime',
    'mystery',
     'openstacks-strips', 'organic-synthesis-opt18-strips',
    'pipesworld-notankage', 'pipesworld-tankage', 'psr-small', 'rovers',
    'satellite',
    'snake-opt18-strips', 'storage',
    'termes-opt18-strips',
    'tidybot-opt11-strips', 'tidybot-opt14-strips', 'tpp',
    'trucks-strips', 'visitall-opt11-strips',
    'visitall-opt14-strips', 'zenotravel' ]

    ENV = LocalEnvironment(processes=2)


exp = FastDownwardExperiment(environment=ENV)

# Add default parsers to the experiment.
exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)

exp.add_suite(BENCHMARKS_DIR, SUITE)

#A* with merge-and-shrink heuristic
exp.add_algorithm('mas', REPO_DIR, 'HEAD',
                 ["--search", "astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear()), shrink_strategy=shrink_bisimulation(), label_reduction=exact(before_shrinking=true,before_merging=false), prune_unreachable_states=false), unsolv_verification=proof, unsolv_directory=$TMPDIR)"],
                 driver_options=["--translate-time-limit", "30m" ]) 
#A* with h^max heuristic
exp.add_algorithm('hmax', REPO_DIR, 'HEAD',
                 ["--search", "astar(hmax(), unsolv_verification=proof, unsolv_directory=$TMPDIR)"],
                 driver_options=["--translate-time-limit", "30m"])

# Run verifier
exp.add_resource('helve_executable', os.path.join(HELVE_DIR, 'helve'))
exp.add_command('helve', ['./{helve_executable}', 'task.txt', "$TMPDIR/proof.txt", '--timeout=14400'], time_limit=14500, memory_limit=2000)

# Add script to print filesize
exp.add_resource('filesize_script', 'print_filesize')
exp.add_command('print-filesize', ['./{filesize_script}'])

# Add custom parser only after filesize is printed, as it parses for this
exp.add_parser('myparser.py')

#steps
exp.add_step("build", exp.build)
exp.add_step("start", exp.start_runs)
exp.add_fetcher(name="fetch")
exp.add_report(AbsoluteReport(filter=[fd_finished, verify_timeout, verify_oom, verify_finished, invalid_certificate, valid_certificate], attributes=['fd_finished', 'verify_timeout','verify_oom', 'verify_finished', 'invalid_certificate', 'valid_certificate', 'run_dir', 'error', 'raw_memory', 'evaluated', 'dead_ends', 'expansions', 'search_time', 'total_time', 'unsolv_total_time', 'unsolv_actions', 'unsolv_is_certificate', 'unsolv_memory', 'unsolv_abort_memory', 'unsolv_abort_time', 'unsolv_exit_message', 'verify_returncode', 'certificate_size_kb']), outfile=os.path.join(exp.eval_dir, 'report.html'))


exp.run_steps()

