import fileinput
import sys


def cast_task(f, cost: int):
    costObjects = " 0"
    costInits = " (COST 0)"

    for i in range(1, cost):
        costObjects = costObjects + " " + str(i)
        costInits = costInits + " (NEXT " + str(i - 1) + " " + str(i) + ")"

    for line in f:
        if "(:objects" in line:
            print(line.replace("(:objects",
                               "(:objects" + costObjects), end='')
        elif "(:INIT" in line:
            print(line.replace("(:INIT",
                               "(:INIT" + costInits), end='')
        elif "(:init" in line:
            print(line.replace("(:init",
                               "(:init" + costInits), end='')
        else:
            print(line, end='')


def cast_domain(f):
    costPredicates = " (cost ?c) (next ?c ?n)"
    costParameters = "(?c ?n "
    costEffects = " (cost ?n) (not(cost ?c))"

    searchPre = False
    searchEff = False
    for line in f:
        if "(:predicates" in line:
            print(line.replace("(:predicates",
                               "(:predicates" + costPredicates), end='')
        elif ":parameters" in line:
            print(line.replace("(",
                               costParameters), end='')
        elif ":precondition" in line:
            if "(and" in line:
                print(line.replace("(and",
                                   "(and" + costPredicates), end='')
            elif "(" in line and ")" in line and not "and" in line:  # no and just one precondition
                print(line.replace(")", "))").replace("(",
                                                      "(and" + costPredicates + " ("), end='')
            else:
                print(line, end="")
                searchPre = True
        elif ":effect" in line:
            if "(and" in line:
                print(line.replace("(and",
                                   "(and" + costEffects), end='')
            elif "(" in line and ")" in line and not "and" in line:  # no and just one precondition
                print(line.replace(")", "))").replace("(",
                                                      "(and" + costEffects + " ("), end='')
            else:
                print(line, end="")
                searchEff = True
        elif "(and" in line:
            if searchPre:
                print(line.replace("(and",
                                   "(and" + costPredicates), end='')
                searchPre = False
            elif searchEff:
                print(line.replace("(and",
                                   "(and" + costEffects), end='')
                searchEff = False

        else:
            print(line, end='')


# Press the green button in the gutter to run the script.
# must be executed in downward-benchmarks
# argument must be cost_extract.txt

# reads task path and domain path from cost_extract.txt and modifies task and domain file if task has a cost c
# modified tasks contain cost restriction of c-1
if __name__ == '__main__':
    domainlist = []
    args = sys.argv[1:]
    f = open(args[0], mode="r")
    for line in f.readlines():
        l = line.split(" ")
        domain = fileinput.FileInput(l[0], inplace=True, backup='.bak')
        task = fileinput.FileInput(l[1], inplace=True, backup='.bak')
        tasktext = open(l[1], mode="r").read()
        domaintext = open(l[0], mode="r").read()
        try:
            cost = int(float(l[2]))
        except ValueError:
            cost = None
        if cost is not None and "(COST 0)" not in tasktext:
            print("casting", l[1])
            cast_task(task, cost)
            if l[0] not in domainlist and "(cost ?c) (next ?c ?n)" not in domaintext:
                print("casting", l[0])
                cast_domain(domain)

        domainlist.append(l[0])
