import os
import sys
import json


def find_domain_filename(directory, task):
    """
    Find domain filename for the given task using automatic naming rules.
    """
    task_name, ext = os.path.splitext(task)

    domain_basenames = [
        "domain.pddl",
        task_name + "-domain" + ext,
        task_name.split('-')[0] + "-domain.pddl",  # for airport
        "domain_" + task,
        "domain-" + task,
    ]

    for domain_basename in domain_basenames:
        domain_filename = os.path.join(directory, domain_basename)
        if os.path.exists(domain_filename):
            return domain_filename

    return None


# Press the green button in the gutter to run the script.
# must be executed in downward-benchmarks
# argument must be properties file

# takes properties file, extracts task path, domain path and cost for each task and writes it to cost_extract.txt
if __name__ == '__main__':

    args = sys.argv[1:]
    f = open(args[0])
    data = json.load(f)

    out = open("cost_extract.txt", mode="w")

    for d in data:
        content = data[d]
        taskfile = content["id"][2]
        directory = content["id"][1]
        domainfile = find_domain_filename(directory, taskfile)
        out.write(domainfile + " " + os.path.join(directory, taskfile) + " " + str(content.get("cost") or "none") + "\n")

    f.close()
    out.close()
