# TODO
# - Place this file in the same directory as the experiment script(s)
# - Adapt the patterns below and rename the parser class appropriately
# - Add the following lines to the experiment script(s):
#   from <name_of_this_file> import LandmarkParser
#   exp.add_parser(LandmarkParser())
# - Define the relevant Attribute object(s) in the experiment script(s), e.g.
#   Attribute("lmgraph_generation_time", min_wins=False)
# - Add the Attribute object(s) to the list of attributes to be shown in the
#   report

import re

from lab.parser import Parser

PATTERNS = [
    ["abstraction_steps", r"Abstraction took (\d+) steps", int],
    ["num_abstracted_variables", r"Abstracted (\d+) safe variables.", int],
    ["num_remaining_variables", r"(\d+) variables remain.", int],
    ["num_composite_operators_created", r"Created (\d+) composite operators.", int],
    ["num_original_operators", r"Original task had: (\d+) operators", int],  
    ["abstraction_percentage_variables", r"Abstracted (.+)% of variables", float],
    ["abstraction_percentage_atoms", r"Abstracted (.+)% of atoms", float],
    ["abstraction_time", r"Abstraction time: (.+)s", float],
    ["composition_time", r"Composition time: (.+)s", float],
    ["refinement_time", r"Refinement time: (.+)s", float],
    ["simplified_plan_length", r"> Simplified Plan Length: (\d+)", int],
    ["refined_plan_length", r"Refined Plan Length: (\d+)", int]
]

class SafeAbstractionParser(Parser):
    def __init__(self):
        Parser.__init__(self)
        for name, pattern, typ in PATTERNS:
            self.add_pattern(name, pattern, type=typ)
