#! /usr/bin/env python
# -*- coding: utf-8 -*-

import common_setup
from common_setup import IssueConfig, IssueExperiment

import os

from lab.reports import Attribute
from lab.reports import arithmetic_mean

from downward.reports.absolute import AbsoluteReport

from lab.environments import LocalEnvironment, BaselSlurmEnvironment

# TODO: Enter git commit hash of code version you want to use.
REVISIONS = ["21a6bb5d1a163f7d06de4997d5b89641e3bde3be"]
DRIVER_OPTIONS = ["--overall-time-limit", "5m"]
CONFIGS = [
    common_setup.IssueConfig(
        "Safe Abstraction (Abstraction, Composition(Soft))",
        [
                "--search",
                "--all_soft",
                "let(hlm,landmark_sum(lm_factory=lm_reasonable_orders_hps(lm_rhw()),transform=adapt_costs(one),pref=false), let(hff, ff(transform=adapt_costs(one)), lazy_greedy([hff,hlm],preferred=[hff,hlm], cost_type=one,reopen_closed=false)))"        
        ],
        driver_options=DRIVER_OPTIONS,
    ),
    common_setup.IssueConfig(
        "Safe Abstraction (Abstraction, Composition)",
        [
		"--search",  
		"--all", 
		"let(hlm,landmark_sum(lm_factory=lm_reasonable_orders_hps(lm_rhw()),transform=adapt_costs(one),pref=false), let(hff, ff(transform=adapt_costs(one)), lazy_greedy([hff,hlm],preferred=[hff,hlm], cost_type=one,reopen_closed=false)))"
	],
        driver_options=DRIVER_OPTIONS,
    ),    
    common_setup.IssueConfig(
        "Safe Abstraction (Abstraction)",
       	[
		"--search",  
		"--abstraction", 
		"let(hlm,landmark_sum(lm_factory=lm_reasonable_orders_hps(lm_rhw()),transform=adapt_costs(one),pref=false), let(hff, ff(transform=adapt_costs(one)), lazy_greedy([hff,hlm],preferred=[hff,hlm], cost_type=one,reopen_closed=false)))"
	],
        driver_options=DRIVER_OPTIONS
    ),
    common_setup.IssueConfig(
        "No Safe Abstraction",
        [
		"--search",  
		"--none", 
		"let(hlm,landmark_sum(lm_factory=lm_reasonable_orders_hps(lm_rhw()),transform=adapt_costs(one),pref=false), let(hff, ff(transform=adapt_costs(one)), lazy_greedy([hff,hlm],preferred=[hff,hlm], cost_type=one,reopen_closed=false)))"
	],
        driver_options=DRIVER_OPTIONS,
    )
]

BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]

if common_setup.is_test_run():
    SUITE = common_setup.IssueExperiment.DEFAULT_TEST_SUITE
    ENVIRONMENT = LocalEnvironment(processes=2)
else:
    # TODO: Make sure suite is approriate.
    SUITE = common_setup.DEFAULT_SATISFICING_SUITE
    ENVIRONMENT = BaselSlurmEnvironment(
        # Choose between infai_1 or infai_2. Either works but stick to a
        # single partition when results have to be comparable.
        partition="infai_2",
        # TODO: Change this to your own email, you will get notified when your
        # jobs finish.
        email="gian.moser@unibas.ch", 
        export=["PATH", "DOWNWARD_BENCHMARKS"],
    )

exp = common_setup.IssueExperiment(
    # TODO: Adapt this path. It should probably be "../.." if you put this
    # script into experiments/something in the downward root directory (same
    # as the Downward Lab tutorial).
    os.environ["DOWNWARD_REPO"],
    revisions=REVISIONS,
    configs=CONFIGS,
    environment=ENVIRONMENT,
)

exp.add_suite(BENCHMARKS_DIR, SUITE)

exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)

from Safe_Abstraction_Parser_2024_12_11  import SafeAbstractionParser
exp.add_parser(SafeAbstractionParser())
# TODO: Add custom parser if necessary.


ATTRIBUTES = IssueExperiment.DEFAULT_TABLE_ATTRIBUTES
ATTRIBUTES += [Attribute("abstraction_steps", min_wins=False, absolute=True)]
ATTRIBUTES += [Attribute("num_abstracted_variables", min_wins=False, absolute=True)]
ATTRIBUTES += [Attribute("num_remaining_variables", min_wins=True, absolute=True)]
ATTRIBUTES += [Attribute("num_composite_operators_created", min_wins=False, absolute=True)]
ATTRIBUTES += [Attribute("num_original_operators", min_wins=False, absolute=True)]
ATTRIBUTES += [Attribute("abstraction_percentage_variables", min_wins=False, absolute=True, function=arithmetic_mean)]
ATTRIBUTES += [Attribute("abstraction_percentage_atoms", min_wins=False, absolute=True, function=arithmetic_mean)]

# TODO: Define custom attributes if necessary.
# ATTRIBUTES += [Attribute("my_attribute", absolute=True, min_wins=False)]


exp.add_step("build", exp.build)
exp.add_step("start", exp.start_runs)
exp.add_step("parse", exp.parse)
exp.add_fetcher(name="fetch")
exp.add_report(AbsoluteReport(attributes=ATTRIBUTES))

exp.run_steps()
