#include "yahsp_eager_search.h"
#include "search_common.h"

#include "../plugins/plugin.h"

using namespace std;

namespace plugin_yahsp_eager {
class YahspEagerSearchFeature
    : public plugins::TypedFeature<SearchAlgorithm, yahsp_eager_search::YahspEagerSearch> {
public:
    YahspEagerSearchFeature() : TypedFeature("yahspeager") {
        document_title("Yahsp Eager best-first search");
        document_synopsis("");

        add_option<shared_ptr<standard_scalar_open_list::YahspOpenList>>("open", "open list");
        add_option<bool>(
            "reopen_closed",
            "reopen closed nodes",
            "false");
        add_option<shared_ptr<Evaluator>>(
            "f_eval",
            "set evaluator for jump statistics. "
            "(Optional; if no evaluator is used, jump statistics will not be displayed.)",
            plugins::ArgumentInfo::NO_DEFAULT);
        add_list_option<shared_ptr<Evaluator>>(
            "preferred",
            "use preferred operators of these evaluators",
            "[]");
        yahsp_eager_search::add_eager_search_options_to_feature(
            *this, "eager");
    }

    virtual shared_ptr<yahsp_eager_search::YahspEagerSearch>
    create_component(const plugins::Options &opts) const override {
        return plugins::make_shared_from_arg_tuples<yahsp_eager_search::YahspEagerSearch>(
            opts.get<shared_ptr<standard_scalar_open_list::YahspOpenList>>("open"),
            opts.get<bool>("reopen_closed"),
            opts.get<shared_ptr<Evaluator>>("f_eval", nullptr),
            opts.get_list<shared_ptr<Evaluator>>("preferred"),
            yahsp_eager_search::get_eager_search_arguments_from_options(opts)
            );
    }
};

static plugins::FeaturePlugin<YahspEagerSearchFeature> _plugin;
}
