#ifndef OPEN_LISTS_YAHSP_OPEN_LIST_H
#define OPEN_LISTS_YAHSP_OPEN_LIST_H

#include "../heuristics/yahsp_ff_heuristic.h"

#include "../open_list.h"

#include <cassert>
#include <deque>
#include <map>

/*
  Open list indexed by a single int, using FIFO tie-breaking.

  Implemented as a map from int to deques.
*/

namespace standard_scalar_open_list {


class YahspOpenList : public StateOpenList {
    typedef std::deque<StateOpenListEntry> Bucket;

    //std::map<int, Bucket> buckets;
    std::map<int, Bucket> h_buckets; //helpful node buckets
    std::map<int, Bucket> r_buckets; //rescue node buckets
    PerStateInformation<std::unordered_set<int>> helpful_actions;
    PerStateInformation<std::unordered_set<int>> rescue_actions;
    const StateRegistry *registry = nullptr;
    
    int size;
    int sizeh;
    int sizer;

    std::shared_ptr<yahsp_ff_heuristic::YahspFFHeuristic> ff;

public:
    virtual void do_insertion(EvaluationContext &eval_context,
                              const StateOpenListEntry &entry) override;
    YahspOpenList(const std::shared_ptr<yahsp_ff_heuristic::YahspFFHeuristic> ff, bool pref_only);

    virtual StateOpenListEntry remove_min() override;
    virtual std::tuple<StateOpenListEntry, std::unordered_set<int>> yahsp_remove_min();
    virtual bool empty() const override;
    virtual void clear() override;
    virtual void get_path_dependent_evaluators(std::set<Evaluator *> &evals) override;
    virtual bool is_dead_end(
        EvaluationContext &eval_context) const override;
    virtual bool is_reliable_dead_end(
        EvaluationContext &eval_context) const override;
};


/*


class YahspOpenListFactory : public OpenListFactory {
    std::shared_ptr<Evaluator> eval;
    bool pref_only;
public:
    YahspOpenListFactory(
        const std::shared_ptr<Evaluator> &eval, bool pref_only);

    virtual std::unique_ptr<StateOpenList> create_state_open_list() override;
    virtual std::unique_ptr<EdgeOpenList> create_edge_open_list() override;
};
*/
}

#endif
