#include "yahsp_open_list.h"

#include "../evaluator.h"
#include "../open_list.h"
#include "../open_list_factory.h"
#include "../heuristic.h"
#include "../per_state_information.h"
#include "../task_proxy.h"

#include "../plugins/plugin.h"

#include <cassert>
#include <deque>
#include <map>

using namespace std;

namespace standard_scalar_open_list {
YahspOpenList::YahspOpenList(const shared_ptr<yahsp_ff_heuristic::YahspFFHeuristic> ff, bool pref_only)
    : StateOpenList(pref_only),
      size(0),
      ff(ff) {
}

void YahspOpenList::do_insertion(
    EvaluationContext &eval_context, const StateOpenListEntry &entry) {
    State curr_state = eval_context.get_state();

    //to get states from stateIDs later
    if (!registry) {
        registry = curr_state.get_registry();
    }
    int h_ff;
    std::vector<int> rp;
    std::unordered_set<int> ha;
    std::unordered_set<int> ra;
    std::tie(h_ff, rp, ha, ra) = ff->compute_yahsp_heuristic(curr_state, true);
    //BA: -1 aka DEAD_END
    if (h_ff != -1) {
        //save info about the nodes (actually sav 2 diff buckts, 1 has stats with rscu actions and othr with hlpful)
        //std::deque<int> help_acts(ra.begin(), ra.end());
        //helpful_actions[curr_state] = help_acts;
        //helpful_actions[curr_state].insert(helpful_actions[curr_state].end(), help_acts.begin(), help_acts.end());

        //could it be that there isn't helpful or rescue actions here sometime?
        helpful_actions[curr_state].insert(ha.begin(),ha.end());
        rescue_actions[curr_state].insert(ra.begin(),ra.end());
        ++sizeh;
        h_buckets[h_ff].push_back(entry);
        ++sizer;
        r_buckets[h_ff].push_back(entry);
        ++size;
        //std::cout << "BA: HALPFUL (((((((((((((((((())))))))))))))))))" << endl;
        //for (FactProxy f : registry->lookup_state(entry)) {
        //    std::cout << f.get_name() << ", ";
        //}
        //std::cout << endl;
        std::vector<bool> p_prime;
        //std::tie(&eval_context, s_prime, p_prime) = lookahead();
        /*if (p_prime.size() >= 2) {
            //calls itself again
        }*/
    } else {
        std::tie(h_ff, rp, ha, ra) = ff->compute_yahsp_heuristic(curr_state); //this time goal preferred action false
        //BA: -1 aka DEAD_END
        if (h_ff != -1) {
            //save info about the nodes
            r_buckets[h_ff].push_back(entry);
            //rescue_actions[curr_state].insert(ha.begin(), ha.end());
            //rescue_actions[curr_state].insert(ra.begin(), ra.end());
            ++sizer;
            ++size;
            //rescue_actions[curr_state].insert(rescue_actions[curr_state].end(), all_actions.begin(), all_actions.end());
        }
    }
}

//output <State, (Plan), actions, (h_ff, flag)>
//requires perstateinformation too (to access actions)
//return helpful actions for helpful node and rescue actions for rescue nodes
std::tuple <StateOpenListEntry, std::unordered_set<int>> YahspOpenList::yahsp_remove_min() {
    assert(size > 0);
    std::unordered_set<int> action_ids;
    auto it_h = h_buckets.begin();
    if (it_h != h_buckets.end()) {
        Bucket &hbucket = it_h->second;
        assert(!hbucket.empty());
        StateOpenListEntry result = hbucket.front();
        State h_state = registry->lookup_state(result);
        assert(!helpful_actions[h_state].empty());
        action_ids = helpful_actions[h_state];
        hbucket.pop_front();
        if (hbucket.empty()) {
            h_buckets.erase(it_h);
            --sizeh;
            --size;
        }
        return make_tuple(result,action_ids);
    } else {
        auto it_r = r_buckets.begin();
        assert(it_r != r_buckets.end());
        Bucket &rbucket = it_r->second;
        assert(!rbucket.empty());
        StateOpenListEntry result = rbucket.front();
        State r_state = registry->lookup_state(result);
        //assert(!rescue_actions[r_state].empty());
        action_ids = rescue_actions[r_state];
        rbucket.pop_front();
        if (rbucket.empty()) {
            r_buckets.erase(it_r);
            --sizer;
            --size;
        }
        return make_tuple(result,action_ids);
    }
}

//we won't use this, but in the case that this is called by something it follows "our" logic to some degree.
StateOpenListEntry YahspOpenList::remove_min() {
    assert(size > 0);
    std::unordered_set<int> action_ids;
    auto it_h = h_buckets.begin();
    if (it_h != h_buckets.end()) {
        Bucket &hbucket = it_h->second;
        assert(!hbucket.empty());
        StateOpenListEntry result = hbucket.front();
        State h_state = registry->lookup_state(result);
        assert(!helpful_actions[h_state].empty());
        action_ids = helpful_actions[h_state];
        hbucket.pop_front();
        if (hbucket.empty()) {
            h_buckets.erase(it_h);
            --sizeh;
            --size;
        }
        return result;
    } else {
        auto it_r = r_buckets.begin();
        assert(it_r != r_buckets.end());
        Bucket &rbucket = it_r->second;
        assert(!rbucket.empty());
        StateOpenListEntry result = rbucket.front();
        State r_state = registry->lookup_state(result);
        assert(!rescue_actions[r_state].empty());
        action_ids = rescue_actions[r_state];
        rbucket.pop_front();
        if (rbucket.empty()) {
            r_buckets.erase(it_r);
            --sizer;
            --size;
        }
        return result;
    }
}

bool YahspOpenList::empty() const {
    return h_buckets.empty() && r_buckets.empty();
}

void YahspOpenList::clear() {
    //buckets.clear();
    h_buckets.clear();
    r_buckets.clear();
    sizeh = 0;
    sizer = 0;
    size = 0;
}

void YahspOpenList::get_path_dependent_evaluators(
    set<Evaluator *> &evals) {
    ff->get_path_dependent_evaluators(evals);
}

bool YahspOpenList::is_dead_end(
    EvaluationContext &eval_context) const {
    return eval_context.is_evaluator_value_infinite(ff.get());
}

bool YahspOpenList::is_reliable_dead_end(
    EvaluationContext &eval_context) const {
    return is_dead_end(eval_context) && ff->dead_ends_are_reliable();
}

// Remo: The following lines are a hacky way to make the plugins work.

static class YahspOpenListCategoryPlugin : public plugins::TypedCategoryPlugin<YahspOpenList> {
public:
    YahspOpenListCategoryPlugin() : TypedCategoryPlugin("YahspOpenList") {
    }
 }
_category_plugin;


class YahspOpenListFeature
    : public plugins::TypedFeature<YahspOpenList, YahspOpenList> {
public:
    YahspOpenListFeature() : TypedFeature("yahsp") {
        document_title("Best-first-based open list for YAHSP");
        document_synopsis(
            "Open list that uses a single evaluator and FIFO tiebreaking.");

        add_option<shared_ptr<yahsp_ff_heuristic::YahspFFHeuristic>>("eval", "evaluator");
        add_open_list_options_to_feature(*this);

        document_note(
            "Implementation Notes",
            "Elements with the same evaluator value are stored in double-ended "
            "queues, called \"buckets\". The open list stores a map from evaluator "
            "values to buckets. Pushing and popping from a bucket runs in constant "
            "time. Therefore, inserting and removing an entry from the open list "
            "takes time O(log(n)), where n is the number of buckets.");
    }


    virtual shared_ptr<YahspOpenList>
    create_component(const plugins::Options &opts) const override {
        return plugins::make_shared_from_arg_tuples<YahspOpenList>(
            opts.get<shared_ptr<yahsp_ff_heuristic::YahspFFHeuristic>>("eval"),
            get_open_list_arguments_from_options(opts));
    }
};

static plugins::FeaturePlugin<YahspOpenListFeature> _plugin;
}
