#ifndef HEURISTICS_FF_HEURISTIC_H
#define HEURISTICS_FF_HEURISTIC_H

#include "yahsp_additive_heuristic.h"

#include <vector>

namespace yahsp_ff_heuristic {
using yahsp_relaxation_heuristic::PropID;
using yahsp_relaxation_heuristic::OpID;

using yahsp_relaxation_heuristic::NO_OP;

using yahsp_relaxation_heuristic::Proposition;
using yahsp_relaxation_heuristic::UnaryOperator;

/*
  TODO: In a better world, this should not derive from
        AdditiveHeuristic. Rather, the common parts should be
        implemented in a common base class. That refactoring could be
        made at the same time at which we also unify this with the
        other relaxation heuristics and the additional FF heuristic
        implementation in the landmark code.
*/
class YahspFFHeuristic : public yahsp_additive_heuristic::YahspAdditiveHeuristic {
    // Relaxed plans are represented as a set of operators implemented
    // as a bit vector.
    using RelaxedPlan = std::vector<bool>;
    RelaxedPlan relaxed_plan;
    void mark_preferred_operators_and_relaxed_plan(
        const State &state, PropID goal_id);
protected:
    virtual int compute_heuristic(const State &ancestor_state) override;
public:
    //BA: contains operator_no (id of the original operator, aka the action) of all helpful actionss
    std::unordered_set<int> helpful_actions;
    //tuple <vector<int>, ordered_set::OrderedSet<OperatorID>>
    std::tuple<int,std::vector<int>,std::unordered_set<int>,std::unordered_set<int>> compute_yahsp_heuristic(const State &ancestor_state, bool gp = false);
    YahspFFHeuristic(
        tasks::AxiomHandlingType axioms,
        const std::shared_ptr<AbstractTask> &transform,
        bool cache_estimates, const std::string &description,
        utils::Verbosity verbosity);
};
}

#endif
