#! /usr/bin/env python
# -*- coding: utf-8 -*-

import common_setup
from common_setup import IssueConfig, IssueExperiment

import os

from lab.reports import Attribute

from downward.reports.absolute import AbsoluteReport

from lab.environments import LocalEnvironment, BaselSlurmEnvironment

from parser import LandmarkParser

# TODO: Enter git commit hash of code version you want to use.
#first is old goal pref, second is new goal pref. 
REVISIONS = ["e9630783d9dee1d4e0ed761664f28f8136d5b95c", "33971ed97a9d1fe38cda1a9d7da2edb0811b1df6"]
DRIVER_OPTIONS = ["--overall-time-limit", "30m"]
CONFIGS = [
    common_setup.IssueConfig(
        "yahsp",
        [
            "--search",
            "yahspeager(yahsp(yahspff()))",
        ],
        driver_options=DRIVER_OPTIONS,
    ),
    common_setup.IssueConfig(
        "lama-first",
        [], driver_options= DRIVER_OPTIONS+["--alias", "lama-first"]
        ),
    common_setup.IssueConfig(
        "eager greedy ff",
        [
            "--search",
            "eager_greedy([ff()])",
        ],driver_options=DRIVER_OPTIONS,
    ),
    common_setup.IssueConfig(
        "greedy ff with pref",
        ["--evaluator", "h=ff()", "--search", "eager_greedy([h], preferred=[h])"],
        driver_options=DRIVER_OPTIONS,
    ),
    # TODO: Add your configs.
]

BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]

#if common_setup.is_test_run():
#    SUITE = common_setup.IssueExperiment.DEFAULT_TEST_SUITE
#    ENVIRONMENT = LocalEnvironment(processes=2)
#else:
SUITE = common_setup.DEFAULT_SATISFICING_SUITE
ENVIRONMENT = BaselSlurmEnvironment(
        # Choose between infai_1 or infai_2. Either works but stick to a
        # single partition when results have to be comparable.
    partition="infai_3",
        # TODO: Change this to your own email, you will get notified when your
        # jobs finish.
    email="lisette.maureiradominguez@stud.unibas.ch", 
    export=["PATH", "DOWNWARD_BENCHMARKS"],
)

exp = common_setup.IssueExperiment(
    # TODO: Adapt this path. It should probably be "../.." if you put this
    # script into experiments/something in the downward root directory (same
    # as the Downward Lab tutorial).
    "/infai/maurei0000/YAHSP_BT_code/",
    revisions=REVISIONS,
    configs=CONFIGS,
    environment=ENVIRONMENT,
)

exp.add_suite(BENCHMARKS_DIR, SUITE)

exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)
exp.add_parser(LandmarkParser())

yahsp_attributes = [Attribute("goal_preferred_count", absolute=True), Attribute("operators_count", absolute=True)]
ATTRIBUTES = IssueExperiment.DEFAULT_TABLE_ATTRIBUTES + yahsp_attributes

exp.add_step("build", exp.build)
exp.add_step("start", exp.start_runs)
exp.add_step("parse", exp.parse)
exp.add_fetcher(name="fetch")
exp.add_report(AbsoluteReport(attributes=ATTRIBUTES))

exp.run_steps()
