#ifndef DOWNWARD_UNIFORM_PDBS_H
#define DOWNWARD_UNIFORM_PDBS_H

#include "types.h"
#include "../option_parser.h"


class State;
class TaskProxy;

namespace pdbs {
    class UniformPDBs {
        PDBCollectionDouble pattern_databases;
    public:
        UniformPDBs(const TaskProxy &task_proxy, const PatternCollection &patterns, const Options &opts);
        ~UniformPDBs() = default;

        double get_value(const State &state) const;
        /*
          Returns the sum of all mean finite h-values of every PDB.
          This is an approximation of the real mean finite h-value of the Heuristic,
          because dead-ends are ignored for the computation of the mean finite
          h-values for a PDB. As a consequence, if different PDBs have different
          states which are dead-end, we do not calculate the real mean h-value for
          these states.
        */
        double compute_approx_mean_finite_h() const;
        void dump() const;
    };
}

#endif //DOWNWARD_UNIFORM_PDBS_H
