#ifndef SATURATED_PDBS_HEURISTIC_H
#define SATURATED_PDBS_HEURISTIC_H

#include "saturated_pdbs.h"

#include "../heuristic.h"

namespace pdbs {
class PatternDatabase;

class SaturatedPDBsHeuristic : public Heuristic {
    SaturatedPDBs saturated_pdbs;
protected:
    virtual int compute_heuristic(const GlobalState &global_state);
    /* TODO: we want to get rid of compute_heuristic(const GlobalState &state)
       and change the interface to only use State objects. While we are doing
       this, the following method already allows to get the heuristic value
       for a State object. */
    int compute_heuristic(const State &state) const;
public:
    SaturatedPDBsHeuristic(const options::Options &opts);
    virtual ~SaturatedPDBsHeuristic() = default;
};
}

#endif
