#ifndef SATURATED_PDBS_H
#define SATURATED_PDBS_H

#include "types.h"
#include "../option_parser.h"
#include "../task_proxy.h"

#include <memory>

class State;
class TaskProxy;

namespace pdbs {
class SaturatedPDBs {
    PDBCollection pattern_databases;
    std::vector<int> calculate_scf(const OperatorsProxy &operators_proxy, const std::shared_ptr<PatternDatabase> &pdb);
public:
    SaturatedPDBs(const TaskProxy &task_proxy, const PatternCollection &patterns, const Options &opts);
    ~SaturatedPDBs() = default;

    int get_value(const State &state) const;
    /*
      Returns the sum of all mean finite h-values of every PDB.
      This is an approximation of the real mean finite h-value of the Heuristic,
      because dead-ends are ignored for the computation of the mean finite
      h-values for a PDB. As a consequence, if different PDBs have different
      states which are dead-end, we do not calculate the real mean h-value for
      these states.
    */
    double compute_approx_mean_finite_h() const;
    void dump() const;
};
}

#endif
