#ifndef DOWNWARD_OPPORT_UNIFORM_PDBS_H
#define DOWNWARD_OPPORT_UNIFORM_PDBS_H

#include "pattern_database_double.h"
#include "../option_parser.h"
#include "../task_proxy.h"
#include "types.h"


class State;
class TaskProxy;

namespace pdbs {
    class OpportUniformPDBs {
        PDBCollectionDouble pattern_databases;
        bool check_operator_relevance_in_pattern(const OperatorProxy &op, const Pattern &pattern);
        std::vector<double> calculate_scf(
                const OperatorsProxy &operators_proxy,
                const std::shared_ptr<PatternDatabaseDouble> &pdb);
    public:
        OpportUniformPDBs(const TaskProxy &task_proxy, const PatternCollection &patterns, const Options &opts);
        ~OpportUniformPDBs() = default;

        double get_value(const State &state) const;
        /*
          Returns the sum of all mean finite h-values of every PDB.
          This is an approximation of the real mean finite h-value of the Heuristic,
          because dead-ends are ignored for the computation of the mean finite
          h-values for a PDB. As a consequence, if different PDBs have different
          states which are dead-end, we do not calculate the real mean h-value for
          these states.
        */
        double compute_approx_mean_finite_h() const;
        void dump() const;
    };
}

#endif
