#ifndef DOWNWARD_COMPRESSION_DOUBLE_H
#define DOWNWARD_COMPRESSION_DOUBLE_H

#include "../option_parser.h"

#include "compression_helper.h"
#include "pattern_collection_information.h"
#include "pattern_database_double.h"
#include "pattern_database_factory_double.h"

#include "types.h"

#include <set>
#include <vector>

using namespace std;
namespace pdbs {
    extern int compute_best_pdb_double(
            Pattern original_pattern,
            shared_ptr<PatternDatabaseDouble> &current_pdb,
            const TaskProxy &task,
            const Options &opts,
            const int remaining_states_collection,
            const std::vector<double> &operator_costs = std::vector<double>()
                    );
    extern void print_avg_finite_mean_for_PDBCollectionDouble(shared_ptr<PDBCollectionDouble> &coll);
    extern void print_avg_finite_mean_for_PDBCollectionDouble(PDBCollectionDouble &coll);
}
#endif //DOWNWARD_COMPRESSION_H
