#ifndef DOWNWARD_COMPRESSION_H
#define DOWNWARD_COMPRESSION_H

#include "../option_parser.h"

#include "pattern_collection_information.h"
#include "pattern_database.h"
#include "pattern_database_factory.h"
#include "compression_helper.h"

#include "types.h"

#include <set>
#include <vector>

using namespace std;
namespace pdbs {

    extern int compute_best_pdb(
            Pattern original_pattern,
            shared_ptr<PatternDatabase> &current_pdb,
            const TaskProxy &task,
            const Options &opts,
            const int remaining_states_collection,
            const std::vector<int> &operator_costs = std::vector<int>()
                    );
    extern void add_compression_parser_parameters(OptionParser &parser);
    extern void print_avg_finite_mean_for_PDBCollection(shared_ptr<PDBCollection> &coll);
    extern void print_avg_finite_mean_for_PDBCollection(PDBCollection &coll);
}
#endif //DOWNWARD_COMPRESSION_H
