#! /usr/bin/env python

"""Experiments according to Issue 21 UCP base only after Bugfix with Double PDBs and boosting"""

import os
import os.path
import platform

from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport
from lab import cached_revision
from lab.environments import BaselSlurmEnvironment, LocalEnvironment


ATTRIBUTES = ["coverage", "error", "pattern_impr", "avg_meanfinite_h", "expansions", "expansions_until_last_jump", "total_time"]

NODE = platform.node()
if NODE.endswith(".scicore.unibas.ch") or NODE.endswith(".cluster.bc2.ch"):
    # Create bigger suites with suites.py from the downward-benchmarks repo.
    SUITE = ['agricola-opt18-strips', 'airport', 'barman-opt11-strips', 'barman-opt14-strips', 'blocks', 'childsnack-opt14-strips', 'data-network-opt18-strips', 'depot', 'driverlog', 'elevators-opt08-strips', 'elevators-opt11-strips', 'floortile-opt11-strips', 'floortile-opt14-strips', 'freecell', 'ged-opt14-strips', 'grid', 'gripper', 'hiking-opt14-strips', 'logistics00', 'logistics98', 'miconic', 'movie', 'mprime', 'mystery', 'nomystery-opt11-strips', 'openstacks-opt08-strips', 'openstacks-opt11-strips', 'openstacks-opt14-strips', 'openstacks-strips', 'organic-synthesis-opt18-strips', 'organic-synthesis-split-opt18-strips', 'parcprinter-08-strips', 'parcprinter-opt11-strips', 'parking-opt11-strips', 'parking-opt14-strips', 'pathways', 'pegsol-08-strips', 'pegsol-opt11-strips', 'petri-net-alignment-opt18-strips', 'pipesworld-notankage', 'pipesworld-tankage', 'psr-small', 'rovers', 'satellite', 'scanalyzer-08-strips', 'scanalyzer-opt11-strips', 'snake-opt18-strips', 'sokoban-opt08-strips', 'sokoban-opt11-strips', 'spider-opt18-strips', 'storage', 'termes-opt18-strips', 'tetris-opt14-strips', 'tidybot-opt11-strips', 'tidybot-opt14-strips', 'tpp', 'transport-opt08-strips', 'transport-opt11-strips', 'transport-opt14-strips', 'trucks-strips', 'visitall-opt11-strips', 'visitall-opt14-strips', 'woodworking-opt08-strips', 'woodworking-opt11-strips', 'zenotravel']
    ENV = BaselSlurmEnvironment(email="pascal.mafli@unibas.ch", partition="infai_2")
else:
    SUITE = ["depot:p01.pddl", "gripper:prob01.pddl", "mystery:prob07.pddl"]
    ENV = LocalEnvironment(processes=2)
# Use path to your Fast Downward repository.
REPO = os.path.expanduser('~/code/downward')
BENCHMARKS_DIR = os.path.expanduser('~/code/downward-benchmarks') 
# If REVISION_CACHE is None, the default ./data/revision-cache is used.
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")
VCS = cached_revision.get_version_control_system(REPO)
REV = "a7416ab0e7e59a415f08d8e018c8feecff69d906"

exp = FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)

# Add built-in parsers to the experiment.
exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)
exp.add_parser('pdbs_parser_v5_2020-10-22.py')

exp.add_suite(BENCHMARKS_DIR, SUITE)
exp.add_algorithm("ucp_pdbs_HC_default", REPO, REV, ["--search", "astar(updbs(patterns=hillclimbing()))"])
exp.add_algorithm("ucp_pdbs_HC_random", REPO, REV, ["--search", "astar(updbs(patterns=hillclimbing(), compress_pdbs=true, compr_algo=RANDOMWALK))"])
exp.add_algorithm("ucp_pdbs_HC_hillclimb_1it", REPO, REV, ["--search", "astar(updbs(patterns=hillclimbing(), compress_pdbs=true, max_iterations=1, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_HC_hillclimb_2it", REPO, REV, ["--search", "astar(updbs(patterns=hillclimbing(), compress_pdbs=true, max_iterations=2, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_HC_hillclimb_3it", REPO, REV, ["--search", "astar(updbs(patterns=hillclimbing(), compress_pdbs=true, max_iterations=3, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_SYS_2_default", REPO, REV, ["--search", "astar(updbs(patterns=systematic(2)))"])
exp.add_algorithm("ucp_pdbs_SYS_2_random", REPO, REV, ["--search", "astar(updbs(patterns=systematic(2), compress_pdbs=true, compr_algo=RANDOMWALK))"])
exp.add_algorithm("ucp_pdbs_SYS_2_hillclimb_1it", REPO, REV, ["--search", "astar(updbs(patterns=systematic(2), compress_pdbs=true, max_iterations=1, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_SYS_2_hillclimb_2it", REPO, REV, ["--search", "astar(updbs(patterns=systematic(2), compress_pdbs=true, max_iterations=2, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_SYS_2_hillclimb_3it", REPO, REV, ["--search", "astar(updbs(patterns=systematic(2), compress_pdbs=true, max_iterations=3, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_SYS_3_default", REPO, REV, ["--search", "astar(updbs(patterns=systematic(3)))"])
exp.add_algorithm("ucp_pdbs_SYS_3_random", REPO, REV, ["--search", "astar(updbs(patterns=systematic(3), compress_pdbs=true, compr_algo=RANDOMWALK))"])
exp.add_algorithm("ucp_pdbs_SYS_3_hillclimb_1it", REPO, REV, ["--search", "astar(updbs(patterns=systematic(3), compress_pdbs=true, max_iterations=1, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_SYS_3_hillclimb_2it", REPO, REV, ["--search", "astar(updbs(patterns=systematic(3), compress_pdbs=true, max_iterations=2, compr_algo=HILLCLIMBING))"])
exp.add_algorithm("ucp_pdbs_SYS_3_hillclimb_3it", REPO, REV, ["--search", "astar(updbs(patterns=systematic(3), compress_pdbs=true, max_iterations=3, compr_algo=HILLCLIMBING))"])
# Add step that writes experiment files to disk.
exp.add_step("build", exp.build)

# Add step that executes all runs.
exp.add_step("start", exp.start_runs)

# Add step that collects properties from run directories and
# writes them to *-eval/properties.
exp.add_fetcher(name="fetch")

# Add report step (AbsoluteReport is the standard report).
exp.add_report(AbsoluteReport(attributes=ATTRIBUTES), outfile="2020-11-03_ucp_boosting.html")

# Parse the commandline and show or run experiment steps.
exp.run_steps()
