using namespace std;
#ifndef UTILS_STATES_HELPER_H
#define UTILS_STATES_HELPER_H

#include <cassert>
#include <vector>

#include "../utils/collections.h"
#include "../globals.h"


namespace utils {
    int num_facts = -1;

    int get_num_facts() {
        if(num_facts != -1) {
            return num_facts;
        } else {
            num_facts = 0;
            for (size_t i = 0; i < g_variable_domain.size(); i++) {
                num_facts += g_variable_domain[i];
            }
            return num_facts;
        }
    }

    vector<bool> create_bit_mask(const GlobalState &global_state) {
        vector<bool> result(get_num_facts());
        vector<int> state = global_state.get_values();
        size_t variable_start = 0;
        for (size_t i = 0; i < state.size(); i++) {
            assert((utils::in_bounds(variable_start + state[i], result)));
            result[variable_start + state[i]] = true;
            variable_start += g_variable_domain[i];
        }
        return result;
    }
}

#endif
