
(DEFINE (DOMAIN ESCAPE-MONSTER)
 (:REQUIREMENTS :ADL)
 (:TYPES
   EXPLORER GREMLIN MONSTER - AGENT
   COMBO-ITEM PRIMITIVE-ITEM - ITEM
   AGENT DIRECTION HEALTHLEVEL LOCATION PROPERTY THING - OBJECT
   ROCK WALL WATER - OBSTACLE
   ITEM OBSTACLE - THING)
 (:CONSTANTS
   COMBO1 COMBO2 - COMBO-ITEM
   EAST NORTH SOUTH WEST - DIRECTION
   EXPLORER1 - EXPLORER
   LEVEL0 LEVEL1 LEVEL2 LEVEL3 - HEALTHLEVEL
   FLAG1 - ITEM
   L0 L1 L2 L3 L4 L5 L6 L7 L8 L9 - LOCATION
   ROCK UNPASSABLE WATER - OBSTACLE
   HAMMER1 HAMMER2 LOG1 LOG2 MEDKIT1 MEDKIT2 NAILS1 NAILS2 ROPE1 ROPE2 - PRIMITIVE-ITEM
   BUOYANT CANBLAST CANBRIDGE CANFLOAT COMPOUND DOESHAMMER DOESNAIL DOESTIE NAILABLE SUPPORTSWEIGHT
     TIEABLE - PROPERTY)
 (:PREDICATES (BLOCKED ?D - DIRECTION ?X ?Y - LOCATION) (HEALTH ?A - AGENT ?H - HEALTHLEVEL)
  (AT-AGENT ?A - AGENT ?X ?Y - LOCATION) (AT-THING ?O - THING ?X ?Y - LOCATION)
  (HAS-PROPERTY ?I - ITEM ?P - PROPERTY) (CAN-DESTROY ?P - PROPERTY ?O - OBSTACLE)
  (CAN-COMPROMISE ?P - PROPERTY ?O - OBSTACLE)
  (CAN-COMBINE ?TOOL - ITEM ?COMBO-PROP - PROPERTY ?P1 ?P2 - PROPERTY)
  (PROPERTY-MAPPING ?P1 ?P2 - PROPERTY ?PCOMBINED - PROPERTY) (USED ?A - AGENT ?I - ITEM)
  (HOLDING ?A - AGENT ?I - ITEM) (DESTROYED ?O - OBSTACLE) (COMPROMISED ?O - OBSTACLE)
  (COMPROMISE-ITEM ?O - OBSTACLE ?I - ITEM) (LOWER-HEALTH ?H ?HNEW - HEALTHLEVEL)
  (LINE-OF-SIGHT ?X ?Y ?X1 ?Y1 - LOCATION ?DIR - DIRECTION)
  (ADJACENT ?X ?Y ?X1 ?Y1 - LOCATION ?DIR - DIRECTION) (DONE) (A0) (A1) (A2) (A3) (A4) (A5) (GOAL)
  (AT-GREMLIN ?G - GREMLIN ?X ?Y - LOCATION) (CAN-SABOTAGE ?G - GREMLIN ?P - PROPERTY ?I - ITEM)
  (SABOTAGED ?I - ITEM) (OBSERVED ?A - EXPLORER ?M - MONSTER))
 (:ACTION PL-STEP1 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (AND
      (NOT (HEALTH EXPLORER1 LEVEL0))
      (AT-AGENT EXPLORER1 L8 L1)
      (NOT (BLOCKED NORTH L8 L1))
      (ADJACENT L8 L1 L8 L2 NORTH)
      (LOWER-HEALTH LEVEL3 LEVEL2)
      (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT
  (AND
    (WHEN
      (NOT (EXISTS (?O - OBSTACLE)
             (AT-THING ?O L8 L2)))
      (AND
        (NOT (AT-AGENT EXPLORER1 L8 L1))
        (AT-AGENT EXPLORER1 L8 L2)))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (COMPROMISED ?O)
          (AT-THING ?O L8 L2)
          (AT-AGENT EXPLORER1 L8 L1))
        (AND
          (NOT (COMPROMISED ?O))
          (NOT (AT-AGENT EXPLORER1 L8 L1))
          (AT-AGENT EXPLORER1 L8 L2))))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (NOT (COMPROMISED ?O))
          (AT-THING ?O L8 L2)
          (LOWER-HEALTH LEVEL3 LEVEL2))
        (AND
          (NOT (HEALTH EXPLORER1 LEVEL3))
          (HEALTH EXPLORER1 LEVEL2))))
    (A0)))
 (:ACTION PL-STEP2 :PARAMETERS () :PRECONDITION
  (AND
    (A0)
    (NOT (A1))
    (AND
      (NOT (HEALTH EXPLORER1 LEVEL0))
      (AT-AGENT EXPLORER1 L8 L2)
      (NOT (BLOCKED NORTH L8 L2))
      (ADJACENT L8 L2 L8 L3 NORTH)
      (LOWER-HEALTH LEVEL3 LEVEL2)
      (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT
  (AND
    (WHEN
      (NOT (EXISTS (?O - OBSTACLE)
             (AT-THING ?O L8 L3)))
      (AND
        (NOT (AT-AGENT EXPLORER1 L8 L2))
        (AT-AGENT EXPLORER1 L8 L3)))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (COMPROMISED ?O)
          (AT-THING ?O L8 L3)
          (AT-AGENT EXPLORER1 L8 L2))
        (AND
          (NOT (COMPROMISED ?O))
          (NOT (AT-AGENT EXPLORER1 L8 L2))
          (AT-AGENT EXPLORER1 L8 L3))))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (NOT (COMPROMISED ?O))
          (AT-THING ?O L8 L3)
          (LOWER-HEALTH LEVEL3 LEVEL2))
        (AND
          (NOT (HEALTH EXPLORER1 LEVEL3))
          (HEALTH EXPLORER1 LEVEL2))))
    (A1)))
 (:ACTION PL-STEP3 :PARAMETERS () :PRECONDITION
  (AND
    (A1)
    (A0)
    (NOT (A2))
    (AND
      (NOT (HEALTH EXPLORER1 LEVEL0))
      (AT-AGENT EXPLORER1 L8 L3)
      (NOT (BLOCKED NORTH L8 L3))
      (ADJACENT L8 L3 L8 L4 NORTH)
      (LOWER-HEALTH LEVEL3 LEVEL2)
      (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT
  (AND
    (WHEN
      (NOT (EXISTS (?O - OBSTACLE)
             (AT-THING ?O L8 L4)))
      (AND
        (NOT (AT-AGENT EXPLORER1 L8 L3))
        (AT-AGENT EXPLORER1 L8 L4)))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (COMPROMISED ?O)
          (AT-THING ?O L8 L4)
          (AT-AGENT EXPLORER1 L8 L3))
        (AND
          (NOT (COMPROMISED ?O))
          (NOT (AT-AGENT EXPLORER1 L8 L3))
          (AT-AGENT EXPLORER1 L8 L4))))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (NOT (COMPROMISED ?O))
          (AT-THING ?O L8 L4)
          (LOWER-HEALTH LEVEL3 LEVEL2))
        (AND
          (NOT (HEALTH EXPLORER1 LEVEL3))
          (HEALTH EXPLORER1 LEVEL2))))
    (A2)))
 (:ACTION PL-STEP4 :PARAMETERS () :PRECONDITION
  (AND
    (A2)
    (A1)
    (A0)
    (NOT (A3))
    (AND
      (NOT (HEALTH EXPLORER1 LEVEL0))
      (AT-AGENT EXPLORER1 L8 L4)
      (NOT (BLOCKED NORTH L8 L4))
      (ADJACENT L8 L4 L8 L5 NORTH)
      (LOWER-HEALTH LEVEL3 LEVEL2)
      (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT
  (AND
    (WHEN
      (NOT (EXISTS (?O - OBSTACLE)
             (AT-THING ?O L8 L5)))
      (AND
        (NOT (AT-AGENT EXPLORER1 L8 L4))
        (AT-AGENT EXPLORER1 L8 L5)))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (COMPROMISED ?O)
          (AT-THING ?O L8 L5)
          (AT-AGENT EXPLORER1 L8 L4))
        (AND
          (NOT (COMPROMISED ?O))
          (NOT (AT-AGENT EXPLORER1 L8 L4))
          (AT-AGENT EXPLORER1 L8 L5))))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (NOT (COMPROMISED ?O))
          (AT-THING ?O L8 L5)
          (LOWER-HEALTH LEVEL3 LEVEL2))
        (AND
          (NOT (HEALTH EXPLORER1 LEVEL3))
          (HEALTH EXPLORER1 LEVEL2))))
    (A3)))
 (:ACTION PL-STEP5 :PARAMETERS () :PRECONDITION
  (AND
    (A3)
    (A2)
    (A1)
    (A0)
    (NOT (A4))
    (AND
      (NOT (HEALTH EXPLORER1 LEVEL0))
      (AT-AGENT EXPLORER1 L8 L5)
      (NOT (BLOCKED WEST L8 L5))
      (ADJACENT L8 L5 L7 L5 WEST)
      (LOWER-HEALTH LEVEL3 LEVEL2)
      (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT
  (AND
    (WHEN
      (NOT (EXISTS (?O - OBSTACLE)
             (AT-THING ?O L7 L5)))
      (AND
        (NOT (AT-AGENT EXPLORER1 L8 L5))
        (AT-AGENT EXPLORER1 L7 L5)))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (COMPROMISED ?O)
          (AT-THING ?O L7 L5)
          (AT-AGENT EXPLORER1 L8 L5))
        (AND
          (NOT (COMPROMISED ?O))
          (NOT (AT-AGENT EXPLORER1 L8 L5))
          (AT-AGENT EXPLORER1 L7 L5))))
    (FORALL (?O - OBSTACLE)
      (WHEN
        (AND
          (NOT (COMPROMISED ?O))
          (AT-THING ?O L7 L5)
          (LOWER-HEALTH LEVEL3 LEVEL2))
        (AND
          (NOT (HEALTH EXPLORER1 LEVEL3))
          (HEALTH EXPLORER1 LEVEL2))))
    (A4)))
 (:ACTION PL-FINISH-PLAN6 :PARAMETERS () :PRECONDITION
  (AND
    (A4)
    (A3)
    (A2)
    (A1)
    (A0)
    (NOT (A5))
    (AND
      (AT-AGENT EXPLORER1 L7 L5)))
  :EFFECT
  (AND
    (DONE)
    (A5)))
 (:ACTION PA-STEP1-7 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (HEALTH EXPLORER1 LEVEL0))
  :EFFECT (GOAL))
 (:ACTION PA-STEP1-8 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (NOT (AT-AGENT EXPLORER1 L8 L1)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP1-9 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (BLOCKED NORTH L8 L1))
  :EFFECT (GOAL))
 (:ACTION PA-STEP1-10 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (NOT (ADJACENT L8 L1 L8 L2 NORTH)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP1-11 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (NOT (LOWER-HEALTH LEVEL3 LEVEL2)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP1-12 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A0))
    (NOT (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP2-13 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A1))
    (A0)
    (HEALTH EXPLORER1 LEVEL0))
  :EFFECT (GOAL))
 (:ACTION PA-STEP2-14 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A1))
    (A0)
    (NOT (AT-AGENT EXPLORER1 L8 L2)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP2-15 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A1))
    (A0)
    (BLOCKED NORTH L8 L2))
  :EFFECT (GOAL))
 (:ACTION PA-STEP2-16 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A1))
    (A0)
    (NOT (ADJACENT L8 L2 L8 L3 NORTH)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP2-17 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A1))
    (A0)
    (NOT (LOWER-HEALTH LEVEL3 LEVEL2)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP2-18 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A1))
    (A0)
    (NOT (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP3-19 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A2))
    (A1)
    (HEALTH EXPLORER1 LEVEL0))
  :EFFECT (GOAL))
 (:ACTION PA-STEP3-20 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A2))
    (A1)
    (NOT (AT-AGENT EXPLORER1 L8 L3)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP3-21 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A2))
    (A1)
    (BLOCKED NORTH L8 L3))
  :EFFECT (GOAL))
 (:ACTION PA-STEP3-22 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A2))
    (A1)
    (NOT (ADJACENT L8 L3 L8 L4 NORTH)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP3-23 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A2))
    (A1)
    (NOT (LOWER-HEALTH LEVEL3 LEVEL2)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP3-24 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A2))
    (A1)
    (NOT (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP4-25 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A3))
    (A2)
    (HEALTH EXPLORER1 LEVEL0))
  :EFFECT (GOAL))
 (:ACTION PA-STEP4-26 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A3))
    (A2)
    (NOT (AT-AGENT EXPLORER1 L8 L4)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP4-27 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A3))
    (A2)
    (BLOCKED NORTH L8 L4))
  :EFFECT (GOAL))
 (:ACTION PA-STEP4-28 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A3))
    (A2)
    (NOT (ADJACENT L8 L4 L8 L5 NORTH)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP4-29 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A3))
    (A2)
    (NOT (LOWER-HEALTH LEVEL3 LEVEL2)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP4-30 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A3))
    (A2)
    (NOT (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP5-31 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A4))
    (A3)
    (HEALTH EXPLORER1 LEVEL0))
  :EFFECT (GOAL))
 (:ACTION PA-STEP5-32 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A4))
    (A3)
    (NOT (AT-AGENT EXPLORER1 L8 L5)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP5-33 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A4))
    (A3)
    (BLOCKED WEST L8 L5))
  :EFFECT (GOAL))
 (:ACTION PA-STEP5-34 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A4))
    (A3)
    (NOT (ADJACENT L8 L5 L7 L5 WEST)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP5-35 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A4))
    (A3)
    (NOT (LOWER-HEALTH LEVEL3 LEVEL2)))
  :EFFECT (GOAL))
 (:ACTION PA-STEP5-36 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A4))
    (A3)
    (NOT (HEALTH EXPLORER1 LEVEL3)))
  :EFFECT (GOAL))
 (:ACTION PA-FINISH-PLAN6-37 :PARAMETERS () :PRECONDITION
  (AND
    (NOT (A5))
    (A4)
    (NOT (AT-AGENT EXPLORER1 L7 L5)))
  :EFFECT (GOAL))
 (:ACTION CATCH :PARAMETERS (?M - MONSTER ?A - EXPLORER ?X ?Y - LOCATION ?H - HEALTHLEVEL)
  :PRECONDITION
  (AND
    (AT-AGENT ?M ?X ?Y)
    (AT-AGENT ?A ?X ?Y)
    (HEALTH ?A ?H)
    (NOT (HEALTH ?A LEVEL0)))
  :EFFECT
  (AND
    (HEALTH ?A LEVEL0)))
 (:ACTION OBSERVE :PARAMETERS
  (?M - MONSTER ?X ?Y - LOCATION ?DIR - DIRECTION ?A - EXPLORER ?X-EXPLORER ?Y-EXPLORER - LOCATION)
  :PRECONDITION
  (AND
    (AT-AGENT ?M ?X ?Y)
    (LINE-OF-SIGHT ?X ?Y ?X-EXPLORER ?Y-EXPLORER ?DIR)
    (AT-AGENT ?A ?X-EXPLORER ?Y-EXPLORER))
  :EFFECT
  (AND
    (OBSERVED ?A ?M)))
 (:ACTION MOVE :PARAMETERS
  (?M - MONSTER ?A - EXPLORER ?X ?Y - LOCATION ?DIR - DIRECTION ?X1 ?Y1 - LOCATION) :PRECONDITION
  (AND
    (OBSERVED ?A ?M)
    (AT-AGENT ?M ?X ?Y)
    (ADJACENT ?X ?Y ?X1 ?Y1 ?DIR)
    (NOT (BLOCKED ?DIR ?X ?Y))
    (FORALL (?O - OBSTACLE)
      (NOT (AT-THING ?O ?X1 ?Y1))))
  :EFFECT
  (AND
    (NOT (AT-AGENT ?M ?X ?Y))
    (AT-AGENT ?M ?X1 ?Y1)))
 (:ACTION PICK-UP :PARAMETERS (?A - AGENT ?X ?Y - LOCATION ?I - ITEM) :PRECONDITION
  (AND
    (AT-AGENT ?A ?X ?Y)
    (AT-THING ?I ?X ?Y)
    (NOT (USED ?A ?I)))
  :EFFECT
  (AND
    (NOT (AT-THING ?I ?X ?Y))
    (HOLDING ?A ?I)))
 (:ACTION COMBINE :PARAMETERS
  (?A - MONSTER ?I1 ?I2 - ITEM ?P1 ?P2 - PROPERTY ?CONNECTOR - ITEM ?CONPROP - PROPERTY ?COMBO-ITEM
   - COMBO-ITEM ?TOOL - ITEM)
  :PRECONDITION
  (AND
    (HOLDING ?A ?I1)
    (HOLDING ?A ?I2)
    (HOLDING ?A ?TOOL)
    (NOT (= ?I1 ?I2))
    (HAS-PROPERTY ?I1 ?P1)
    (HAS-PROPERTY ?I2 ?P2)
    (PROPERTY-MAPPING ?P1 ?P2 ?CONPROP)
    (CAN-COMBINE ?TOOL ?CONPROP ?P1 ?P2))
  :EFFECT
  (AND
    (NOT (HOLDING ?A ?I1))
    (NOT (HOLDING ?A ?I2))
    (NOT (HOLDING ?A ?CONNECTOR))
    (HOLDING ?A ?COMBO-ITEM)
    (HAS-PROPERTY ?COMBO-ITEM ?CONPROP)))
 (:ACTION APPLY :PARAMETERS
  (?A - MONSTER ?X ?Y - LOCATION ?I - ITEM ?P - PROPERTY ?DIR - DIRECTION ?O - OBSTACLE ?X1 ?Y1 -
   LOCATION)
  :PRECONDITION
  (AND
    (AT-THING ?O ?X1 ?Y1)
    (AT-AGENT ?A ?X ?Y)
    (HOLDING ?A ?I)
    (HAS-PROPERTY ?I ?P)
    (ADJACENT ?X ?Y ?X1 ?Y1 ?DIR)
    (NOT (BLOCKED ?DIR ?X ?Y)))
  :EFFECT
  (AND
    (WHEN
      (CAN-DESTROY ?P ?O)
      (NOT (AT-THING ?O ?X1 ?Y1)))
    (WHEN
      (AND
        (NOT (CAN-DESTROY ?P ?O))
        (CAN-COMPROMISE ?P ?O))
      (COMPROMISED ?O))
    (NOT (HOLDING ?A ?I))
    (USED ?A ?I)))
 (:ACTION STEP-GREMLIN :PARAMETERS
  (?G - GREMLIN ?X ?Y - LOCATION ?DIR - DIRECTION ?X1 ?Y1 - LOCATION) :PRECONDITION
  (AND
    (AT-GREMLIN ?G ?X ?Y)
    (NOT (BLOCKED ?DIR ?X ?Y))
    (ADJACENT ?X ?Y ?X1 ?Y1 ?DIR))
  :EFFECT
  (AND
    (WHEN
      (NOT (EXISTS (?O - OBSTACLE)
             (AT-THING ?O ?X1 ?Y1)))
      (AND
        (NOT (AT-GREMLIN ?G ?X ?Y))
        (AT-GREMLIN ?G ?X1 ?Y1)))))
 (:ACTION SABOTAGE-ITEM :PARAMETERS
  (?G - GREMLIN ?I - ITEM ?P - PROPERTY ?X ?Y - LOCATION ?A - EXPLORER ?X1 ?Y1 - LOCATION)
  :PRECONDITION
  (AND
    (AT-GREMLIN ?G ?X ?Y)
    (AT-THING ?I ?X ?Y)
    (HAS-PROPERTY ?I ?P)
    (CAN-SABOTAGE ?G ?P ?I)
    (AT-AGENT ?A ?X1 ?Y1))
  :EFFECT
  (AND
    (SABOTAGED ?I)
    (NOT (HAS-PROPERTY ?I ?P))
    (NOT (AT-AGENT ?A ?X1 ?Y1))))
 (:ACTION SABOTAGE-COMBO :PARAMETERS (?I - ITEM ?P - PROPERTY ?X ?Y - LOCATION) :PRECONDITION
  (AND
    (AT-THING ?I ?X ?Y)
    (HAS-PROPERTY ?I ?P)
    (FORALL (?G - GREMLIN)
      (AND
        (AT-GREMLIN ?G ?X ?Y)
        (CAN-SABOTAGE ?G ?P ?I))))
  :EFFECT
  (AND
    (SABOTAGED ?I)
    (NOT (HAS-PROPERTY ?I ?P))
    (FORALL (?O - OBSTACLE)
      (WHEN (COMPROMISED ?O)
        (NOT (COMPROMISE-ITEM ?O ?I))))
    (FORALL (?O - OBSTACLE)
      (WHEN (COMPROMISE-ITEM ?O ?I)
          (NOT (COMPROMISED ?O)))))))