#ifndef TASKS_MODIFIED_OPERATORS_TASK_H
#define TASKS_MODIFIED_OPERATORS_TASK_H

#include "delegating_task.h"

#include <vector>

namespace extra_tasks {
class ModifiedOperatorsTask : public tasks::DelegatingTask {
    const std::vector<int> operators;

public:
    ModifiedOperatorsTask(
        const std::shared_ptr<AbstractTask> &parent,
        std::vector<int> &&operators);
    ~ModifiedOperatorsTask() = default;

    virtual int get_num_operators() const override;
	virtual int get_operator_cost(int index, bool is_axiom) const override;
	virtual std::string get_operator_name(int index, bool is_axiom) const override;
	virtual int get_num_operator_preconditions(int index, bool is_axiom) const override;
	virtual FactPair get_operator_precondition(int op_index, int fact_index, bool is_axiom) const override;
	virtual int get_num_operator_effects(int op_index, bool is_axiom) const override;
	virtual int get_num_operator_effect_conditions(int op_index, int eff_index, bool is_axiom) const override;
	virtual FactPair get_operator_effect_condition(int op_index, int eff_index, int cond_index, bool is_axiom) const override;
	virtual FactPair get_operator_effect(int op_index, int eff_index, bool is_axiom) const override;
	virtual const GlobalOperator* get_global_operator(int index, bool is_axiom) const override;

};
}

#endif
