#include "modified_operators_task.h"

using namespace std;

namespace extra_tasks {
ModifiedOperatorsTask::ModifiedOperatorsTask(
    const shared_ptr<AbstractTask> &parent,
    vector<int> &&operators)
    : DelegatingTask(parent),
      operators(move(operators)) {
}

int ModifiedOperatorsTask::get_num_operators() const {
    return operators.size();
}

int ModifiedOperatorsTask::get_operator_cost(int index, bool is_axiom) const {
	return parent->get_operator_cost(operators.at(index), is_axiom);
}

std::string ModifiedOperatorsTask::get_operator_name(int index, bool is_axiom) const {
	return parent->get_operator_name(operators.at(index), is_axiom);
}

int ModifiedOperatorsTask::get_num_operator_preconditions(int index, bool is_axiom) const {
	return parent->get_num_operator_preconditions(operators.at(index), is_axiom);
}

FactPair ModifiedOperatorsTask::get_operator_precondition(int op_index, int fact_index, bool is_axiom) const {
	return parent->get_operator_precondition(operators.at(op_index), fact_index, is_axiom);
}

int ModifiedOperatorsTask::get_num_operator_effects(int op_index, bool is_axiom) const {
	return parent->get_num_operator_effects(operators.at(op_index), is_axiom);
}

int ModifiedOperatorsTask::get_num_operator_effect_conditions(int op_index, int eff_index, bool is_axiom) const	{
	return parent->get_num_operator_effect_conditions(operators.at(op_index), eff_index, is_axiom);
}

FactPair ModifiedOperatorsTask::get_operator_effect_condition(int op_index, int eff_index, int cond_index, bool is_axiom) const {
	return parent->get_operator_effect_condition(operators.at(op_index), eff_index, cond_index, is_axiom);
}

FactPair ModifiedOperatorsTask::get_operator_effect(int op_index, int eff_index, bool is_axiom) const {
	return parent->get_operator_effect(operators.at(op_index), eff_index, is_axiom);
}

const GlobalOperator* ModifiedOperatorsTask::get_global_operator(int index, bool is_axiom) const {
	return parent->get_global_operator(operators.at(index), is_axiom);
}

}
