#ifndef SEARCH_ENGINES_EAGER_SEARCH_H
#define SEARCH_ENGINES_EAGER_SEARCH_H

#include "../search_engine.h"

#include "../open_lists/open_list.h"
#include "../successor_generator.h"

#include <memory>
#include <vector>

class GlobalOperator;
class Heuristic;
class ScalarEvaluator;

namespace options {
class Options;
}

namespace sub_search {
class SubSearch : public SearchEngine {
    const bool reopen_closed_nodes;

    std::unique_ptr<StateOpenList> open_list;

    std::vector<Heuristic *> heuristics;
    std::vector<Heuristic *> preferred_operator_heuristics;


    std::pair<SearchNode, bool> fetch_next_node();
    void start_f_value_statistics(EvaluationContext &eval_context);
    void update_f_value_statistics(const SearchNode &node);
    void reward_progress();
	bool check_if_goal(const GlobalState &state);
		bool check_if_goal_and_set_plan(const GlobalState &state);
		void print_checkpoint_line(int g) const;
    State convert_global_state(const GlobalState &global_state) const;

protected:
    virtual void initialize() override;
    virtual SearchStatus step() override;
	std::shared_ptr<AbstractTask> task;
    SuccessorGenerator successor_generator;

public:
    explicit SubSearch(const options::Options &opts, std::shared_ptr<AbstractTask> sub_task);
    virtual ~SubSearch() = default;

    virtual void print_statistics() const override;

    void dump_search_space() const;
};
}

#endif
