#include "meta_node.h"
#include "../landmarks/landmark_graph.h"

using namespace std;

namespace MetaNode{

MetaNode::MetaNode(const StateID s_id, vector<bool> a, landmarks::LandmarkNode* l, vector<const GlobalOperator *> p)
	:state_id(s_id)
	{
	this->achieved_lms = a;
	this->goal_lm = l;
	this->plan = p;
}

void MetaNode::dump_metanode(StateRegistry sr) {
	cout << "METANODE: " << endl;
	cout << "State: ";
	sr.lookup_state(this->state_id).dump_pddl(); // discards (const) qualifiers error
	cout << "Achieved_lms: ";
	for (vector<bool>::const_iterator i=this->achieved_lms.begin(); i != this->achieved_lms.end(); ++i) {
		cout << *i << " ";
	}
	cout << endl << "Goal_LM: " << this->goal_lm->get_id();
	cout << "Plan: ";
	/*for (vector<const GlobalOperator *>::const_iterator i=this->plan.begin(); i != this->plan.end(); ++i) {
		cout << *i->get_name() << " ";
	}*/ // incomplete type error
	cout << endl;
}

}