//
//  MinBloom.cpp
//  hog2 glut
//
//  Created by Nathan Sturtevant on 5/4/14.
//  Copyright (c) 2014 University of Denver. All rights reserved.
//

#include "MinBloom.h"

#include <cmath>
#include <limits>
#include "MinBloom.h"
#include <string.h>
#include <stdio.h>
#include <cinttypes>

// [8 possible hashes][16x 4-bit segments][16 values for 4 bits]
static uint64_t salt[8] = {0x6B8B4567327B23C6ull, 0x643C986966334873ull, 0x74B0DC5119495CFFull, 0x2AE8944A625558ECull, 0x238E1F2946E87CCDull, 0x3D1B58BA507ED7ABull, 0x2EB141F241B71EFBull, 0x79E2A9E37545E146ull};
static uint64_t zobrist[8][256] = {
	{ 0x415FD31C783455EEull, 0x3F2CF1797421BFBFull, 0x10F5E25F6E4E0219ull, 0x5BC91D9C2F2F972Full, 0x5B8D025C69FDBE2Full, 0x5DDE50AA4A144A49ull, 0x3C2EE97B53BEAD45ull, 0x23AA143D1814A14Eull, 0x150690F16DA374CBull, 0x4D4BBEAF07276797ull, 0x66C2D4180B70CD38ull, 0x2EDEB4DB3ED9ED2Cull, 0x48537DB20314664ull, 0x342EB04461887999ull, 0x7466C188691AD722ull, 0x6793705035C694A5ull, 0x614F2D1026C061CAull, 0x29E8546472450F6Full, 0x150E63E305B17200ull, 0x2174A69E709B663Full, 0x6FAF302F7F52F749ull, 0x3AAFB0882BDE19AAull, 0x5311A48E5E59C4C5ull, 0x43F2BAF86818357Full, 0x4BFD3991113E79A8ull, 0x6F3F9D1632C00DA9ull, 0x1CAF46E01E1E51F1ull, 0x7199FAD521347EBBull, 0x3E4F985525C8AB1Aull, 0x2BCF85432B659DEull, 0xEE3823C6A5068A5ull, 0x687CEE837032AF4Cull, 0x1110CA6F126542E7ull, 0x6277BEBB261F2E52ull, 0x1816B4E803EC655Aull, 0x16BA949107C5E517ull, 0x33F5CA3516A4519ull, 0x33A3FEC256510131ull, 0x2FC409DE7796B9BAull, 0x3E6936B17BC1436Full, 0x8D533622DA8D3C7ull, 0x2E81511825847A42ull, 0x4BC725B9201B4BEEull, 0x46B8F8FE0A16BE0Eull, 0x45E3F7084975F152ull, 0x3CCD17EC54C77944ull, 0x33C659F7254A066Full, 0x44FA289044D72466ull, 0x37AF49572771E74Bull, 0x6AF652B84FC5FE3Full, 0x2B5E4CA501B0E749ull, 0x578BE3562E9DA948ull, 0x531B2C620B2FE218ull, 0x4EEAA7A02DF3641ull, 0x2C69BD34357E12Bull, 0x7EA079B00B9BCF35ull, 0x7100B4F22D21CAC9ull, 0x312049783CC7DAABull, 0x4D3D16B777D94276ull, 0x46DE98BA13210DBFull, 0x414F33C803ABB0A6ull, 0x67E8870375158DC0ull, 0x28F5B7162CE2AF93ull, 0x39ECB22660A5006Dull, 0x545496DE24E304DFull, 0x306AFEAC7FB2E384ull, 0x2693EC2807F6E202ull, 0x2E508CCC79AF188Bull, 0x1326C41B333F3746ull, 0x7C8E4ECC15ED5FEEull, 0x769718717B2EC87Cull, 0x21892F236797CD64ull, 0x2850934552A9789Bull, 0x245FA80F758DA9FCull, 0x4A82BB116B3E40C9ull, 0x8AEB7BB0BD1EEDAull, 0x6EE9F17070973EBEull, 0xE77C9A17DFA886ull, 0x1D79EE513AD42EC0ull, 0x7884A8F371CE8530ull, 0x5FB7339F28EFA79Full, 0x718168B4064B1FC8ull, 0x30E689A11FD1F580ull, 0x7FFA3853440D4DBCull, 0x53112CC77C88871Full, 0x59FAADAA49A84538ull, 0x77B74F9B7B83DCCEull, 0x3140129C2007E2E1ull, 0x4E2D5569559FBAACull, 0x15958CDD18B0107Bull, 0x40DDFB751E444499ull, 0x2481FF552FC7ECE5ull, 0xEDB835725697BEFull, 0x47A7956B2C5571A9ull, 0x603DAAAF402C3E5Eull, 0x1E23F6D93FF4DE4Full, 0x691BE5FD0FA55F8Dull, 0x463FFE171A026F9Full, 0x2F77550D463A366Aull, 0x5E0FBD5B028881D4ull, 0x42C2BD89380A6B06ull, 0x4C30C70D3A7A0D24ull, 0x338E47D47D70D9A9ull, 0x5A81F00501BB9D3Dull, 0x5310945570177CE3ull, 0x1A6BADB813EE8FCBull, 0xE5BC17C3EEDAD0Dull, 0x43B67CB01D3744D3ull, 0x645728FC0B5E121Cull, 0x498CB67C4494D3ACull, 0x4B8A507A67B0AD55ull, 0x489B1FB34A63678ull, 0x77560CE24AC9B012ull, 0x4EA8A61726CD61F0ull, 0x1103E67C2CB86372ull, 0x2955E3C453C6A405ull, 0x64C2CE787586AAD1ull, 0xE40B1291851164Cull, 0x72F7847B68C2A12Full, 0x1A0CB38A460818D0ull, 0x58DA1E1234786142ull, 0x59F6A89B6735DF8Eull, 0x73660E501DAD254Cull, 0x46D246157BD374Cull, 0x290B37684DF9DADEull, 0x1C520AF8749587E2ull, 0x35AA883320DBBCF3ull, 0x293BBE5A2D009516ull, 0x6BA56D0577E46471ull, 0x53CDF7067CA95381ull, 0x249CC7E47D23DACAull, 0x506FF786095F965Cull, 0x72AA859C5EB0A8B0ull, 0x21B0ACA965A20A17ull, 0x477349DF3BBD6033ull, 0x2BAA22E7204D67F1ull, 0x7035C17505A0CB83ull, 0x783477F639BCFC5ull, 0x234DF0CF0BF06BE0ull, 0x3B5907124C592837ull, 0x59EA46BE57AB120Aull, 0x40EEB0190F94CEF2ull, 0x7886CEFE6A2A6E74ull, 0x3C956408642C3C03ull, 0x620ED2E510635B0Eull, 0x60D58F8506AB9AC9ull, 0xD8735D83145870Bull, 0x100B31260031BB74ull, 0xFF62FBB31BBDDCFull, 0x65D3C58B5769799Aull, 0x6D793E02117DE873ull, 0x77B6E18B5DAEFF77ull, 0x171EB3F67F3A290Aull, 0x414ACF3D3A6CA4C5ull, 0xB2A94EB7CA3D64Full, 0x6C5CCFC6514DBA9ull, 0x544EE85947B47D15ull, 0x74A9AA9B4CD5B757ull, 0x31DEEB89313F0EA3ull, 0x3101F35B13EDBE6Full, 0x41A269B111D782E0ull, 0x1A9959384F299F8Aull, 0x431D09EB2AA48A5Eull, 0x4F5B5AFE531339A7ull, 0x5C60682D352F208Aull, 0x2A7CB34149D9A62Full, 0x46AD08FD223394CDull, 0x2788A5A75DCBBCF3ull, 0x216DBDD768D374E4ull, 0x183861B82C9852C2ull, 0x65774B331EFE2EB4ull, 0x11AD2E6C39C6338Cull, 0x66B2ABC90656D907ull, 0x69BEAE418919753ull, 0x3795E7AB379DDE3Full, 0x2C7F55C27938515Cull, 0x4975611F4718AEFAull, 0x4861F0E60C926B0Aull, 0x71BD395917BD4BE5ull, 0x5FA5A4B14E1DA186ull, 0x4CEC6C6F0A2257F3ull, 0x17F747B61399756Cull, 0x2C55ECC03F7FED5Dull, 0x7165325F4DC3AA97ull, 0x28536241099D9417ull, 0x7A5BFD5A0DCAAD74ull, 0x289BC2CB0C092BC6ull, 0x4790E1000F4E6E94ull, 0x126004CD4E2CCBE4ull, 0x27E005E749F5EC78ull, 0x5CAAA23545F5BA9ull, 0x432E3DD54F400B42ull, 0x1B780AA40B902EBBull, 0x5BD2764D0D3543FDull, 0x234D7AA03B781AFEull, 0x5B52E5837039E70Full, 0x459A72F1734A2D39ull, 0x3D35C7B71F05FB1ull, 0x32CA1A9675388EDAull, 0x3FB40A495B1D7CD7ull, 0x7ED622F13A1007A3ull, 0x68E82A4B2771E5BCull, 0x4619336930790B4Cull, 0x36C0545158793836ull, 0x7EA5D7305EA05A38ull, 0x226F24AF04708154ull, 0x32FFB5E2659D6284ull, 0x53B08C964E77C086ull, 0x712D913F2F8302E3ull, 0x5BAD0483147B0BE0ull, 0x6AFB1DE236FFEA06ull, 0x4B4F2EF309590D3ull, 0x2A4A174008884F6Bull, 0x2285F0855D1431D6ull, 0x7DC0DE456239FACEull, 0x3831AEAE7C970137ull, 0x1C4A02712119D8F9ull, 0x2408E6F3626335DAull, 0x5192E4455AC93B44ull, 0x3ADC6E105038BB76ull, 0x3969957D5D4B92BFull, 0x54A93CCA6C694B5Full, 0x42E8F5432859C960ull, 0x3AE10BE534168683ull, 0x57DCCC44168E1068ull, 0x4891926342D7EA26ull, 0x4D8DFA6E4D468552ull, 0x736D7AF977D811AEull, 0x55CED4BD15F36B7Eull, 0x54EC4385538FB303ull, 0x782D664C0D1DF233ull, 0x5026B43A147768BDull, 0x2E37CB2C742F9B2Dull, 0x76DA9E977FCAAF72ull, 0x4EF8D67231B70CA8ull, 0x50036AE808626BEFull, 0xF029F6724ACA7B2ull, 0x74CBB74E51EB94ABull, 0x4D0671122FACC333ull, 0x6021B2E24E33D56ull, 0x463AD39B4E93AD91ull, 0x67BB277C13C8CE09ull, 0x1BDA32E35B28A276ull, 0xBA0DFB871A907A1ull, 0x711C0DF4608D233Dull, 0x4538BAA469497441ull, 0x6DAB1570155F6EDEull, 0x7DC0DCFE1BE2E09Cull, 0x98F0A0B749B7B96ull, 0x1BAD900E5887E07Dull, 0x2652883E6BB0FAF6ull, 0x60EA4C6C355527A5ull, 0x105DA2A855B603BAull, 0x740BC505D6413BBull, 0x562C6ED0D42D77Eull, 0x24751114B9D9A88ull},
	{ 0x5BD6850F6A02788Eull, 0x5F66689277B0B7F3ull, 0x452B1B046B07484Aull, 0x6959BF94364728F8ull, 0x4B946B872E927A38ull, 0x1F909D39393F80F7ull, 0x43F1E9161D517A38ull, 0x552261934D80F321ull, 0x11ECF5CE70CFF1A2ull, 0x2608D39F383F7E0Cull, 0x5C80EC9806F3200Bull, 0x6D94A5B16CDE8F41ull, 0x5CA923C674D56202ull, 0x4A42A2FC620BEAB3ull, 0x21839804C89F40Dull, 0x2DA9853C5DEEBE90ull, 0x368C6C9B0D0FEDCEull, 0x559F76837BB7879Full, 0x781736183EF93617ull, 0x31FEB09843ABA19Full, 0x6D8BB04F518F4DD1ull, 0x7CEB2296317D9965ull, 0x6EE0C809520D8429ull, 0x7EFE8C8600CDBDD7ull, 0x42DD75CB25076025ull, 0x390D3BE31F5E6264ull, 0x2BFA803126A1E195ull, 0xC3CF1A508A3A3F7ull, 0x1B774397567F94A1ull, 0x6AAF8EAA1D8F7D17ull, 0x230988AE185913E6ull, 0x7B7E3BA75995F54Aull, 0x256901B4511DB22Aull, 0x554D7CE91D8037CCull, 0x1016E841074C2D81ull, 0x612BD96B7DA29890ull, 0x58DB7B535E16FC01ull, 0x2F2031F547BC435Cull, 0x3024802B2E1EBE7Cull, 0x488A01347301F5F6ull, 0x53261EA101973D17ull, 0x1260585A7F209ED2ull, 0x28391EAC1E9D49FFull, 0x7C442C943B06243ull, 0x751CDEA07273D174ull, 0x613FDF5B1826674Full, 0xACCE55A5CBE1B02ull, 0x71BC5C993035E70Full, 0x2DDBCD2D4709D982ull, 0x4DB61EDB3DF2B56Eull, 0x4E5607042EE1F847ull, 0x3B954DFF27318257ull, 0xCF8F4486AB57FF4ull, 0x6EEDC5B33D1D7473ull, 0x18D43E703777C6E7ull, 0x301F6A6A6BFA5D12ull, 0x390F03FF427FC2C4ull, 0x6B1AFBE4614822ABull, 0x611D0CC472DF3EAEull, 0x24F884EF5639EB64ull, 0x655310220638644Aull, 0x6E6052B3701FF57Cull, 0x62F67F4C601CAF4Cull, 0x2055DC8B10D24C79ull, 0x272688CF6E0BFB67ull, 0x4EC501E8757C8FD3ull, 0x1CEDF3AE0A5A4FE7ull, 0x1CAE122A29E6E7F6ull, 0x750FCFDB0B9BD7DDull, 0x67045C6A0DE40E4Cull, 0x43139EC51723C6D4ull, 0x79DE6B5E7C22A2C4ull, 0x59A3899864F96742ull, 0x5D6AC56F3AC0965Cull, 0x57D8A5F002634A5Eull, 0x10FA81C13D2BB612ull, 0x89BAEA87F5AD474ull, 0x2D4BAB8F6B922DF5ull, 0x5F7783C14DA1881Aull, 0x7C647A6E069E0C90ull, 0x3BAD83814B297C56ull, 0x7C1A9C63589B772Full, 0x5583CC3D18C8AE8Dull, 0x2825F264A939C19ull, 0x2464866A6986BB90ull, 0x5877AA656778252Full, 0xAA8264525615C3ull, 0x639AC7F35A4E0BFCull, 0x374F7D0541058D63ull, 0x150EA2590F2822F6ull, 0x4368D7C12609241Aull, 0x4C53D9084C04866Aull, 0x2563F88E799F8497ull, 0x3796B45F04DB7C4Full, 0x47410CB233FB2ECDull, 0xB7988DF02EE9033ull, 0x7F24AB2407942542ull, 0x5B8A076354A87761ull, 0x205CD3CF5E0C6689ull, 0x1F3C137A44C15A3Aull, 0x4793221977B3BDDFull, 0x2C397F69483DA47Dull, 0x4A09D3A20FD4475Dull, 0x228BB079015950A8ull, 0x50D9D4C0379A52D2ull, 0x1081739E1442AC81ull, 0x5DA376EC5CD54CA6ull, 0x604732EB03076F7Bull, 0x5674D13E17DDE74Aull, 0x7E2EBCA1DB5DDF0ull, 0x4BD91618135C74AAull, 0x20A46E234AFDC13Cull, 0x1AF099EC7C2E7586ull, 0x1FA6389D3B4D6DBCull, 0x5A3ADC0F3EE24C18ull, 0xEC7F621CDFE28ull, 0x369609F72C48475Full, 0x6A0BA2A5009FDD9Aull, 0x3C1C8EBC0C97531Full, 0x1F92E420CF6637Cull, 0x4431A5F1127AA1E0ull, 0x21390FFE21D51CDEull, 0x6F4FEE86018042E9ull, 0x24DC8C5945C4BFC4ull, 0x195E2A342CBF7823ull, 0x637A9DB46537404Cull, 0x401BECCD041F0BD8ull, 0x303501885B0C86BAull, 0x4D815E4FDB3A25ull, 0x1659F4765A885D6Eull, 0xEBD863D1668BC6Cull, 0x7C565B9645539035ull, 0x42B103CB6661FE3Cull, 0x45F36DCF7ECD9288ull, 0x72F9515B47EC9C11ull, 0xBC3F604372AF74Cull, 0x5A673DF12CFD0602ull, 0x5900142A49B72C77ull, 0x2E7D48EC7DDCA083ull, 0xF7BEC3C47DB7320ull, 0x2A9C18A772F689F0ull, 0x2D12B36C6AB80574ull, 0x771595C85D47B4F4ull, 0x45C48C2E77631727ull, 0x2D22EF195C1E80A4ull, 0x51EB74953BE07557ull, 0x72873D104E41D02Bull, 0x134058C353840DCull, 0x34A3CE674727735Bull, 0x3405D364279D1FC2ull, 0xF140F6C3FC9C968ull, 0x5EC8170F697B4D5Dull, 0x6CC6CF6B37C82B39ull, 0x333279D41B441857ull, 0x35A4CBBD42AE6610ull, 0x631F8B776040E464ull, 0x35A4F00110323EE3ull, 0x4AF8E9D82CBA85C9ull, 0x6D79F3D710BD7607ull, 0x241D9CF01A9CE2F0ull, 0x6CDBF6AB76091185ull, 0x567D58475F6333BCull, 0x444AE1B157B15DD3ull, 0x149B749878EEB018ull, 0x1ED8D12E48A147FCull, 0x208BCFDB2DECE09Aull, 0x86B11647F53E6EAull, 0x17682DF77531E0CFull, 0x371C12234A9AA7CCull, 0x1075F9266CC0DDE0ull, 0xD490DDC7395849Dull, 0x4D01C24442EDFDDDull, 0x3C7C38017FAAC1Dull, 0x6FA883A77141B757ull, 0x28B8222413C62097ull, 0xBDE9A48159418CFull, 0x9CF321D625BF28Full, 0x74F74C8B4E1A13CEull, 0x3A0D50630992C123ull, 0x4708C3E658E62191ull, 0x5234091F679493C1ull, 0x6D3022C5A9F1A84ull, 0x66E87AAB1E3B3023ull, 0x4FD0FB531E048CCFull, 0x68D5D7EF6046F47Aull, 0xAC56AAF761EE5CCull, 0x53DC791757C72CF4ull, 0x390CE3A957A43C98ull, 0x6FC1D91128B56750ull, 0x48E5F3EF1879FB35ull, 0x3C7B87E854C48E37ull, 0x2E0E1404464ABA05ull, 0x372080C723056090ull, 0x1464CDD3712DD12Aull, 0x2C9821B35B6D91B9ull, 0x4A13F2BB7ECC2AD3ull, 0x4302257B50E6F4E7ull, 0x596B455729EAA026ull, 0x6F22250B293C40AAull, 0x47EF2CF557F7FCFAull, 0x983352452B497A5ull, 0x4E16E2C65D5FAE3Cull, 0x2A7BC4990723C670ull, 0x3503EAD41A3D9DAAull, 0x2FD92DC07DE9DEC3ull, 0x32B798DF6C54B5A8ull, 0x52AE6CFB60C5ACE3ull, 0x329F6FAD09CEEDC2ull, 0x3CB0D7347043D80ull, 0x7AFCBEEC30632F27ull, 0x2271CF3A4510B1A7ull, 0x2F2F59FA6573F4B5ull, 0x15F7A68F089A9F51ull, 0xF5E94DB0519CB9Aull, 0x31D6DFFB574DC1D1ull, 0x5D11C8943B5A1520ull, 0x2A0259762B28AB5Bull, 0x18B9C35C547E1E0Full, 0x324C71CB4DBDAE30ull, 0x6EBBBBB962259F8Bull, 0x4BA78CF321735498ull, 0x4E7A55341E55F9EEull, 0x239017B0119C4E1ull, 0x2824E7B006040EEFull, 0x481E02622321A69Cull, 0x36673E166A8FD19Cull, 0x6832584465969810ull, 0x5003C6517E29FED3ull, 0x6E3137615F625B2Cull, 0x343CA6D2008175Cull, 0x36B01CFD60559301ull, 0x5B622C7C60B27673ull, 0xB7E3E5C741BEFD8ull, 0x353094823DCAB027ull, 0x41D99E0823EC503Bull, 0x1FF04FB30D812AFCull, 0x455FA4D36E6AA4E7ull, 0x2BD724EA4798A64Full, 0x6F8469C853FC0C9Bull, 0x4D9CB53E37A26C2Aull, 0x771DB3370403F354ull, 0x22323DC65F500B7Bull, 0x699A8B6472360417ull, 0x5D7A0A4E57CBC2C5ull, 0x51985F4460BDD4BBull, 0x77D3DA2108487C41ull, 0x411367BD5336069Eull, 0x68FAF2B54C91A619ull, 0x4751F6761E2B8737ull, 0xA5C5641092B947Full, 0x4217D7732A4CA5F4ull, 0x16ACBF7B07777C46ull, 0x18B74ADB4283E465ull, 0x4F102295083BB4A3ull, 0x167FF1001CACD7D3ull, 0x3FDE20CE0D9DA438ull},
	{ 0x20B0CB2762105E94ull, 0x6CEDAFB30A4B568Bull, 0x544662AC4A67BA02ull, 0x6217195025DEC1F0ull, 0x2B258EBD59EAF372ull, 0x2E273E316C38F67Aull, 0x2D20FA10172230E6ull, 0x38CA9C947472F086ull, 0x354DB81E4326F2D5ull, 0x7D9E850577658F91ull, 0x6D7398C9144B4480ull, 0x7EDD0BD7062AE3A4ull, 0x56CF28E64DED2E6Dull, 0xE6698476D4F19E6ull, 0x6A9A06404E44B915ull, 0x7AECBE1E0B4AD168ull, 0x305517AA67DA6DD2ull, 0x159627F3049B7A56ull, 0x324227D477AD4144ull, 0x2A7A3C465D67B691ull, 0x519834B658A17A77ull, 0x49A0AD0C7EB92EC6ull, 0x6FC3AB5E026B49A0ull, 0x732C1F4C2511637Cull, 0x45923C7570CAA452ull, 0x1C76F30D3305D53Eull, 0x515E8D21B53FEE4ull, 0x3930B8E25BE511B8ull, 0x69412D5147975129ull, 0x49342B9F53DB3392ull, 0x15DC0A3F4420E9BDull, 0x5F2604FA463121E9ull, 0x2BFB578F74BC2CEDull, 0x4ACC9C3F5E3D7F63ull, 0x6C696E317546D885ull, 0x3BA535F53E01A2E7ull, 0x4DE852FC0545E301ull, 0x3CBAD1AD3DABFE5Aull, 0x7B12CA12FE6F0FAull, 0x62BD61D64D436916ull, 0x20B1954C7F3454E3ull, 0x493E5425C77E1Eull, 0x1A8853C83979F736ull, 0x1AC8FD703C98119ull, 0x111485F4AE0BB76ull, 0x57A4B4AB16ED529Eull, 0xF01A53336CAB9A5ull, 0x5D1E74873AFCFCC3ull, 0x2B86E69327EB10C6ull, 0x193A7C2617F054C4ull, 0x1D31E94B54DFB21Bull, 0x55F1F7AC6B1A3C48ull, 0x5A25951C12ACC959ull, 0x28C63AA261D6C1BDull, 0x4293BA530B839C79ull, 0x2F1A2AD363454F9Full, 0xAB7F15C2F636927ull, 0x90CCDBE25404524ull, 0x68DD605D0AB95D95ull, 0x2909C63E69EEA8BDull, 0x559A190B00AE7AE9ull, 0xDBFB5B649BBE3Eull, 0x3779348F5DFA6FE3ull, 0x1F98BB0163001B22ull, 0x5E580A938D33728ull, 0x7AF06FE6231769F5ull, 0xDB2E94350E26792ull, 0xE31A63D67D87E60ull, 0x638F30EC36F7E0DFull, 0x49AF401D2622EB3Full, 0x427B7D5878C96AF1ull, 0x9683ADF4D336EB5ull, 0x282CD4181275089Dull, 0x7273B3D9110A3476ull, 0x1D2E66321B7D7A17ull, 0x7AF8DD3372C87F3Dull, 0x1C2BF5017BD4D88Eull, 0x57643D7B53A52990ull, 0x59CF487176FCF87Dull, 0x36A544B25FB4C91Bull, 0x2FD02FA53195B498ull, 0x2CC33103D8318E8ull, 0x2781C2B10FDD94Dull, 0x255B974866074D17ull, 0x47F5BA2C6F0AD766ull, 0xC2A38560A713785ull, 0x67D4425715927335ull, 0x57A4A63A1001166Full, 0x28077BD24A185A13ull, 0x210B4AE54535E204ull, 0x6595D42B1C042818ull, 0x37FE614101C1C92Cull, 0x17D900A70F629EBDull, 0x5566F2BC71A84918ull, 0x65F973A0C0C376Eull, 0x515D1233362FC6DFull, 0x3DA1EC0654294543ull, 0x73B2DFC7401A0831ull, 0x65271E90190E7710ull, 0x262155482D1CD8BDull, 0x8194E76324B8D9Full, 0x378E10426FED90CDull, 0x47DE00D40F32B67Cull, 0x7FEEA73C6FE57CA7ull, 0x594B108F20F9F222ull, 0x351B5EAB3EE0E4BAull, 0x3CFE1A3A6D19BFEDull, 0x40A2ADE654D71AE1ull, 0x7C7C5EAA1609A0A2ull, 0x467F63FA02DBF5E4ull, 0x2215D81017DC762Dull, 0x390BBCC35FB7C417ull, 0x6C05BB712CBE9C8Aull, 0x1FD1CC48512CDA01ull, 0x45CD139A45F32191ull, 0x7E49B2BE4DE66210ull, 0x783EAF3035D7C300ull, 0x3DD3F2DD401CB004ull, 0x450A797C3DC29A1Aull, 0x30022CAB1E558A0Cull, 0x5EBC8C3C651D8B57ull, 0x5D366EC61BBAA676ull, 0x52374B441DD91CADull, 0x7091C1584EB3A9EEull, 0x33E2BD4F37112552ull, 0x518F9FD255F89560ull, 0x4EED9B7F0A9B5C95ull, 0x35B059773AF356F0ull, 0x3759F91F558225BFull, 0xC2030F27D270CBAull, 0x1B7547500A69E3B0ull, 0x4B0D6ECA13B3F680ull, 0x4041A6B108E161A8ull, 0x53D0A685054C202Dull, 0x46A3FBC203D2D330ull, 0x23A1AA39256087FEull, 0x68F05E8700D81900ull, 0x411B2E743B27A9CBull, 0x1EB135AD31ACEFCCull, 0x9DB53B95293F2FCull, 0x68BE151E5B6AF38Bull, 0x288C885C37ABB09Eull, 0x660650205E3CE1D3ull, 0x729F078E1D604940ull, 0x33BF07937EBF3880ull, 0x1A8755FA4F344EE3ull, 0x9291C316594C4C4ull, 0x62E84564496AC2E2ull, 0x6E76266C36B8EBE9ull, 0x4EB6E30F351A222Eull, 0x3A8BBF1972588D49ull, 0x5A7AAA2C237C1DA1ull, 0x7330A6491B95D8A1ull, 0x5EA3C76C11E1DBF6ull, 0x4D42C86D687F1B26ull, 0x6475CEF23600DD8Cull, 0x43EA0EB10D02574Full, 0x6DAC8E2A29F05ED2ull, 0x6B3F3922604B95B8ull, 0x4750A8121EFE40B5ull, 0x5F0ACE3961D7FE0Cull, 0x6E328F996833EA6Aull, 0x476CC2D0511AD4FDull, 0x319EAD4C35E2E93Dull, 0x7D3C0E60055905Bull, 0x6AFD0B6B425F7FFFull, 0x72AE1DA44577B598ull, 0x65DB9DA065DEC3EDull, 0x610D8E39447F650Dull, 0x77C09FE32E5056A6ull, 0x2CFE80335C366ED6ull, 0x6451343270E88EE4ull, 0x6938C62551FDC25Cull, 0x1AD8EDB65477FF47ull, 0x32495815622995C8ull, 0x73763FFD1154264Eull, 0x440193D461A8CF96ull, 0x798810B80B6E56A5ull, 0x32C3A4932B26BE04ull, 0x41513FE23A976579ull, 0x2B7C4E5F2C4E4B4Dull, 0x7CF6E5781E2A6C04ull, 0x71C600E562D28319ull, 0x4092FF152D38F1Eull, 0x2751E8267BC9CFD5ull, 0x123E5C554506859ull, 0x58003EAB657519F7ull, 0x4538F73D413904D0ull, 0x3772DC546011E4F4ull, 0x15B1041769BC3469ull, 0x423B7ABC09274414ull, 0x7B105AB7063D0E91ull, 0x6AD013AA74986B6Full, 0x11AB65361D93B83Dull, 0x1FBF297352FCA518ull, 0x582B1DB64B3B77D2ull, 0x7F4AF0655522032Full, 0x6965E3D67110F14Bull, 0x37F486486D6F13C8ull, 0x43E480695F466E6Eull, 0x6938E39D4508662Eull, 0x3396D6C741392248ull, 0x2A7D802678CFCE04ull, 0x272271861F05C7Aull, 0x58E1B2F818232B2Full, 0x4BAC90E31B1D2DB5ull, 0x214A6F4446BCEB9Aull, 0x215A3C460C1A82EEull, 0x3B5557093305A17Cull, 0x29AE3B2C5B14807Cull, 0x602469401D958E2ull, 0x264FF84E054D36F9ull, 0x56FB5C110FB5DC25ull, 0x765E28440EEFE259ull, 0x7D24EFED3A42A8AEull, 0x6E3650C7665DD38Aull, 0x7F4B0EDC21CD278Eull, 0x2796F5D229C88F02ull, 0x1A9CF5932A091CEAull, 0xBB8EB7C737EA88Bull, 0x422C481957657C5Full, 0xE9BD6406376B75Dull, 0x1E2267F92FF61286ull, 0x6F913A4C5977BF02ull, 0x62FBB402193F7578ull, 0x348C3F7E68FDFA96ull, 0x1B18CE5A5ADC37CDull, 0x6E4B319072142A6Cull, 0x6A9213F264A959D4ull, 0x1040CC567B703DFull, 0x1EEC02826F3A5D8Dull, 0x4E14D7691E37115Full, 0x1107851B75ABCD3Bull, 0x47FFA0612BA47AAEull, 0x1FB4EA2553B88BDEull, 0x1F23233A61E1323Eull, 0x2B1E083D2DBEF97Aull, 0x4557E99C49407037ull, 0x5DB50C0134E923E8ull, 0x22B82F3940B0C003ull, 0x4E28996057446EB8ull, 0x29AEBA9A694167BAull, 0x3220A68517F9EC2Aull, 0x5B5592261CB2BA77ull, 0x7CA345FE5C599EECull, 0x469BE561B8F4881ull, 0x4B93FC79527E95BFull, 0x39C659E05C9B8194ull, 0x482A62FA01C5FA41ull, 0x83FFC4367DF4D1Full, 0x557E861F27631F7Dull, 0x49C07F5D009C8E5Dull, 0x552218F70F1868F9ull, 0x49DCFE9432D724F8ull, 0x44018CE16C952DCDull, 0x7387E4FC122A2641ull},
	{ 0x43D99C851D369F96ull, 0x7B6B8DFC75FA430Aull, 0x35308BC056C12022ull, 0x12ACFD8131D3D1BEull, 0x331ABF0E1716BBD7ull, 0x4D631A3F7EAEBB87ull, 0x699551960729741Full, 0x5B4A3D1C31BFB490ull, 0x8EF6E61638A395Full, 0x199F01AF5E6DF480ull, 0xAED58DC635F810Dull, 0x5F0A82DD600F71D3ull, 0x7277EA0628E78171ull, 0x12E696CC367976E8ull, 0x157CAF3F066E7BC8ull, 0x48A39D2959564BC4ull, 0x23A51B5E440F2B25ull, 0x4F508ECF58D5A71Eull, 0x1AD04B4861FD8C50ull, 0xAA978DC4DEB0A56ull, 0x79144828580C931Cull, 0x4C99C5DE62A999BEull, 0x5F36073B27E402FAull, 0x14694E4F6825759Cull, 0xB6E3C592E084FFEull, 0x46936A1D165B9535ull, 0x1167D10B259DECFAull, 0x766B070803DFBB12ull, 0x4E856E6C09519DD4ull, 0x3A5931FA64021DABull, 0xFC0199C02FCCF23ull, 0x3D58696F336534FAull, 0x470BFA490CA8F83Eull, 0xC3ADC1861DC4591ull, 0x6EA6848F16E454F5ull, 0x2FC74FE767BACCB7ull, 0x6EF0E8117C6115C5ull, 0x4A6466754E26EF4Cull, 0x244518BF5ECDB4C4ull, 0x364C64E92FB35518ull, 0xCD604C37CDFCF06ull, 0x460EEA4D1E3DD5CEull, 0x227DBC003C79F156ull, 0x221D90E071032A6Cull, 0x45CB8F2A5C76C2DAull, 0x55054817558BA8C7ull, 0x5F7391FE125DB187ull, 0x8F0DDC1267F8C47ull, 0x1F06A9C5152BB9DAull, 0x85BD1D80DAD2E54ull, 0x2C100ECF382321BFull, 0x7567FB0B1B00F6E0ull, 0x348437853FCC6181ull, 0x6927E62C58C95044ull, 0x1E9A16451F744B15ull, 0x87CA55D2B701B08ull, 0x1C541A1B4E8B8FAAull, 0x49ADF0D73ED1D61Cull, 0xB0581006BCB81B7ull, 0x2FD5008850D1102Bull, 0x4842449204DA48A0ull, 0x265CB8F227B5D690ull, 0x1737FA272F4D96B3ull, 0x4E3562D7363EA3ECull, 0x4479508D569134AFull, 0x43EBD24170895F5Cull, 0xEB4566E3953CD4Cull, 0xB8A563C43388DF3ull, 0x79202ECD74B23C69ull, 0x1C01DE3817BA4513ull, 0x1426877E247E8395ull, 0x432A601B307AA19Aull, 0x730A133F0CD850F2ull, 0x6F4C77B67E0F9440ull, 0x78A3D2AA1F21783Eull, 0x4EE0A46B40E6173Cull, 0x23FBC0DE753D5D5Dull, 0x689BEDCC3B33BB05ull, 0x248AF41036D150A3ull, 0x71725EF26904449Eull, 0xD628552355E3133ull, 0x598DA3FA1C16DBC0ull, 0x6EB1FE7F6517FA37ull, 0x5F4F69B467D22D4Dull, 0x59CA36A07B5147ECull, 0x7F8C72606DF0BE1Eull, 0x1FCFCB8142B6D27Bull, 0x1E6B5FB812D9DEC0ull, 0x4F8F236E0DB7D76Eull, 0x10E973004832F618ull, 0x2CD94FAD5FCA176Bull, 0x9190D5450D5108Bull, 0x550774C871B4FB20ull, 0xC08CB91799268D9ull, 0x28864BC37D7B2A83ull, 0x6296AD7735E8D115ull, 0x32D95BB63C245171ull, 0x51FFACD5218B5A35ull, 0x213C4BA8314F1689ull, 0x95D87827B068248ull, 0x2CA05E7508E9F9E2ull, 0x68F740674C7029F6ull, 0x4BA0CC5E0762A01Full, 0x5F4A08B71B2FEFCCull, 0x151A778E70337BB7ull, 0x6362E5E441F3C73Bull, 0x4FFD93236C7BF338ull, 0x12C8D7C6250507EBull, 0x5E30EE581ED1A357ull, 0x1E9770C406B73A1Bull, 0x1C4CCDDA012E1E3Bull, 0x3CA00B304F262990ull, 0x3D526FAD0E9FB805ull, 0x70B183C65E8EBB55ull, 0x3FEECE8F7A0F0B48ull, 0x59953D9E6C8F2D04ull, 0x2F9052B428C7E05ull, 0x38FF56FB4E99D189ull, 0x49EF1E2418495FB2ull, 0x69C9C1555F0995B2ull, 0x87CDB694D2CA739ull, 0x20FD5CED587A6E8Cull, 0x39A89A7133C634B4ull, 0x7D7F767817D988C9ull, 0x5297D80B1C16E73Cull, 0x1E90C2E46EE4A5E6ull, 0x1D4505785B30CE14ull, 0x3E0ACF765A977525ull, 0x69D086192EBC533Cull, 0x3926307A29BF54A8ull, 0x28CB5E8512BB6E18ull, 0x164E81AD2BC463B0ull, 0x5547EC1D4F4DD8A8ull, 0x7A5E35391F370A42ull, 0x6797385A6427F68Eull, 0x7E409FF4701413C3ull, 0x31549DC71F3DFCE2ull, 0x488E82506AFD3838ull, 0x53043196460DF8C8ull, 0x2D6C101259C09A1ull, 0x6224E004216783E5ull, 0x1480AF877F69E57Cull, 0x7C9851F9528B7EFEull, 0x5A015AA16668D812ull, 0x147D23A13278B1Cull, 0x10282CBB2A1330BFull, 0x25E2F9342676AE68ull, 0x55D7946F7B2AE552ull, 0x75C487105035C9A8ull, 0x1A61EF945D5BBF6Aull, 0x345DC03618A28F88ull, 0x4D6FD32D65B25DFDull, 0x37E08C6A15FE557Dull, 0x50AF96350AE4BE00ull, 0x5C0C4E4553865736ull, 0x3080C7A23E312E4Aull, 0x74EDDB1B45017729ull, 0x3D9B13C671862D14ull, 0x178CF627179C6E68ull, 0x57EF052718D4C862ull, 0x2AC3F984681731E2ull, 0x42E7F92150A6F2B8ull, 0xE8DE04A18BF8D91ull, 0x4BD1D80A0452675Aull, 0x68F557396633C79Eull, 0x61AE26C41D531770ull, 0x7ED657272F1DF9F1ull, 0x305756D36B6E391ull, 0x451C4F6F53B50BA3ull, 0x419BA19221289DB4ull, 0x273B62D9721C6934ull, 0x5F59CBFE1C293DF5ull, 0x371DE05D1CF4DFC5ull, 0xDAF6B094EAAD685ull, 0x34914E2D659E7030ull, 0x677F9EE75F5547B1ull, 0x4DB5A2122A679808ull, 0x2FFC3A695C43825Cull, 0x432725997BCE1274ull, 0x6095E9B62C1C7CD3ull, 0x6201DA124244107Aull, 0x496F944360D83139ull, 0x71620A6C4C7509B0ull, 0x178F14CB367E59DBull, 0x202A1553592AB65Dull, 0x57A6F78F4765782Dull, 0x4B471F913700C38Eull, 0x638EB6220264FFEEull, 0x53F5A353713E212Bull, 0x510FD6730886F180ull, 0x56DC915C388F755Aull, 0x67DC39312492336Eull, 0x62F70D6317D8739Aull, 0xD5B5CB261E32FCull, 0x13A6860E616B9F81ull, 0x523AAFCF75A86021ull, 0x23AFAFFC1BAA4412ull, 0x5680915A1511BA68ull, 0x681F4DC36E0FA625ull, 0x4B90144308496316ull, 0x473A5C8223370BD2ull, 0x4FAEDB4312817C13ull, 0x5A37CF60333D9165ull, 0x14E67C022E2D72B3ull, 0x247BB29165F65275ull, 0x36B464337B5843EDull, 0x1E85C7D01E909D64ull, 0x1FEA775B017CD533ull, 0x366910FF20C02D26ull, 0x279B082F4A0F970Dull, 0x22BCCA879D5B7FFull, 0x3FB7F72E25DB7CA4ull, 0x157FFC1116388889ull, 0x3AED370C7D9F49D4ull, 0x4482EAE067D4B4Full, 0x5E8ACEB4B828B31ull, 0x29B457215597882Eull, 0x5E04074403EC2682ull, 0x8D5199472EA8346ull, 0x321999352D50CC25ull, 0x58E0D5BC68CDFD69ull, 0x28A9101277669D8Cull, 0x75E9ACD4893876Dull, 0x78E372BF3DC7ABCCull, 0x6953B494207E7AEEull, 0x7D742DA6B7F813Cull, 0x1A5432ED478F3A08ull, 0x115AFDE02FD42EFFull, 0x5DC7C2914C4834ECull, 0x2D7378D3620FF140ull, 0x52C5803B335C25BEull, 0x2D927C717C79D75Cull, 0x8F3ADED0B9683B5ull, 0x65FDDE11C8C781ull, 0x7E8106FC327F9714ull, 0x3F1993A65761DCB8ull, 0x1B4D947D67C2A3B8ull, 0x4EC87A4422AC2F4Aull, 0x30562B2547ABED03ull, 0x6073DB1719A9DFB9ull, 0x682A67F1684B1DF1ull, 0x52960F5027E9ADFull, 0x2FDA57F916845ED5ull, 0x3252C9DE0DA21A8Bull, 0x62CC93C15FC642B1ull, 0x6FB20BCB359213FCull, 0x132268701D44883Cull, 0x320BEB591C16165Dull, 0x28DB0BF13271E937ull, 0x2DDEDDDE275C12EDull, 0x64F1804B6CF87184ull, 0x7EBDEFA5003F14C8ull, 0x54BB153C4D8669E9ull, 0x22EB441305114061ull, 0x153256EC035F1F2Aull, 0x1EBB201B7D5CBEDEull},
	{ 0x6BAA3D1B23E48110ull, 0x7FDB59BD1B849514ull, 0x3A68DFE6322E239Bull, 0x2926AF9F1D3573A7ull, 0x11F4664C18D8BB6Aull, 0x52C787A42516CEBCull, 0x361D43A604D372FDull, 0x412CE5195EF84F98ull, 0x37455C346F0BC2F7ull, 0x65462851C36DC80ull, 0x5C04347B0512522Bull, 0x1C75F14830BF49B7ull, 0x5298BC143F61355Bull, 0x35D08A1967CB1301ull, 0x42C05485548BAA34ull, 0x6527D1DF2E6A91A0ull, 0x78702B4465032B9Cull, 0x49EF26B532D90B2Aull, 0x17314F377315D654ull, 0x500E7ED22925B583ull, 0xBEE91BF22D60676ull, 0x4E3C8440420BD565ull, 0x27A979730F696959ull, 0x210424FD5EEED5A7ull, 0x7E752C5127588783ull, 0x7B25B2275A7960CCull, 0x2C6AD9AE179BA370ull, 0xB38AA847F0395C2ull, 0x56FCD8CB4109349Dull, 0x66CEA8C319BD2D51ull, 0x1594DED14BF67AA2ull, 0x4827BEF10E050A15ull, 0x30F9A63E1216E5A6ull, 0x40DE1540482AF575ull, 0x52CBBFB10EC9412ull, 0x7150AAF9111B4DBAull, 0x33C29A883F8D2F39ull, 0x5327231F5B6C13FBull, 0x4EF69892742B481Dull, 0x3A5AE9A24D6BC4E3ull, 0x1B83CFA035809BCAull, 0x27E525B047EEA94Eull, 0x4D1C3F3A331DD034ull, 0x46F23F1024191805ull, 0x742704D12DC0E7D4ull, 0x3DD6455609BBE3A2ull, 0x79B7627605FE0448ull, 0x17C0EDB72AB108B5ull, 0x1814E9EE589F02F7ull, 0x72DBFE2A1D41A5E9ull, 0x698B9709642CA923ull, 0x2E5CF3A31D4E3191ull, 0x23B9D85C018416C3ull, 0x78BA458C72B070EFull, 0x75AF5EE033152F2Full, 0x401C35D211332E80ull, 0x6895CAF968015B82ull, 0x5921D7CE35B20A33ull, 0x1B1F2BB6201416DEull, 0x59CB22380F463087ull, 0x4DD4FEB217A1678Full, 0x19021429478C6129ull, 0x1D9F6BD730C301E1ull, 0x723D69DE35B455C5ull, 0x96204D865196808ull, 0x52F5FBAF72ED9BE2ull, 0x4946112C0152EF52ull, 0x103BCD736CFFE988ull, 0x2D7061508F61300ull, 0x5FB05A77788664F5ull, 0x3C0B422F1FCC904Aull, 0x9B9937524A10D28ull, 0x7CDEBCC62DB6B43ull, 0x5A53175B22ED1783ull, 0x2EF8222341E3993ull, 0x3233480A50C480D4ull, 0x4BBFA1224B355C34ull, 0x1850E1FD695F0CF9ull, 0x7BF85E150A8E4BDBull, 0x1F1362BF055A62EDull, 0x6FA7B3E472095E6Eull, 0x7847FECF38EDC510ull, 0x735C4DC00883CC43ull, 0x25EDAE98763353D6ull, 0x1179DF43059E0910ull, 0x6EB9B8CB4D852172ull, 0x256A995A78734C41ull, 0x72262E9A2D388526ull, 0x5B4EB7844C7945F5ull, 0x50259CA95E3E39A6ull, 0x977F880258E4B4ull, 0x2F02BA7B4C5720ABull, 0x4D8E40E847539C78ull, 0x35B62DA449869EFDull, 0x51E1E85454C99063ull, 0x4EE101EA41899C38ull, 0x46D2EED1472900BAull, 0x7A7761483A2F3C92ull, 0x4FACCCFD20650FE0ull, 0x306290686126AC40ull, 0x260318F01F1C4933ull, 0x2EABCDB24B6DB24Aull, 0x178F957420D1FC4Cull, 0x78A6377172DE4CF9ull, 0x6D4B424148CBD41Aull, 0x511C869F6DE2C1C9ull, 0x4B24B8CE001F411Aull, 0x3A39E27418B2F9B6ull, 0x4772DD936FF01019ull, 0x623998B31954C5E7ull, 0x44B9A07C311A9A9Eull, 0x5ADE621F0B8C8F4Eull, 0x78439B585555C367ull, 0x45BBCBE047F06855ull, 0x75BAD347761E5C48ull, 0x291714951BBDEC38ull, 0x153AA57B57C2E247ull, 0x672B9E822CCA3AF0ull, 0x7894DE935FD1D5F3ull, 0x1FA887E965E020D4ull, 0x289DAA0E70C50E88ull, 0x53C2E29D73C262DCull, 0x70E44FA30DFCC512ull, 0xC755C9338572D36ull, 0x7DECD52B6EAEF546ull, 0x51ABF31D42A675A7ull, 0x1FC98FE42C8A553Cull, 0x4E3304F5180D2B3Cull, 0x1E018A313EED0D5ull, 0x5FFD9391779AEBEAull, 0xA0D2D1D0914A826ull, 0x1358D8221F47D299ull, 0x60D78A6D7A8476A5ull, 0x4C120D89596C6900ull, 0x5A564C986BBA9572ull, 0x3F4C89D402F3F6A6ull, 0x5C7FA3FA130F6C72ull, 0x76B659834D63F39Dull, 0x210C3184032BB616ull, 0x5BB20D31EF906AFull, 0x71DAAB5C576713F0ull, 0x619F7C5611A43B41ull, 0x3F1692C2FD2814Cull, 0x29B1667D05D181CFull, 0x43C1522109AEFA0Full, 0x7D6C6DBA4DCE7F3Full, 0x12C3A23510C545DCull, 0x6D1651D8739B2CA3ull, 0xB49BC8139285F61ull, 0x4D0795A365A0091Aull, 0x24E2F4D30C541F78ull, 0x6893FFC0016298CDull, 0x1F638BEA5F4A5943ull, 0x4EC68C6B406FBD6Eull, 0x62760F595481AD3Eull, 0x5F68C41D5450BAB6ull, 0x2BE8C12F41084073ull, 0x65F4F5F72FDA2A5Bull, 0x70DAC1BF0FA65C74ull, 0x35ABAC2B349C13E1ull, 0x19555683331819E5ull, 0x26A93202C18F8B9ull, 0x43DD5FC16F80E4F8ull, 0x1FB4255C4F271C43ull, 0x28A944596CBBBAFFull, 0x34C7255D4D8C392Cull, 0x790FDA771D5B251Dull, 0x4EEED1F918736661ull, 0x7CA57E611DB55E64ull, 0x58E323CF5F1B8DBAull, 0x72370BA3384BE7ECull, 0x336C48701E1FCCD2ull, 0x7954286019613E67ull, 0x4DF9F72D6A2EEA1Full, 0x29079ADC03A5A358ull, 0x1ECAFE00425CF15Full, 0x36BDBD3D21359120ull, 0x6E75EA187A9B1CFFull, 0x10B676180E2A0F74ull, 0x49C23942395FBA71ull, 0x7AE5CA747E895E9Full, 0x6EBF39D73F5A4EBull, 0x1BE483BC55DAC597ull, 0xC690B4D188A021Dull, 0x739023FB654C2F1Cull, 0x77A58FD865C72F9Eull, 0x1D9817092B11D848ull, 0x3E6FC7016EC3F69ull, 0x447316B051E0F39Eull, 0x11B29886D7AB18Cull, 0x558696F61FE62789ull, 0x2FD7A2EB0C445434ull, 0x411BB8A91E4D8D04ull, 0x6DF713351D22EC2ull, 0x2C779C7850A1AA75ull, 0xB31E933275D66ECull, 0x4F2B0914121DDCD1ull, 0x1B530BD86B0F8CD0ull, 0x67F8A26827BC1725ull, 0x3998EEE5B88C663ull, 0xD0846417B3F1EC6ull, 0x414FF6022AA05D4Aull, 0x2650F70E4536F272ull, 0x418C9CB36AC40DBEull, 0x1717E61042A7C63Cull, 0x583EBF4A6C9E7D07ull, 0x628DEDC508166236ull, 0x78E2D13B23A9A66Eull, 0x2663EF3A7FC2426Eull, 0x757BD53052DB8BB2ull, 0x5063ECE300ADBE64ull, 0x7A38F29F1F8EF5F7ull, 0x12CB9B35158BFE77ull, 0xA9E82C77AC43D9Dull, 0x3D48159C0E3811B5ull, 0x564D04004A505BDDull, 0x977307B179CFA02ull, 0x74F0B9282FC8278Aull, 0x5CD3EC75367D55DBull, 0x1A8C354873EBD285ull, 0x79251C1772CAF493ull, 0x608A4F8C5BB309DCull, 0x7AE156C9596D20C7ull, 0x7F5CB04B21454603ull, 0x592F633574D8857Bull, 0x7420D1B529935018ull, 0x758643DF6E59C454ull, 0x4922460F0851DF14ull, 0x3E5C2CB53C0C8D7ull, 0x3161CB1412DD867ull, 0x61F8DA8C596320B2ull, 0xB7E34456B700B08ull, 0x71001AB4006EED6Dull, 0x1B3832924DD40729ull, 0x36EC434835C467DAull, 0x41BFD9AF30115F60ull, 0x288F5C6D224A293Bull, 0xBC4693C2370B336ull, 0x7BB74A030B211987ull, 0x44B5F93954E6AD38ull, 0x7FF99F0338D6CAEFull, 0x7E79FD51757FE2E2ull, 0x27308F43479C4360ull, 0x7DD1C1F72B16520Full, 0x1B5D0C3700E7DEA8ull, 0x6C442A767D55E6C4ull, 0x5A4AFF5A77C25EBBull, 0x68C5F1CC4B4B1A0Full, 0x78314C2803FE245Eull, 0x191F21382F1D8F71ull, 0x39C28C385ADEFAE7ull, 0x5F2EEED16251E8A6ull, 0x7D2924236AF3580Dull, 0x5C29BDC78E06E26ull, 0x761471954A789516ull, 0x4DC71B5E760E1098ull},
	{ 0x34F60054C4118AFull, 0x6B8DF37A2A7FEF48ull, 0x13DD5C10695FB571ull, 0x559641572F3A6847ull, 0x6A47941A41DA6BCEull, 0x2C904F0B44929374ull, 0x399CCA89155640D7ull, 0xFDDAD8331CE16B2ull, 0x1954653528FCCEBCull, 0x60EBA6235316F16Eull, 0x3DBC9A3401A94F4ull, 0x3568DA140104EDC6ull, 0x2B0DED013B2B75F0ull, 0x79E55BEC21225E96ull, 0x5A40B0647AC774Bull, 0x17306F2E08F36B0Bull, 0x13ED8FFA02BE62A9ull, 0x33735A5427CAEC0Aull, 0x6C1E181A09099BABull, 0x570554525665AC34ull, 0x4AE407790395A35Dull, 0x1AF83FA90480D203ull, 0x18EBE4352AD5ED2Cull, 0x364EE8B53240496Aull, 0x53D2BBE8173A8ED8ull, 0x5573AD857AE858Cull, 0x575523CC3AC014ECull, 0x58B37352026310CDull, 0x75EB8ADD5298CF3Full, 0x23856F647B8F95E3ull, 0x1A45468A3AB5DE92ull, 0x48300EF2E32D684ull, 0x3D74413B37F65B43ull, 0x55FDC28F29925956ull, 0x40FFF6EE2D0316E1ull, 0x7FF8058A0BE3FE68ull, 0x3098BA3E1AF04533ull, 0x1064D06B49849E73ull, 0x45C6326046B3B920ull, 0x7BC4E7DE1998EE48ull, 0x5DEE47F8011C22B6ull, 0x714773D435436BC4ull, 0x3BDC37A349FAE727ull, 0x37A67C9131C7C280ull, 0x1C93B6665B2BEBF5ull, 0x2D57586336D8FCF0ull, 0x15E1CA8831DA5952ull, 0x650BD37453560BC3ull, 0x69D0B4953B099603ull, 0x7CE865192AD0AB84ull, 0x680CACE47CE06AA4ull, 0x36B4A9EC18A56723ull, 0x17D0AFD747197A57ull, 0x622A05965D96E237ull, 0xDCD33775DEEED74ull, 0x772FD0806BBB7B6Full, 0x5F0B102B68774454ull, 0x20FEE7331AE747CEull, 0x32722B7B58A563C4ull, 0x4CAF0A4E4F05E1E1ull, 0x33D14FBA7A0662B1ull, 0x5DEDED149B31A42ull, 0x2BE0BC046AEAB246ull, 0x1D09260515B17099ull, 0x25F4484919F18B1Full, 0x40821C1D0E00F52Eull, 0x16D1F5C37736C609ull, 0x26A65C512EA2A59Aull, 0x3E50406008D061E7ull, 0xC3987D24C1D73D7ull, 0x66BF4F5C03695852ull, 0x37D8EF4645CA5F87ull, 0x6BE09CA658D7D679ull, 0x60B1A7551E52C822ull, 0x317D3A3E2D60B1A3ull, 0x6D58AA03654E89F8ull, 0x27671454733788D5ull, 0x2F01A43A5347D058ull, 0x5E223B1B4C0ACA3Full, 0x68F940F204168364ull, 0x65FC555E297B5D0Full, 0x121778927CCE4B21ull, 0x20B2231938BDD4E3ull, 0x2B70F0BC5F026379ull, 0x418E36CB37AA788Eull, 0x2B1FD751284D8627ull, 0x3B13D0E062F8C697ull, 0x6E17E5AE26F46D86ull, 0x3BD09D114EC98D03ull, 0x454735A86D4DD74Full, 0x7C2A3EA6329FDFACull, 0x529C6147239152FAull, 0x25D76881019E0581ull, 0x76D9235303F9A39Cull, 0x4DA8CFC05FD26445ull, 0x810270033A5251Full, 0x94DC1541A279F93ull, 0x3073704029FFE46Dull, 0x52E574765BE460FCull, 0x90247E71473AB41ull, 0x138ED98A34221F38ull, 0x3CC131684EA2AA6Aull, 0x171AE5CF2AD91716ull, 0x759717F152EB82E0ull, 0x79A2A4193ADE4D99ull, 0x40395A2F75CCE2BFull, 0x6D7E2D4512D5BB76ull, 0x195E35BA135595C6ull, 0x1473C0F71037590Dull, 0x174F3962621C90B8ull, 0x7009BD521F5F6063ull, 0x15C1B5D779577EA6ull, 0x3986FFF646352617ull, 0x235763140C6C746Cull, 0x221987142C59AAFBull, 0x20E01FAE35A8609Eull, 0x607BCA335DA15116ull, 0x44B0B097796B002ull, 0x87A682D79E222FAull, 0x4A8232E3021D0C46ull, 0x34C070930ABB8D12ull, 0x77E9EF06223E9DD9ull, 0x1D914889114824C0ull, 0x3594339F32050980ull, 0x217F7DCD4CE36D02ull, 0x14219A3811893B1Full, 0x6C42CD6529E3500Full, 0xAE0B9C525C9CD5Bull, 0x701876272E381CD9ull, 0x323641C71231FD3Bull, 0x5A91C7D453166175ull, 0x47DA5DD93B0D9207ull, 0x30B7B28C4C2568E2ull, 0x32A4420A39321AB9ull, 0x46078BDC7D2674EDull, 0x3B4F26FF7AC7FC70ull, 0x7E201FF33391605ull, 0x1D069A4925734A88ull, 0x44813AC5529ACDE8ull, 0x577854096600B892ull, 0x1F7E3AEA6B99EE41ull, 0x7789F3B10BC1084Full, 0x157D3E51026AAD77ull, 0x318AD5AA0595B478ull, 0x30A2CA5063C11772ull, 0x17C7B1B30B349225ull, 0x36D778E75FA20F8Cull, 0x4642242C678F2B73ull, 0x2BC7786F78E66636ull, 0x20C1462C71CF044Bull, 0x760CDB235C106D2Cull, 0x6C9700BB7DEEDD23ull, 0xF498331099D9B04ull, 0x236227AB53CABDF7ull, 0x5C3868ED7ADA7BB4ull, 0x39CB76897BB6A3D7ull, 0x667469F631556A3Bull, 0x777AC277BF1A847ull, 0x33C017B2390281D1ull, 0x1875CBF6462E202ull, 0x1CC39943194F0E72ull, 0x6F977427539B122Bull, 0x78F11DFE35D99854ull, 0x3B2A3D9E24B8966Dull, 0x2EBFFE8A5BEB83CBull, 0x16879AB924CCD9AEull, 0x37FBF0F7031E9B74ull, 0x22BBB6D147457428ull, 0xCBC3679461DDE7Cull, 0x1B10321F68F49F66ull, 0x40F85A3154DBA8A9ull, 0x64AB433D276CC427ull, 0x63112E46C22EF64ull, 0x235E6C6E39F12A96ull, 0x2525713624E5C92Dull, 0x1E540C9841E90A79ull, 0x3E34D79F0DEB80C0ull, 0x15841CA43725F59Dull, 0x43C5191450AE5A43ull, 0x5BDE8C0B7285179Eull, 0x2C99DE0E726626C4ull, 0x1751F14C6495CF05ull, 0x7584C2383A0DA81Dull, 0x2BDB432D0240F8B1ull, 0x2B869A46EB754Dull, 0x6B3598174123E0CBull, 0x1BC71DF64FE0DB55ull, 0x6890A4F221F830DAull, 0x3C03CAB90BEF1160ull, 0x5BE95B7061293BEFull, 0x30D4DA8D7A3D6808ull, 0x231246696F09B22Cull, 0x828E8C83896630Dull, 0x262FA7C94BEE01DCull, 0x944BD50020E33D4ull, 0x3E73197B35DE9B5Eull, 0x74745A9855C50AC7ull, 0x1A746A6369F91CD1ull, 0xFD2B2E5464FAD91ull, 0x6C3A15820FFE397Full, 0xD3B22DE576FAD9Aull, 0x51221A4A290240D4ull, 0x275088EF39B2BF3Cull, 0x4AFA71AE635453A8ull, 0x45A1D09C26E3CD1Eull, 0x447D8F987676AB29ull, 0x21213526678FD601ull, 0x65805D55294A1DEFull, 0x2026390E0BB0051Eull, 0x75381FCB296AF65Full, 0xDBE38F333AB3946ull, 0x5F4991BD0232938Bull, 0x970440E79BDFC21ull, 0x6C2BB05C1942F6F3ull, 0x400DA9B25865C5DFull, 0x294130724D48CC90ull, 0x2FD573797A634ABCull, 0x764B0D645725FC68ull, 0x341609F841457F12ull, 0x3A7A501079B7DA94ull, 0x68294C307EF7DFA8ull, 0x702E85BD094A8156ull, 0x6687B5A955AEE312ull, 0x32949F4506ADEEB8ull, 0x615EE83027CCBF11ull, 0x3018E5176F1D2123ull, 0x5B77F8570F6276D4ull, 0x714FB4AF64E83C65ull, 0x92072F55D7B650Bull, 0x7E2B3358492E1CA7ull, 0x35E12AEA276C63CAull, 0x1676E93765B69E63ull, 0x21CFAE860CC1F69Bull, 0x3CDC9ACB55E5B87Eull, 0x4E0775AD7756EADCull, 0x4F9D93123630C1DDull, 0x764ECA843FCC18CFull, 0x3F7B43345CD6802Eull, 0x157AFBE1720FE279ull, 0x63846EE676D9E412ull, 0x19DCA18A139D53FDull, 0x65F70535755499E2ull, 0x22FFCAD15746B9E4ull, 0x5A3CD6472C203DC7ull, 0x34C21EF0586809A0ull, 0x754E5A6E6AA349DAull, 0x7FD46D6A0BC543A6ull, 0x5059E83E21A41BF1ull, 0x18873A410D368309ull, 0x7789D46F668EAFEFull, 0x48D6DE547276782ull, 0x1CBF71CC7ADC386Aull, 0x6F380515C3AB500ull, 0x57B2B8981C6E7C33ull, 0x4E4A977A3B37277Eull, 0x1348604568273904ull},
	{ 0x4ED47B7B793F657Aull, 0x5D7BD2E671D4464Cull, 0x50861F5F37B8A92Eull, 0x1DF4841305483E4Full, 0x1020B2CE1342DE82ull, 0x6FEB88290FF52038ull, 0x1F08222840457067ull, 0x31993C29378F5C69ull, 0x4D7BF37129231099ull, 0x1E1E0C5852096156ull, 0x704A781B3ADD7E25ull, 0x4CE599C0773DF86Cull, 0x1718332524985258ull, 0x13AC749F6562CA9Full, 0x5FCF79D626F4D4E4ull, 0x4D8A03A42EA3F551ull, 0x20343A5F2B05D68Aull, 0x20783B9E70BA59BEull, 0x62BE7FB83E6CBFB1ull, 0x7602980D72DF3286ull, 0x51AF9E3365EE2036ull, 0x2D452BF70B7C05Bull, 0x2633909E346D8EE8ull, 0x28471CC573AF840Full, 0x5D909F814665291Dull, 0x45B8E5654DDB179Cull, 0x142A742129E7F26ull, 0x45191009185ADA68ull, 0x3736D17E58C584A8ull, 0x7DBDA50717064B55ull, 0x7FBA598D4B47A8ABull, 0x45AA40A61FEE93ECull, 0x764D7F3666227C44ull, 0x10A8EDAA590BFEEEull, 0x248F3BF606AB85B7ull, 0x4BEB3175763EDA29ull, 0x6C99A5ED4EBF8434ull, 0x66F69A8512CD368Bull, 0x32D131C0F3DB74Aull, 0x67CBA9A60BDB29Eull, 0x55A2E0674C35A000ull, 0x2E98CA3A56E587AAull, 0x5ED41F2673B1DA43ull, 0x6F406212160AF0A4ull, 0x4C775EEC6CFE0719ull, 0x2D113BF94C31B879ull, 0x3845AFC572BB7CA0ull, 0x6C204C652E932EFBull, 0x58DDF8E47CC93A0Full, 0x79F2DE97D6D34DAull, 0x374BFC6538A5F5Eull, 0x73AC0F04700E65B3ull, 0x2249E3925AA2A989ull, 0x2DB9C3F2576F6AFull, 0x69E060D3095856D9ull, 0x634A94D3F83413Aull, 0x558DF6D934CD7387ull, 0x1668C8E4346215FFull, 0x287F4DCB05A92AF6ull, 0x4A6D06A474F6ACB7ull, 0x72A73210777E429Dull, 0x412865302AECE1D5ull, 0x6A39BF3D2D48B195ull, 0x598010D04317B822ull, 0x2A11EBA4611F3EB9ull, 0x4084ECFC2D86AB6Aull, 0x34A99E183430FC00ull, 0x1D95111D56F381AAull, 0xED3A5892070AD5Cull, 0x7C6A785978B4065Cull, 0x29C90436029F21A6ull, 0x383747977F56FB0Full, 0x376C952E4EA0107Bull, 0x33B9110F5FEBE2F9ull, 0x54493B727E2617B3ull, 0x54E28FB046F06D82ull, 0x75A45A50160AF4E0ull, 0x71DD4F575FDE198Eull, 0x4353A6754B5D6027ull, 0x22F5D1B06D659219ull, 0x2C7C9EE0637ABEACull, 0x1AEC3D8361263CF8ull, 0x17ABBAAD38814EA0ull, 0x3819BEA3267F6036ull, 0x58F1FBFD348436FCull, 0x1F33669302BB0033ull, 0x372358A3576AAE2Aull, 0x211FB426E8FEDD1ull, 0x260ABEA535CB0C51ull, 0x4E7BD0CA7A53FA17ull, 0x33F12404235E607Aull, 0x4144679929957E55ull, 0x3969555A3321B6F0ull, 0x97397E37CBCFBCFull, 0x7E7F17172C696993ull, 0x6A228DE82AFBB5F8ull, 0xFE4283F050ECB6Bull, 0xC21F2F0278FE2ECull, 0x3D901A0B443BB193ull, 0x4E0F432316821608ull, 0x78BFE8906D42A9B6ull, 0x193D163B2FE34133ull, 0x44AD57E01B4F117Eull, 0x1E732F046AB81685ull, 0x511A1DCF6CEEFFCEull, 0x650C109D050B41D4ull, 0x104D604826507836ull, 0x2EA0C02949B6B5A2ull, 0x59722F273814580Cull, 0x4673B17157F1463Eull, 0x647DC19F30963F59ull, 0x2ECFC367461E9DEull, 0x35A50AC40F0EEF27ull, 0x1BF1CCCB733524CFull, 0x534AA0BA6A010FEEull, 0x9B73AD84C0A894Aull, 0x5743B9A422F45113ull, 0x7BEDCA7D1BF11184ull, 0x3E4362911A60F981ull, 0x6A928090F5D8061ull, 0x74FF94F6BB538A6ull, 0x1468C235179D5997ull, 0x1205B0DD4309825Eull, 0x61540F396B77E004ull, 0x7B1DDA6A27C7C0AAull, 0x436926425F9B9C09ull, 0x585E000346562279ull, 0x53FD85E70E030AC7ull, 0x556511A06FEF52B2ull, 0x1382F9728AFB25Aull, 0x59F062A00AEF6A6Full, 0x74BA3BA531341C44ull, 0x2DE3BB8270A80622ull, 0x4D252DC86C271E14ull, 0xB08FFA453CE55D2ull, 0x7B849E751258F8F3ull, 0x3F838E780FED60AAull, 0x29F6528B51893F55ull, 0x52F6E3080B4A61C4ull, 0x3D011F594E14BD72ull, 0x3312226F006A459Cull, 0x2DB0597B0B702272ull, 0x46C0681501ADDF62ull, 0x19732D3A1C2579B5ull, 0x719D32151AAB5CD1ull, 0x44D52C0F4B8D94B5ull, 0x259AC740398F67B4ull, 0x7CC1B0FA537E82C2ull, 0x2A376DD749E6DEC2ull, 0x3FA5A0D635406D7Bull, 0x1DB534943B2A3F4Bull, 0x4799666E5D38C30Dull, 0x4B179FF5718FB8F9ull, 0x2EC202621E0E82FDull, 0x7CDA1ABE6BC321BCull, 0x6C23406F2FEC3D2Dull, 0x6C2D675819D399EAull, 0x3B5C5F9F32EDCF6Dull, 0x1B81794D54CF8CD9ull, 0x4F1349220D1EAB62ull, 0x6F7AE9AA13E87531ull, 0x58AC40171515B0EAull, 0x4D77DCE6556DF111ull, 0x689433AD77AF4ABDull, 0x1F54CFD42839D483ull, 0x2CEFB8383D0A0468ull, 0x636413CF74891EA6ull, 0x1A42C7752E7BB3C4ull, 0x6618D7A04904C9D8ull, 0x4C8A36C262F2F25Eull, 0x34C7EB9438AD7731ull, 0x12DF2F8B20F552ECull, 0x5281111C4E3B8F2Aull, 0x53E322596E028A69ull, 0x230B1C0422F66B7Bull, 0x7B2135CB128605AEull, 0x36DEE0AC53CD75E2ull, 0x279BB6990456BD92ull, 0x293B66F4102FEA46ull, 0x7C06084F489036C8ull, 0x3869BEC928F5C087ull, 0x59A3B301BCDD298ull, 0x1D7EDF2E1FDD02A6ull, 0x4A49865D0397B6CEull, 0x68E1CC7E16D3BD1Full, 0x668AA92C1DA9B812ull, 0x4F8134507969D8B7ull, 0x3E9F0AFE2202456Cull, 0x47A567E112822D57ull, 0x1004CFD56AB083E5ull, 0x357898D20B2605A0ull, 0x7D3689946C57797Eull, 0x5EF37B8324D2402Dull, 0x70AE3711082EE277ull, 0x35022A736CB43F60ull, 0x50BF193F6D6BE93Cull, 0x15A9FFE85659546Full, 0x939BBD53328DF16ull, 0x7636571553834232ull, 0x36C095E45F182393ull, 0x6A56FF511D4B3F10ull, 0x7CC1DBA539D833A1ull, 0x16B517C73B60E6A3ull, 0x5BDA790E5E5A7FA8ull, 0x4DE313FA6BDF48E3ull, 0x490B038E035BACCCull, 0x77054E8446418D22ull, 0x6FB3264B55F8CA07ull, 0x6B13CD4F60615D5Cull, 0x5E27AC7E2015F7C2ull, 0x4D159CBC2EE6C5BDull, 0xD81E0FE62BF9CA4ull, 0x5401A2C16BB9CD3ull, 0x15E87BBA7B767142ull, 0x6A3EDF054CA9119Eull, 0x5A8E94D55495DE56ull, 0x69F450AE5750707Bull, 0xE6E11F800A96875ull, 0x12B1571E6A488B06ull, 0x5F03E81E60946B19ull, 0x5627D3E9280EEBACull, 0x63F017E54D2D226Dull, 0x6E5078CE53A33E30ull, 0x2325EC745964461Dull, 0x34049B8C014D98F2ull, 0x797A3DDF011A3849ull, 0x30345EAF06FC1EDDull, 0x63D9D4ED357478DCull, 0x1DB7BBB179C250A8ull, 0x30EAEA1E07F69AB6ull, 0x466B62460B797EF3ull, 0x5C8C790D305FB2F5ull, 0x62C9EF6E6AFA8B05ull, 0x31091B6A757B468Dull, 0x5543160B100D0388ull, 0x560FB1A62B6AE9F4ull, 0x381BEF3439FFC98Bull, 0x78980C62266C6802ull, 0xDA307BC1BBDF8D6ull, 0x7FD0AE1F41A7A348ull, 0x1D0B91C9794AEBFEull, 0x42C1DB914D3FF078ull, 0x470ADC269BB07Full, 0x2B469541DFEC68Dull, 0x205E0127339F5372ull, 0x25F5614366C9636Dull, 0x3F18D2660281DA50ull, 0x1729166221E2C1D4ull, 0x6D7C6555483231CDull, 0x175E086142BF7B60ull, 0x583F35556D6DBA07ull, 0x6E2A6555105B248Aull, 0x276D839366C271B7ull, 0x36C78C8C35108B4Full, 0x2806A8D36983AACull, 0x76B82E971F8BFC56ull},
	{ 0x2FE326AA397A0A29ull, 0x6CCBECCF302A3186ull, 0x6015BAA86F805623ull, 0x4E28F8130073BBCFull, 0x231FA996741E5957ull, 0x673D1F3C62387BFCull, 0x76A033A77E66359Full, 0x41B3DD0641C98FDull, 0x4698676C1B794632ull, 0x26DC145D1ED79CC1ull, 0x8E70039150679B2ull, 0x2F32C14B305483CCull, 0x7BC8EB6965FA4DD8ull, 0x65650F1B7E4955F7ull, 0x1C9288845C1D3DB3ull, 0x1DD5524D4C75AF2Eull, 0x159747DC0AA13F1Cull, 0x7C9FE0B575AD0284ull, 0x7A2195404AC8D8C8ull, 0x7620BE531D413ED6ull, 0x3EE7321F5D5DDD8Full, 0x7F79BAD2358765C7ull, 0x5BC4132E0394F8A2ull, 0x19A3FEC4225C7A9Aull, 0x1F0E3ED440801321ull, 0x4134175C27F53F0Eull, 0x55868CD47066D8A7ull, 0x5849C2DA514F783Dull, 0x5661267F3DAED1F6ull, 0x4F98CE3472F3AF03ull, 0x19CC0FA96D6E2082ull, 0x3F695E322F635785ull, 0x780F5F9E3C093EE7ull, 0x25105A097230F4DEull, 0x6D217AF1B31185Cull, 0xF7233B445B949CFull, 0x788EF5EB0EEBEE86ull, 0x7B40AF965453091Aull, 0x1280E72914E4AE5Aull, 0x76AF83B4318F25FDull, 0x5564C17B37E39B10ull, 0x5984650B2AEB4E4Full, 0x284A73B831CE27E6ull, 0x7C3AC68D7EAB9A37ull, 0x6F7CF9DC4BD394C1ull, 0x719F493B09490985ull, 0x3941B5433108A76Dull, 0x38AC610A315114E2ull, 0x6D11E6545DBCBB13ull, 0x238209C073E3FE03ull, 0x78EDD36F32F43D75ull, 0x399D47D2717CC95Aull, 0x41E02BFB34DDF768ull, 0x45CFD27454611324ull, 0x49C2A5C23C7F5629ull, 0x5F039221F27673Eull, 0x7462F1395F749E2Dull, 0x4A12B58D1CAD64F1ull, 0x1142C613464D7C1Aull, 0x1B58FF2900BFBFEFull, 0x122110DC0CF84864ull, 0xA08C9744B62C61Full, 0x3E00EFD142B52A7Eull, 0x7CB3DB012B12D625ull, 0x2071E5912035E4C2ull, 0x1EF6D428195FB900ull, 0x532A223758941BFBull, 0xADC825B150A4E32ull, 0xD72136350AC54CFull, 0x696B61575734B926ull, 0xD2BAAF86F5B9A79ull, 0x765C2064018E9C32ull, 0x4ED038A6406ED5F1ull, 0x1E3C01236012FEBAull, 0x6BC520C3995004Cull, 0x60D2BEA918DD62E8ull, 0x468D48B06ADB881Eull, 0x64402907048E3881ull, 0x2D90B29C60F40409ull, 0x2FA10EA64E02982Eull, 0x129E8CB4E97E2CFull, 0x6762512E54540B02ull, 0x272BFECA723ED389ull, 0x695E5934349E122Dull, 0x42EB285952C9BA8Bull, 0xBD2CB535016D351ull, 0x42255504022EEBB7ull, 0x51A56F8310F58DABull, 0x429DC1A96FE170A7ull, 0x71088C65495A13B5ull, 0x297670F351DB4B0Eull, 0x6237769D7003B9A4ull, 0x3CB6D32C46779FA4ull, 0x7491F2256A4785C9ull, 0x276BA3AD243300CCull, 0x384A1DF728958C78ull, 0x72CAE39B1FAC6F25ull, 0x7CE9977A19F6E265ull, 0x11EB42AF6647F0AFull, 0x4E94F49254D66B08ull, 0x3911AB3A5A67BFE6ull, 0x24ED3E597B37003Full, 0x5C96AB9D7692ADDDull, 0xC2C8DEA1F346D46ull, 0x66741E847D351A4Full, 0x688E80FB0FEA8F77ull, 0x4F10655D4AC5F798ull, 0x7FEE491B0BC7388Aull, 0x113D973D74803B41ull, 0x760EBE5338A93AEAull, 0x18B33C0D2E58DC4Aull, 0x613EC7630B7E1FA8ull, 0x4E054B6F5E285EDDull, 0x2575020D5FF08E1Eull, 0x44704F8C7409F69Full, 0x34C6F9267D81FAC7ull, 0x4E71B68559B43780ull, 0x78B8FB062B086223ull, 0x5046E55D04E588F0ull, 0x4A3CCF6936BB03E1ull, 0x21AA33F32CB5065ull, 0x46A59358512B089Cull, 0x7D9147FD4693DC74ull, 0x5CF241260ECEDF3Aull, 0x3B1417B55300FF79ull, 0x47781A2553C753C2ull, 0x159DBC328B6E188ull, 0x5F45736A4F5F2733ull, 0x6DF406504BA7577ull, 0x2F4FB5514B4F8FF2ull, 0x78C46C166416AE78ull, 0x48D18AB94736229Cull, 0x3DCAE5F8418A85BFull, 0x723E84BF0E11CB55ull, 0x46700EAF3C7B5428ull, 0x44CCCF36488AB1EEull, 0x6F46A48D0B72628Eull, 0x19B5BA8A6CD7EC8Bull, 0x52063F0276A7FBB1ull, 0x7BA6CBC50D1A56B7ull, 0x49A8FB2A431EE5EAull, 0x60E1AA794B02D6EEull, 0x6BD5C77240271DE3ull, 0x1A61FE2172B507D8ull, 0x44E1935A49B1B372ull, 0x3E0497CA3DA5FF71ull, 0x2DC861EA06D62283ull, 0x4DC220D6B9347E2ull, 0x4860A842771AA6CCull, 0x79A513370ED0B6F1ull, 0x3395FAF43E71E26Dull, 0x575B68DF22DC9F82ull, 0x49E444FC71112369ull, 0xFB48C0D1BEA83FEull, 0x67B91F1A0B5B57D2ull, 0x2904DAB631621A45ull, 0x4E7A3DBD09E6852Full, 0x7C64F1333A50052Full, 0x4A0DA31316C6EF54ull, 0x2D050D070EEF366Dull, 0x6078A2C66B09A4D1ull, 0x4C9535DE0E4104B1ull, 0x71DFC754517157EBull, 0x79D44C933A406F96ull, 0x488BFEB773795FCBull, 0x491126877C21F9ACull, 0x31EB4238206C8F66ull, 0x1EFE992E7BCF8734ull, 0x117DB2D02EB3253Bull, 0x17BA0B337936D1EAull, 0x3A0E7D0D40BEE5E9ull, 0x2A98EC2F0888BACAull, 0x4AA56B1826FDDD62ull, 0x42D8BFFA14B30E2Bull, 0x3DC4CCB66FDDCD01ull, 0x23A244991E3D6F7Dull, 0x5AE771D370377A77ull, 0x2C7E742E4CC73927ull, 0x41A8D2632652C0C1ull, 0x707A8BE0A34D11Aull, 0x19CC208C5018CF45ull, 0x656CAC64BB762C5ull, 0x70855EAC255563F4ull, 0x4786E9F90203117Cull, 0x5408892F5F40F52Cull, 0x7B39E3660E17063Dull, 0x1FFFDB1525D2CF96ull, 0x169FC1076AA5462Eull, 0x4CD0ACF859788101ull, 0x7F5854590A9579AFull, 0x49564E0322FA98F2ull, 0x28D2E92C243DBFD6ull, 0x1332136A55515D5Aull, 0x7104F8FD54DAE5CDull, 0x7BA41E1B780CA1BBull, 0x5F0FB6E715703EA8ull, 0x48257101656681AEull, 0x6127A16D38AACFADull, 0xABBE5A228AE8B66ull, 0x3AADE1295EC46ED2ull, 0x7EF809335E7C48Full, 0x6CDB750F27EF5BA8ull, 0x5BBA9425037B3616ull, 0x1294A1D6288B411Eull, 0x5CF3B71811ECF630ull, 0x3320BACD264A051Bull, 0x34E78F225BF3A3F9ull, 0x4A87C4F14819A28Cull, 0x314501533B8CBDEEull, 0x1CF488592CE91F6Eull, 0x33995FAA7C043F41ull, 0x42595E167BBED0ABull, 0x616AC0EF2380FF83ull, 0x3469A0586C26A691ull, 0x4C2F8AEA6F178181ull, 0x4AEB1563541F0B7Dull, 0x24FF461037C68A72ull, 0x7C0E672500B9DA36ull, 0x3B41C0890EA308FCull, 0x29451B54183577A1ull, 0x208FFF2C5C65D621ull, 0x3E7F7CBC55778E4Eull, 0x38597A1A090741ADull, 0x1D9130DB699E7B6Dull, 0x4493FF9B3A85B934ull, 0x16879ADB782D5F45ull, 0x3689F87558E0F8F2ull, 0x73EC2FF017F4B964ull, 0x7C61F8752855D048ull, 0x41B5FF64891835Full, 0x176D51C94F067559ull, 0x1CB08EDC3C6C97DAull, 0x6CCFFCC18BEF602ull, 0x3D267210420EC055ull, 0x2761FEFE666B8D64ull, 0x5A4437F647F1FE2Aull, 0x42D1638518C3B4B2ull, 0x1D698C787B2ADD9Full, 0x21CAF65F3AFABD53ull, 0x64C9590C665EF5FAull, 0x758076887B50F3E7ull, 0x5E8C55402C0A6EFDull, 0x5431ECD952788530ull, 0x43FF28625093E54Full, 0x7ACE5579481A8858ull, 0x192568AE123BA742ull, 0x1720FDB135D5F78Bull, 0x4EA83F1C1DEDFD7Dull, 0x4E94ED8D0BCEB12Cull, 0x5FFCBDD275F6EC8Bull, 0x723A3E903A40F5C8ull, 0x3DE8EAB5350BA215ull, 0x5304AA7A5B52772Dull, 0x30367FB474CFA0D9ull, 0x164D348114FFD8C0ull, 0x5B2E96D40BCDAB09ull},
};


MinBloomFilter::MinBloomFilter(uint64_t filterSize, int numHash, bool save, bool zero)
{
	this->filterSize = filterSize;
	this->numHash = numHash;
    saveAtExit = save;
	bits = new FourBitArray(filterSize);
	bits->FillMax();
}

MinBloomFilter::MinBloomFilter(uint64_t filterSize, int numHash, const char *loadPrefix)
{
	this->filterSize = filterSize;
	this->numHash = numHash;
    saveAtExit = false;
	bits = new FourBitArray(filterSize);
	saveAtExit = false;
	
	char name[127];
	sprintf(name, "%smin-bloom-%" PRId64 "-%d.dat", loadPrefix, filterSize, numHash);
	printf("Loading '%s'\n", name);
	bits->Read(name);
}

MinBloomFilter::MinBloomFilter(uint64_t numItems, double targetFalseRate, bool save, bool zero)
{
	double min_m = std::numeric_limits<double>::infinity();
	double min_k = 0.0;
	double curr_m = 0.0;
	double k = 1.0;
	
	while (k < 5) // limit to 4 hash functions
	{
		double numerator   = (- k * numItems);
		double denominator = std::log(1.0 - std::pow(targetFalseRate, 1.0 / k));
		curr_m = numerator / denominator;
		if (curr_m < min_m)
		{
			min_m = curr_m;
			min_k = k;
		}
		k += 1.0;
	}
	numHash = static_cast<unsigned int>(min_k);
	filterSize = static_cast<unsigned long long int>(min_m);
	saveAtExit = save;
	if (0)
	{
		//		char name[127];
		//		sprintf(name, "/tmp/bloom-%" PRId64 "-%d.dat", filterSize, numHash);
		//		bits = new BitVector(filterSize, name, zero);
	}
	else {
		bits = new FourBitArray(filterSize);
	}
}

MinBloomFilter::~MinBloomFilter()
{
	if (saveAtExit)
	{
		char name[127];
		sprintf(name, "min-bloom-%" PRId64 "-%d.dat", filterSize, numHash);
		printf("Writing to '%s'\n", name);
		bits->Write(name);
	}
	delete bits;
	bits = 0;
}

void MinBloomFilter::Analyze()
{
	uint64_t entries = bits->Size();
	uint64_t setEntries = 0;
	for (uint64_t x = 0; x < entries; x++)
	{
		if (bits->Get(x) != 0xF)
			setEntries++;
	}
	printf("%" PRId64 " of %" PRId64 " entries set. (%1.2f%%)\n", setEntries, entries, 100.0*double(setEntries)/double(entries));
}

void MinBloomFilter::Load()
{
	saveAtExit = false;
	char name[127];
	sprintf(name, "bloom-%" PRId64 "-%d.dat", filterSize, numHash);
	bits->Read(name);
}

void MinBloomFilter::Insert(uint64_t item, int depth)
{
	for (int x = 0; x < numHash; x++)
	{
		uint64_t hash = Hash(item, x)%filterSize;
		int val = bits->Get(hash);
		bits->Set(hash, std::min(val, depth));
	}
}

int MinBloomFilter::Contains(uint64_t item)
{
	uint8_t max = 0;
	for (int x = 0; x < numHash; x++)
	{
		uint8_t next = bits->Get(Hash(item, x)%filterSize);
		if (next == 0xF)
			return next;
		max = std::max(max, next);
	}
	return max;
}

uint64_t MinBloomFilter::Hash(uint64_t value, int which)
{
	value ^= salt[which];
	uint64_t result = 0;
	for (int x = 0; x < 8; x++)
	{
		result ^= zobrist[x][(value)&0xFF];// [8 possible hashes][13x 5-bit segments][32 values for 5 bits]
		value >>= 8;
	}
	return result;
}
