//
//  Bloom.cpp
//  hog2 glut
//
//  Created by Nathan Sturtevant on 1/25/14.
//  Copyright (c) 2014 University of Denver. All rights reserved.
//

#include <cmath>
#include <limits>
#include "Bloom.h"
#include <cstring>
#include <stdio.h>
#include <cinttypes>

//int numHash;
//uint64_t filterSize;
//BitVector *bits;

// [8 possible hashes][16x 4-bit segments][16 values for 4 bits]
static uint64_t salt[8] = {0x6B8B4567327B23C6ull, 0x643C986966334873ull, 0x74B0DC5119495CFFull, 0x2AE8944A625558ECull, 0x238E1F2946E87CCDull, 0x3D1B58BA507ED7ABull, 0x2EB141F241B71EFBull, 0x79E2A9E37545E146ull};
static uint64_t zobrist[8][256] = {
	{ 0x415FD31C783455EEull, 0x3F2CF1797421BFBFull, 0x10F5E25F6E4E0219ull, 0x5BC91D9C2F2F972Full, 0x5B8D025C69FDBE2Full, 0x5DDE50AA4A144A49ull, 0x3C2EE97B53BEAD45ull, 0x23AA143D1814A14Eull, 0x150690F16DA374CBull, 0x4D4BBEAF07276797ull, 0x66C2D4180B70CD38ull, 0x2EDEB4DB3ED9ED2Cull, 0x48537DB20314664ull, 0x342EB04461887999ull, 0x7466C188691AD722ull, 0x6793705035C694A5ull, 0x614F2D1026C061CAull, 0x29E8546472450F6Full, 0x150E63E305B17200ull, 0x2174A69E709B663Full, 0x6FAF302F7F52F749ull, 0x3AAFB0882BDE19AAull, 0x5311A48E5E59C4C5ull, 0x43F2BAF86818357Full, 0x4BFD3991113E79A8ull, 0x6F3F9D1632C00DA9ull, 0x1CAF46E01E1E51F1ull, 0x7199FAD521347EBBull, 0x3E4F985525C8AB1Aull, 0x2BCF85432B659DEull, 0xEE3823C6A5068A5ull, 0x687CEE837032AF4Cull, 0x1110CA6F126542E7ull, 0x6277BEBB261F2E52ull, 0x1816B4E803EC655Aull, 0x16BA949107C5E517ull, 0x33F5CA3516A4519ull, 0x33A3FEC256510131ull, 0x2FC409DE7796B9BAull, 0x3E6936B17BC1436Full, 0x8D533622DA8D3C7ull, 0x2E81511825847A42ull, 0x4BC725B9201B4BEEull, 0x46B8F8FE0A16BE0Eull, 0x45E3F7084975F152ull, 0x3CCD17EC54C77944ull, 0x33C659F7254A066Full, 0x44FA289044D72466ull, 0x37AF49572771E74Bull, 0x6AF652B84FC5FE3Full, 0x2B5E4CA501B0E749ull, 0x578BE3562E9DA948ull, 0x531B2C620B2FE218ull, 0x4EEAA7A02DF3641ull, 0x2C69BD34357E12Bull, 0x7EA079B00B9BCF35ull, 0x7100B4F22D21CAC9ull, 0x312049783CC7DAABull, 0x4D3D16B777D94276ull, 0x46DE98BA13210DBFull, 0x414F33C803ABB0A6ull, 0x67E8870375158DC0ull, 0x28F5B7162CE2AF93ull, 0x39ECB22660A5006Dull, 0x545496DE24E304DFull, 0x306AFEAC7FB2E384ull, 0x2693EC2807F6E202ull, 0x2E508CCC79AF188Bull, 0x1326C41B333F3746ull, 0x7C8E4ECC15ED5FEEull, 0x769718717B2EC87Cull, 0x21892F236797CD64ull, 0x2850934552A9789Bull, 0x245FA80F758DA9FCull, 0x4A82BB116B3E40C9ull, 0x8AEB7BB0BD1EEDAull, 0x6EE9F17070973EBEull, 0xE77C9A17DFA886ull, 0x1D79EE513AD42EC0ull, 0x7884A8F371CE8530ull, 0x5FB7339F28EFA79Full, 0x718168B4064B1FC8ull, 0x30E689A11FD1F580ull, 0x7FFA3853440D4DBCull, 0x53112CC77C88871Full, 0x59FAADAA49A84538ull, 0x77B74F9B7B83DCCEull, 0x3140129C2007E2E1ull, 0x4E2D5569559FBAACull, 0x15958CDD18B0107Bull, 0x40DDFB751E444499ull, 0x2481FF552FC7ECE5ull, 0xEDB835725697BEFull, 0x47A7956B2C5571A9ull, 0x603DAAAF402C3E5Eull, 0x1E23F6D93FF4DE4Full, 0x691BE5FD0FA55F8Dull, 0x463FFE171A026F9Full, 0x2F77550D463A366Aull, 0x5E0FBD5B028881D4ull, 0x42C2BD89380A6B06ull, 0x4C30C70D3A7A0D24ull, 0x338E47D47D70D9A9ull, 0x5A81F00501BB9D3Dull, 0x5310945570177CE3ull, 0x1A6BADB813EE8FCBull, 0xE5BC17C3EEDAD0Dull, 0x43B67CB01D3744D3ull, 0x645728FC0B5E121Cull, 0x498CB67C4494D3ACull, 0x4B8A507A67B0AD55ull, 0x489B1FB34A63678ull, 0x77560CE24AC9B012ull, 0x4EA8A61726CD61F0ull, 0x1103E67C2CB86372ull, 0x2955E3C453C6A405ull, 0x64C2CE787586AAD1ull, 0xE40B1291851164Cull, 0x72F7847B68C2A12Full, 0x1A0CB38A460818D0ull, 0x58DA1E1234786142ull, 0x59F6A89B6735DF8Eull, 0x73660E501DAD254Cull, 0x46D246157BD374Cull, 0x290B37684DF9DADEull, 0x1C520AF8749587E2ull, 0x35AA883320DBBCF3ull, 0x293BBE5A2D009516ull, 0x6BA56D0577E46471ull, 0x53CDF7067CA95381ull, 0x249CC7E47D23DACAull, 0x506FF786095F965Cull, 0x72AA859C5EB0A8B0ull, 0x21B0ACA965A20A17ull, 0x477349DF3BBD6033ull, 0x2BAA22E7204D67F1ull, 0x7035C17505A0CB83ull, 0x783477F639BCFC5ull, 0x234DF0CF0BF06BE0ull, 0x3B5907124C592837ull, 0x59EA46BE57AB120Aull, 0x40EEB0190F94CEF2ull, 0x7886CEFE6A2A6E74ull, 0x3C956408642C3C03ull, 0x620ED2E510635B0Eull, 0x60D58F8506AB9AC9ull, 0xD8735D83145870Bull, 0x100B31260031BB74ull, 0xFF62FBB31BBDDCFull, 0x65D3C58B5769799Aull, 0x6D793E02117DE873ull, 0x77B6E18B5DAEFF77ull, 0x171EB3F67F3A290Aull, 0x414ACF3D3A6CA4C5ull, 0xB2A94EB7CA3D64Full, 0x6C5CCFC6514DBA9ull, 0x544EE85947B47D15ull, 0x74A9AA9B4CD5B757ull, 0x31DEEB89313F0EA3ull, 0x3101F35B13EDBE6Full, 0x41A269B111D782E0ull, 0x1A9959384F299F8Aull, 0x431D09EB2AA48A5Eull, 0x4F5B5AFE531339A7ull, 0x5C60682D352F208Aull, 0x2A7CB34149D9A62Full, 0x46AD08FD223394CDull, 0x2788A5A75DCBBCF3ull, 0x216DBDD768D374E4ull, 0x183861B82C9852C2ull, 0x65774B331EFE2EB4ull, 0x11AD2E6C39C6338Cull, 0x66B2ABC90656D907ull, 0x69BEAE418919753ull, 0x3795E7AB379DDE3Full, 0x2C7F55C27938515Cull, 0x4975611F4718AEFAull, 0x4861F0E60C926B0Aull, 0x71BD395917BD4BE5ull, 0x5FA5A4B14E1DA186ull, 0x4CEC6C6F0A2257F3ull, 0x17F747B61399756Cull, 0x2C55ECC03F7FED5Dull, 0x7165325F4DC3AA97ull, 0x28536241099D9417ull, 0x7A5BFD5A0DCAAD74ull, 0x289BC2CB0C092BC6ull, 0x4790E1000F4E6E94ull, 0x126004CD4E2CCBE4ull, 0x27E005E749F5EC78ull, 0x5CAAA23545F5BA9ull, 0x432E3DD54F400B42ull, 0x1B780AA40B902EBBull, 0x5BD2764D0D3543FDull, 0x234D7AA03B781AFEull, 0x5B52E5837039E70Full, 0x459A72F1734A2D39ull, 0x3D35C7B71F05FB1ull, 0x32CA1A9675388EDAull, 0x3FB40A495B1D7CD7ull, 0x7ED622F13A1007A3ull, 0x68E82A4B2771E5BCull, 0x4619336930790B4Cull, 0x36C0545158793836ull, 0x7EA5D7305EA05A38ull, 0x226F24AF04708154ull, 0x32FFB5E2659D6284ull, 0x53B08C964E77C086ull, 0x712D913F2F8302E3ull, 0x5BAD0483147B0BE0ull, 0x6AFB1DE236FFEA06ull, 0x4B4F2EF309590D3ull, 0x2A4A174008884F6Bull, 0x2285F0855D1431D6ull, 0x7DC0DE456239FACEull, 0x3831AEAE7C970137ull, 0x1C4A02712119D8F9ull, 0x2408E6F3626335DAull, 0x5192E4455AC93B44ull, 0x3ADC6E105038BB76ull, 0x3969957D5D4B92BFull, 0x54A93CCA6C694B5Full, 0x42E8F5432859C960ull, 0x3AE10BE534168683ull, 0x57DCCC44168E1068ull, 0x4891926342D7EA26ull, 0x4D8DFA6E4D468552ull, 0x736D7AF977D811AEull, 0x55CED4BD15F36B7Eull, 0x54EC4385538FB303ull, 0x782D664C0D1DF233ull, 0x5026B43A147768BDull, 0x2E37CB2C742F9B2Dull, 0x76DA9E977FCAAF72ull, 0x4EF8D67231B70CA8ull, 0x50036AE808626BEFull, 0xF029F6724ACA7B2ull, 0x74CBB74E51EB94ABull, 0x4D0671122FACC333ull, 0x6021B2E24E33D56ull, 0x463AD39B4E93AD91ull, 0x67BB277C13C8CE09ull, 0x1BDA32E35B28A276ull, 0xBA0DFB871A907A1ull, 0x711C0DF4608D233Dull, 0x4538BAA469497441ull, 0x6DAB1570155F6EDEull, 0x7DC0DCFE1BE2E09Cull, 0x98F0A0B749B7B96ull, 0x1BAD900E5887E07Dull, 0x2652883E6BB0FAF6ull, 0x60EA4C6C355527A5ull, 0x105DA2A855B603BAull, 0x740BC505D6413BBull, 0x562C6ED0D42D77Eull, 0x24751114B9D9A88ull},
	{ 0x5BD6850F6A02788Eull, 0x5F66689277B0B7F3ull, 0x452B1B046B07484Aull, 0x6959BF94364728F8ull, 0x4B946B872E927A38ull, 0x1F909D39393F80F7ull, 0x43F1E9161D517A38ull, 0x552261934D80F321ull, 0x11ECF5CE70CFF1A2ull, 0x2608D39F383F7E0Cull, 0x5C80EC9806F3200Bull, 0x6D94A5B16CDE8F41ull, 0x5CA923C674D56202ull, 0x4A42A2FC620BEAB3ull, 0x21839804C89F40Dull, 0x2DA9853C5DEEBE90ull, 0x368C6C9B0D0FEDCEull, 0x559F76837BB7879Full, 0x781736183EF93617ull, 0x31FEB09843ABA19Full, 0x6D8BB04F518F4DD1ull, 0x7CEB2296317D9965ull, 0x6EE0C809520D8429ull, 0x7EFE8C8600CDBDD7ull, 0x42DD75CB25076025ull, 0x390D3BE31F5E6264ull, 0x2BFA803126A1E195ull, 0xC3CF1A508A3A3F7ull, 0x1B774397567F94A1ull, 0x6AAF8EAA1D8F7D17ull, 0x230988AE185913E6ull, 0x7B7E3BA75995F54Aull, 0x256901B4511DB22Aull, 0x554D7CE91D8037CCull, 0x1016E841074C2D81ull, 0x612BD96B7DA29890ull, 0x58DB7B535E16FC01ull, 0x2F2031F547BC435Cull, 0x3024802B2E1EBE7Cull, 0x488A01347301F5F6ull, 0x53261EA101973D17ull, 0x1260585A7F209ED2ull, 0x28391EAC1E9D49FFull, 0x7C442C943B06243ull, 0x751CDEA07273D174ull, 0x613FDF5B1826674Full, 0xACCE55A5CBE1B02ull, 0x71BC5C993035E70Full, 0x2DDBCD2D4709D982ull, 0x4DB61EDB3DF2B56Eull, 0x4E5607042EE1F847ull, 0x3B954DFF27318257ull, 0xCF8F4486AB57FF4ull, 0x6EEDC5B33D1D7473ull, 0x18D43E703777C6E7ull, 0x301F6A6A6BFA5D12ull, 0x390F03FF427FC2C4ull, 0x6B1AFBE4614822ABull, 0x611D0CC472DF3EAEull, 0x24F884EF5639EB64ull, 0x655310220638644Aull, 0x6E6052B3701FF57Cull, 0x62F67F4C601CAF4Cull, 0x2055DC8B10D24C79ull, 0x272688CF6E0BFB67ull, 0x4EC501E8757C8FD3ull, 0x1CEDF3AE0A5A4FE7ull, 0x1CAE122A29E6E7F6ull, 0x750FCFDB0B9BD7DDull, 0x67045C6A0DE40E4Cull, 0x43139EC51723C6D4ull, 0x79DE6B5E7C22A2C4ull, 0x59A3899864F96742ull, 0x5D6AC56F3AC0965Cull, 0x57D8A5F002634A5Eull, 0x10FA81C13D2BB612ull, 0x89BAEA87F5AD474ull, 0x2D4BAB8F6B922DF5ull, 0x5F7783C14DA1881Aull, 0x7C647A6E069E0C90ull, 0x3BAD83814B297C56ull, 0x7C1A9C63589B772Full, 0x5583CC3D18C8AE8Dull, 0x2825F264A939C19ull, 0x2464866A6986BB90ull, 0x5877AA656778252Full, 0xAA8264525615C3ull, 0x639AC7F35A4E0BFCull, 0x374F7D0541058D63ull, 0x150EA2590F2822F6ull, 0x4368D7C12609241Aull, 0x4C53D9084C04866Aull, 0x2563F88E799F8497ull, 0x3796B45F04DB7C4Full, 0x47410CB233FB2ECDull, 0xB7988DF02EE9033ull, 0x7F24AB2407942542ull, 0x5B8A076354A87761ull, 0x205CD3CF5E0C6689ull, 0x1F3C137A44C15A3Aull, 0x4793221977B3BDDFull, 0x2C397F69483DA47Dull, 0x4A09D3A20FD4475Dull, 0x228BB079015950A8ull, 0x50D9D4C0379A52D2ull, 0x1081739E1442AC81ull, 0x5DA376EC5CD54CA6ull, 0x604732EB03076F7Bull, 0x5674D13E17DDE74Aull, 0x7E2EBCA1DB5DDF0ull, 0x4BD91618135C74AAull, 0x20A46E234AFDC13Cull, 0x1AF099EC7C2E7586ull, 0x1FA6389D3B4D6DBCull, 0x5A3ADC0F3EE24C18ull, 0xEC7F621CDFE28ull, 0x369609F72C48475Full, 0x6A0BA2A5009FDD9Aull, 0x3C1C8EBC0C97531Full, 0x1F92E420CF6637Cull, 0x4431A5F1127AA1E0ull, 0x21390FFE21D51CDEull, 0x6F4FEE86018042E9ull, 0x24DC8C5945C4BFC4ull, 0x195E2A342CBF7823ull, 0x637A9DB46537404Cull, 0x401BECCD041F0BD8ull, 0x303501885B0C86BAull, 0x4D815E4FDB3A25ull, 0x1659F4765A885D6Eull, 0xEBD863D1668BC6Cull, 0x7C565B9645539035ull, 0x42B103CB6661FE3Cull, 0x45F36DCF7ECD9288ull, 0x72F9515B47EC9C11ull, 0xBC3F604372AF74Cull, 0x5A673DF12CFD0602ull, 0x5900142A49B72C77ull, 0x2E7D48EC7DDCA083ull, 0xF7BEC3C47DB7320ull, 0x2A9C18A772F689F0ull, 0x2D12B36C6AB80574ull, 0x771595C85D47B4F4ull, 0x45C48C2E77631727ull, 0x2D22EF195C1E80A4ull, 0x51EB74953BE07557ull, 0x72873D104E41D02Bull, 0x134058C353840DCull, 0x34A3CE674727735Bull, 0x3405D364279D1FC2ull, 0xF140F6C3FC9C968ull, 0x5EC8170F697B4D5Dull, 0x6CC6CF6B37C82B39ull, 0x333279D41B441857ull, 0x35A4CBBD42AE6610ull, 0x631F8B776040E464ull, 0x35A4F00110323EE3ull, 0x4AF8E9D82CBA85C9ull, 0x6D79F3D710BD7607ull, 0x241D9CF01A9CE2F0ull, 0x6CDBF6AB76091185ull, 0x567D58475F6333BCull, 0x444AE1B157B15DD3ull, 0x149B749878EEB018ull, 0x1ED8D12E48A147FCull, 0x208BCFDB2DECE09Aull, 0x86B11647F53E6EAull, 0x17682DF77531E0CFull, 0x371C12234A9AA7CCull, 0x1075F9266CC0DDE0ull, 0xD490DDC7395849Dull, 0x4D01C24442EDFDDDull, 0x3C7C38017FAAC1Dull, 0x6FA883A77141B757ull, 0x28B8222413C62097ull, 0xBDE9A48159418CFull, 0x9CF321D625BF28Full, 0x74F74C8B4E1A13CEull, 0x3A0D50630992C123ull, 0x4708C3E658E62191ull, 0x5234091F679493C1ull, 0x6D3022C5A9F1A84ull, 0x66E87AAB1E3B3023ull, 0x4FD0FB531E048CCFull, 0x68D5D7EF6046F47Aull, 0xAC56AAF761EE5CCull, 0x53DC791757C72CF4ull, 0x390CE3A957A43C98ull, 0x6FC1D91128B56750ull, 0x48E5F3EF1879FB35ull, 0x3C7B87E854C48E37ull, 0x2E0E1404464ABA05ull, 0x372080C723056090ull, 0x1464CDD3712DD12Aull, 0x2C9821B35B6D91B9ull, 0x4A13F2BB7ECC2AD3ull, 0x4302257B50E6F4E7ull, 0x596B455729EAA026ull, 0x6F22250B293C40AAull, 0x47EF2CF557F7FCFAull, 0x983352452B497A5ull, 0x4E16E2C65D5FAE3Cull, 0x2A7BC4990723C670ull, 0x3503EAD41A3D9DAAull, 0x2FD92DC07DE9DEC3ull, 0x32B798DF6C54B5A8ull, 0x52AE6CFB60C5ACE3ull, 0x329F6FAD09CEEDC2ull, 0x3CB0D7347043D80ull, 0x7AFCBEEC30632F27ull, 0x2271CF3A4510B1A7ull, 0x2F2F59FA6573F4B5ull, 0x15F7A68F089A9F51ull, 0xF5E94DB0519CB9Aull, 0x31D6DFFB574DC1D1ull, 0x5D11C8943B5A1520ull, 0x2A0259762B28AB5Bull, 0x18B9C35C547E1E0Full, 0x324C71CB4DBDAE30ull, 0x6EBBBBB962259F8Bull, 0x4BA78CF321735498ull, 0x4E7A55341E55F9EEull, 0x239017B0119C4E1ull, 0x2824E7B006040EEFull, 0x481E02622321A69Cull, 0x36673E166A8FD19Cull, 0x6832584465969810ull, 0x5003C6517E29FED3ull, 0x6E3137615F625B2Cull, 0x343CA6D2008175Cull, 0x36B01CFD60559301ull, 0x5B622C7C60B27673ull, 0xB7E3E5C741BEFD8ull, 0x353094823DCAB027ull, 0x41D99E0823EC503Bull, 0x1FF04FB30D812AFCull, 0x455FA4D36E6AA4E7ull, 0x2BD724EA4798A64Full, 0x6F8469C853FC0C9Bull, 0x4D9CB53E37A26C2Aull, 0x771DB3370403F354ull, 0x22323DC65F500B7Bull, 0x699A8B6472360417ull, 0x5D7A0A4E57CBC2C5ull, 0x51985F4460BDD4BBull, 0x77D3DA2108487C41ull, 0x411367BD5336069Eull, 0x68FAF2B54C91A619ull, 0x4751F6761E2B8737ull, 0xA5C5641092B947Full, 0x4217D7732A4CA5F4ull, 0x16ACBF7B07777C46ull, 0x18B74ADB4283E465ull, 0x4F102295083BB4A3ull, 0x167FF1001CACD7D3ull, 0x3FDE20CE0D9DA438ull},
	{ 0x20B0CB2762105E94ull, 0x6CEDAFB30A4B568Bull, 0x544662AC4A67BA02ull, 0x6217195025DEC1F0ull, 0x2B258EBD59EAF372ull, 0x2E273E316C38F67Aull, 0x2D20FA10172230E6ull, 0x38CA9C947472F086ull, 0x354DB81E4326F2D5ull, 0x7D9E850577658F91ull, 0x6D7398C9144B4480ull, 0x7EDD0BD7062AE3A4ull, 0x56CF28E64DED2E6Dull, 0xE6698476D4F19E6ull, 0x6A9A06404E44B915ull, 0x7AECBE1E0B4AD168ull, 0x305517AA67DA6DD2ull, 0x159627F3049B7A56ull, 0x324227D477AD4144ull, 0x2A7A3C465D67B691ull, 0x519834B658A17A77ull, 0x49A0AD0C7EB92EC6ull, 0x6FC3AB5E026B49A0ull, 0x732C1F4C2511637Cull, 0x45923C7570CAA452ull, 0x1C76F30D3305D53Eull, 0x515E8D21B53FEE4ull, 0x3930B8E25BE511B8ull, 0x69412D5147975129ull, 0x49342B9F53DB3392ull, 0x15DC0A3F4420E9BDull, 0x5F2604FA463121E9ull, 0x2BFB578F74BC2CEDull, 0x4ACC9C3F5E3D7F63ull, 0x6C696E317546D885ull, 0x3BA535F53E01A2E7ull, 0x4DE852FC0545E301ull, 0x3CBAD1AD3DABFE5Aull, 0x7B12CA12FE6F0FAull, 0x62BD61D64D436916ull, 0x20B1954C7F3454E3ull, 0x493E5425C77E1Eull, 0x1A8853C83979F736ull, 0x1AC8FD703C98119ull, 0x111485F4AE0BB76ull, 0x57A4B4AB16ED529Eull, 0xF01A53336CAB9A5ull, 0x5D1E74873AFCFCC3ull, 0x2B86E69327EB10C6ull, 0x193A7C2617F054C4ull, 0x1D31E94B54DFB21Bull, 0x55F1F7AC6B1A3C48ull, 0x5A25951C12ACC959ull, 0x28C63AA261D6C1BDull, 0x4293BA530B839C79ull, 0x2F1A2AD363454F9Full, 0xAB7F15C2F636927ull, 0x90CCDBE25404524ull, 0x68DD605D0AB95D95ull, 0x2909C63E69EEA8BDull, 0x559A190B00AE7AE9ull, 0xDBFB5B649BBE3Eull, 0x3779348F5DFA6FE3ull, 0x1F98BB0163001B22ull, 0x5E580A938D33728ull, 0x7AF06FE6231769F5ull, 0xDB2E94350E26792ull, 0xE31A63D67D87E60ull, 0x638F30EC36F7E0DFull, 0x49AF401D2622EB3Full, 0x427B7D5878C96AF1ull, 0x9683ADF4D336EB5ull, 0x282CD4181275089Dull, 0x7273B3D9110A3476ull, 0x1D2E66321B7D7A17ull, 0x7AF8DD3372C87F3Dull, 0x1C2BF5017BD4D88Eull, 0x57643D7B53A52990ull, 0x59CF487176FCF87Dull, 0x36A544B25FB4C91Bull, 0x2FD02FA53195B498ull, 0x2CC33103D8318E8ull, 0x2781C2B10FDD94Dull, 0x255B974866074D17ull, 0x47F5BA2C6F0AD766ull, 0xC2A38560A713785ull, 0x67D4425715927335ull, 0x57A4A63A1001166Full, 0x28077BD24A185A13ull, 0x210B4AE54535E204ull, 0x6595D42B1C042818ull, 0x37FE614101C1C92Cull, 0x17D900A70F629EBDull, 0x5566F2BC71A84918ull, 0x65F973A0C0C376Eull, 0x515D1233362FC6DFull, 0x3DA1EC0654294543ull, 0x73B2DFC7401A0831ull, 0x65271E90190E7710ull, 0x262155482D1CD8BDull, 0x8194E76324B8D9Full, 0x378E10426FED90CDull, 0x47DE00D40F32B67Cull, 0x7FEEA73C6FE57CA7ull, 0x594B108F20F9F222ull, 0x351B5EAB3EE0E4BAull, 0x3CFE1A3A6D19BFEDull, 0x40A2ADE654D71AE1ull, 0x7C7C5EAA1609A0A2ull, 0x467F63FA02DBF5E4ull, 0x2215D81017DC762Dull, 0x390BBCC35FB7C417ull, 0x6C05BB712CBE9C8Aull, 0x1FD1CC48512CDA01ull, 0x45CD139A45F32191ull, 0x7E49B2BE4DE66210ull, 0x783EAF3035D7C300ull, 0x3DD3F2DD401CB004ull, 0x450A797C3DC29A1Aull, 0x30022CAB1E558A0Cull, 0x5EBC8C3C651D8B57ull, 0x5D366EC61BBAA676ull, 0x52374B441DD91CADull, 0x7091C1584EB3A9EEull, 0x33E2BD4F37112552ull, 0x518F9FD255F89560ull, 0x4EED9B7F0A9B5C95ull, 0x35B059773AF356F0ull, 0x3759F91F558225BFull, 0xC2030F27D270CBAull, 0x1B7547500A69E3B0ull, 0x4B0D6ECA13B3F680ull, 0x4041A6B108E161A8ull, 0x53D0A685054C202Dull, 0x46A3FBC203D2D330ull, 0x23A1AA39256087FEull, 0x68F05E8700D81900ull, 0x411B2E743B27A9CBull, 0x1EB135AD31ACEFCCull, 0x9DB53B95293F2FCull, 0x68BE151E5B6AF38Bull, 0x288C885C37ABB09Eull, 0x660650205E3CE1D3ull, 0x729F078E1D604940ull, 0x33BF07937EBF3880ull, 0x1A8755FA4F344EE3ull, 0x9291C316594C4C4ull, 0x62E84564496AC2E2ull, 0x6E76266C36B8EBE9ull, 0x4EB6E30F351A222Eull, 0x3A8BBF1972588D49ull, 0x5A7AAA2C237C1DA1ull, 0x7330A6491B95D8A1ull, 0x5EA3C76C11E1DBF6ull, 0x4D42C86D687F1B26ull, 0x6475CEF23600DD8Cull, 0x43EA0EB10D02574Full, 0x6DAC8E2A29F05ED2ull, 0x6B3F3922604B95B8ull, 0x4750A8121EFE40B5ull, 0x5F0ACE3961D7FE0Cull, 0x6E328F996833EA6Aull, 0x476CC2D0511AD4FDull, 0x319EAD4C35E2E93Dull, 0x7D3C0E60055905Bull, 0x6AFD0B6B425F7FFFull, 0x72AE1DA44577B598ull, 0x65DB9DA065DEC3EDull, 0x610D8E39447F650Dull, 0x77C09FE32E5056A6ull, 0x2CFE80335C366ED6ull, 0x6451343270E88EE4ull, 0x6938C62551FDC25Cull, 0x1AD8EDB65477FF47ull, 0x32495815622995C8ull, 0x73763FFD1154264Eull, 0x440193D461A8CF96ull, 0x798810B80B6E56A5ull, 0x32C3A4932B26BE04ull, 0x41513FE23A976579ull, 0x2B7C4E5F2C4E4B4Dull, 0x7CF6E5781E2A6C04ull, 0x71C600E562D28319ull, 0x4092FF152D38F1Eull, 0x2751E8267BC9CFD5ull, 0x123E5C554506859ull, 0x58003EAB657519F7ull, 0x4538F73D413904D0ull, 0x3772DC546011E4F4ull, 0x15B1041769BC3469ull, 0x423B7ABC09274414ull, 0x7B105AB7063D0E91ull, 0x6AD013AA74986B6Full, 0x11AB65361D93B83Dull, 0x1FBF297352FCA518ull, 0x582B1DB64B3B77D2ull, 0x7F4AF0655522032Full, 0x6965E3D67110F14Bull, 0x37F486486D6F13C8ull, 0x43E480695F466E6Eull, 0x6938E39D4508662Eull, 0x3396D6C741392248ull, 0x2A7D802678CFCE04ull, 0x272271861F05C7Aull, 0x58E1B2F818232B2Full, 0x4BAC90E31B1D2DB5ull, 0x214A6F4446BCEB9Aull, 0x215A3C460C1A82EEull, 0x3B5557093305A17Cull, 0x29AE3B2C5B14807Cull, 0x602469401D958E2ull, 0x264FF84E054D36F9ull, 0x56FB5C110FB5DC25ull, 0x765E28440EEFE259ull, 0x7D24EFED3A42A8AEull, 0x6E3650C7665DD38Aull, 0x7F4B0EDC21CD278Eull, 0x2796F5D229C88F02ull, 0x1A9CF5932A091CEAull, 0xBB8EB7C737EA88Bull, 0x422C481957657C5Full, 0xE9BD6406376B75Dull, 0x1E2267F92FF61286ull, 0x6F913A4C5977BF02ull, 0x62FBB402193F7578ull, 0x348C3F7E68FDFA96ull, 0x1B18CE5A5ADC37CDull, 0x6E4B319072142A6Cull, 0x6A9213F264A959D4ull, 0x1040CC567B703DFull, 0x1EEC02826F3A5D8Dull, 0x4E14D7691E37115Full, 0x1107851B75ABCD3Bull, 0x47FFA0612BA47AAEull, 0x1FB4EA2553B88BDEull, 0x1F23233A61E1323Eull, 0x2B1E083D2DBEF97Aull, 0x4557E99C49407037ull, 0x5DB50C0134E923E8ull, 0x22B82F3940B0C003ull, 0x4E28996057446EB8ull, 0x29AEBA9A694167BAull, 0x3220A68517F9EC2Aull, 0x5B5592261CB2BA77ull, 0x7CA345FE5C599EECull, 0x469BE561B8F4881ull, 0x4B93FC79527E95BFull, 0x39C659E05C9B8194ull, 0x482A62FA01C5FA41ull, 0x83FFC4367DF4D1Full, 0x557E861F27631F7Dull, 0x49C07F5D009C8E5Dull, 0x552218F70F1868F9ull, 0x49DCFE9432D724F8ull, 0x44018CE16C952DCDull, 0x7387E4FC122A2641ull},
	{ 0x43D99C851D369F96ull, 0x7B6B8DFC75FA430Aull, 0x35308BC056C12022ull, 0x12ACFD8131D3D1BEull, 0x331ABF0E1716BBD7ull, 0x4D631A3F7EAEBB87ull, 0x699551960729741Full, 0x5B4A3D1C31BFB490ull, 0x8EF6E61638A395Full, 0x199F01AF5E6DF480ull, 0xAED58DC635F810Dull, 0x5F0A82DD600F71D3ull, 0x7277EA0628E78171ull, 0x12E696CC367976E8ull, 0x157CAF3F066E7BC8ull, 0x48A39D2959564BC4ull, 0x23A51B5E440F2B25ull, 0x4F508ECF58D5A71Eull, 0x1AD04B4861FD8C50ull, 0xAA978DC4DEB0A56ull, 0x79144828580C931Cull, 0x4C99C5DE62A999BEull, 0x5F36073B27E402FAull, 0x14694E4F6825759Cull, 0xB6E3C592E084FFEull, 0x46936A1D165B9535ull, 0x1167D10B259DECFAull, 0x766B070803DFBB12ull, 0x4E856E6C09519DD4ull, 0x3A5931FA64021DABull, 0xFC0199C02FCCF23ull, 0x3D58696F336534FAull, 0x470BFA490CA8F83Eull, 0xC3ADC1861DC4591ull, 0x6EA6848F16E454F5ull, 0x2FC74FE767BACCB7ull, 0x6EF0E8117C6115C5ull, 0x4A6466754E26EF4Cull, 0x244518BF5ECDB4C4ull, 0x364C64E92FB35518ull, 0xCD604C37CDFCF06ull, 0x460EEA4D1E3DD5CEull, 0x227DBC003C79F156ull, 0x221D90E071032A6Cull, 0x45CB8F2A5C76C2DAull, 0x55054817558BA8C7ull, 0x5F7391FE125DB187ull, 0x8F0DDC1267F8C47ull, 0x1F06A9C5152BB9DAull, 0x85BD1D80DAD2E54ull, 0x2C100ECF382321BFull, 0x7567FB0B1B00F6E0ull, 0x348437853FCC6181ull, 0x6927E62C58C95044ull, 0x1E9A16451F744B15ull, 0x87CA55D2B701B08ull, 0x1C541A1B4E8B8FAAull, 0x49ADF0D73ED1D61Cull, 0xB0581006BCB81B7ull, 0x2FD5008850D1102Bull, 0x4842449204DA48A0ull, 0x265CB8F227B5D690ull, 0x1737FA272F4D96B3ull, 0x4E3562D7363EA3ECull, 0x4479508D569134AFull, 0x43EBD24170895F5Cull, 0xEB4566E3953CD4Cull, 0xB8A563C43388DF3ull, 0x79202ECD74B23C69ull, 0x1C01DE3817BA4513ull, 0x1426877E247E8395ull, 0x432A601B307AA19Aull, 0x730A133F0CD850F2ull, 0x6F4C77B67E0F9440ull, 0x78A3D2AA1F21783Eull, 0x4EE0A46B40E6173Cull, 0x23FBC0DE753D5D5Dull, 0x689BEDCC3B33BB05ull, 0x248AF41036D150A3ull, 0x71725EF26904449Eull, 0xD628552355E3133ull, 0x598DA3FA1C16DBC0ull, 0x6EB1FE7F6517FA37ull, 0x5F4F69B467D22D4Dull, 0x59CA36A07B5147ECull, 0x7F8C72606DF0BE1Eull, 0x1FCFCB8142B6D27Bull, 0x1E6B5FB812D9DEC0ull, 0x4F8F236E0DB7D76Eull, 0x10E973004832F618ull, 0x2CD94FAD5FCA176Bull, 0x9190D5450D5108Bull, 0x550774C871B4FB20ull, 0xC08CB91799268D9ull, 0x28864BC37D7B2A83ull, 0x6296AD7735E8D115ull, 0x32D95BB63C245171ull, 0x51FFACD5218B5A35ull, 0x213C4BA8314F1689ull, 0x95D87827B068248ull, 0x2CA05E7508E9F9E2ull, 0x68F740674C7029F6ull, 0x4BA0CC5E0762A01Full, 0x5F4A08B71B2FEFCCull, 0x151A778E70337BB7ull, 0x6362E5E441F3C73Bull, 0x4FFD93236C7BF338ull, 0x12C8D7C6250507EBull, 0x5E30EE581ED1A357ull, 0x1E9770C406B73A1Bull, 0x1C4CCDDA012E1E3Bull, 0x3CA00B304F262990ull, 0x3D526FAD0E9FB805ull, 0x70B183C65E8EBB55ull, 0x3FEECE8F7A0F0B48ull, 0x59953D9E6C8F2D04ull, 0x2F9052B428C7E05ull, 0x38FF56FB4E99D189ull, 0x49EF1E2418495FB2ull, 0x69C9C1555F0995B2ull, 0x87CDB694D2CA739ull, 0x20FD5CED587A6E8Cull, 0x39A89A7133C634B4ull, 0x7D7F767817D988C9ull, 0x5297D80B1C16E73Cull, 0x1E90C2E46EE4A5E6ull, 0x1D4505785B30CE14ull, 0x3E0ACF765A977525ull, 0x69D086192EBC533Cull, 0x3926307A29BF54A8ull, 0x28CB5E8512BB6E18ull, 0x164E81AD2BC463B0ull, 0x5547EC1D4F4DD8A8ull, 0x7A5E35391F370A42ull, 0x6797385A6427F68Eull, 0x7E409FF4701413C3ull, 0x31549DC71F3DFCE2ull, 0x488E82506AFD3838ull, 0x53043196460DF8C8ull, 0x2D6C101259C09A1ull, 0x6224E004216783E5ull, 0x1480AF877F69E57Cull, 0x7C9851F9528B7EFEull, 0x5A015AA16668D812ull, 0x147D23A13278B1Cull, 0x10282CBB2A1330BFull, 0x25E2F9342676AE68ull, 0x55D7946F7B2AE552ull, 0x75C487105035C9A8ull, 0x1A61EF945D5BBF6Aull, 0x345DC03618A28F88ull, 0x4D6FD32D65B25DFDull, 0x37E08C6A15FE557Dull, 0x50AF96350AE4BE00ull, 0x5C0C4E4553865736ull, 0x3080C7A23E312E4Aull, 0x74EDDB1B45017729ull, 0x3D9B13C671862D14ull, 0x178CF627179C6E68ull, 0x57EF052718D4C862ull, 0x2AC3F984681731E2ull, 0x42E7F92150A6F2B8ull, 0xE8DE04A18BF8D91ull, 0x4BD1D80A0452675Aull, 0x68F557396633C79Eull, 0x61AE26C41D531770ull, 0x7ED657272F1DF9F1ull, 0x305756D36B6E391ull, 0x451C4F6F53B50BA3ull, 0x419BA19221289DB4ull, 0x273B62D9721C6934ull, 0x5F59CBFE1C293DF5ull, 0x371DE05D1CF4DFC5ull, 0xDAF6B094EAAD685ull, 0x34914E2D659E7030ull, 0x677F9EE75F5547B1ull, 0x4DB5A2122A679808ull, 0x2FFC3A695C43825Cull, 0x432725997BCE1274ull, 0x6095E9B62C1C7CD3ull, 0x6201DA124244107Aull, 0x496F944360D83139ull, 0x71620A6C4C7509B0ull, 0x178F14CB367E59DBull, 0x202A1553592AB65Dull, 0x57A6F78F4765782Dull, 0x4B471F913700C38Eull, 0x638EB6220264FFEEull, 0x53F5A353713E212Bull, 0x510FD6730886F180ull, 0x56DC915C388F755Aull, 0x67DC39312492336Eull, 0x62F70D6317D8739Aull, 0xD5B5CB261E32FCull, 0x13A6860E616B9F81ull, 0x523AAFCF75A86021ull, 0x23AFAFFC1BAA4412ull, 0x5680915A1511BA68ull, 0x681F4DC36E0FA625ull, 0x4B90144308496316ull, 0x473A5C8223370BD2ull, 0x4FAEDB4312817C13ull, 0x5A37CF60333D9165ull, 0x14E67C022E2D72B3ull, 0x247BB29165F65275ull, 0x36B464337B5843EDull, 0x1E85C7D01E909D64ull, 0x1FEA775B017CD533ull, 0x366910FF20C02D26ull, 0x279B082F4A0F970Dull, 0x22BCCA879D5B7FFull, 0x3FB7F72E25DB7CA4ull, 0x157FFC1116388889ull, 0x3AED370C7D9F49D4ull, 0x4482EAE067D4B4Full, 0x5E8ACEB4B828B31ull, 0x29B457215597882Eull, 0x5E04074403EC2682ull, 0x8D5199472EA8346ull, 0x321999352D50CC25ull, 0x58E0D5BC68CDFD69ull, 0x28A9101277669D8Cull, 0x75E9ACD4893876Dull, 0x78E372BF3DC7ABCCull, 0x6953B494207E7AEEull, 0x7D742DA6B7F813Cull, 0x1A5432ED478F3A08ull, 0x115AFDE02FD42EFFull, 0x5DC7C2914C4834ECull, 0x2D7378D3620FF140ull, 0x52C5803B335C25BEull, 0x2D927C717C79D75Cull, 0x8F3ADED0B9683B5ull, 0x65FDDE11C8C781ull, 0x7E8106FC327F9714ull, 0x3F1993A65761DCB8ull, 0x1B4D947D67C2A3B8ull, 0x4EC87A4422AC2F4Aull, 0x30562B2547ABED03ull, 0x6073DB1719A9DFB9ull, 0x682A67F1684B1DF1ull, 0x52960F5027E9ADFull, 0x2FDA57F916845ED5ull, 0x3252C9DE0DA21A8Bull, 0x62CC93C15FC642B1ull, 0x6FB20BCB359213FCull, 0x132268701D44883Cull, 0x320BEB591C16165Dull, 0x28DB0BF13271E937ull, 0x2DDEDDDE275C12EDull, 0x64F1804B6CF87184ull, 0x7EBDEFA5003F14C8ull, 0x54BB153C4D8669E9ull, 0x22EB441305114061ull, 0x153256EC035F1F2Aull, 0x1EBB201B7D5CBEDEull},
	{ 0x6BAA3D1B23E48110ull, 0x7FDB59BD1B849514ull, 0x3A68DFE6322E239Bull, 0x2926AF9F1D3573A7ull, 0x11F4664C18D8BB6Aull, 0x52C787A42516CEBCull, 0x361D43A604D372FDull, 0x412CE5195EF84F98ull, 0x37455C346F0BC2F7ull, 0x65462851C36DC80ull, 0x5C04347B0512522Bull, 0x1C75F14830BF49B7ull, 0x5298BC143F61355Bull, 0x35D08A1967CB1301ull, 0x42C05485548BAA34ull, 0x6527D1DF2E6A91A0ull, 0x78702B4465032B9Cull, 0x49EF26B532D90B2Aull, 0x17314F377315D654ull, 0x500E7ED22925B583ull, 0xBEE91BF22D60676ull, 0x4E3C8440420BD565ull, 0x27A979730F696959ull, 0x210424FD5EEED5A7ull, 0x7E752C5127588783ull, 0x7B25B2275A7960CCull, 0x2C6AD9AE179BA370ull, 0xB38AA847F0395C2ull, 0x56FCD8CB4109349Dull, 0x66CEA8C319BD2D51ull, 0x1594DED14BF67AA2ull, 0x4827BEF10E050A15ull, 0x30F9A63E1216E5A6ull, 0x40DE1540482AF575ull, 0x52CBBFB10EC9412ull, 0x7150AAF9111B4DBAull, 0x33C29A883F8D2F39ull, 0x5327231F5B6C13FBull, 0x4EF69892742B481Dull, 0x3A5AE9A24D6BC4E3ull, 0x1B83CFA035809BCAull, 0x27E525B047EEA94Eull, 0x4D1C3F3A331DD034ull, 0x46F23F1024191805ull, 0x742704D12DC0E7D4ull, 0x3DD6455609BBE3A2ull, 0x79B7627605FE0448ull, 0x17C0EDB72AB108B5ull, 0x1814E9EE589F02F7ull, 0x72DBFE2A1D41A5E9ull, 0x698B9709642CA923ull, 0x2E5CF3A31D4E3191ull, 0x23B9D85C018416C3ull, 0x78BA458C72B070EFull, 0x75AF5EE033152F2Full, 0x401C35D211332E80ull, 0x6895CAF968015B82ull, 0x5921D7CE35B20A33ull, 0x1B1F2BB6201416DEull, 0x59CB22380F463087ull, 0x4DD4FEB217A1678Full, 0x19021429478C6129ull, 0x1D9F6BD730C301E1ull, 0x723D69DE35B455C5ull, 0x96204D865196808ull, 0x52F5FBAF72ED9BE2ull, 0x4946112C0152EF52ull, 0x103BCD736CFFE988ull, 0x2D7061508F61300ull, 0x5FB05A77788664F5ull, 0x3C0B422F1FCC904Aull, 0x9B9937524A10D28ull, 0x7CDEBCC62DB6B43ull, 0x5A53175B22ED1783ull, 0x2EF8222341E3993ull, 0x3233480A50C480D4ull, 0x4BBFA1224B355C34ull, 0x1850E1FD695F0CF9ull, 0x7BF85E150A8E4BDBull, 0x1F1362BF055A62EDull, 0x6FA7B3E472095E6Eull, 0x7847FECF38EDC510ull, 0x735C4DC00883CC43ull, 0x25EDAE98763353D6ull, 0x1179DF43059E0910ull, 0x6EB9B8CB4D852172ull, 0x256A995A78734C41ull, 0x72262E9A2D388526ull, 0x5B4EB7844C7945F5ull, 0x50259CA95E3E39A6ull, 0x977F880258E4B4ull, 0x2F02BA7B4C5720ABull, 0x4D8E40E847539C78ull, 0x35B62DA449869EFDull, 0x51E1E85454C99063ull, 0x4EE101EA41899C38ull, 0x46D2EED1472900BAull, 0x7A7761483A2F3C92ull, 0x4FACCCFD20650FE0ull, 0x306290686126AC40ull, 0x260318F01F1C4933ull, 0x2EABCDB24B6DB24Aull, 0x178F957420D1FC4Cull, 0x78A6377172DE4CF9ull, 0x6D4B424148CBD41Aull, 0x511C869F6DE2C1C9ull, 0x4B24B8CE001F411Aull, 0x3A39E27418B2F9B6ull, 0x4772DD936FF01019ull, 0x623998B31954C5E7ull, 0x44B9A07C311A9A9Eull, 0x5ADE621F0B8C8F4Eull, 0x78439B585555C367ull, 0x45BBCBE047F06855ull, 0x75BAD347761E5C48ull, 0x291714951BBDEC38ull, 0x153AA57B57C2E247ull, 0x672B9E822CCA3AF0ull, 0x7894DE935FD1D5F3ull, 0x1FA887E965E020D4ull, 0x289DAA0E70C50E88ull, 0x53C2E29D73C262DCull, 0x70E44FA30DFCC512ull, 0xC755C9338572D36ull, 0x7DECD52B6EAEF546ull, 0x51ABF31D42A675A7ull, 0x1FC98FE42C8A553Cull, 0x4E3304F5180D2B3Cull, 0x1E018A313EED0D5ull, 0x5FFD9391779AEBEAull, 0xA0D2D1D0914A826ull, 0x1358D8221F47D299ull, 0x60D78A6D7A8476A5ull, 0x4C120D89596C6900ull, 0x5A564C986BBA9572ull, 0x3F4C89D402F3F6A6ull, 0x5C7FA3FA130F6C72ull, 0x76B659834D63F39Dull, 0x210C3184032BB616ull, 0x5BB20D31EF906AFull, 0x71DAAB5C576713F0ull, 0x619F7C5611A43B41ull, 0x3F1692C2FD2814Cull, 0x29B1667D05D181CFull, 0x43C1522109AEFA0Full, 0x7D6C6DBA4DCE7F3Full, 0x12C3A23510C545DCull, 0x6D1651D8739B2CA3ull, 0xB49BC8139285F61ull, 0x4D0795A365A0091Aull, 0x24E2F4D30C541F78ull, 0x6893FFC0016298CDull, 0x1F638BEA5F4A5943ull, 0x4EC68C6B406FBD6Eull, 0x62760F595481AD3Eull, 0x5F68C41D5450BAB6ull, 0x2BE8C12F41084073ull, 0x65F4F5F72FDA2A5Bull, 0x70DAC1BF0FA65C74ull, 0x35ABAC2B349C13E1ull, 0x19555683331819E5ull, 0x26A93202C18F8B9ull, 0x43DD5FC16F80E4F8ull, 0x1FB4255C4F271C43ull, 0x28A944596CBBBAFFull, 0x34C7255D4D8C392Cull, 0x790FDA771D5B251Dull, 0x4EEED1F918736661ull, 0x7CA57E611DB55E64ull, 0x58E323CF5F1B8DBAull, 0x72370BA3384BE7ECull, 0x336C48701E1FCCD2ull, 0x7954286019613E67ull, 0x4DF9F72D6A2EEA1Full, 0x29079ADC03A5A358ull, 0x1ECAFE00425CF15Full, 0x36BDBD3D21359120ull, 0x6E75EA187A9B1CFFull, 0x10B676180E2A0F74ull, 0x49C23942395FBA71ull, 0x7AE5CA747E895E9Full, 0x6EBF39D73F5A4EBull, 0x1BE483BC55DAC597ull, 0xC690B4D188A021Dull, 0x739023FB654C2F1Cull, 0x77A58FD865C72F9Eull, 0x1D9817092B11D848ull, 0x3E6FC7016EC3F69ull, 0x447316B051E0F39Eull, 0x11B29886D7AB18Cull, 0x558696F61FE62789ull, 0x2FD7A2EB0C445434ull, 0x411BB8A91E4D8D04ull, 0x6DF713351D22EC2ull, 0x2C779C7850A1AA75ull, 0xB31E933275D66ECull, 0x4F2B0914121DDCD1ull, 0x1B530BD86B0F8CD0ull, 0x67F8A26827BC1725ull, 0x3998EEE5B88C663ull, 0xD0846417B3F1EC6ull, 0x414FF6022AA05D4Aull, 0x2650F70E4536F272ull, 0x418C9CB36AC40DBEull, 0x1717E61042A7C63Cull, 0x583EBF4A6C9E7D07ull, 0x628DEDC508166236ull, 0x78E2D13B23A9A66Eull, 0x2663EF3A7FC2426Eull, 0x757BD53052DB8BB2ull, 0x5063ECE300ADBE64ull, 0x7A38F29F1F8EF5F7ull, 0x12CB9B35158BFE77ull, 0xA9E82C77AC43D9Dull, 0x3D48159C0E3811B5ull, 0x564D04004A505BDDull, 0x977307B179CFA02ull, 0x74F0B9282FC8278Aull, 0x5CD3EC75367D55DBull, 0x1A8C354873EBD285ull, 0x79251C1772CAF493ull, 0x608A4F8C5BB309DCull, 0x7AE156C9596D20C7ull, 0x7F5CB04B21454603ull, 0x592F633574D8857Bull, 0x7420D1B529935018ull, 0x758643DF6E59C454ull, 0x4922460F0851DF14ull, 0x3E5C2CB53C0C8D7ull, 0x3161CB1412DD867ull, 0x61F8DA8C596320B2ull, 0xB7E34456B700B08ull, 0x71001AB4006EED6Dull, 0x1B3832924DD40729ull, 0x36EC434835C467DAull, 0x41BFD9AF30115F60ull, 0x288F5C6D224A293Bull, 0xBC4693C2370B336ull, 0x7BB74A030B211987ull, 0x44B5F93954E6AD38ull, 0x7FF99F0338D6CAEFull, 0x7E79FD51757FE2E2ull, 0x27308F43479C4360ull, 0x7DD1C1F72B16520Full, 0x1B5D0C3700E7DEA8ull, 0x6C442A767D55E6C4ull, 0x5A4AFF5A77C25EBBull, 0x68C5F1CC4B4B1A0Full, 0x78314C2803FE245Eull, 0x191F21382F1D8F71ull, 0x39C28C385ADEFAE7ull, 0x5F2EEED16251E8A6ull, 0x7D2924236AF3580Dull, 0x5C29BDC78E06E26ull, 0x761471954A789516ull, 0x4DC71B5E760E1098ull},
	{ 0x34F60054C4118AFull, 0x6B8DF37A2A7FEF48ull, 0x13DD5C10695FB571ull, 0x559641572F3A6847ull, 0x6A47941A41DA6BCEull, 0x2C904F0B44929374ull, 0x399CCA89155640D7ull, 0xFDDAD8331CE16B2ull, 0x1954653528FCCEBCull, 0x60EBA6235316F16Eull, 0x3DBC9A3401A94F4ull, 0x3568DA140104EDC6ull, 0x2B0DED013B2B75F0ull, 0x79E55BEC21225E96ull, 0x5A40B0647AC774Bull, 0x17306F2E08F36B0Bull, 0x13ED8FFA02BE62A9ull, 0x33735A5427CAEC0Aull, 0x6C1E181A09099BABull, 0x570554525665AC34ull, 0x4AE407790395A35Dull, 0x1AF83FA90480D203ull, 0x18EBE4352AD5ED2Cull, 0x364EE8B53240496Aull, 0x53D2BBE8173A8ED8ull, 0x5573AD857AE858Cull, 0x575523CC3AC014ECull, 0x58B37352026310CDull, 0x75EB8ADD5298CF3Full, 0x23856F647B8F95E3ull, 0x1A45468A3AB5DE92ull, 0x48300EF2E32D684ull, 0x3D74413B37F65B43ull, 0x55FDC28F29925956ull, 0x40FFF6EE2D0316E1ull, 0x7FF8058A0BE3FE68ull, 0x3098BA3E1AF04533ull, 0x1064D06B49849E73ull, 0x45C6326046B3B920ull, 0x7BC4E7DE1998EE48ull, 0x5DEE47F8011C22B6ull, 0x714773D435436BC4ull, 0x3BDC37A349FAE727ull, 0x37A67C9131C7C280ull, 0x1C93B6665B2BEBF5ull, 0x2D57586336D8FCF0ull, 0x15E1CA8831DA5952ull, 0x650BD37453560BC3ull, 0x69D0B4953B099603ull, 0x7CE865192AD0AB84ull, 0x680CACE47CE06AA4ull, 0x36B4A9EC18A56723ull, 0x17D0AFD747197A57ull, 0x622A05965D96E237ull, 0xDCD33775DEEED74ull, 0x772FD0806BBB7B6Full, 0x5F0B102B68774454ull, 0x20FEE7331AE747CEull, 0x32722B7B58A563C4ull, 0x4CAF0A4E4F05E1E1ull, 0x33D14FBA7A0662B1ull, 0x5DEDED149B31A42ull, 0x2BE0BC046AEAB246ull, 0x1D09260515B17099ull, 0x25F4484919F18B1Full, 0x40821C1D0E00F52Eull, 0x16D1F5C37736C609ull, 0x26A65C512EA2A59Aull, 0x3E50406008D061E7ull, 0xC3987D24C1D73D7ull, 0x66BF4F5C03695852ull, 0x37D8EF4645CA5F87ull, 0x6BE09CA658D7D679ull, 0x60B1A7551E52C822ull, 0x317D3A3E2D60B1A3ull, 0x6D58AA03654E89F8ull, 0x27671454733788D5ull, 0x2F01A43A5347D058ull, 0x5E223B1B4C0ACA3Full, 0x68F940F204168364ull, 0x65FC555E297B5D0Full, 0x121778927CCE4B21ull, 0x20B2231938BDD4E3ull, 0x2B70F0BC5F026379ull, 0x418E36CB37AA788Eull, 0x2B1FD751284D8627ull, 0x3B13D0E062F8C697ull, 0x6E17E5AE26F46D86ull, 0x3BD09D114EC98D03ull, 0x454735A86D4DD74Full, 0x7C2A3EA6329FDFACull, 0x529C6147239152FAull, 0x25D76881019E0581ull, 0x76D9235303F9A39Cull, 0x4DA8CFC05FD26445ull, 0x810270033A5251Full, 0x94DC1541A279F93ull, 0x3073704029FFE46Dull, 0x52E574765BE460FCull, 0x90247E71473AB41ull, 0x138ED98A34221F38ull, 0x3CC131684EA2AA6Aull, 0x171AE5CF2AD91716ull, 0x759717F152EB82E0ull, 0x79A2A4193ADE4D99ull, 0x40395A2F75CCE2BFull, 0x6D7E2D4512D5BB76ull, 0x195E35BA135595C6ull, 0x1473C0F71037590Dull, 0x174F3962621C90B8ull, 0x7009BD521F5F6063ull, 0x15C1B5D779577EA6ull, 0x3986FFF646352617ull, 0x235763140C6C746Cull, 0x221987142C59AAFBull, 0x20E01FAE35A8609Eull, 0x607BCA335DA15116ull, 0x44B0B097796B002ull, 0x87A682D79E222FAull, 0x4A8232E3021D0C46ull, 0x34C070930ABB8D12ull, 0x77E9EF06223E9DD9ull, 0x1D914889114824C0ull, 0x3594339F32050980ull, 0x217F7DCD4CE36D02ull, 0x14219A3811893B1Full, 0x6C42CD6529E3500Full, 0xAE0B9C525C9CD5Bull, 0x701876272E381CD9ull, 0x323641C71231FD3Bull, 0x5A91C7D453166175ull, 0x47DA5DD93B0D9207ull, 0x30B7B28C4C2568E2ull, 0x32A4420A39321AB9ull, 0x46078BDC7D2674EDull, 0x3B4F26FF7AC7FC70ull, 0x7E201FF33391605ull, 0x1D069A4925734A88ull, 0x44813AC5529ACDE8ull, 0x577854096600B892ull, 0x1F7E3AEA6B99EE41ull, 0x7789F3B10BC1084Full, 0x157D3E51026AAD77ull, 0x318AD5AA0595B478ull, 0x30A2CA5063C11772ull, 0x17C7B1B30B349225ull, 0x36D778E75FA20F8Cull, 0x4642242C678F2B73ull, 0x2BC7786F78E66636ull, 0x20C1462C71CF044Bull, 0x760CDB235C106D2Cull, 0x6C9700BB7DEEDD23ull, 0xF498331099D9B04ull, 0x236227AB53CABDF7ull, 0x5C3868ED7ADA7BB4ull, 0x39CB76897BB6A3D7ull, 0x667469F631556A3Bull, 0x777AC277BF1A847ull, 0x33C017B2390281D1ull, 0x1875CBF6462E202ull, 0x1CC39943194F0E72ull, 0x6F977427539B122Bull, 0x78F11DFE35D99854ull, 0x3B2A3D9E24B8966Dull, 0x2EBFFE8A5BEB83CBull, 0x16879AB924CCD9AEull, 0x37FBF0F7031E9B74ull, 0x22BBB6D147457428ull, 0xCBC3679461DDE7Cull, 0x1B10321F68F49F66ull, 0x40F85A3154DBA8A9ull, 0x64AB433D276CC427ull, 0x63112E46C22EF64ull, 0x235E6C6E39F12A96ull, 0x2525713624E5C92Dull, 0x1E540C9841E90A79ull, 0x3E34D79F0DEB80C0ull, 0x15841CA43725F59Dull, 0x43C5191450AE5A43ull, 0x5BDE8C0B7285179Eull, 0x2C99DE0E726626C4ull, 0x1751F14C6495CF05ull, 0x7584C2383A0DA81Dull, 0x2BDB432D0240F8B1ull, 0x2B869A46EB754Dull, 0x6B3598174123E0CBull, 0x1BC71DF64FE0DB55ull, 0x6890A4F221F830DAull, 0x3C03CAB90BEF1160ull, 0x5BE95B7061293BEFull, 0x30D4DA8D7A3D6808ull, 0x231246696F09B22Cull, 0x828E8C83896630Dull, 0x262FA7C94BEE01DCull, 0x944BD50020E33D4ull, 0x3E73197B35DE9B5Eull, 0x74745A9855C50AC7ull, 0x1A746A6369F91CD1ull, 0xFD2B2E5464FAD91ull, 0x6C3A15820FFE397Full, 0xD3B22DE576FAD9Aull, 0x51221A4A290240D4ull, 0x275088EF39B2BF3Cull, 0x4AFA71AE635453A8ull, 0x45A1D09C26E3CD1Eull, 0x447D8F987676AB29ull, 0x21213526678FD601ull, 0x65805D55294A1DEFull, 0x2026390E0BB0051Eull, 0x75381FCB296AF65Full, 0xDBE38F333AB3946ull, 0x5F4991BD0232938Bull, 0x970440E79BDFC21ull, 0x6C2BB05C1942F6F3ull, 0x400DA9B25865C5DFull, 0x294130724D48CC90ull, 0x2FD573797A634ABCull, 0x764B0D645725FC68ull, 0x341609F841457F12ull, 0x3A7A501079B7DA94ull, 0x68294C307EF7DFA8ull, 0x702E85BD094A8156ull, 0x6687B5A955AEE312ull, 0x32949F4506ADEEB8ull, 0x615EE83027CCBF11ull, 0x3018E5176F1D2123ull, 0x5B77F8570F6276D4ull, 0x714FB4AF64E83C65ull, 0x92072F55D7B650Bull, 0x7E2B3358492E1CA7ull, 0x35E12AEA276C63CAull, 0x1676E93765B69E63ull, 0x21CFAE860CC1F69Bull, 0x3CDC9ACB55E5B87Eull, 0x4E0775AD7756EADCull, 0x4F9D93123630C1DDull, 0x764ECA843FCC18CFull, 0x3F7B43345CD6802Eull, 0x157AFBE1720FE279ull, 0x63846EE676D9E412ull, 0x19DCA18A139D53FDull, 0x65F70535755499E2ull, 0x22FFCAD15746B9E4ull, 0x5A3CD6472C203DC7ull, 0x34C21EF0586809A0ull, 0x754E5A6E6AA349DAull, 0x7FD46D6A0BC543A6ull, 0x5059E83E21A41BF1ull, 0x18873A410D368309ull, 0x7789D46F668EAFEFull, 0x48D6DE547276782ull, 0x1CBF71CC7ADC386Aull, 0x6F380515C3AB500ull, 0x57B2B8981C6E7C33ull, 0x4E4A977A3B37277Eull, 0x1348604568273904ull},
	{ 0x4ED47B7B793F657Aull, 0x5D7BD2E671D4464Cull, 0x50861F5F37B8A92Eull, 0x1DF4841305483E4Full, 0x1020B2CE1342DE82ull, 0x6FEB88290FF52038ull, 0x1F08222840457067ull, 0x31993C29378F5C69ull, 0x4D7BF37129231099ull, 0x1E1E0C5852096156ull, 0x704A781B3ADD7E25ull, 0x4CE599C0773DF86Cull, 0x1718332524985258ull, 0x13AC749F6562CA9Full, 0x5FCF79D626F4D4E4ull, 0x4D8A03A42EA3F551ull, 0x20343A5F2B05D68Aull, 0x20783B9E70BA59BEull, 0x62BE7FB83E6CBFB1ull, 0x7602980D72DF3286ull, 0x51AF9E3365EE2036ull, 0x2D452BF70B7C05Bull, 0x2633909E346D8EE8ull, 0x28471CC573AF840Full, 0x5D909F814665291Dull, 0x45B8E5654DDB179Cull, 0x142A742129E7F26ull, 0x45191009185ADA68ull, 0x3736D17E58C584A8ull, 0x7DBDA50717064B55ull, 0x7FBA598D4B47A8ABull, 0x45AA40A61FEE93ECull, 0x764D7F3666227C44ull, 0x10A8EDAA590BFEEEull, 0x248F3BF606AB85B7ull, 0x4BEB3175763EDA29ull, 0x6C99A5ED4EBF8434ull, 0x66F69A8512CD368Bull, 0x32D131C0F3DB74Aull, 0x67CBA9A60BDB29Eull, 0x55A2E0674C35A000ull, 0x2E98CA3A56E587AAull, 0x5ED41F2673B1DA43ull, 0x6F406212160AF0A4ull, 0x4C775EEC6CFE0719ull, 0x2D113BF94C31B879ull, 0x3845AFC572BB7CA0ull, 0x6C204C652E932EFBull, 0x58DDF8E47CC93A0Full, 0x79F2DE97D6D34DAull, 0x374BFC6538A5F5Eull, 0x73AC0F04700E65B3ull, 0x2249E3925AA2A989ull, 0x2DB9C3F2576F6AFull, 0x69E060D3095856D9ull, 0x634A94D3F83413Aull, 0x558DF6D934CD7387ull, 0x1668C8E4346215FFull, 0x287F4DCB05A92AF6ull, 0x4A6D06A474F6ACB7ull, 0x72A73210777E429Dull, 0x412865302AECE1D5ull, 0x6A39BF3D2D48B195ull, 0x598010D04317B822ull, 0x2A11EBA4611F3EB9ull, 0x4084ECFC2D86AB6Aull, 0x34A99E183430FC00ull, 0x1D95111D56F381AAull, 0xED3A5892070AD5Cull, 0x7C6A785978B4065Cull, 0x29C90436029F21A6ull, 0x383747977F56FB0Full, 0x376C952E4EA0107Bull, 0x33B9110F5FEBE2F9ull, 0x54493B727E2617B3ull, 0x54E28FB046F06D82ull, 0x75A45A50160AF4E0ull, 0x71DD4F575FDE198Eull, 0x4353A6754B5D6027ull, 0x22F5D1B06D659219ull, 0x2C7C9EE0637ABEACull, 0x1AEC3D8361263CF8ull, 0x17ABBAAD38814EA0ull, 0x3819BEA3267F6036ull, 0x58F1FBFD348436FCull, 0x1F33669302BB0033ull, 0x372358A3576AAE2Aull, 0x211FB426E8FEDD1ull, 0x260ABEA535CB0C51ull, 0x4E7BD0CA7A53FA17ull, 0x33F12404235E607Aull, 0x4144679929957E55ull, 0x3969555A3321B6F0ull, 0x97397E37CBCFBCFull, 0x7E7F17172C696993ull, 0x6A228DE82AFBB5F8ull, 0xFE4283F050ECB6Bull, 0xC21F2F0278FE2ECull, 0x3D901A0B443BB193ull, 0x4E0F432316821608ull, 0x78BFE8906D42A9B6ull, 0x193D163B2FE34133ull, 0x44AD57E01B4F117Eull, 0x1E732F046AB81685ull, 0x511A1DCF6CEEFFCEull, 0x650C109D050B41D4ull, 0x104D604826507836ull, 0x2EA0C02949B6B5A2ull, 0x59722F273814580Cull, 0x4673B17157F1463Eull, 0x647DC19F30963F59ull, 0x2ECFC367461E9DEull, 0x35A50AC40F0EEF27ull, 0x1BF1CCCB733524CFull, 0x534AA0BA6A010FEEull, 0x9B73AD84C0A894Aull, 0x5743B9A422F45113ull, 0x7BEDCA7D1BF11184ull, 0x3E4362911A60F981ull, 0x6A928090F5D8061ull, 0x74FF94F6BB538A6ull, 0x1468C235179D5997ull, 0x1205B0DD4309825Eull, 0x61540F396B77E004ull, 0x7B1DDA6A27C7C0AAull, 0x436926425F9B9C09ull, 0x585E000346562279ull, 0x53FD85E70E030AC7ull, 0x556511A06FEF52B2ull, 0x1382F9728AFB25Aull, 0x59F062A00AEF6A6Full, 0x74BA3BA531341C44ull, 0x2DE3BB8270A80622ull, 0x4D252DC86C271E14ull, 0xB08FFA453CE55D2ull, 0x7B849E751258F8F3ull, 0x3F838E780FED60AAull, 0x29F6528B51893F55ull, 0x52F6E3080B4A61C4ull, 0x3D011F594E14BD72ull, 0x3312226F006A459Cull, 0x2DB0597B0B702272ull, 0x46C0681501ADDF62ull, 0x19732D3A1C2579B5ull, 0x719D32151AAB5CD1ull, 0x44D52C0F4B8D94B5ull, 0x259AC740398F67B4ull, 0x7CC1B0FA537E82C2ull, 0x2A376DD749E6DEC2ull, 0x3FA5A0D635406D7Bull, 0x1DB534943B2A3F4Bull, 0x4799666E5D38C30Dull, 0x4B179FF5718FB8F9ull, 0x2EC202621E0E82FDull, 0x7CDA1ABE6BC321BCull, 0x6C23406F2FEC3D2Dull, 0x6C2D675819D399EAull, 0x3B5C5F9F32EDCF6Dull, 0x1B81794D54CF8CD9ull, 0x4F1349220D1EAB62ull, 0x6F7AE9AA13E87531ull, 0x58AC40171515B0EAull, 0x4D77DCE6556DF111ull, 0x689433AD77AF4ABDull, 0x1F54CFD42839D483ull, 0x2CEFB8383D0A0468ull, 0x636413CF74891EA6ull, 0x1A42C7752E7BB3C4ull, 0x6618D7A04904C9D8ull, 0x4C8A36C262F2F25Eull, 0x34C7EB9438AD7731ull, 0x12DF2F8B20F552ECull, 0x5281111C4E3B8F2Aull, 0x53E322596E028A69ull, 0x230B1C0422F66B7Bull, 0x7B2135CB128605AEull, 0x36DEE0AC53CD75E2ull, 0x279BB6990456BD92ull, 0x293B66F4102FEA46ull, 0x7C06084F489036C8ull, 0x3869BEC928F5C087ull, 0x59A3B301BCDD298ull, 0x1D7EDF2E1FDD02A6ull, 0x4A49865D0397B6CEull, 0x68E1CC7E16D3BD1Full, 0x668AA92C1DA9B812ull, 0x4F8134507969D8B7ull, 0x3E9F0AFE2202456Cull, 0x47A567E112822D57ull, 0x1004CFD56AB083E5ull, 0x357898D20B2605A0ull, 0x7D3689946C57797Eull, 0x5EF37B8324D2402Dull, 0x70AE3711082EE277ull, 0x35022A736CB43F60ull, 0x50BF193F6D6BE93Cull, 0x15A9FFE85659546Full, 0x939BBD53328DF16ull, 0x7636571553834232ull, 0x36C095E45F182393ull, 0x6A56FF511D4B3F10ull, 0x7CC1DBA539D833A1ull, 0x16B517C73B60E6A3ull, 0x5BDA790E5E5A7FA8ull, 0x4DE313FA6BDF48E3ull, 0x490B038E035BACCCull, 0x77054E8446418D22ull, 0x6FB3264B55F8CA07ull, 0x6B13CD4F60615D5Cull, 0x5E27AC7E2015F7C2ull, 0x4D159CBC2EE6C5BDull, 0xD81E0FE62BF9CA4ull, 0x5401A2C16BB9CD3ull, 0x15E87BBA7B767142ull, 0x6A3EDF054CA9119Eull, 0x5A8E94D55495DE56ull, 0x69F450AE5750707Bull, 0xE6E11F800A96875ull, 0x12B1571E6A488B06ull, 0x5F03E81E60946B19ull, 0x5627D3E9280EEBACull, 0x63F017E54D2D226Dull, 0x6E5078CE53A33E30ull, 0x2325EC745964461Dull, 0x34049B8C014D98F2ull, 0x797A3DDF011A3849ull, 0x30345EAF06FC1EDDull, 0x63D9D4ED357478DCull, 0x1DB7BBB179C250A8ull, 0x30EAEA1E07F69AB6ull, 0x466B62460B797EF3ull, 0x5C8C790D305FB2F5ull, 0x62C9EF6E6AFA8B05ull, 0x31091B6A757B468Dull, 0x5543160B100D0388ull, 0x560FB1A62B6AE9F4ull, 0x381BEF3439FFC98Bull, 0x78980C62266C6802ull, 0xDA307BC1BBDF8D6ull, 0x7FD0AE1F41A7A348ull, 0x1D0B91C9794AEBFEull, 0x42C1DB914D3FF078ull, 0x470ADC269BB07Full, 0x2B469541DFEC68Dull, 0x205E0127339F5372ull, 0x25F5614366C9636Dull, 0x3F18D2660281DA50ull, 0x1729166221E2C1D4ull, 0x6D7C6555483231CDull, 0x175E086142BF7B60ull, 0x583F35556D6DBA07ull, 0x6E2A6555105B248Aull, 0x276D839366C271B7ull, 0x36C78C8C35108B4Full, 0x2806A8D36983AACull, 0x76B82E971F8BFC56ull},
	{ 0x2FE326AA397A0A29ull, 0x6CCBECCF302A3186ull, 0x6015BAA86F805623ull, 0x4E28F8130073BBCFull, 0x231FA996741E5957ull, 0x673D1F3C62387BFCull, 0x76A033A77E66359Full, 0x41B3DD0641C98FDull, 0x4698676C1B794632ull, 0x26DC145D1ED79CC1ull, 0x8E70039150679B2ull, 0x2F32C14B305483CCull, 0x7BC8EB6965FA4DD8ull, 0x65650F1B7E4955F7ull, 0x1C9288845C1D3DB3ull, 0x1DD5524D4C75AF2Eull, 0x159747DC0AA13F1Cull, 0x7C9FE0B575AD0284ull, 0x7A2195404AC8D8C8ull, 0x7620BE531D413ED6ull, 0x3EE7321F5D5DDD8Full, 0x7F79BAD2358765C7ull, 0x5BC4132E0394F8A2ull, 0x19A3FEC4225C7A9Aull, 0x1F0E3ED440801321ull, 0x4134175C27F53F0Eull, 0x55868CD47066D8A7ull, 0x5849C2DA514F783Dull, 0x5661267F3DAED1F6ull, 0x4F98CE3472F3AF03ull, 0x19CC0FA96D6E2082ull, 0x3F695E322F635785ull, 0x780F5F9E3C093EE7ull, 0x25105A097230F4DEull, 0x6D217AF1B31185Cull, 0xF7233B445B949CFull, 0x788EF5EB0EEBEE86ull, 0x7B40AF965453091Aull, 0x1280E72914E4AE5Aull, 0x76AF83B4318F25FDull, 0x5564C17B37E39B10ull, 0x5984650B2AEB4E4Full, 0x284A73B831CE27E6ull, 0x7C3AC68D7EAB9A37ull, 0x6F7CF9DC4BD394C1ull, 0x719F493B09490985ull, 0x3941B5433108A76Dull, 0x38AC610A315114E2ull, 0x6D11E6545DBCBB13ull, 0x238209C073E3FE03ull, 0x78EDD36F32F43D75ull, 0x399D47D2717CC95Aull, 0x41E02BFB34DDF768ull, 0x45CFD27454611324ull, 0x49C2A5C23C7F5629ull, 0x5F039221F27673Eull, 0x7462F1395F749E2Dull, 0x4A12B58D1CAD64F1ull, 0x1142C613464D7C1Aull, 0x1B58FF2900BFBFEFull, 0x122110DC0CF84864ull, 0xA08C9744B62C61Full, 0x3E00EFD142B52A7Eull, 0x7CB3DB012B12D625ull, 0x2071E5912035E4C2ull, 0x1EF6D428195FB900ull, 0x532A223758941BFBull, 0xADC825B150A4E32ull, 0xD72136350AC54CFull, 0x696B61575734B926ull, 0xD2BAAF86F5B9A79ull, 0x765C2064018E9C32ull, 0x4ED038A6406ED5F1ull, 0x1E3C01236012FEBAull, 0x6BC520C3995004Cull, 0x60D2BEA918DD62E8ull, 0x468D48B06ADB881Eull, 0x64402907048E3881ull, 0x2D90B29C60F40409ull, 0x2FA10EA64E02982Eull, 0x129E8CB4E97E2CFull, 0x6762512E54540B02ull, 0x272BFECA723ED389ull, 0x695E5934349E122Dull, 0x42EB285952C9BA8Bull, 0xBD2CB535016D351ull, 0x42255504022EEBB7ull, 0x51A56F8310F58DABull, 0x429DC1A96FE170A7ull, 0x71088C65495A13B5ull, 0x297670F351DB4B0Eull, 0x6237769D7003B9A4ull, 0x3CB6D32C46779FA4ull, 0x7491F2256A4785C9ull, 0x276BA3AD243300CCull, 0x384A1DF728958C78ull, 0x72CAE39B1FAC6F25ull, 0x7CE9977A19F6E265ull, 0x11EB42AF6647F0AFull, 0x4E94F49254D66B08ull, 0x3911AB3A5A67BFE6ull, 0x24ED3E597B37003Full, 0x5C96AB9D7692ADDDull, 0xC2C8DEA1F346D46ull, 0x66741E847D351A4Full, 0x688E80FB0FEA8F77ull, 0x4F10655D4AC5F798ull, 0x7FEE491B0BC7388Aull, 0x113D973D74803B41ull, 0x760EBE5338A93AEAull, 0x18B33C0D2E58DC4Aull, 0x613EC7630B7E1FA8ull, 0x4E054B6F5E285EDDull, 0x2575020D5FF08E1Eull, 0x44704F8C7409F69Full, 0x34C6F9267D81FAC7ull, 0x4E71B68559B43780ull, 0x78B8FB062B086223ull, 0x5046E55D04E588F0ull, 0x4A3CCF6936BB03E1ull, 0x21AA33F32CB5065ull, 0x46A59358512B089Cull, 0x7D9147FD4693DC74ull, 0x5CF241260ECEDF3Aull, 0x3B1417B55300FF79ull, 0x47781A2553C753C2ull, 0x159DBC328B6E188ull, 0x5F45736A4F5F2733ull, 0x6DF406504BA7577ull, 0x2F4FB5514B4F8FF2ull, 0x78C46C166416AE78ull, 0x48D18AB94736229Cull, 0x3DCAE5F8418A85BFull, 0x723E84BF0E11CB55ull, 0x46700EAF3C7B5428ull, 0x44CCCF36488AB1EEull, 0x6F46A48D0B72628Eull, 0x19B5BA8A6CD7EC8Bull, 0x52063F0276A7FBB1ull, 0x7BA6CBC50D1A56B7ull, 0x49A8FB2A431EE5EAull, 0x60E1AA794B02D6EEull, 0x6BD5C77240271DE3ull, 0x1A61FE2172B507D8ull, 0x44E1935A49B1B372ull, 0x3E0497CA3DA5FF71ull, 0x2DC861EA06D62283ull, 0x4DC220D6B9347E2ull, 0x4860A842771AA6CCull, 0x79A513370ED0B6F1ull, 0x3395FAF43E71E26Dull, 0x575B68DF22DC9F82ull, 0x49E444FC71112369ull, 0xFB48C0D1BEA83FEull, 0x67B91F1A0B5B57D2ull, 0x2904DAB631621A45ull, 0x4E7A3DBD09E6852Full, 0x7C64F1333A50052Full, 0x4A0DA31316C6EF54ull, 0x2D050D070EEF366Dull, 0x6078A2C66B09A4D1ull, 0x4C9535DE0E4104B1ull, 0x71DFC754517157EBull, 0x79D44C933A406F96ull, 0x488BFEB773795FCBull, 0x491126877C21F9ACull, 0x31EB4238206C8F66ull, 0x1EFE992E7BCF8734ull, 0x117DB2D02EB3253Bull, 0x17BA0B337936D1EAull, 0x3A0E7D0D40BEE5E9ull, 0x2A98EC2F0888BACAull, 0x4AA56B1826FDDD62ull, 0x42D8BFFA14B30E2Bull, 0x3DC4CCB66FDDCD01ull, 0x23A244991E3D6F7Dull, 0x5AE771D370377A77ull, 0x2C7E742E4CC73927ull, 0x41A8D2632652C0C1ull, 0x707A8BE0A34D11Aull, 0x19CC208C5018CF45ull, 0x656CAC64BB762C5ull, 0x70855EAC255563F4ull, 0x4786E9F90203117Cull, 0x5408892F5F40F52Cull, 0x7B39E3660E17063Dull, 0x1FFFDB1525D2CF96ull, 0x169FC1076AA5462Eull, 0x4CD0ACF859788101ull, 0x7F5854590A9579AFull, 0x49564E0322FA98F2ull, 0x28D2E92C243DBFD6ull, 0x1332136A55515D5Aull, 0x7104F8FD54DAE5CDull, 0x7BA41E1B780CA1BBull, 0x5F0FB6E715703EA8ull, 0x48257101656681AEull, 0x6127A16D38AACFADull, 0xABBE5A228AE8B66ull, 0x3AADE1295EC46ED2ull, 0x7EF809335E7C48Full, 0x6CDB750F27EF5BA8ull, 0x5BBA9425037B3616ull, 0x1294A1D6288B411Eull, 0x5CF3B71811ECF630ull, 0x3320BACD264A051Bull, 0x34E78F225BF3A3F9ull, 0x4A87C4F14819A28Cull, 0x314501533B8CBDEEull, 0x1CF488592CE91F6Eull, 0x33995FAA7C043F41ull, 0x42595E167BBED0ABull, 0x616AC0EF2380FF83ull, 0x3469A0586C26A691ull, 0x4C2F8AEA6F178181ull, 0x4AEB1563541F0B7Dull, 0x24FF461037C68A72ull, 0x7C0E672500B9DA36ull, 0x3B41C0890EA308FCull, 0x29451B54183577A1ull, 0x208FFF2C5C65D621ull, 0x3E7F7CBC55778E4Eull, 0x38597A1A090741ADull, 0x1D9130DB699E7B6Dull, 0x4493FF9B3A85B934ull, 0x16879ADB782D5F45ull, 0x3689F87558E0F8F2ull, 0x73EC2FF017F4B964ull, 0x7C61F8752855D048ull, 0x41B5FF64891835Full, 0x176D51C94F067559ull, 0x1CB08EDC3C6C97DAull, 0x6CCFFCC18BEF602ull, 0x3D267210420EC055ull, 0x2761FEFE666B8D64ull, 0x5A4437F647F1FE2Aull, 0x42D1638518C3B4B2ull, 0x1D698C787B2ADD9Full, 0x21CAF65F3AFABD53ull, 0x64C9590C665EF5FAull, 0x758076887B50F3E7ull, 0x5E8C55402C0A6EFDull, 0x5431ECD952788530ull, 0x43FF28625093E54Full, 0x7ACE5579481A8858ull, 0x192568AE123BA742ull, 0x1720FDB135D5F78Bull, 0x4EA83F1C1DEDFD7Dull, 0x4E94ED8D0BCEB12Cull, 0x5FFCBDD275F6EC8Bull, 0x723A3E903A40F5C8ull, 0x3DE8EAB5350BA215ull, 0x5304AA7A5B52772Dull, 0x30367FB474CFA0D9ull, 0x164D348114FFD8C0ull, 0x5B2E96D40BCDAB09ull},
};

//uint64_t zobrist[8][11][64] = {
//	{
//		{0x6B8B4567327B23C6ull, 0x643C986966334873ull, 0x74B0DC5119495CFFull, 0x2AE8944A625558ECull, 0x238E1F2946E87CCDull, 0x3D1B58BA507ED7ABull, 0x2EB141F241B71EFBull, 0x79E2A9E37545E146ull, 0x515F007C5BD062C2ull, 0x122008544DB127F8ull, 0x216231B1F16E9E8ull, 0x1190CDE766EF438Dull, 0x140E0F763352255Aull, 0x109CF92E0DED7263ull, 0x7FDCC2331BEFD79Full, 0x41A7C4C96B68079Aull, 0x4E6AFB6625E45D32ull, 0x519B500D431BD7B7ull, 0x3F2DBA317C83E458ull, 0x257130A362BBD95Aull, 0x436C6125628C895Dull, 0x333AB105721DA317ull, 0x2443A8582D1D5AE9ull, 0x6763845E75A2A8D4ull, 0x8EDBDAB79838CB2ull, 0x4353D0CD0B03E0C6ull, 0x189A769B54E49EB4ull, 0x71F324542CA88611ull, 0x836C40E02901D82ull, 0x3A95F87408138641ull, 0x1E7FF5217C3DBD3Dull, 0x737B8DDC6CEAF087ull, 0x22221A704516DDE9ull, 0x3006C83E614FD4A1ull, 0x419AC2415577F8E1ull, 0x440BADFC05072367ull, 0x3804823E77465F01ull, 0x7724C67E5C482A97ull, 0x2463B9EA5E884ADCull, 0x51EAD36B2D517796ull, 0x580BD78F153EA438ull, 0x3855585C70A64E2Aull, 0x6A2342EC2A487CB0ull, 0x1D4ED43B725A06FBull, 0x2CD89A3257E4CCAFull, 0x7A6D8D3C4B588F54ull, 0x542289EC6DE91B18ull, 0x38437FDB7644A45Cull, 0x32FFF902684A481Aull, 0x579478FE749ABB43ull, 0x3DC240FB1BA026FAull, 0x79A1DEAA75C6C33Aull, 0x12E685FB70C6A529ull, 0x520EEDD1374A3FE6ull, 0x4F4EF00523F9C13Cull, 0x649BB77C275AC794ull, 0x393865751CF10FD8ull, 0x180115BE235BA861ull, 0x47398C89354FE9F9ull, 0x15B5AF5C741226BBull, 0xD34B6A810233C99ull, 0x3F6AB60F61574095ull, 0x7E0C57B177AE35EBull, 0x579BE4F1310C50B3ull},
//		{0x5FF87E052F305DEFull, 0x25A70BF71DBABF00ull, 0x4AD084E91F48EAA1ull, 0x1381823A5DB70AE5ull, 0x100F8FCA6590700Bull, 0x15014ACB5F5E7FD0ull, 0x98A3148799D0247ull, 0x6B9476442C296BDull, 0x168E121F1EBA5D23ull, 0x661E3F1E5DC79EA8ull, 0x540A471C7BD3EE7Bull, 0x51D9C564613EFDC5ull, 0xBF72B1411447B73ull, 0x42963E5A0A0382C5ull, 0x8F2B15E1A32234Bull, 0x3B0FD37968EB2F63ull, 0x4962813B60B6DF70ull, 0x6A5EE6414330624ull, 0x7FFFCA111A27709Eull, 0x71EA1109100F59DCull, 0x7FB7E0AA06EB5BD4ull, 0x6F6DD9AC094211F2ull, 0x885E1B76272110ull, 0x4C04A8AF1716703Bull, 0x14E17E333222E7CDull, 0x74DE0EE368EBC550ull, 0x2DF6D64846B7D447ull, 0x4A2AC31539EE015Cull, 0x57FC4FBB0CC1016Full, 0x43F1842260EF0119ull, 0x26F324BA7F01579Bull, 0x49DA307D7055A5F5ull, 0x5FB8370B50801EE1ull, 0x488AC1A5FB8011Cull, 0x6AA78F7F7672BD23ull, 0x6FC75AF86A5F7029ull, 0x7D5E18F85F3534A4ull, 0x73A1821B7DE67713ull, 0x555C55B53FA62ACAull, 0x14FCE74E6A3DD3E8ull, 0x71C9129809DAF632ull, 0x532999381FBFE8E0ull, 0x5092CA791D545C4Dull, 0x59ADEA3D288F1A34ull, 0x2A155DBC1D9F6E5Full, 0x97E1B4E51088277ull, 0x1CA0C5FA53584BCBull, 0x415E286C7C58FD05ull, 0x23D86AAC45E6D486ull, 0x5C10FE210E7FFA2Bull, 0x3C5991AA4BD8591Aull, 0x78DF6A5539B7AAA2ull, 0x2B0D8DBE6C80EC70ull, 0x379E21B50069E373ull, 0x2C27173B4C9B0904ull, 0x6AA7B75C1DF029D3ull, 0x5675FF363DD15094ull, 0x3DB012B32708C9AFull, 0x5B25ACE2175DFCF0ull, 0x4F97E3E4053B0A9Eull, 0x34FD6B4F5915FF32ull, 0x56438D15519E3149ull, 0x2C6E4AFD17A1B582ull, 0x4DF72E4E5046B5A9ull},
//		{0x5D888A082A082C70ull, 0x5EC6AFD419E21BB2ull, 0x75E0858A57A61A29ull, 0x5399C65420EE1348ull, 0x4427069A0B37E80Aull, 0x2157F6BC704E1DD5ull, 0x57D2F10E0BFFAE18ull, 0xE3E47A82E48F044ull, 0x49D0FEAC4BEE5A5Bull, 0x5551B9F324F6AB8Eull, 0x634C574C24E99DD7ull, 0x2A31B62D1849C29Bull, 0x7DFF9D0900754342ull, 0x69E7F3E52A6DE806ull, 0x1816F8C437DF2233ull, 0x7AB49DAF759F82CDull, 0x61E74EA3597B4D84ull, 0xF819E7F57C7D42Dull, 0x312167AD631B64D4ull, 0x78B5E77675486E47ull, 0x6E534CDE1A0DDE32ull, 0x65968C1C46263DECull, 0x260D8C4A73D4D3C4ull, 0x746F2E306FDE8AF6ull, 0x3FC32E2049C0E823ull, 0x14D53685230F856Cull, 0x6EAA85FB3F06ECB2ull, 0x3B5948076CAA2304ull, 0x3F7C2FF425413BECull, 0x17180B0B579328B9ull, 0x5D205E2011CCA8BAull, 0x4D32AB863F07ACC3ull, 0x6B47F63E5CB44A05ull, 0x16CF80F11C695DECull, 0x3FCFAED90F856867ull, 0x11B1CC332E22FBB7ull, 0x2993469977485850ull, 0x744939A34FA0D2E3ull, 0x6B1D2C1468B867D3ull, 0x3F7F5DD92AE05A34ull, 0x32794FF75454945Eull, 0x4DEFDFA02123D5F2ull, 0x135B8110094927A8ull, 0xDCDF8F652D7B105ull, 0x2E8A639424E60401ull, 0x2A6AD9BE0BAAC1B4ull, 0x36B2ACBC779D8544ull, 0x4AB26E7821FAA2FAull, 0x5451CF496181EF69ull, 0x3E6400E614217E23ull, 0x710757D05015CD1Aull, 0x424479DA1A9A9E69ull, 0x475E256A368DB37Eull, 0x6A3B714C327B517Eull, 0x1F461B5129BACF25ull, 0x5D5BABB351BF6B48ull, 0x7E0F63842B4B8B53ull, 0x72E3413A116AE494ull, 0x3494B2FB00B13A31ull, 0x64429599631F1690ull, 0x25973E320EAD6F57ull, 0x6EC9D8445C49EAEEull, 0x64AF49B397C46BCull, 0x7E448DE95A9CC3E5ull},
//		{0x1AFE36253CA88ECFull, 0x6EBE42080C058DF5ull, 0xCBE5BE93102BBE2ull, 0x26A02C5E541C8153ull, 0x67906F6010DB9DAAull, 0x697D2D206D68AB2ull, 0x3A966CD063F37E85ull, 0x5895F5FA38A5D054ull, 0xF3F09D84B793735ull, 0x4A10B4E843D3BCD4ull, 0x4C2A71662E534A82ull, 0x26F2D36471C1AF98ull, 0x3D00B9D915BCABA8ull, 0x4E0B9A87434BAE75ull, 0x4F38F2654C502870ull, 0x1DE8725A6A37288Aull, 0x8F8B73F0CA6B462ull, 0x763CB68015B71329ull, 0x3DA970441CDCE2DEull, 0x69D3947C2539DFA5ull, 0x2DB88089706B674Eull, 0x2C106A57684EED59ull, 0x545EE5D304A66051ull, 0x20F4BDAD639DEFACull, 0x501F97866B057295ull, 0x2771AC801C4A08ECull, 0x1958BD174E647FE4ull, 0xE0BB885565976F1ull, 0x64212B8C5C17530Cull, 0x19A52566335A1DF1ull, 0x28677B7C378D97C0ull, 0x1D91467C316032BBull, 0x44344C2213CDFCFCull, 0x471745E401DDBC66ull, 0x30AADFDA30EADA61ull, 0x27179C0B5E636063ull, 0x215641AF53280662ull, 0x46B24DBC75B52783ull, 0x57CE66B467A70B69ull, 0x5953172F27EDFE3Aull, 0x52AC7DFF00C4C3AFull, 0x443807276C053B16ull, 0x4F2943935243BFACull, 0x425EB207334A6F1Full, 0x2E5B12B85C03D76Dull, 0x66A48D1156C28E34ull, 0x13916F2D0435D38Dull, 0x822C0EF57C5BB4Full, 0x1803D0894F3A06D4ull, 0x59A377B648AEB063ull, 0x24E13500BB13C1ull, 0x271210C7217B22E4ull, 0x53E31A246DC45E83ull, 0x17304A672BB180D8ull, 0x556B69ED70836196ull, 0x539F7F122817E7ECull, 0x7148254517D78639ull, 0x141D2302407168D8ull, 0x6A1B45E5567BD50Aull, 0x73BBD7F81876589Dull, 0x327FAC775A606509ull, 0x6F38E6D146111BA5ull, 0x5E963896775BA7C1ull, 0x1DD6D6F4769A091Full},
//		{0x4695AE95777A4EAAull, 0x3F48B98246BA8FCAull, 0x7835626C665ACA49ull, 0x6835B2AE4C187C90ull, 0x541F28CD7F65FD16ull, 0x77C9FD68298A92BAull, 0x6FE95EAC4B697C7Aull, 0x51A27AA6613183F2ull, 0x634102B465BF9DA8ull, 0x21A2ECCA4D5C4899ull, 0x3C3B72B2155EC4C2ull, 0x65D2A1376EBB1F2Aull, 0x6FBF29CB550B8808ull, 0x34CC3ACF4E556261ull, 0x4C672FC952A311C3ull, 0x44EF6B8012FCDE5Eull, 0x4A1D606E04382503ull, 0x59B76E284252C2DAull, 0x6A92EF4C41ED20D7ull, 0xE6B3F6A3EB21819ull, 0x41531DED06353CD2ull, 0x683CAAD3313C7C99ull, 0x519EB94C39DF2579ull, 0x126E008B34DFBC00ull, 0x1F9EC3223410ED56ull, 0x23C049A5BDA35D4ull, 0x496FB218680EA5D1ull, 0x4A9554FE392EDBE4ull, 0x3D1A2DD97F618FCDull, 0x7843E4509815DA3ull, 0x5204A1914C73A9C6ull, 0x1C7E3C011C2201FFull, 0x50ABCEC97635AA2Aull, 0x5E74C4D93B3EBE15ull, 0x3822CB016CE00443ull, 0x79F0D62F7975E8EEull, 0x73154115622D8102ull, 0x2AB2658744B3FA61ull, 0x1C0CA67C3D206613ull, 0x7993B6623BAB699Eull, 0x713153697BCFBAFCull, 0x17859F723AA10581ull, 0x63DE60CD621AF471ull, 0x73CFE16520F88EA6ull, 0x617C843E7B541FABull, 0x2A79EC49338125CFull, 0x47C7C97146F8284Bull, 0x4FA327CE1873983Aull, 0x3D2DD2752E17ECA7ull, 0x53B2564F75509D76ull, 0x1AF7F0EA4DA32C7Eull, 0x6EC686640E0D31FFull, 0x2FD0AD811978EBEBull, 0x52C12C614BDD53FDull, 0x569951FE4C54E2C3ull, 0x788BD9B47CAA567ull, 0x48249DBF1F0E5D0Dull, 0x26BAAE92C02FE8Cull, 0x129517E763B8C4Eull, 0x4CFB8D3262A5D5BDull, 0x718FABF97775797Cull, 0x1626FB8C3957756Aull, 0x3E6DA1C765CA235Bull, 0x51CB0DA47B9B743Cull},
//		{0x13E21002257D63F4ull, 0x70EC11B22EDA00EDull, 0x732090725FB29816ull, 0x3CE732EC22F13DF3ull, 0x792B84010FA85F4Dull, 0x6ECE91F04FC4D600ull, 0x5BFD421076574F8Bull, 0x178F7B672421DFCFull, 0x1565AC9919FB2650ull, 0x5024DE5B168EFE17ull, 0x1036B29F1D206B8Eull, 0x7934D3D401C65E98ull, 0x1495E50A0F5BCF61ull, 0x3B1DD403530386D1ull, 0x7525F2BC0CE8E1A7ull, 0x4E9EFB0D090802BEull, 0x3266459B3F8B0CBFull, 0x37E203AB2586D60Eull, 0x1F3DA4D574C93698ull, 0x48781401186928D6ull, 0x47195E53746A5F2ull, 0x682DFED6606ED7F6ull, 0x2D9DF57D7FBD7A3Eull, 0x490B7C54303A216ull, 0x19B8A08E54B59621ull, 0x5992A02E29EF532Dull, 0x71D601AF52C77402ull, 0x2BB5B1C6066BE6B9ull, 0x6223436366D385C9ull, 0x596F6D8A5749361Full, 0x73BC6770280E6897ull, 0x605138DE2622AD0Cull, 0x6799755618333C89ull, 0x4BA9831A06D71A2Bull, 0xCFC73211421971Bull, 0x1F404301116E0907ull, 0x4B683D0D076E41D8ull, 0x71DCE0FD7906328Bull, 0x72BBC16766D98C2ull, 0x3C09D4A120E45CA4ull, 0x4B232EE3159C74CFull, 0x4AD3AFD23CF93092ull, 0x6863E8D276896198ull, 0x4365174B4A872C35ull, 0x5D5CE7611CD484D5ull, 0x21D0625551194ED1ull, 0x44E2ED6C02219B33ull, 0x773BFBDD2C7C62C2ull, 0x1A54D7BC42E57EF7ull, 0x33537CED27514ADEull, 0x570716135293BFEFull, 0x38BF53E5226F5320ull, 0x5A0201C72A9C34E2ull, 0x1B7585AB612DBDDDull, 0x2109CDA4577F5A4Dull, 0x2121A816C2CFC88ull, 0x6D1BCF1C4CE5CA53ull, 0x29262D1A557FB7EEull, 0x436F2BEB6C8B4466ull, 0x2006E42420CC134Cull, 0x95FC93B41D74679ull, 0x71E5621E4E42B6A8ull, 0x43F8E1AC69215DFBull, 0x7ABF196A5E4DB968ull},
//		{0x2C06DCF32E129658ull, 0x59F0446030DF306ull, 0xA656473E5E582Bull, 0x257D46265AA8580Eull, 0x68FA8D0D40F2CBD2ull, 0x3BD615EB0A045AB2ull, 0x1872261F3DE8306Cull, 0x7631573A058DF53Bull, 0xACDFAC01F578454ull, 0x5B0DAD2A4E3D26ABull, 0xBE2C8BA7B14914Eull, 0x6F0939F8154291F6ull, 0x3CEBD7C760EE9C16ull, 0x6385489E00E4B973ull, 0x4A0FFA115E446208ull, 0x5F3272DB7616D704ull, 0xC56F86064D17722ull, 0x7924CA0A0CFD4EA7ull, 0x232FCF4D1EA21031ull, 0x67A5A6B50C2A5C5Bull, 0x5F94DC03237BBCA0ull, 0x162EB70D78070222ull, 0x6163ED0D0C600E47ull, 0x7D94F75D6C31E7CDull, 0x2BB7929B58A2A487ull, 0x3A6F0E78379A5B56ull, 0x53B735D529784870ull, 0x4CDCED4C10A30D9Cull, 0xA66E486306235EAull, 0x1187C70F5476DE98ull, 0xEA697F270BA39EBull, 0x4A8DB59C1AFD9053ull, 0x558BB10D43B27FA7ull, 0x27FADEFA78BB805Aull, 0x62548FD80FA085B0ull, 0x4E5DCB541E96BDBull, 0x331C42501B1493C2ull, 0x39F06DFD14802F5Dull, 0x2774A2093785655Aull, 0xB2172A532C34A5ull, 0x102809E23B2125A3ull, 0xAC68FFB63DF3FB7ull, 0x64996E1357A37D47ull, 0x74824D546F00529Aull, 0x805B331060A1463ull, 0x4377313216AC4B23ull, 0x76C44E4E0E04E6CEull, 0x31A9DB764C4FFF5Bull, 0x51B7667559A4BA71ull, 0x450B7FB6340BF64Dull, 0x6945402149F15C6Bull, 0x75F562281C618271ull, 0x6505F02E2FE5D025ull, 0x30E1B1CF0C7A9237ull, 0x676B35803193C8F9ull, 0x5FA6C6DC77933F62ull, 0x6CB4EE9C6A6D56D7ull, 0x5B727F19514E5CB0ull, 0x4210D41E4FF4CC6Dull, 0x404EAF4A4A16874Full, 0x55FEE0D103C5E07Cull, 0x60C2D2734CC32F1Full, 0x11CAC74A126CADE9ull, 0x19132E7B63822DC0ull},
//		{0x6C11685A5E1EAE31ull, 0x178E240D5556A87Bull, 0x28100A9C0D838636ull, 0x71B82AED0D15FACAull, 0x3D69565B2299DCBCull, 0x19908D0224D48BDBull, 0x542DA5B5793753DEull, 0x1C67CB3D40E29452ull, 0x63A4AAB677DA4A57ull, 0x1230F10225B57ED4ull, 0x47CF16C4527FA04Cull, 0x6FCC06241DCDF795ull, 0x564580C8508ED897ull, 0x6A9126B568104812ull, 0x62FB868003A45530ull, 0x4B9275D24F0CEEDBull, 0x61C30361632099E0ull, 0x2463975609D30DFDull, 0x70A42016161BC243ull, 0x16E908C82E0D7671ull, 0x38B59EFF307995CAull, 0x52E2024D0CE344B5ull, 0x29B0E9A86F49CD8Aull, 0x4DC5D9070D55945Eull, 0x672417E15FF6CA09ull, 0x330B13332EF32EA6ull, 0x32766A5522D71957ull, 0x4CC1263B08BBEB1Dull, 0x7365F1EE37524CF0ull, 0x70CC332F5661786Eull, 0x3AF6A2203C5EA902ull, 0x256E67491CB9A581ull, 0x1F7F42E249D1FEA0ull, 0x268CB37F102362F8ull, 0x5FEDC0E33D75BC47ull, 0x3E30D96918A35FE3ull, 0x6DEF52111112DBB6ull, 0x2586A49817A03BB9ull, 0x5CA941734C7D9Full, 0x24F5D0186780C122ull, 0x534347A85800E34Bull, 0x1673EFC805B9B1FDull, 0x7AD7FCA263351604ull, 0xE759D1A6E3DEE90ull, 0x1A8762F47F41D049ull, 0x449F66FE557E0515ull, 0x3BA0794B6A0DCE48ull, 0x7237AA965B1FBC2Dull, 0x33DFCCE818C45E15ull, 0x6B431F2513CD8DCBull, 0x563A1A5C2973F88Full, 0x2C70EDAE44296C6Dull, 0x3A86D44551F79246ull, 0x5BC9A8273AE37D86ull, 0x45440FE500BF783Full, 0x22643EA91887578Dull, 0x58C05B8A38D82E71ull, 0x1E41098A5398582Cull, 0x1C0D44752CB6A6A4ull, 0x41D646BC3694A76Aull, 0x2BF876EE0675ADBAull, 0xC12AC7F6798F039ull, 0x70837C027E4A5715ull, 0x42B8AC67246348EAull},
//		{0x170EB52B2DFBCB8Cull, 0x3830D6B66D48CF87ull, 0x576FC41B64A1C464ull, 0x31723BF511F69861ull, 0x369956AB0D3BE41Cull, 0x4CDA15E77BDD6690ull, 0xDFB5C5B6F3E5490ull, 0x1464BE1E66BBB7E5ull, 0x2816830232A5C7A8ull, 0x3A5410114423C777ull, 0x5F5C6E4D7C2A56CDull, 0x7AB86EE10B54E53Bull, 0x2A0048706CB1B60ull, 0x72EDD5747323808Aull, 0x515727635A681DBull, 0x1786C9741C2427A1ull, 0x63A24D684FB7A02Aull, 0x96CF7283B121183ull, 0x3459648F3ADF331Dull, 0x4D08A9E46AF2BB3Aull, 0x481B173919E2BFCCull, 0x66D021CA56167394ull, 0x921145C7B34DFE8ull, 0x3CD22B793137975Eull, 0x2DDAA79177263B8Aull, 0x755B5ED60D3715DEull, 0x735092577013CDB7ull, 0x188BFB1975F096DFull, 0x76DEE9180B79D08Dull, 0x691417697BF45B8Eull, 0x41205269009AE0DDull, 0x1818832F24C29FD1ull, 0x5052810821857A57ull, 0x5FD4B15404ABE597ull, 0x5C64AD752CDD5B39ull, 0x6F9EA0D1247FC4AEull, 0x46C01B05566EC29Bull, 0x7A9638434FE12F61ull, 0x51A3A284376863BCull, 0x118C6C07F7E4A15ull, 0x2E8E9F4776742596ull, 0xCB55FF321DF319Eull, 0x6687F34D25415B0Cull, 0x17CFC87D5D66DC65ull, 0x30BB2B9900E3DFE6ull, 0x595B37F371DB7E02ull, 0x17EC0C47173BB22ull, 0x169E1DD351D141CCull, 0x12F9357A7672CF28ull, 0x567D27636F5DE2EFull, 0x23502A61461BC834ull, 0x13DDA79D6A104566ull, 0x1C8A8ACF0E73DFE0ull, 0x39F174C76E2E2D53ull, 0x45DC439D3B0A3B87ull, 0x6DAC7768746AE2E4ull, 0x317E611D7A61D75Bull, 0x164A14821806546Bull, 0x1FA332672E19DD00ull, 0x756D30D0505E5E01ull, 0x2EFDBCE64EC868C4ull, 0x4239DC03307C7DAAull, 0x403C23E658D7F9D7ull, 0x24DBF7653355960ull},
//		{0x4F4AC8FF58CAE6D9ull, 0x42933C4F729AF360ull, 0x1EE6AF0D5670E3EDull, 0x5CAB38C63B7139DDull, 0x64E4C3CD169CAD8Dull, 0x299F67302AC1076Aull, 0x51A6E915174BDE99ull, 0x1F2BEA4E03254A32ull, 0x11ADB5F43575FED1ull, 0x1B2B9E9D3150E85Cull, 0x638FDBD11098CF6Eull, 0x1AF465D128D98B7ull, 0x5F61383243E92260ull, 0x430A16621F9D5C18ull, 0x1CC11C374557D5D8ull, 0x72D2B5796C0BE536ull, 0x1E22BCB23565F1C8ull, 0x5EA6D8963D096BBFull, 0xBD6D5B53B52115Cull, 0x787AA59C70BB9983ull, 0x51EEBEEA221A0CCDull, 0x1B7CA0ED2395A7FFull, 0x3965EB663AA88B3Cull, 0x26BAF2314B13A15Aull, 0x701E8A0D41E690CFull, 0x7C6489B653AE65DEull, 0x527F603D7E13D013ull, 0x663BFE9531E0986Full, 0x41FCF274294614F7ull, 0x517DF4875EBE0EABull, 0x6E9DEAD04450AA00ull, 0x4AC9F3E20CC0A782ull, 0x79B69BC92970CC78ull, 0x49CA1341058D717Eull, 0x64C2DDD54244B8DEull, 0x76490B0136B19CBFull, 0x645EC5AB11C5ABEFull, 0x5A4744BE1DC4B111ull, 0x4C6E372B010236EFull, 0x68D8526B3C8CC138ull, 0x42E8C7BE653CDC22ull, 0x103B2716156827FBull, 0x6350AC35767725ABull, 0x4748C06A254D9EA9ull, 0x1FBD3AA318C6B4F2ull, 0x40BAD550E5B2573ull, 0x5D175EF24ED5A137ull, 0x1B1BCCF556CDFABBull, 0x78466DAF64E5E036ull, 0x5C5B6C3A5D094B84ull, 0x272A991452A4773Bull, 0x13BAE8430B895EBFull, 0x646A232A6E022D01ull, 0x294E0FD030D85A55ull, 0x6F0463F11226623Cull, 0x6D651B8D31ED2BAFull, 0x77633E5E7DA042A3ull, 0x475553AB5AB3EA93ull, 0x7417684F0E9E1415ull, 0x1893D13D4A2F2ull, 0x2764C907040D3692ull, 0x222FC865047C27FAull, 0x52E2D7C93D4B955Aull, 0x5B4A22B54B294578ull},
//		{0x2231759037A58EEFull, 0x283290FD495C0EA5ull, 0xA4A062B3BED7940ull, 0x54E56D646EB42955ull, 0x29EFA6427E337D35ull, 0x1F8C83AB18F40A33ull, 0x1059DF710CF19F38ull, 0x4AE135E207BD1DCFull, 0xA91E1DC1236898Dull, 0x627108627EA94A2Bull, 0x20D49DA36272919Full, 0x127DED1D483966AAull, 0x667FC83134ADB582ull, 0x4CB58EA439629FFAull, 0x71F94ADC27FFB15Aull, 0x48BE573142AC06Cull, 0x5FA540492CBE7670ull, 0x5D86CF1169EF4674ull, 0x68ABEFB0326C3C76ull, 0x58A36FCA129B95F2ull, 0x309FB9AB782FF375ull, 0x2B8FA02540F9991Cull, 0x52192AD7670D608ull, 0x48B6B6EB0FB37489ull, 0x8A75F952B27BF4Dull, 0xE5CBEB4297BFD38ull, 0xD9A50ED20DAABD1ull, 0x71B563E3741A191Eull, 0x558861533E6AF287ull, 0x2D7CB9194781AC2Full, 0x666AA3E132089E8Cull, 0x5BAC6C9C460FE42Bull, 0x5EC714FC39333BADull, 0x2FFF2A9F477304ACull, 0x6B9F782308A29A69ull, 0x5A0E9A9F1C3F31CEull, 0xD28DDE059E3AC4ull, 0x5D38CAEA05F4208Cull, 0x7C0F10CC25EF81D5ull, 0x15A7951504B67062ull, 0x51174123240453CAull, 0x2E326D9A5EB19210ull, 0x44DEFF9B1FE7D17Dull, 0x52CBAB2E1A6760EFull, 0x5E52C40500486447ull, 0x61E90D1E44BD67E6ull, 0x325102D33D9579BAull, 0xACD4C11111817CFull, 0x76C8B5683ACC76B1ull, 0x588B1C7C62682D8Bull, 0x436F111A3299B71Bull, 0x7EA75F5A44419EF9ull, 0x3837F1DF5BE02A44ull, 0x4A35BF85344702ACull, 0x1CFAC1A5FDD549Aull, 0x38FD730E52E6ED3Dull, 0x3E1A864672FE0A8ull, 0x31987F4D48C0A800ull, 0x717B22604642A7Bull, 0x632808EF656A762Bull, 0x4AC8EC34511160Dull, 0x2A27DE1136FD9196ull, 0x2A68FC834F52A23ull, 0x4815A966796F4530ull},
//	},
//	{
//		{0x6FC1A0D420A0C5E2ull, 0x5BD772BB3330B1EEull, 0x533A7CFD5A7ED215ull, 0x777250E70B726EDCull, 0x365EFC5A41A8106Cull, 0x3FB97188382EA874ull, 0x2185650778B6E496ull, 0xB1595B125670D6Bull, 0x5FE6C53F3CAE14FEull, 0x6E27B56B66FE7765ull, 0x41123F79514FBE5Aull, 0x4C68ED9045BECE3Cull, 0x1660D4687690CBA1ull, 0x7CBC5FD319076430ull, 0x2B85F5C444D20939ull, 0x1276A9601B479698ull, 0x6572CF1B6E4E1C1Bull, 0x4E78488738AD4C18ull, 0x48CCEE3145EA996Eull, 0x441FBAF47F2BEA8Bull, 0x792A9DB03D92C7Dull, 0x375A92FF29180EE2ull, 0x7C901113427028B0ull, 0x4E7F1C4D5C76D652ull, 0x7F1E3DAE3CA6D1B9ull, 0x43754DB740307D27ull, 0xDF690130FDE3B47ull, 0x5EF4B642457647Bull, 0x66F06E902ABAB37ull, 0x3D5EC8AB31F4FCADull, 0x477DB4704FD5720Bull, 0x4D3C93462CF0838Bull, 0x3E238E271BB4DBCDull, 0x659DCFA306F07C58ull, 0x619F753B29BD8A97ull, 0x61C66E369321F16ull, 0x2D96B7143D76F9E2ull, 0x124A2DF82A26C828ull, 0x7FE7229260C94A46ull, 0x69D9E7A7F056040ull, 0x1D701BFF4A12EC32ull, 0x3F35DD672B66AC12ull, 0x59F12779452528CBull, 0x4FBE108E60602E62ull, 0x47D0D4020D1CD939ull, 0x12552B100F4E8872ull, 0x5CF24B455F91BE56ull, 0x3C3F0BFD1B15D96Cull, 0x7B469A2321DCDBA0ull, 0x220655C45CE60F5Eull, 0x4B9A66382822BCA7ull, 0x46182E7579311D4Cull, 0x6599B68958625C6Dull, 0x2357E5746580D91Bull, 0x392BA6B329F583EFull, 0x6486395B569BC2B2ull, 0x7408702123BC16C2ull, 0x2026EC54DF9979Aull, 0x68E13F8E51C07F53ull, 0x2E59C5FD30B21390ull, 0x5EDD588C40AEF10Dull, 0x40009C033BCFA3D1ull, 0x2040AF637C3FA800ull, 0x56E57D3D1B874986ull},
//		{0x1E1C83A178EBD301ull, 0x786D58E469B6E9D9ull, 0x210E8FA83E858759ull, 0x62E8072506A84631ull, 0x16E7E3C7063FEC9Aull, 0x6C291F4C50138A7Aull, 0x3035708950AF58A7ull, 0x26AF4D2D243DE0AAull, 0x746B6F6A28B1BBF2ull, 0x723778445D4CAEF8ull, 0x7A723B4520913E41ull, 0xDFEC288594F93D1ull, 0x61402F4E4DFF5E8Bull, 0x151F37A30180DEB1ull, 0x4A3F068C6C04B4E0ull, 0x1D082837685B8A2Dull, 0x64F087E21575811Cull, 0x5212740605FF178Aull, 0x53FB087534FA7B2Bull, 0xCA75DBC6AE2EC3Cull, 0x3B3A67C578D07D08ull, 0x3AF676B76B6FD84Eull, 0x497FD5B061A5C3E4ull, 0xFADB8F83DEB451Aull, 0xA577FD601E5313Dull, 0x1B37F41204C9BB1Bull, 0x22766F7E2936B69Aull, 0x5E194EEC03B69ECDull, 0x773615267338868Full, 0x5377D7E41751BB2ull, 0x5F3D3B70223FA5B6ull, 0x29D0A5DF442DC352ull, 0x37B526D27BE319E5ull, 0x4A2CDADC0BB02F47ull, 0x30DD951056D43898ull, 0x76931B846C17FCD6ull, 0x4FA4B5A13189923Bull, 0x5787D52419248B51ull, 0x132F561F67358E1Dull, 0x570FD06B1D86D5F5ull, 0x691ABF5A7247C47Dull, 0x225091100B912ED8ull, 0x1B7E7B170069DFFCull, 0xF47CDA512B4903Dull, 0x73A2668C147F4B24ull, 0x5429ABEF52DFA1FCull, 0x36BEF0DA7DFA51CEull, 0x170D654E6E7417ACull, 0x79DD6BB3613A402Aull, 0x7A2446F32ABB00C4ull, 0x380E78C370B76277ull, 0x16D2FD9A07B32E64ull, 0x2240F4B26E5AD2BEull, 0x20D7B9B535704AD1ull, 0x559060DB77E78A20ull, 0x52F720C63EAB2035ull, 0x6A2F4E9D7547B1D6ull, 0x4A3C4F0E05ADC9B4ull, 0x75B191D359841CB3ull, 0x186259F26953F85Full, 0x6E0367D76C8C05E1ull, 0x3C339A5B24C258B1ull, 0x6A8657B05340FFA9ull, 0x1336705D6463C363ull},
//		{0x347B3FD30D5AB751ull, 0xF1EC4276C89B896ull, 0x7E1219C825F1C1C1ull, 0x743CE6FA20530E7Bull, 0x144C94801514A0AFull, 0x55C3594C69DCF55Bull, 0xCFC2ACF28BA7A13ull, 0x28881591772B796Cull, 0x1E022BE972C4649Full, 0x7CD9432113B3BDBCull, 0x4C488152153B9D13ull, 0x7D07B61B3A4BE92Aull, 0x1C7A2F4393B5076ull, 0x5F0E41DB6C4DFAA4ull, 0xC7C501F7244B239ull, 0x50B1BE0840F78FF3ull, 0x7F9F698A5FD0822Full, 0x2D8148897DB18352ull, 0x5C243F121BE2F84ull, 0x1E0491CD1A0ED871ull, 0x36D2D03373C7EB1Aull, 0x3EBCDCC43CEFB03ull, 0x1C82652D2C73E35Dull, 0x3AFA746F3A849116ull, 0x1F3847FC37D3B790ull, 0x4E384ED36B80C94Full, 0x4D0F54A34B4004EEull, 0x25CCB2794ED6F798ull, 0x47B556504DAF454ull, 0x3B24F23C10F7A584ull, 0x771FA68D0BD6B044ull, 0x51EF357776BF1017ull, 0x6BA732747F707E01ull, 0x7470936A71697665ull, 0x212EAD8512752537ull, 0xB784ED658017DB8ull, 0x63D10510F641CA2ull, 0x1BD078BB22BF757Eull, 0x3BD8000056CAED2Bull, 0x5D4406955B1047FCull, 0xE9EA4BB2B7C5568ull, 0x4691114B5BADF95Full, 0x76BC5A566C5DC3C4ull, 0x2A84F0F77B37AFBBull, 0x7138B81965A9E333ull, 0xC2F554068585EA6ull, 0x718093785E1E8AB7ull, 0x5F176EBE5D27C5ECull, 0x5D8F08B853880228ull, 0x4E913C517EBDB63Dull, 0x65FD275F5A098B27ull, 0x56BF33F66C3A37B1ull, 0x696DA7C9728FACB1ull, 0xEF9AD2F2545A7C9ull, 0x495A99DC6C3DB3C4ull, 0x55EFC657F93E98ull, 0x17BA092C46E70111ull, 0x33A737F70E766383ull, 0x3344C4D65E2C28EEull, 0x9AE133E247D7CEFull, 0x43D60C2115DD687Eull, 0xCD5DB9535569F99ull, 0x73FBF3366BED4A53ull, 0x127E6585518AFBEEull},
//		{0x3F754C7B610FA1D6ull, 0x5048B22C257273DBull, 0x3B192CFD2707E622ull, 0x11ACAB8C2486D4C7ull, 0x199792D320A658BBull, 0x49CC7C9062F22CB0ull, 0xCE40C804A226C56ull, 0x3AEB6B48249E15ACull, 0x11096D686E92A33Full, 0x3314792F444E323Eull, 0x4CBECC2D3CC28C6Eull, 0x68CBAF2D1094D84Eull, 0x529FF4EC75A18AC2ull, 0x45EB77E8469BE822ull, 0x618ED5165869DD6Dull, 0x1826E41121042191ull, 0x39797F44686F963Dull, 0x4676956C7492AC41ull, 0xF777C5F582340F8ull, 0x19198108290F0F32ull, 0x78C999B462E5FD99ull, 0xC013BE205ADA634ull, 0x2D0869EF46ECA72Aull, 0x2A4BBBE03E11D757ull, 0x357F4A695D603510ull, 0x2600995023E1696ull, 0x1A22C17E6B2BB8C2ull, 0x12D2EEE56CC2B66Aull, 0x60CD438558BE66CDull, 0x335E9E8D425C189Bull, 0x3128443A4B85829Eull, 0x63603A2C6AA1C37Eull, 0x33F518DB29D6CF99ull, 0x5F346FC0436C953Aull, 0x1FA1091784DF0C8ull, 0x6C7BA46C7AC3AA45ull, 0x5B33EE61787CE04Full, 0x715079083C5851ull, 0x3F6987792ABD0C5Aull, 0x464E2FA874E8D1E3ull, 0x81D416A48AE393Eull, 0x7726E879224002E8ull, 0x33D9F20009F9D75Eull, 0xF02B95214A73585ull, 0x62B83E2B426157DFull, 0x57034E2013E08266ull, 0xDE6DA7D3A63884Dull, 0x7E8245E441DBF358ull, 0x643A57E65DB6B5A4ull, 0x548889266346877ull, 0x5604A66D71C42CFFull, 0x60F812BD313894CEull, 0x6A410D4E61696336ull, 0x3974ED1F29AA94C7ull, 0xC266F907FC31CC8ull, 0x1E9366AA1443B0FAull, 0x4871560615BA4F24ull, 0x3683B3E27C4B4806ull, 0x1FB4268245866D35ull, 0x10F27D8C026C64AEull, 0x7E7C51467F5CBACull, 0x164CE71415CE9F92ull, 0x225953F914CF2CF8ull, 0x57AA92EA0693ABDFull},
//		{0x7285E29D5CF31B7Dull, 0x6CC81457488A890Aull, 0x4EB7487C4DC02714ull, 0x79C31DD838F855CAull, 0x2F298A4A33380AF8ull, 0x62A2EA913B4FF9DBull, 0x32FB27C00136513Cull, 0x4F93AAD57B6C7DC6ull, 0x16F0A06006175EB8ull, 0x77B7C5CC36A4C6E2ull, 0x4B9DCBED08AA4358ull, 0x39112B9053859101ull, 0x70A00F054F5E12A4ull, 0x6954309312F962FEull, 0x642D3F9D40FEC37Eull, 0x198D0EDE56B3223Aull, 0x1DF1DEFB06552335ull, 0x1F3DAB446CA92777ull, 0x54154A491900C91Cull, 0x25A17D41033ED493ull, 0x4C38D414084467D2ull, 0x3E8ECE6E7F33FBD4ull, 0x97AB90E0E227944ull, 0x7AA0799A206B596Eull, 0x1439D7FC72583F67ull, 0x571020515FD7A3E9ull, 0x7B0282BF10214BE1ull, 0x335D34EA6BA291C4ull, 0x5F7F5E861CB1657Eull, 0x7E9BF4C343AC9E23ull, 0x5DB028FC182903A1ull, 0x1A5FC05D7BA207F7ull, 0x1E7E26D6399D6BA1ull, 0x684B2F6E7293711Full, 0x529E34BD0DECACAFull, 0x75D245B21ED708D2ull, 0x1631148134611421ull, 0x1E0B04A61FABCD90ull, 0x42838D6518AB7E41ull, 0x401726FE56BD6561ull, 0xB03BDA81727474Full, 0x3695094A06064067ull, 0x2748933169F23E34ull, 0x71A8D22C06C7F1B7ull, 0x6A3A3B27044C6EFull, 0x4A748FDA6453CCAEull, 0x86DCA9064D45037ull, 0x5FF5D4A526EBF166ull, 0x1E71BBD848410413ull, 0x197F6285710FF095ull, 0x562DB0C20F51A837ull, 0xFE6F9676C5EC544ull, 0x43B2BC582DF1FE0Eull, 0xC0A92D4063649BDull, 0x469D7C4F4C21B9D2ull, 0x5CF3AF1E51A139F7ull, 0x634901221388B868ull, 0x57A77A5E0A919453ull, 0x7D7AF69D49504C8Aull, 0x1159860A041E9A4Full, 0x399513795BCE15E4ull, 0x687266FE4202DE09ull, 0x40A2661B48683BA3ull, 0x68EECF6F5F1421F3ull},
//		{0x10A93FB7026E31F4ull, 0x5024128866D6F079ull, 0x11BFDA2C600B0BF0ull, 0x5335B5BD55729684ull, 0xDFD09FE5F404891ull, 0x5BA8E042549A864Dull, 0x2B620264389C8F60ull, 0x263BC0440EAB0386ull, 0x4C2547C97DE33AA2ull, 0x193C97D949A03E66ull, 0x4733872D2A961DE3ull, 0x4DBED8B500C89AA6ull, 0x66433C736313FB3ull, 0x42CB78B0470699E2ull, 0x7E997B572BBA481Full, 0x261ABBD50F42BB0Eull, 0x2E287A14763ECE5Dull, 0x7619AB873FE85440ull, 0x5649DA4D494F6145ull, 0x155AEAC46446E44Bull, 0x288FA9D67103CB06ull, 0x38E16A9853F1AC3Aull, 0x29A05A675F1D2ADCull, 0x629CAFC075C5A230ull, 0x5D00657F7BD94799ull, 0x3F65E0962433ECACull, 0x266F657C0D24B94Bull, 0x24FC87522CD39943ull, 0x4355F8FF67C80002ull, 0x73DA332541EF7456ull, 0x1382482219F4EEFAull, 0x51322F6441AAC236ull, 0x1033BD58474BDAEBull, 0x1931676667D97A5ull, 0x109B3C3016EE013Aull, 0x4AC47BF1392AE607ull, 0x7F1CC4103A5E689ull, 0xD1C9241319226A8ull, 0x62C311666FB94202ull, 0x2757C8D83FC376E5ull, 0x6B92899B66BDA96Eull, 0x63F763911201EF18ull, 0x73E262B908F3EAE3ull, 0x3ED5885B37385BB8ull, 0x70BBEAE632AFBB81ull, 0x7927D00E043E3308ull, 0x4CA4AA7B4A59FF72ull, 0x45E8F53E5CD867D3ull, 0x11A5DA5E477C0BB4ull, 0x4355FF792241168Eull, 0x5E6A0CEE0E1A7B6Aull, 0x5B6BFC95665BD92Full, 0x11C061F368888ED7ull, 0x17EDFFD774837359ull, 0x5841D0D93F45C8AFull, 0x3446EA3E43D45A74ull, 0x2603721D183E4DCFull, 0x55D6498C19E5D4D7ull, 0x213238B314ABD1E8ull, 0x511E308F11EE2399ull, 0x475B8D694A46009Eull, 0x162C56A1140037E4ull, 0x14A000105C154BDFull, 0x70D89FB82645DA6Eull},
//		{0x23915793342E9F31ull, 0x4886F0FD01FB6481ull, 0x42491A9B23F2ED92ull, 0x68573DB154097C8Eull, 0xC7B7C6900453D88ull, 0x488CEFE864BD4D42ull, 0x3F8B06387CD3DA26ull, 0x2891A7B7658E7855ull, 0x151227F67E67F143ull, 0x7F744D2C364460A9ull, 0x1313C32B50927DBCull, 0x483284425A6F5094ull, 0x1AD87E5A5E5EDAE3ull, 0x6E6F88792F787E6Aull, 0x3A7426C25F482831ull, 0x55BE58D95E057E55ull, 0x1376C7621E4549D6ull, 0x6000E2D655BFE1FDull, 0x4238376848582087ull, 0x29C95E8B4EB3B3D2ull, 0x489D5E1072564E73ull, 0x3371011408286448ull, 0x6F2A289A5C02A8CBull, 0x6DB6DC9D043C5090ull, 0x5A6A9A0F6D2B29CAull, 0x3A80B1396D7E5D3Aull, 0x3DBDA78602B3357Bull, 0x47EDADCF589625E0ull, 0x6112105E365D3648ull, 0x80EA44A1B863720ull, 0x15A55E795DCCFD23ull, 0x798BB575291C25DBull, 0x7C1246F9598C984Bull, 0x7EDC07D83E4A7E62ull, 0x21E4B8D328A56663ull, 0xCFE32346A8216E3ull, 0x1AFBB4D7406F3348ull, 0x72AA7B2B0A25DD71ull, 0x1C71DC14606157C8ull, 0xE622E0176DC7623ull, 0x4D8C819248E2DF3Aull, 0x645AD35D0B4A2918ull, 0x4B9614B52C48812Cull, 0x63E04EF82CA82513ull, 0x62A5B7746BEEF343ull, 0x482E5C33784B15EDull, 0x49BBF06641BA11A8ull, 0x21673BC845CE3760ull, 0x1B46A9F3204343A0ull, 0x418B5C23D2B62C6ull, 0x48E8AA041116E7F6ull, 0x27AD79A963E45EDBull, 0x51861B3E1A57F4D4ull, 0x6E0A3C4C6DF7F752ull, 0x7AB94C9D7C6C6A4Dull, 0x64D46D754845CE2Full, 0x454F4987492F40D3ull, 0x538FF74810E55E3Cull, 0x7577C1FF37704640ull, 0x3D8D834F581D7974ull, 0x235F398305BBDF82ull, 0x50688F616D1B29EAull, 0x4775F12A71CFCB2Aull, 0x32E9614A62BC9B1Dull},
//		{0x12130ECA3702170Cull, 0x1FE7FDE45AFBB8CEull, 0x4818FF024795778Dull, 0x3EE017A9199F1A40ull, 0x61ED6C622CEA53F5ull, 0x79711935CA6B8FFull, 0x2956BE426C6B7F08ull, 0x24EC872E6EA607C9ull, 0x359ABFDB787C7E76ull, 0x7F8B66052B1281DBull, 0x2FECC4B73D18E954ull, 0x32FFB4F534BFE3Aull, 0x42D4C8D653988AB0ull, 0x406728240A4ABA00ull, 0x456855DA7350896Eull, 0x6D07551E577B64A5ull, 0x2A52A07A0CEF5302ull, 0x32771D73726B9F7Cull, 0x5484CA8F7157351Dull, 0xC0AB9BD367236F1ull, 0x1E41891213A1CB50ull, 0x1318EFF047984755ull, 0xD4A583805771Full, 0x363E4F1E35A80A34ull, 0x3081F59535C9B524ull, 0x60BA8C0F606EBA4Cull, 0x72E29E7863EA875Eull, 0x33BAB88735B7674Full, 0x3783120E7421E0ABull, 0x4002214F7CEB67E9ull, 0x67726A1A2D09766Dull, 0x5466CC8E11C50A94ull, 0x39F8C96F06DDEA01ull, 0x430AA110E7D93FFull, 0x78351F1E103B63CEull, 0x44EFCAF01676A831ull, 0x23DD2F1E5808BAE1ull, 0x5E0EEF8623EA7976ull, 0x100E3200144D3EA4ull, 0x599283AA40902795ull, 0x4A16F3C83A4D0FB9ull, 0x20FEE1E23CF99241ull, 0x1E37971754B99A69ull, 0x72B0F99055BAA926ull, 0x48DB7B1432B31ADFull, 0x52A6110F304DE52Eull, 0x5FBC914D270CDD9Dull, 0x4212EFC319B55ABCull, 0x2DEAC79E464399D4ull, 0x2832EEBB261FE6BDull, 0x567EFDA26D22B9ACull, 0x3C968EEE7A5C2CC0ull, 0x452B748D1AA57E74ull, 0x1E46A6365539A68Dull, 0x2EF2BD1877D929E1ull, 0x15C9CE227909B0E1ull, 0x3226399A36C8B004ull, 0x36034322505DD0B2ull, 0xB824A6D28B43CB2ull, 0x261879D8545DC582ull, 0x5B67579178BE8AE7ull, 0x4ABAAB03B23E8DEull, 0x1FCB688446BE9A73ull, 0x54D9439B4DB63022ull},
//		{0xD0234477D0C3256ull, 0x73D616DF638131E9ull, 0x6A2EEC02306CA5CDull, 0x5DDD5EA92F5A608Full, 0x4B1224417C2404E0ull, 0x494071C7A04E15Aull, 0x73FD2EC11A5DD53Full, 0x730E923B2623685Bull, 0x512685432911D55Dull, 0x7681390D5CA8CFB1ull, 0x51C6120F1C99B2E5ull, 0x310695332D2D69A0ull, 0x15583DCC35B23FE3ull, 0x6851527F3523A650ull, 0x7C70DA573D2A961Aull, 0x2D9D67309730E9Eull, 0x3A36C87076AFED52ull, 0x6CF440882465B473ull, 0x271C93204AD19F31ull, 0x53C01502722EB761ull, 0x46F5A41158541C1Full, 0x6C3398BB3AF2D2D2ull, 0x72B1F15E5F422AF6ull, 0x61163B2E43D876A1ull, 0x85400535797743Bull, 0x208146525A1A1262ull, 0x743127215187DB85ull, 0x7477C03098964EDull, 0x73A1B696F98CE82ull, 0x3EAD0B3E03AAF5C0ull, 0x2CC3649C4186E1B1ull, 0xD1E045E66FA2D0Cull, 0x3836CF037A1244E6ull, 0xB5FE17F5F536223ull, 0x44E3E4185F1FF682ull, 0x518219850BD98829ull, 0x377412A13DB5B240ull, 0x46CC5AFC2A2603FFull, 0x1CF7DD3727E2962Aull, 0x6DFE7AA0254BDD8Aull, 0x7F7A0A650E7FC0F3ull, 0x7F65EFED73AB3186ull, 0x60079C7806AD6BF0ull, 0x7D3496746741B7E1ull, 0x76463A723BE1A1B2ull, 0x6AECADA123099F0Eull, 0x7D688363780AB200ull, 0xA03CC1A359F5266ull, 0x721CF6E61563AD9Aull, 0x14F2B48A3700DAFEull, 0x7483A41C6674CE0Full, 0x42DA63282BF7B6BDull, 0x242A804F09A6BE24ull, 0x561DBABC41225D86ull, 0x3189544E441C355Cull, 0x666E3B1131035EB3ull, 0x529BF64F65D42AFEull, 0x24AE903A32A392C8ull, 0x6C8196EE21E326AEull, 0x19E54AA962C7D160ull, 0x5DC4C86004D1F84Bull, 0x5D1706E5B2D4BC3ull, 0x7CDCAA4B0FD53C88ull, 0x10CC9E296EF9A131ull},
//		{0x2538EA2225BF52B3ull, 0x25FA7C3019BC8E3Eull, 0xC3420C268D4DF58ull, 0x45B444FB305EA112ull, 0x727B9D7C1BD1FFB7ull, 0x7180FE982404F1CAull, 0x5FEE351457EF39A9ull, 0x5508507D328A2B63ull, 0x3DC364A779B6E0B7ull, 0x652DBE2B2A44FB95ull, 0x1B9A07657F1308D5ull, 0xD0CCCF5795ECFC5ull, 0x3E5012012DE3D63ull, 0x548C1B8800C1AB6Bull, 0x22B379EC6558B9B2ull, 0x6FBB4C9C47EC640Eull, 0xB180C6515B5C8CCull, 0x61A8F24D174C2D28ull, 0x7E8AA824275D3748ull, 0x47AACE3A710645A0ull, 0x432F3700392BCCD2ull, 0x150B376A231D6C14ull, 0x111B067C6A1387E8ull, 0x55A797774EDE6B23ull, 0x63CA689F3AD555A3ull, 0x792366B97F647005ull, 0x39E85E78063033AEull, 0x78C33FCA3DCD5F98ull, 0x190E71124D4F5B53ull, 0x3E8F0B033BC1EAFEull, 0x32A815052E4A579Full, 0x3AE4F0C3DC0216Aull, 0x4400206C65574159ull, 0x550C4E92428AC890ull, 0xCB478A21CB71CCCull, 0x33910E314FE3AFA2ull, 0x55E2E99F489C459Bull, 0x73011BB666FDF01Bull, 0x32AFCD8348A8B32Dull, 0x35DC5B3E167A3623ull, 0x37E08D02EFFC1F7ull, 0x15DEA6283D666748ull, 0x352FF5A60EA1E5F2ull, 0x7B33C6E04E3E66B8ull, 0x5BF1414539C2D1E3ull, 0xA0051B60E99564Aull, 0x680D29830DAEA0C2ull, 0x4C5977B52C0D49EFull, 0x7305E21C2165C647ull, 0x6E98127F7FBA5ABEull, 0x3E1CE314222920B0ull, 0x4F9E0A6013FFCCB3ull, 0x6AC5664C429F2616ull, 0x7AFDBCCE1D7533CFull, 0xB47D94330DA180Cull, 0x33EF69F20EC5E214ull, 0x5FD9DA0449CE101Aull, 0x4C2C495C1509CFAAull, 0x586FF60D4760103Dull, 0x6348366234613752ull, 0x122E2206D488818ull, 0x42FA8D9D69300BA3ull, 0x7AF728DA0F540552ull, 0x153D55926DFD0AF6ull},
//		{0x30B9CB9903D56812ull, 0x6DB765B46ED6AEADull, 0x25FE88C23D557014ull, 0x2D67B6010C3EF0Eull, 0x7FF4962A7DD4382Eull, 0x2E3922DE0B3C6F6Eull, 0x2EAE503B62288CD0ull, 0x1A0251820E882A3Full, 0x2BF69CEB662E9ADEull, 0x2391F9E9046692F8ull, 0x2D8EAB1B06DA304Bull, 0x38C7CA4A2EB18D3Cull, 0x7422B8637BC257E7ull, 0x17E198DF6F19E13Dull, 0xB165D392D1EEE72ull, 0x5D16EC343BD028D3ull, 0x30F456844ACE51E8ull, 0x2AA6D78056F2DF46ull, 0x823C1FD2D7D52E1ull, 0x67B6CE5508185827ull, 0x2B518B0F15EFF133ull, 0x1354C79559FFDB4Aull, 0x78187E032D571917ull, 0x68880589240F1AEEull, 0x1385B3F60C19FF72ull, 0x2875ADE641145F11ull, 0x12F42FBD613D7831ull, 0x6FC5EC4D0716E820ull, 0x5CFFD01807A7852Dull, 0x7630C95E68162D52ull, 0x34C6739F5347B592ull, 0x23E6562565BACA23ull, 0x1E16077A4E8D2DA5ull, 0x3CADA9692639C977ull, 0x7C0A8086246477BEull, 0x2E52219F275C0B96ull, 0x3A5468F141A6E934ull, 0x15BE6E0326CE6F5ull, 0x6EFE024C69E3EC6Aull, 0x567C01E30283B642ull, 0x75FDEBDC7EF1AFCAull, 0x4398155308F21B9Aull, 0x602F27FB335E01A1ull, 0x100903BA3D2EF813ull, 0x3B0586CE0639CD18ull, 0x254525656FCBFA6Dull, 0x598182AA492B7B8Aull, 0x5586C49077978A25ull, 0x17B8A93012346DF9ull, 0x1DD1539C13C329B6ull, 0x3698E5B84C23753Bull, 0x3B1F354C70ED4EA9ull, 0xDCA5E703C7B1C2Dull, 0x235A359E7CC860BCull, 0x265F089779D63782ull, 0x7F4C16FE1C5CF473ull, 0x78C7E74C42E42C51ull, 0x254F100D58F70F47ull, 0x76422DF2355813C8ull, 0x1626075A3147B4C0ull, 0x3B91E0E03B6B2CC0ull, 0x2113AF2D1513638Bull, 0x496A84A769A73BDull, 0xCAAEDB01C4F517Aull},
//	},
//	{
//		{0x8CEE1B72A7C414Cull, 0x30127B313F67C76Full, 0x769FB6886B31B07Dull, 0x30551618046A14F8ull, 0x27ACCCAA53AF4BB7ull, 0x13275B44E0BD541ull, 0x4D858339007E8CB2ull, 0x6A68C9B5464D6A85ull, 0x4362B9030FB7D9C2ull, 0x1F4479CC39A4E6F6ull, 0x450FED8A356A8126ull, 0x6AEC9BB600A1CE6Bull, 0x70D5ADE60C004AE4ull, 0x15B531F6756C5631ull, 0x29ABEA122601FA6ull, 0x11BBA7AB0B69A058ull, 0x4CDC60F241CE22DCull, 0x4AD167C7437C177Aull, 0x2CFFD35A7B267DE0ull, 0x47E62C7254ACA004ull, 0x4ED5C9974918A226ull, 0x22B875461C5B4CD0ull, 0x49972ED80D213EFBull, 0x62A8B7550CF9E7DCull, 0x1CD918BD01ED3121ull, 0x469ECED261E90648ull, 0x3757B247318B6A88ull, 0x628AD4B3282D602Eull, 0x3D8BB56C784006A9ull, 0x1D99B65F4026740Eull, 0x1AA0264F2F555E0Aull, 0x4B901466677C8741ull, 0x712380E716617C2Eull, 0x2AF89EBC1E235441ull, 0x1187FA0E72DECB2Eull, 0x72CFF445605DC3A5ull, 0x3BF76D551588698Bull, 0x7CB91075058E9C2Dull, 0x22A9A8865F61C7CAull, 0x128884093F82C144ull, 0x614EF8EB592752DBull, 0x216BC78C18A6AB32ull, 0xAB2BD6403F69C3Full, 0x40D40B60483E72D0ull, 0x7C36A2E85E6DC1BFull, 0x864E6DE16D6C937ull, 0xDC31FCA53F4FB45ull, 0x7E5350787EE6A0B1ull, 0x6A567773294BEF34ull, 0x1D09F4F27BDE7181ull, 0x1C2ABA630FD9E937ull, 0x5C3C3526582227B8ull, 0x256252C358F5459Bull, 0x5DB0C3E5480BFB49ull, 0x38570D65703947EFull, 0x78EBC8D19A60650ull, 0x49609ACA28FA8419ull, 0x324CB1825413582Eull, 0x2CF120587320BCE3ull, 0x1C51CAFF2927C340ull, 0x518E7EA224B6B1DDull, 0x3FFE8C775F519E6Cull, 0x78ABAD223E51DCF0ull, 0x5E383F1D63022495ull},
//		{0x679DCC247B42340Full, 0x5EE0961603C88687ull, 0xB1C1D473B1CCB3Cull, 0x5BEAAE3F307E700Aull, 0x141210D7399B7225ull, 0x788A6B534C691E3Cull, 0x29D4BA14001927E1ull, 0x660F248C733554DEull, 0x2913ABFA185BD60Full, 0x4748AD0D5604CC53ull, 0xB7C92F2639A780Cull, 0x7F2C8F935D0B1194ull, 0x85129E93F2B1C0Bull, 0x3C5CB00100FCD70Cull, 0x7D7CF8FB1A94EF1Eull, 0x63FEFBA1651AC51Full, 0x15D7232E42DF91B8ull, 0x68E34BA720F34075ull, 0x7DFC5CF444CDF9E6ull, 0x5171B07F120E6DCCull, 0x7E696C0B49FC1BD2ull, 0x5E778C08283E261Full, 0x4A1543B34486B095ull, 0x1B737AFE7328EFAEull, 0x5CE286A462BC280Bull, 0x492DBC01685F1996ull, 0x4656A017485A4B94ull, 0x456A2B2A4EA7CA00ull, 0x785679F01C6DB2Bull, 0x4FA4A10C0502609Aull, 0x1C5BCA4A33A39CAEull, 0x6A1D25BA3232ED78ull, 0x76832E6653007161ull, 0x53262DED747F8B5Aull, 0x17CE6B472497DE6Cull, 0x68DF9261637D753ull, 0x6E93FA3E6505852Full, 0x3E75FD7238A93DF2ull, 0x298C35C459E97870ull, 0x2BD22DA0066EBC68ull, 0x3CA5A07B74FFE9A1ull, 0x6ECDD5FE02FC4092ull, 0x3D5A353534380128ull, 0x51A40A9344DF9CD5ull, 0x35FEDC542148AB9Full, 0x49E1FD6F525AA69Eull, 0x54EC484D33FF2329ull, 0x48D94164B6F76B3ull, 0x6FF948A57B3C203ull, 0x3FEF020E1ECDFFD2ull, 0x7C4BA06F467CFB34ull, 0x3505D7256ADF9AADull, 0x2B828063737BD497ull, 0x2388D89F550EB627ull, 0x4D654D084F5B063Full, 0x5B7D728F0A0AED83ull, 0x445AEFE04A4B488Dull, 0xD072E1601B52516ull, 0x7E8349B65EAB38A9ull, 0x4694C1EB3482260Aull, 0x7FF3E4481076BF5Aull, 0x6DCCCA854E02C96ull, 0x4475E2840B6A60BEull, 0x204FA3494B75770Eull},
//		{0x631E22C1603EA557ull, 0x6A4376E05F69C330ull, 0x26BBA08C1F494E05ull, 0x4A495DDD523E20EFull, 0x12C5229D6DD2367Dull, 0x274CD717602A6FA5ull, 0x3D2D3CBC02CA49A6ull, 0x6A355D2801882C9Dull, 0x4D159234773C8B3Eull, 0x33D51B34B98DBEAull, 0x55E7C3E749D2139Eull, 0x1B01F455DBA830ull, 0x5A48D2F806F7CE9Cull, 0x2ABBD4C61EBEB57Cull, 0x12622F5A4B0B780Full, 0x6A342C8B7580521Bull, 0x2B4A1D675477A36Bull, 0x54EA154B5205BDF3ull, 0x73C0F1711F337328ull, 0x2443DEE20686140Eull, 0xD05A9A54B90B5F9ull, 0x66B083B34A32E662ull, 0x4E5AFFA050E5E0DBull, 0x4BBB12FF1B7091D4ull, 0x48226C1A4EF864B2ull, 0x67096DBE1E0A3001ull, 0x18CA785067246FB2ull, 0x73E5D83173134B48ull, 0x6E1C3E4E1EA1ACF7ull, 0x11D200C5007E6DA8ull, 0x69AD25077C062D50ull, 0x75FEBFC314F7426Eull, 0x507DD0BB4AE8D50Eull, 0x66FD0061443EC22Cull, 0x6A1C48360B40DF43ull, 0x4AC4D63A7721F1DCull, 0x56D1953D317559EDull, 0x4154D83E252C94DDull, 0x25B3AC90D0FEB3Dull, 0x409D26B14A7DA6E3ull, 0x5C084FEF27A6946Full, 0x6887D6E474D2C83Full, 0xECB04215C6DAF16ull, 0x67E613877CE7426Full, 0x7B0F5C0D79B8144Cull, 0x7D65B01764BC8114ull, 0x75BE419C73646FDAull, 0x79B3C382463C1258ull, 0x3E4D44E860B0C3E3ull, 0xA7AD48428698D1Eull, 0x6BF1A327553FAABFull, 0x1F8B7EFA42C33864ull, 0x6B504AC60E05738ull, 0x67EFCD4109103F75ull, 0x6DF04275288CF3F2ull, 0x538DE65849F89264ull, 0x503388613C15BD3Dull, 0x3ECB5AA35EFE8C82ull, 0x18836C5326B16E2Bull, 0x5BE5CEF11392C860ull, 0x20698277594B7F08ull, 0x784F49751627C414ull, 0x4CAFEEE272030CF7ull, 0x5C63D66C0AFD33CAull},
//		{0x52B3D0DB66DEAAF0ull, 0x3366C0E83EA57402ull, 0x3C1E55AF52F23FE3ull, 0x168AC6642D35A5Cull, 0x33D2971B695879A7ull, 0x4BE399D121C2D991ull, 0x11E56D991F71802Aull, 0x6BBB6BF56218F5FAull, 0x5B873D672A86C699ull, 0x4117827C740AA9BAull, 0x513834C41CFD516Dull, 0x79D721A71A1B73Bull, 0x7648D0757FECBB8Full, 0x7C97B4F42F8BF57ull, 0x71EFC887642D51BBull, 0x4DF5F32144A39962ull, 0x4B0BFCAC015CB409ull, 0x3490D64072A525Bull, 0x544EF3EC04B1B9CAull, 0x49FDACB708218B08ull, 0x6E0A337115E14689ull, 0x29E464997FEFA10Aull, 0x3552C6B3159FD08Eull, 0x6208970410DA041Aull, 0x4026972723201980ull, 0x4E4ADD4115ECBEBull, 0x401D6AED0C821FEEull, 0x300832736663B62ull, 0xC6EDB7E0AC9FE76ull, 0x795EFAB97E5EA405ull, 0x6EF750324754EDDAull, 0x43023D673A034CDEull, 0x48B1A1E3464B4ACBull, 0x412D9F391D0095D0ull, 0x4AFD04950B2B4BF1ull, 0x252220D839073806ull, 0x210C927A4F068571ull, 0x38F6D910565F592Dull, 0x64A655FF1AFF7014ull, 0x67395D4724CCED27ull, 0x3E1F89946C1E0B1Bull, 0x362BB9127E3CF481ull, 0x78A02B09392C3C39ull, 0x34A32FE3050F0687ull, 0x43F63AB02E022A9Cull, 0x36DAA8C32ED8AE2ull, 0x75571876466FE7F3ull, 0x6CF0D7C03E08BA59ull, 0xCBB32BE2E1E76F9ull, 0x5B09502957B83753ull, 0x3949C2EA002B7101ull, 0x10BF6F595A565564ull, 0x4F31F67249B64869ull, 0x30B5AE9133D84C72ull, 0x64B5B87D17EF0BD8ull, 0x58A5399922D54211ull, 0x40D16F30ED0F2ABull, 0x211236927CAD41FDull, 0x47FD2EE555B56675ull, 0x1BC48840BF36995ull, 0x3B791110529F311ull, 0x3EE0F477790EA987ull, 0x4B99DB042BD1CC37ull, 0x371763E158550DC3ull},
//		{0x59F043301220B40Aull, 0x300D4516133A061Bull, 0x124C250C40CCB470ull, 0x6D905B7F617E1B7Eull, 0xA82FCD91E460A11ull, 0x155667F06F38B557ull, 0x363515E96DFBA189ull, 0x120DF7683A422CDDull, 0x7CCC943533202DFBull, 0x36EF6EDA44C9C31Aull, 0x8D5947038ABB75Eull, 0x50BD2CAF0C8D2582ull, 0x3DD5AA6F0F9E2126ull, 0x59BCF09096F8574ull, 0x3B6FED5D3CB332EAull, 0x61C493371560308Dull, 0x4ED3E6F511D1D84Dull, 0x289A36A861200C01ull, 0x529E8CBD162A9228ull, 0x429E277F5D218997ull, 0x34709C3957F48F70ull, 0x4C5A3EEE6AA5B222ull, 0x45F030F95E683656ull, 0x24E7DEFF42BCC52Eull, 0x118864515BD74DD9ull, 0x78688481A5DF8C2ull, 0x148305385843B4F7ull, 0x26EB1E445258AFA7ull, 0x67E1D61D2C86ED4Dull, 0x5BC8351B2351C37Aull, 0x693A20383D8CC852ull, 0x38B1F408380E072Dull, 0x4F5EA0A0614C2AB0ull, 0x192E132E21FD2D5Dull, 0x7776BCD85BCC3AADull, 0x7F1EB6F42BE75911ull, 0x33C0CA1D4B78F5E2ull, 0x168D0B3479B0FB17ull, 0x29E12C393B74EA33ull, 0x3C6DC0453B69908Aull, 0x174C380D43F4488Eull, 0x55C7894C2BCF3D45ull, 0x1C37FD857CB2A790ull, 0x7E27ECEC0419D3A3ull, 0x293994DE59F02208ull, 0x276B971D1273B516ull, 0x177CEA5A601D8B25ull, 0x4A81BC4366DB8AFAull, 0x4169B5D663AFCF71ull, 0x8D8B85838E072AEull, 0x3F7C0A1E07F76F4Cull, 0x64C7CBC0733CD43Cull, 0x5370652F7B54D6F4ull, 0x6CEDCF537D519168ull, 0x36C9C127295B8F98ull, 0x38BB21F24E15F934ull, 0x6D4FD8260E82AB3Full, 0x79E536790987D5ACull, 0xB3552CF780D2366ull, 0xDA1A94F346EE7ADull, 0x51FD456E350D406Cull, 0x46E29CC3697A2FC8ull, 0x152ACB9211645906ull, 0x5055BAC356948168ull},
//		{0x75142877592E731Bull, 0xF74F41634903296ull, 0x6125E267743CBFD6ull, 0x27CD06D234964796ull, 0x6F9196CA14BAD625ull, 0x31E7D8FE265B57F2ull, 0x3E1665BD6AA2FAF1ull, 0x747151262B663DE4ull, 0x7925A6306E5687A0ull, 0x34EE1390045AF8FFull, 0x6663AB06428FBCDFull, 0x38C9E0AD3860F074ull, 0x779CFD4B7FAC7D70ull, 0x21DB203C0CC7C8DDull, 0x1110D6777230DAFFull, 0x635C4A450624FEEEull, 0x4B5F4E1A72D13E5Cull, 0x3AB531842C853082ull, 0x670DFE3262823856ull, 0x611B7818569F94FDull, 0x773D0E7B13035117ull, 0x7CFAECEF35537439ull, 0x7DA64C08716C3E15ull, 0x60B9B21D76CBF238ull, 0x5FC2C5B515A7C5ADull, 0x7B26EB37462670BBull, 0x5837828C33F0CBE4ull, 0x7E87612F4FD47FD7ull, 0x339D49552062816Cull, 0x5C9C48B544AE1FCCull, 0x12935C6B3FF892FAull, 0x4AD31EBA5DF2AA86ull, 0x32C9D1560588503Full, 0xA77DB0819D7CF89ull, 0x680A88956B935320ull, 0x707764865F479711ull, 0x7E96A4376D725175ull, 0x149B0B4A7C3CF03Full, 0x5EDE8F8A7554BD67ull, 0x7308E2773EA15540ull, 0xAFC83146E2FCDAFull, 0x4C7C5FB633405A0ull, 0x22209993034F272Bull, 0x3308857755BDE2E8ull, 0x23B1A8970FA4CE2Cull, 0x1A6C02B436450502ull, 0x4F9D6127653F216Full, 0x1437AF880267327Dull, 0x6AC771AE1EAF8A90ull, 0x1C3F020652D1FA43ull, 0xA42DDB10CB6668Cull, 0x3219915408D981E8ull, 0x7A28B80146B49C9Eull, 0x51672285907478Cull, 0x3C095A05781F549Full, 0x17A89CCC4705DD19ull, 0x664F224E1C7062C7ull, 0x2A39E2B9086FBBE2ull, 0x1FBF89F25D426831ull, 0x5E2D9ECA43713289ull, 0x6CE7365D7899A17Full, 0x79B6378C3C849784ull, 0x5DD8C2EE0DEDE714ull, 0x3EEBCA0248A0349Cull},
//		{0x2C9D71A55B2ACC08ull, 0x1B722EDF36E04F56ull, 0x67E132954D8BC034ull, 0x3FB9D13E6209EA96ull, 0x14405CD244D04366ull, 0x3B1132225049B6D8ull, 0x3CEF980652B9CEEEull, 0x174F93F1233EBA54ull, 0x6F2A31B6418976ABull, 0x2BAE76360EE9BBA8ull, 0x1ECBDEDC09DC1501ull, 0x525AEE320BB31539ull, 0x275B6804C1125BEull, 0x4837ACBE604E796Eull, 0x59FF0CD2072376C0ull, 0x28EEAE0A069C7E77ull, 0x624E42C84460DCE9ull, 0x3D7CCDCD4A2F755Dull, 0x11EC9D1D7D369F0Cull, 0x2C395FF4262CF9F0ull, 0x4206E272674A9216ull, 0x7676B0C87EF67A78ull, 0x3A0461050DC644B9ull, 0x223534CD292E92BBull, 0x4F4FBB644DE3AB03ull, 0x38184E636E1B9A40ull, 0x57BFC0040A733C95ull, 0x79CEAF7A5A357684ull, 0x5684625342065C38ull, 0x3A83EFF230836F26ull, 0x4929D2F863729DFCull, 0x371FED9D2B7815C0ull, 0x27D37AE6749CBB6Bull, 0x75A78B1E39C01803ull, 0x71D35A7721E0EB12ull, 0x5FED11F333DA3CE9ull, 0x92B7D285663C2BBull, 0x32D0B762432FDE2Dull, 0x642A07755505EC2Full, 0x6C5E70E83379C2D9ull, 0x22E997322476BF4Cull, 0x21955D1A7AA95737ull, 0x2EE9FBE11B640C94ull, 0x54DECDBB056E5E35ull, 0x5D6A68CC0F62BDAEull, 0x35F1CD5B26943BC4ull, 0x72D55BAA6D11BAF8ull, 0x520C51841AA8D690ull, 0x61AE766347B3DCA2ull, 0x5468EE945381D0DAull, 0x6994C7B434560087ull, 0x75C0DC472C044DDull, 0xAB9C3433A2CC526ull, 0x35F0230A6EE3CAB8ull, 0xF32B155224E93F3ull, 0x225D8D91321C4887ull, 0x46C5533F43F2EAABull, 0x2CC59FBE75AF4F20ull, 0x5F56F73F01A46D7Aull, 0x7B1DAD553CC1600Bull, 0x11072B28310F7AB0ull, 0x63559BCF03DC86D2ull, 0x1E2135A93561ED54ull, 0x1E855D637FCFAC0Cull},
//		{0x7D15C9F672EE4BF7ull, 0x53517CE766AA91ABull, 0x27444C7E5AAD8AABull, 0x596AD68831FE0FC1ull, 0x14DA4FD10F5AF992ull, 0x20E1DA79240D0126ull, 0x31A98D85433F680Bull, 0x562949AD786EE0C4ull, 0x73252B602EEE96Cull, 0x6E1E2FE5668949F6ull, 0x49356E6693BDD3Aull, 0x234AAA01159A820Eull, 0x1A4B57EB06A045D1ull, 0x197708E0386C8D94ull, 0x3C02332537FC6643ull, 0x383C39A03917FD1Bull, 0x2AEAB23A0B8DB687ull, 0x1FC28EC6522EFEB9ull, 0x663B4132792D654Eull, 0x42D0E7A7B159103ull, 0x8885EE1250EE8F4ull, 0x1F2292293A31EC66ull, 0x684E50FF754BDBD7ull, 0x32A0CD2B6F80A3B5ull, 0x783AC54320BEFD10ull, 0x5609EDAB7CCE1C29ull, 0x9FADA4A795497ADull, 0x12689E3724463235ull, 0x7FF4DD7E2BDFA717ull, 0x5CB2BFC93BF710A3ull, 0x63DC0D5B14EEF96Aull, 0x750F0DBE0EC6BF95ull, 0x207CAFF114D19C85ull, 0x60F5BE4E06B7F124ull, 0xDFF01D36522CCC9ull, 0x1CD8227168760B4ull, 0xA31B5BD20F01451ull, 0x50B94D1B728006BCull, 0x163BF028035A1A46ull, 0x6200AA710E76B56Bull, 0x24191756380A981Dull, 0xB44D1942E13F1A0ull, 0x315F2FCA1DAD6FCBull, 0x525A23D631540D48ull, 0x498D16E22F0CE39Full, 0x6D4B1DEB2D69243Dull, 0x43FBDD09625A2BA9ull, 0x3C2FE3D364788CFBull, 0x772BC82E1D25A221ull, 0x6B307E1F052ACA02ull, 0x2486EEA6CFE0046ull, 0x1BB22AB60C7A24A7ull, 0xDEE14976C6B77D1ull, 0x7EFA2B63242A04BFull, 0x6FC5921760FAD5D5ull, 0x32A0BA2A13DEA96Dull, 0x19056DF23DE58BBEull, 0x41F29B0E4A649DBCull, 0x5B92FB89144CBEE4ull, 0x7BB8AB042520126Cull, 0x4359A2836903C8EFull, 0x528936A907557F8Dull, 0x4B5DF4980EB91A7Cull, 0x6BCE0C884289BCC7ull},
//		{0x2BDEBC9E56FE8AA7ull, 0x47B486C92E272B88ull, 0x43FC8AED6366B17Full, 0x3AA1503051EA9F85ull, 0x4FD22951399B7B93ull, 0x7614A4443F97BB68ull, 0x1A96516828B55E6Full, 0x537664D6339BBF5Aull, 0x669AEA2D1568FFE4ull, 0x7E005D16422DE5B7ull, 0x29B5BEC879B9081Aull, 0x674DF8236D0F614Bull, 0x62BCD10939D72ECCull, 0x7464E0D82E1AC5A2ull, 0x489049496032ED60ull, 0x70A48269746F05E7ull, 0x3731780738590932ull, 0x2296316F7B2E02F5ull, 0x1BBFBAB15D37819Full, 0x4D18A27A6B91E402ull, 0x16D2FD33432D46BEull, 0x2B299F6B31694E9Bull, 0x6BE2A52D7EA00441ull, 0x65050DF6527D8F5Bull, 0x1409042563056B0Cull, 0x14AB75123DBEC2EDull, 0x5CBE73277BF96D35ull, 0x2ACE24383F7B4430ull, 0x35D09C011F330511ull, 0x6D9609D27E60E54Aull, 0x7F65F2715E3A8C3Bull, 0x72CFEB3136976A79ull, 0x1693956D15661CA1ull, 0x31C56D6E3253501Full, 0x729D9E407EDE0FE8ull, 0x1DE5342109709B73ull, 0x420B56A6490ED38Cull, 0x3AD9EA0F2DEDFBD4ull, 0x47AED7CD1FDEF805ull, 0x6B8B2F5BB7DBF2ull, 0x2E4631115170041ull, 0x19769EDF5FA2D638ull, 0x11106D764444C318ull, 0x1F1E1A6946E10977ull, 0x6377C8290CB4243Bull, 0x4541EEC262DDBA9Aull, 0x6AEEB0773811D9F3ull, 0x19752513018245E4ull, 0x4D77F6944B3A9281ull, 0x33D59603401594D5ull, 0x4A18A26951BACA25ull, 0x498630480C23F910ull, 0x1AC99DB104601A57ull, 0x3A11F4E46278757Full, 0x243F125C3A7D8013ull, 0x3E3051712723756Eull, 0x4F94805457A6F051ull, 0x6C64BA660A4EDCAull, 0x1BEBB36925E4660Full, 0x2785F7417F637B92ull, 0x32988A4B6CC7E603ull, 0x6241362C1D873AC2ull, 0x24D9BFF77BB65B40ull, 0x1F0980A67251B68Bull},
//		{0x46F0EDC152DF16AAull, 0x32674B601109902Bull, 0x2499E0CF7BED7BA9ull, 0x1D2D893B3F637E80ull, 0x4D9600573F7E1Full, 0x21DBF3FF248CA85Dull, 0x11BCFE32600C4571ull, 0x4BB01DCB61517E86ull, 0x37B335C252766971ull, 0x41F66C50539EE92Bull, 0x785ACF81697C6391ull, 0x530264BD2AF359CCull, 0x5644499535439AE9ull, 0x487A948E7B1E098Cull, 0x30F9F62967841534ull, 0x6D6FC01777EAE3EBull, 0x3A632BDE1FD70B78ull, 0x8F474165EFD0CADull, 0x1BC487212621FD51ull, 0x1E608B2E1C121D21ull, 0x7D617B70403C7F2Dull, 0x409EC57E0F1E79A2ull, 0x2048C49E0C4EE349ull, 0x706FF82857FBFA60ull, 0x5EC54CBB32666478ull, 0x2B9AE38B57201C3Cull, 0x1BE2C8097E9D4848ull, 0x21376087227119Eull, 0x33E0E3324A8E0A96ull, 0x6D451B2A64DAD95Bull, 0x32121FCA5AB4DB42ull, 0x5CC5BD466C754BA9ull, 0x7A8BE6BA65BA315Cull, 0x4B72585616506DDBull, 0xBDC2EAD69D2E384ull, 0x32628AFC093DAA1Dull, 0x2A0F62B27301507Bull, 0x185C23BF4A582750ull, 0x7F5033C408CC1BE7ull, 0x225421B15E15807Full, 0x3B32805F4DEF053Cull, 0x35359CBB57154869ull, 0x4C8C4D85374912C3ull, 0x493C5A07006D30B7ull, 0x1D71D5936817532ull, 0x65480A1233E93D24ull, 0x11365074420DC759ull, 0x205E88CD0BC2372Eull, 0x27C7F8B56BD0E123ull, 0x2212A50933A42763ull, 0x55A3C4A854753005ull, 0x3CE1D1807FB3275Aull, 0x47768080553DF540ull, 0x4A0B4EAA46C6B445ull, 0x5E0A11276C5F705Bull, 0x24DC34C4193C9187ull, 0x3A4E75985A11D180ull, 0x7051D9F006DAC31Dull, 0x115AE443398E33F7ull, 0x747F3D41332019Dull, 0x700FA9296C8FFDE6ull, 0x471B3EC10145F99Dull, 0x2E9DC53F6779C78Eull, 0xD0830CB5665BDF5ull},
//		{0x534AA8B12F1AD5D4ull, 0xA09E55828EE6D59ull, 0x39005DA46EBB6D8ull, 0x28A194B34B06865Aull, 0x1C29AC1872ACE35Eull, 0x11CD3A9F7A33BD40ull, 0x5F0C53B936A96F64ull, 0x13704EC7195AC951ull, 0x10BB40E403C228B7ull, 0x20358C6E22162527ull, 0x3D505CAE277D8042ull, 0x354826C42D6005D8ull, 0x140D7E297C636585ull, 0x2EA5FF7542AB4368ull, 0x63DD2D133BAE3041ull, 0x1911015D3727D5C5ull, 0x6AC90615231AE6B5ull, 0x6016431E6E590BEFull, 0x6A069D8E08B7D7D2ull, 0x395F924A063049A6ull, 0x7B64BB304B2CCCE9ull, 0x6406E65A710EE9ull, 0x1D63C4D13D455ADull, 0x73CBD83B12917D31ull, 0x17967E64140164A9ull, 0x34A7A25954E6DB13ull, 0x3B7EE4EC69EFC91Dull, 0x246E0EB4F8C6315ull, 0x66532EA330ECE060ull, 0x1237A67D4A305BB6ull, 0x6C9B10A12B48A7DBull, 0x158317B576416B7ull, 0x4E638E90616E749Aull, 0x45BD22A6386A2C1Eull, 0x6A264C6C7F1CB4F0ull, 0x3E9A75C5658B079Cull, 0x4A4981DA3EFE7CABull, 0x3FFC16854C1FBE27ull, 0x52D2D25933C7EEC0ull, 0x5EB13B596A6950BDull, 0x47C9536A1358DDB2ull, 0x3F502BD003483856ull, 0x7D48A6CF41970CBBull, 0x52D49B6B639BD572ull, 0x7283ED1C650C41E8ull, 0x2DCC31295F1EFDBDull, 0x1054E9C32F2462A4ull, 0x368314745EB87854ull, 0x1092D73E7C40371Bull, 0x1722A4727AB923AAull, 0x7B5CEC0B55BD1A37ull, 0x60442B4645A66DE5ull, 0x14BB96E3204041CCull, 0x11C62C0D678E693Cull, 0x5408308C70776766ull, 0x51F7B9F91BD183F6ull, 0x3D045181147E5CAull, 0x1F19BC4C0118EBE7ull, 0x52DEF28571EE57B7ull, 0x64B4C15A4562DFA1ull, 0x56FA99A01280F283ull, 0x2481DD5F674F8363ull, 0x41A555275B04F1D3ull, 0x4607FBB752382C66ull},
//	},
//	{
//		{0x574528EE5D2AA02Aull, 0x4CF1501052A214FAull, 0x32E7BA612D357B57ull, 0x184882DF47A35144ull, 0x4D75BD232A0EAEECull, 0x2F31BA80217DEDAFull, 0x1A8616520129747Aull, 0x3D4F71A61E565B6Aull, 0x12715A445C692DF2ull, 0x1F6F475265504CC9ull, 0x4E5785AA042408ACull, 0x2AB32C6B25521F4Aull, 0x16A4FB2F4F3509CAull, 0xCA1A2AD584A5056ull, 0x2A39FB9D52A99E65ull, 0x2A827CBC017F248Cull, 0x2FD43E8F7773CCCDull, 0x5421398662BBF8F0ull, 0x24A948246C69BC65ull, 0x2A5F4A35721F0547ull, 0x16786B52599104B5ull, 0x139CF2F630FE81A4ull, 0x5ABA792F50EC649Cull, 0x4F54DD0F6D2BD373ull, 0x2D55928F6EC42461ull, 0x527C203D7BAD1839ull, 0x72E82D0D7D2F4CA8ull, 0x20FF3783098D283Cull, 0x4C6456722DA0DA30ull, 0x61D77892769E520Full, 0x4A78950C59F54Full, 0x781D769B301EB724ull, 0x3CDC21C4C3EB021ull, 0x12DAB01528770A40ull, 0x38A86C873D39FA4Aull, 0x1A960F874F20D7D9ull, 0x16CAFEFF2E33027Dull, 0x1F597D7185782Full, 0x7F1F671A4F74368Cull, 0x5EB14BA22C74F9A9ull, 0x3E385AED312D6BDFull, 0x282211E2312087FAull, 0x2E5CB88749214965ull, 0x3AADB0367AC10EF9ull, 0x76C223951C8528C9ull, 0x715F6109770C9C2Bull, 0x28DF1E18697CD7A4ull, 0x272B534F2CACE034ull, 0x35BB87C63A060364ull, 0x5523EA746E63F44Dull, 0x773FFDAE6FB9F9FBull, 0x3D84CC260E0AFCAEull, 0x1DECFC783DA425A3ull, 0x7F9074DD1D0C6392ull, 0xD185C305E41C07Full, 0x49815D3B4B50B71Dull, 0xF6F2C5F71A36F1Dull, 0x7C713F183DCBE4E6ull, 0x3AC4B882371EEF4Eull, 0x388CF3E03186DC18ull, 0x53A4181729EC54E9ull, 0x289378437C83362Full, 0x13692C8D4FBECB92ull, 0x293016634924B453ull},
//		{0x9C4CEF77E5400D7ull, 0x3788A8A00104CCA5ull, 0x6E0DFAD2750D74C6ull, 0xF0FC9530BFAF74Bull, 0x32B19A6A0EA03E30ull, 0x29075ADD3FC9F69Aull, 0x6CE1FEB07288B819ull, 0xB1AADB77C512B0Full, 0x642C2736078BECCFull, 0x3A1D0FF51EF0DFB9ull, 0x3EAADC1E72AA03D5ull, 0x5077BBD1124EF435ull, 0x1C9658BE790B3414ull, 0xED22A652FFF854Cull, 0x48C9FFA6380240C8ull, 0x7924399F528ECE9Dull, 0x365641A030ACE240ull, 0x53939B4324643C72ull, 0x25BA570662A36496ull, 0x305F33BD586BF170ull, 0x7143A2C759668E9Bull, 0x1835E80A5E25A177ull, 0x4BEF46B4235095C2ull, 0x5A76CC86301B6DEAull, 0x2ADC82911493DC7Bull, 0x4F0C4DA369875EAFull, 0x73DE0511F840974ull, 0x7BD652E523D4390Full, 0x188F3D880AA87D4Aull, 0x53D3BE5B61593D2Full, 0x42AABE124CF7F7FBull, 0x33E80BCC7900FFB2ull, 0x7DA4DA3B077BA70Full, 0x1D653C25235F3141ull, 0x6A1F0BA64DC46FE2ull, 0x7BCB22B25B62AE6Dull, 0x272AFE7D14010ABCull, 0x39884FE4731A4531ull, 0x3751A07E13FF1C6Aull, 0x2335B31C622E2310ull, 0x2892F8E5724200BFull, 0x4BB581BF2FD0D936ull, 0x11C60A34478BD4A4ull, 0x53A512462A5547BCull, 0x523451EE2778D0A1ull, 0xBAE84EB14DF1001ull, 0x7470C89C3F9690B8ull, 0xDE00FB37215A2D7ull, 0x471237C72B454BD8ull, 0x1574D4193131436Dull, 0x7909BBBB113FF6CBull, 0xC93F1DA2034BA38ull, 0x25410187461C41BEull, 0x134EFF6A5C92A206ull, 0x5A1B5E283684B286ull, 0x3EC0C51602AE570Eull, 0x28C6B3450A7646D5ull, 0x327F30443A8CBD79ull, 0x52021B7A0624428Aull, 0x64E2053624366D68ull, 0x2D9D132C70908A21ull, 0x39157D69220DDBC8ull, 0x30271AD946F58D1Dull, 0x14237EA0773952A1ull},
//		{0x723AD8F5299852B9ull, 0x286A960E6B4494B0ull, 0x3AD8498434FE87E9ull, 0xB794EE960194B0Bull, 0x7B1AC9A71EC84E53ull, 0x3CABED11553627D0ull, 0x554D00D97B6CB227ull, 0x57E47EDE7E13B41Eull, 0x5E2F8FD0A63AF22ull, 0x38A0719857E51477ull, 0x1087F1AD1D8276CEull, 0x7C1B81DF3E2504D9ull, 0xE1300EF3530FF49ull, 0x6032E0A13E3A1BC9ull, 0x7C268C6674565F41ull, 0x35736E6A6E61655Bull, 0x1DEEB1FA5DDE0478ull, 0x59A5FA0C58C6FB7Eull, 0x12DC8C61651F48F5ull, 0x38E0468A0DF75609ull, 0x3E79748758C339Bull, 0x632D7DD959349821ull, 0x70F8E5C33B11FCB7ull, 0x57484C3F76DBDEC0ull, 0x4575ABD90FE8BDD7ull, 0x4EC0F33755FD9D86ull, 0x2D6B34A54ADC7516ull, 0x1422A25F3B7E3595ull, 0xD745F74558301ull, 0x79B8515E7C3400C5ull, 0x68ABE2422F2BBFC8ull, 0x6A956621069A943Dull, 0xD09C440443B602Dull, 0x5F618FBB1FE650A2ull, 0x295AA9221841D645ull, 0x2DDDA6AB2D42406Aull, 0xDCE09E1110B2484ull, 0x676D88B7EC6EFA4ull, 0x4C1D213B5DBF24CAull, 0x75A2CE641192CD14ull, 0x6DA7E2A24463C19Bull, 0x67906A9B1B131747ull, 0xF4036B17BB30CFAull, 0x56914CDC0F4DAB11ull, 0x70088FFB50499E3Aull, 0xB81ABD658B4723Eull, 0x7F755E02761711F7ull, 0x5F4F067B0C7F2243ull, 0x3A5272243EB09636ull, 0x2C6572E563AD1B46ull, 0x56F26C7C5A431990ull, 0x10EF5BB064C0765Dull, 0x6B4E3E141766343Bull, 0x63876601376B5F4Full, 0x75255906592A3465ull, 0x48FE2C6362CD3BA8ull, 0x1D8DF600308E96FEull, 0x7DE052EF2CCE2CB1ull, 0x2C41A3F954719FCCull, 0x3C1BD7C21C4A33F4ull, 0x24BB3E06479D8399ull, 0x74FEA63224309C09ull, 0x3DB49590544DACADull, 0x30AFBE4C780707B5ull},
//		{0x12FE42E45D153131ull, 0x5BB422FB69F0AF60ull, 0x37584AC16CA37EACull, 0x4EB125BD22A688D5ull, 0x409B2E732388BBEull, 0x5A11E824792F0BEDull, 0xB62C02323101487ull, 0x5BFC479528F0B623ull, 0x539EAB8659DC9A85ull, 0x55BEE2D47FE04F7Full, 0x2E4E3A5111DABA97ull, 0x1C2A837353097857ull, 0x59783E30112929A6ull, 0x773A1460172CD3C0ull, 0x6576D65327E9D2ACull, 0xF33DB7578751937ull, 0x4FF03DD6AE7FE71ull, 0x6265C8973C574E9Eull, 0x578B7D1D3116EE54ull, 0x5EFDD7735B953004ull, 0x634F7A12390FBF97ull, 0x54C43BF26EB23A35ull, 0x5C1FD41F30C08387ull, 0x17A2F0582FBE7FA5ull, 0xA9D1E0C6D61D32Dull, 0x2F9ECF2438EB585Dull, 0x7F3C8DC44BC95297ull, 0xBF4D0B558B4CBF4ull, 0x5CF27C3D032EE515ull, 0x6FE19FB442695291ull, 0x2B18B7C27F157B2Aull, 0x3ADE6BC83017BB9Full, 0x69FD799B1D443460ull, 0x6C6F0A3E4188F6B8ull, 0x4E5B22B44B6CE1B1ull, 0x1D1E26BC31AA9CC7ull, 0x47CA14971E262AEull, 0x205CD6FC609C7568ull, 0x22A2E63637FFC755ull, 0x105AF50D2D400442ull, 0x25619A823FF9C431ull, 0x662B5CA0249E2846ull, 0xBC316C872202D55ull, 0x7D52F43A68B59306ull, 0x754F126A6D3493EEull, 0x2B1EE5972067CA2Cull, 0x6C4A0F1865FD515Full, 0x507F85CC564788B3ull, 0x34185BF3CEE900Aull, 0x17D07F6B519CA874ull, 0x85B71BB34EEA628ull, 0x347453B0CD81304ull, 0x26D108D623A41C37ull, 0x6D74886C4973EF0Cull, 0x5BA3E38C7DCF7D79ull, 0x76B3F34F01057E0Eull, 0x3DC941AA5CDF4FEFull, 0x25A3A654498C5873ull, 0x4EFF7D4422F69A8Eull, 0x3241EB79444E8FAEull, 0x102B2E7D5D60D110ull, 0x64B659DB7C753D95ull, 0x435E226F3535DFA7ull, 0x52BCC649469FA82Full},
//		{0x72246FB16A8D45B4ull, 0x183C50A37A7FE16Cull, 0x1F7BEBDC1B8395DEull, 0x757F471464CF4B3ull, 0x3F27B21574CC7CDDull, 0xFC0E3BF1ACB95A2ull, 0x729BFA570674D70Eull, 0x1BD113B030653C01ull, 0x635426FD4174BA05ull, 0x79F194743253A441ull, 0x646B54932C337FEDull, 0x76A233F074968310ull, 0x99450FD5B588DCBull, 0x710BC0A64CF2736Dull, 0x108E6D7243C886EFull, 0x13921B9C02B2DD23ull, 0x2E55CCA32BCE6C3Full, 0x7D32BE8F4DD1B880ull, 0x4752021D048AB300ull, 0x141EAD330679B432ull, 0x79572FDE23DF90F2ull, 0x214549D46BF32A35ull, 0x2A5468013D165D85ull, 0x1C5866360DA88EFEull, 0x7E8B178A1649FAABull, 0x3FFC334062F66C1Dull, 0x427D7A98369E6730ull, 0x578CEF2E4C11CB96ull, 0x11F6F4FB4898AFD4ull, 0x19043F032285626Dull, 0xC6136C32C965A9Full, 0x25383F903AB70366ull, 0x5864C6DE226AFE1Full, 0x888BBE61FB6C8FBull, 0x26F5B1201CA76919ull, 0x26307D2D204CE0FEull, 0x4086FA0C4775C702ull, 0xC400B336ADB620Dull, 0x48C248728987169ull, 0x7883F10B03173C11ull, 0x3EE26C143880244Bull, 0x660DA82E015FE6ADull, 0x6F1E8B7B3D9A975Cull, 0x4D71B24301158076ull, 0x63347306675F146ull, 0x239AE2E312947DF3ull, 0x130C4BE548D32273ull, 0x4D4B815A6B7112C3ull, 0x6B3E209355D43D40ull, 0xB27DBBE1233D1B3ull, 0x727BA65A315858EBull, 0x3280B2B13302A066ull, 0x78CE1FED3EC0BDE4ull, 0x1DDE02737D5A4474ull, 0x67592F4D1661F37Eull, 0x718085263B9B62ull, 0x4EE217CA667F28B4ull, 0x279B820F3E00A345ull, 0x2419C010750D3452ull, 0x3F1623BC2A4D0741ull, 0x5B83259862B1069Full, 0x3CE185346E8F717Dull, 0x2B8429130A2D068Eull, 0x5A00844016C249A6ull},
//		{0x600143CF65285FFEull, 0x28F61B59527CEA29ull, 0x1680B8E95B76CE0Aull, 0x57F8A8F0F4ED8D7ull, 0x1A378BEE235D8D02ull, 0xCA91D4B0190BB3Bull, 0x39BF80800D1A9DD1ull, 0x27CC569D08A1984Aull, 0x7399C6854F67D8ACull, 0x46A23B9017B38695ull, 0x44750CFE05B85F4Cull, 0x42008DD61FF83296ull, 0x686965EB7EE2130Bull, 0xE87A41313ED8EFEull, 0x90F199968882853ull, 0x2AAFD8A469105D68ull, 0x4DB0885153A5F3FDull, 0x3B8D47916431413Bull, 0x2F1CC207410CD220ull, 0x73801A1249544DF5ull, 0x646A5F220029375Dull, 0x4AE509311E29DFA3ull, 0xD43D52E72B15FCEull, 0x26CB77ED00DD9BB3ull, 0x4219387B6D6DB37Dull, 0x18912249068E4579ull, 0x732612C95A91B01Full, 0x268678105B8F78B5ull, 0x5973C32A350E1C23ull, 0x6F7D07B36282DCC4ull, 0x1D9644771A2CE058ull, 0x4B933A2C6B46CCC8ull, 0x6DD2D455072081BEull, 0x4F780E031CEF965Dull, 0x482D53DE42F82815ull, 0x6643E4522C97B301ull, 0x43215F733128ED83ull, 0x4AC192A4506534A1ull, 0x23DA4D52718D0A91ull, 0x5142D05565F385CDull, 0x5EFABE0F69D3F29Eull, 0x6C81CB465220D0D8ull, 0x4465A2BD13084356ull, 0x2DB0498D1DD965E8ull, 0x48165F7A1D2D5141ull, 0x5C42AC65ACA3F1ull, 0x375A31994BEF7CD8ull, 0x50F370B9252D05EEull, 0x530FFE96206B7EBDull, 0x421C9C4B1B3D5275ull, 0x6363A6D22860809Eull, 0x47D5057626850645ull, 0x59896E211296981Aull, 0x76EA3AE77D63BB73ull, 0x423A2AB482D0B3Cull, 0x63574140631E60BAull, 0x3200FDDA4FD90C87ull, 0x353F31937666A097ull, 0x62E14FDD62EF7B20ull, 0x1440067F2AF7AF57ull, 0x1CCC61149C492Bull, 0x10A453483776FDFAull, 0x608BC6046197C402ull, 0x5CA403E9339BC49Aull},
//		{0x20342BF1EC0A034ull, 0x4ED9170F6566E991ull, 0x472120D216AE1C85ull, 0xBEBEFD720AA8EF4ull, 0x2944B49F02D62ABEull, 0x1E0E4A672D68574Bull, 0x4B0335FA01658BA8ull, 0x1086B8057D0433D4ull, 0x513E982F45C5E998ull, 0x736AD46B341FE80Cull, 0x28B564B907AADAEBull, 0x5F17976428D2311Aull, 0x1C4724166FBBEAACull, 0x60492F157CD2EA1Aull, 0x5153AEAE3CED32FEull, 0x306EAEB55356F16Dull, 0x5BADD3327F47C5C4ull, 0x38BDDAFF22CEF405ull, 0x15F5E24A44A9CAD6ull, 0x437982F93F3A96E9ull, 0x477FF5946187CD60ull, 0x6CA2EE3412832B8Eull, 0x62ED59087D29A63Aull, 0xF875F62342BF137ull, 0x42EF8FD202F233CDull, 0x684BD9446BA4F48Bull, 0xA9D0EB8476370A8ull, 0x147725A626E432CFull, 0x371F5B5474C054BBull, 0x23B71CE908730A03ull, 0x31AD87B95425CB9Eull, 0x5BC9FB700D5B5AEBull, 0x536D91631487D66Full, 0x302A4EF0696373ADull, 0x5931A14573A3D1E9ull, 0x289E0A9620B196D9ull, 0x552B9F4A1540F8CBull, 0x3334C2673818F852ull, 0x126A9F0542BC21C9ull, 0x6C44E98A555A2ED7ull, 0x45AE55975490C2CEull, 0x40FF2363504B644Full, 0x1BF4337655764909ull, 0x772F971E53138ECAull, 0x4A369DC41AE6B408ull, 0x5B8698CD7BE4257Dull, 0x6F0C7FA63750943Eull, 0x93F8068427A1109ull, 0x4BD86AAD3969CF59ull, 0x2BDD84B6250A0BF3ull, 0x2D0DA142547B8F4Dull, 0x45BBA2CC0239408Cull, 0x69BC881878F06534ull, 0x3A5238DF7C27271Dull, 0x3BAC86FD26972269ull, 0x518155F4015ADC94ull, 0x7B27E53712807957ull, 0x51A640E4171C18ADull, 0x67F6C26048D5D802ull, 0x6A2FA777322D6024ull, 0x63BC8C0A45B64045ull, 0x2E1185A152C90BB1ull, 0x7D06D4833751060Aull, 0x15431CBA48DF3F30ull},
//		{0x70BAD5634120A171ull, 0x6DE94B231DC876A5ull, 0x159C30BE33A4EDF0ull, 0x2001B7327F58B8D6ull, 0x2C9553245A53F011ull, 0x7B7FDFF36841DA21ull, 0xEB127A4D0135E7ull, 0x699CB6B67C12F7B1ull, 0x5F81AF3F3B42F79Aull, 0x132F105E4778719Full, 0x418CF9C7D5EB7D5ull, 0x79A5D1C467D55BA7ull, 0x4314F81A27B75765ull, 0x3A9E6758401BCC9Dull, 0x5F085D6F4FE18412ull, 0x8FB0BCE4FC332D2ull, 0x1102258376E456F1ull, 0x6D8BA978269E5641ull, 0x2A8944E10D8D60AAull, 0x25F70F17571E9805ull, 0x67E150BB2176EF0Aull, 0x3F60722768CC6335ull, 0x6E7824F228FD28DDull, 0x64DF5AE64DF9D431ull, 0x64402077780E6B44ull, 0x157245D06858F013ull, 0x756D23190F181794ull, 0x502E4BBA38821B34ull, 0x36CF6EFA0ACCB312ull, 0x789DE7D115D7CC69ull, 0x5AAE37250198F39Full, 0x659AFF3C6BB05CA8ull, 0x787D4A915326A8B4ull, 0x124EB2EA23068F72ull, 0x60B4095E3845C201ull, 0x7A25277848955A19ull, 0x59BCB10C3985999Full, 0x3161BD4E4834D5FEull, 0x6282C27C16411834ull, 0x162EAA2F46C2E2F3ull, 0xE4F83782BA0EFFFull, 0x2F1BD30603BCA691ull, 0x3AB907947F4A1EC1ull, 0x3C3EC1C57188768Eull, 0xA16D1D334DCA997ull, 0x76042F764C508F8ull, 0x36759D366CFB4233ull, 0x507565A12EF2E7C7ull, 0x4021EAE762C4188Bull, 0x51F9773A20D5F445ull, 0x1B09DA8C4C1E9EB2ull, 0x696B4E5E74C68B98ull, 0x5A438511ACD0BACull, 0x3CFB61966826FACDull, 0x310E23E0532A0BC5ull, 0x2EE9DDC03F5DA758ull, 0x7ECAFBC55E05B0C6ull, 0x431A4DEA39840359ull, 0x5D4FCF877F590FAFull, 0x2B0C79E76766A15Bull, 0x3435B946326CBCDEull, 0x4C2BAA536AAB567Dull, 0x1F67FF121CA10FF4ull, 0x199E3E445F89E9F9ull},
//		{0x7F65287F6B97B57Eull, 0x5FDE3F1A6F030Cull, 0x37B6543069CB2C9Dull, 0xF358EA43D5A8C81ull, 0x498384A4C30F03Bull, 0x2581874E35A65C2Aull, 0x1F5AFC00546B650Eull, 0x750403831E25F7C5ull, 0x327115D5381E516Dull, 0x57A9FB1E0FC0E55Cull, 0x3777611C02B67505ull, 0x772786B76BAD1A63ull, 0x352331E44353310Bull, 0x565870E0548B30F6ull, 0x5FF440FF6FF6AF24ull, 0x34151AEF5F59697Full, 0x5B8E64A33474F92Eull, 0x79C86C8B1344B8D3ull, 0x1E4025CC08FDFB2Full, 0x509F455522D85E16ull, 0x552EEB6A7620CCA3ull, 0x587EBA407489E76Bull, 0x4A8C31B24D82BDC3ull, 0x12AFDF307CFD4787ull, 0x5A10F306A59DA4Full, 0xCBE2CE33D18704Dull, 0x6D104F5403E5B39Bull, 0x28C58AB022338138ull, 0x4738E4A67F1DFB90ull, 0x76BEB22E272D25A5ull, 0x6F14AAB42AD3CD1Eull, 0x6868F244AA30F57ull, 0x5F48C64C004EFBAFull, 0x5DE7C82B7D88EC18ull, 0x94CF6DF2E870D80ull, 0x20614A2E5E7BE249ull, 0x24A7DA2378E0046Full, 0x5305C9B46F340BD5ull, 0x4662C23265B5A8E5ull, 0x6C31535C4C03D163ull, 0x500F833478EF8040ull, 0x91C41B03D1FD288ull, 0x7CD533DB31E1CC60ull, 0x5F5353C1440E1881ull, 0x30FFC7F0561205EFull, 0x6B3B3E26201472A4ull, 0xE5D30D71C1CD4Bull, 0x6AB781FC602E995Aull, 0x7210C8FA489F4A27ull, 0x5DB785727B5DBFD9ull, 0x772657A77E18CFA1ull, 0x59D9A2231BCE31CAull, 0x76F8D4102CDF6BD7ull, 0xB023DA03D5B9642ull, 0x129514BC773390FCull, 0x95F67A562A497F0ull, 0x7023113C127BA955ull, 0x1FC46A796CF84517ull, 0x445D75B57F17BE3Aull, 0x31065D98755D3DA5ull, 0x5529C4291C419BBFull, 0x1571B04A560F9737ull, 0xE03690A00293246ull, 0x363E309100143204ull},
//		{0x48C87C6D13F5B603ull, 0x7B71F1DE3FEED414ull, 0x120E85A4554B9401ull, 0x5BBD05DE090759B4ull, 0x22AFFD866BF437Eull, 0x4662EFF714C01495ull, 0x5DF2D47B4FC2579Cull, 0x7764AC854E15E5B7ull, 0x623E00F2172916FEull, 0x3B0E2ACF269B76A7ull, 0x1640D5386C148867ull, 0x1BF8B44D6B6A9962ull, 0x8562426316A6497ull, 0x417A309916598D30ull, 0x319396DD77B8612Aull, 0x166DBF357A5C134Aull, 0xBAE172D11DFB113ull, 0x3A4AE75E1DBC9CD2ull, 0x672B45141607ED3Cull, 0x26C3F686695644ECull, 0x7CC730BB6D26E67Dull, 0x7E1659815ABA0536ull, 0x3CE93E1A757B0607ull, 0x28CFEAED1F273F0Cull, 0xCA41D0563DE15BCull, 0x45C2B5B322E4F23Eull, 0x4FF29E2461BB6A00ull, 0xE4F8BA05848C24Aull, 0x1325CE974FC9BC39ull, 0x6EA24F7B44B96574ull, 0x47821D6305100EB0ull, 0x3F1578BE53303490ull, 0x16EFBFC37960601Cull, 0x70ECD1627E1B04D7ull, 0xF684D5917B0C7E9ull, 0x677149C30C2F7E14ull, 0x4D7AE666587A345ull, 0x66E9834A41C0EC80ull, 0x5B02A94C0FB96E37ull, 0x60E82B8C67A6C651ull, 0x739783F426AAE140ull, 0xA8BB88F438A2218ull, 0x8664B4018DB442Full, 0x1BD2E4621B8C19D8ull, 0x68A500680A7533DDull, 0x60457F4C30271DCBull, 0xF85428D1F5AF80Bull, 0x357525C26750250ull, 0x18BB5827744423BEull, 0x249007272823A580ull, 0xBF4EBA70C0150EBull, 0x3453239410CC9A0Eull, 0x7188F4301B3CA6DEull, 0x528D868E4C8B9D7Cull, 0x2AF615163375B21Bull, 0x343263CD1E8D990Aull, 0x5A20935B3EBE1C5Dull, 0x6217BB226286DE9Bull, 0x5799608C7DEA9F84ull, 0x7E12F873403E60F5ull, 0x85FD3625E5877C0ull, 0x70657EC017E515EFull, 0x7DB36FCB73BCD11Cull, 0x3E5A1840166EC7F2ull},
//		{0x6800F4DB62EA1F67ull, 0x3E926D7373F5E082ull, 0x6EEB705272E59107ull, 0x4C27A9060746482ull, 0xE2237E65750011Full, 0x2D0001FE39184CFCull, 0xAC5B33A613265CCull, 0x57A5E60664E64695ull, 0x1FF0822939BDA128ull, 0x476D25307789E2B5ull, 0x37A840AC45801DA4ull, 0x37C843AA4008140Eull, 0x23D89564282DC26Bull, 0x57ED29FE218C052Full, 0x1BEA93871647423Eull, 0x37FACD2103EB8862ull, 0x793161A5768D3A94ull, 0x77E168E5681CD1F8ull, 0x6972CB9C7CA3E375ull, 0x4891367A77950382ull, 0x53F3E49475913879ull, 0x30AD507E5EB997CEull, 0x56C39E4508533684ull, 0x439FDE6376B4206Eull, 0x4210D7AC0B0D0394ull, 0x6E3E032379B91858ull, 0x508D2138260646CEull, 0x39C12C677465B69Cull, 0x4E34093911AE5665ull, 0x15F1BBCB6A1E9CC0ull, 0x27F598A34DEC88ECull, 0x6E0A25232126FA48ull, 0x4479C38165EB8E08ull, 0x943CC402DEC8F1Dull, 0x628F717D51D502BBull, 0x2581929F36835612ull, 0x47663B34562EE31Dull, 0x153CEDE01E29D979ull, 0x5E8219A158DCCC44ull, 0x14DDF9E72092F14Dull, 0x63E9CFD8031BFD0Aull, 0x1A4C09A53476F110ull, 0x292243D8540D360Cull, 0x28DCA7AC77564D11ull, 0x65BB8C713ECE6377ull, 0x6174E9D20DB12514ull, 0xCBAEC634F7F0EF5ull, 0x2ED81F5D5134AFE4ull, 0x356A9CFD381BEB9Dull, 0x7F213F0117FA0E7Aull, 0x9F0EE5824A2D1A0ull, 0x4E7D648C5157298Cull, 0x7AD1B4BD63BA526Dull, 0x6F8103055953CE5Eull, 0x3C971EB1045EFCECull, 0x79E6BFAB2080EE89ull, 0x77AF9F71432C951ull, 0x54F7DF99309D3DCFull, 0x683FFF5D7DD48745ull, 0x27F38AE14DFB8BCFull, 0x3CA2EABC096874B3ull, 0x5BACB0E3495DD71Full, 0x58E783A80A84D040ull, 0x1A9287040E5220A5ull},
//	},
//	{
//		{0x42A0BBDE19B3C605ull, 0x264C2F1F4C91AA36ull, 0x3E5697A674C993ACull, 0x1DE8D3C339284C63ull, 0x5883E6190D69D6C8ull, 0x127C1AC2151B04CAull, 0x11C8D3B50C62DA6Dull, 0x359BF3531943CDACull, 0x2095A3BE0A93D2ECull, 0x49E10B7B08D5A31Cull, 0x8685A3171D4965Cull, 0x56D12EEB450B44EDull, 0x7B3D0B0F327DDFCEull, 0xE691C0C54248EB7ull, 0x3D02B00F28FBA310ull, 0x6276AF5C7FA36BEDull, 0x42AF691608C2DE7Cull, 0x4C351623010600BCull, 0x7D8C72286A1DE9E6ull, 0x3A2E4D1F56105841ull, 0x7787C0AF4CAA67E1ull, 0x6B2B5D0B09509464ull, 0x590D424F20C7505Eull, 0x2294621079A2E60Dull, 0x2B5B234A6C756D8Bull, 0x278892933C37D7Bull, 0x5E4A03E85949B814ull, 0x78CEC26859870EF7ull, 0xBC797E30737DE74ull, 0x2DAB9DAF48CA47F2ull, 0x3033818510224D0Bull, 0x486DB3DF72E2EA9Bull, 0x18E52B8714A2CA02ull, 0x73E8EB5716719DAFull, 0x7EC0B3E92E173876ull, 0x6C81F5F076487498ull, 0x7AC1A05857AD52FBull, 0x7F9908FC53CEE2A7ull, 0x7874A359222D6B0Cull, 0x4D71C8B423CFC6A3ull, 0xEA2D8974FEA51DEull, 0x5793441E6CECDC7Full, 0x293409F250620686ull, 0x4673EB7734FBA1D5ull, 0x5799E4FB741F8926ull, 0x7DC5E9C707CD6680ull, 0x441D63146339DA6ull, 0x7AB0511B1D2701B9ull, 0x5AD667A96E993C72ull, 0x33989F6859971B92ull, 0x1CB074E8201A9559ull, 0x4FDF902A17721540ull, 0x77C7E8544F789926ull, 0x6B40F7E7703C8BAEull, 0x71A6043238B2C09Cull, 0x140C52510048DCC9ull, 0x89D127A6B9F9670ull, 0x6D35B94931D11C6Cull, 0x3C019CF633A9A4C0ull, 0x66CCBE42139B81F1ull, 0x27C92DE66492A809ull, 0x1B68E8712C0B0417ull, 0x2AC645B01619398Cull, 0x493205D0059CAD59ull},
//		{0x4B275FE7CCAA539ull, 0x5F33C8EB2162EAE7ull, 0x1CE53A922F135915ull, 0x38D5002714AD22E6ull, 0x7E8BF23B2415F80Full, 0x4E9AE947031F66Dull, 0x5CC8B8AB18F600E6ull, 0x707AD3366565CB25ull, 0x49597565DB08C7Full, 0x1736E7914097344Cull, 0x115A313F7E03A5D3ull, 0x5432B63E39235F25ull, 0x62964DDD6F9B9EAFull, 0x652E633D0D5C938Dull, 0x5B4D83C2E60690Dull, 0x12F940E60A674E3Aull, 0x2B2B0E46722D09D1ull, 0x2BCA3921481048D8ull, 0x214062E6649F3949ull, 0x5CBD6BBF1FCC5521ull, 0x8B5315861A71A53ull, 0xFFE4B8E657DEA03ull, 0x7A9D1B3900791EC4ull, 0x4AE3B5287F32B28Full, 0x5E29AB44621A9CB9ull, 0x3FC9E6DC6F83DC83ull, 0x601E428D13FC9D1Aull, 0x28A73BA942B4906Aull, 0x3983BC90DD59EE6ull, 0x501123F7094D1405ull, 0x3C3607F3630A64DDull, 0x13B462406761163Aull, 0x55376EAE3F7E9B61ull, 0x2F715F127677D194ull, 0x241DD4AA0C2ECAD1ull, 0x164426B52CD30602ull, 0x6DD5E52526427243ull, 0x1250F0056873005Eull, 0x26BB91075D34A52Dull, 0x67A5B2EE04E53C4Bull, 0x3F4F41E7276F99CAull, 0x746918CF1F6D8474ull, 0x3B6C36E41D105478ull, 0x622214DE3F0472ADull, 0x2AE5F35E323338D5ull, 0x485186B3671BFB51ull, 0x153D9DB25C05E8F3ull, 0x4E7D118B6A750C60ull, 0x1B8484547DEE709Eull, 0x60ECDDF43FA258FFull, 0xA1D3B6F773104A9ull, 0x6C755F0177F32094ull, 0x1D7376EC7EC64F07ull, 0x606620F3442F07F3ull, 0x5BFAF434480BD3E1ull, 0x4914443F1B4A361Bull, 0x6F7B6DAB3D7D5D0Eull, 0x3AB7BA8F2AE7A48Full, 0x5A8DB1861CD9CF6Dull, 0x69EC173C0573A4E4ull, 0x4F0D0842323D9DEFull, 0x6C8FA035644AA5F4ull, 0xE4386E23B0CB1C1ull, 0x4EBFB25429C80B37ull},
//		{0x38FB225F2FAC9048ull, 0x696A643643185DCEull, 0x26DD94F155DFC337ull, 0x3B0B7E6344510BDDull, 0x54A6123E1B719F56ull, 0x88013D130A10673ull, 0x637D733751945810ull, 0x4BEB3C8E52F8E0E2ull, 0xF11B51E06A2F71Eull, 0x7DE08571699F66A4ull, 0x237CC68B67CC9CADull, 0x6F130B887289CECEull, 0x1A0A3A9D5BA2ABBDull, 0x56D474C2284DC17Full, 0x16AF5D7E25942717ull, 0x5215CCB64FAA7FDDull, 0x5540B75F3B8030ECull, 0x12C2DDAC7C1E4C51ull, 0x115FF4244DCE5C0Full, 0x406F582E66060662ull, 0x693FFB6548EF6BFFull, 0x16A70CD54CBD6E9Cull, 0x1A83C40F62924964ull, 0x1FB64F7E2995792Dull, 0x693540821D96D4EFull, 0x1334DFD10CB2070Dull, 0x563719C0247EB59ull, 0x7F3BD5DB1F6DAC39ull, 0x5DEA971756104A9Eull, 0x47BB6DB97499F495ull, 0x7BA471B519D13A6Full, 0x4444747350E52914ull, 0x55516B5C5707521Full, 0x4D03756566B15F80ull, 0x24D5AE2E0D72CD94ull, 0x4CB765E20E15A993ull, 0x56623993635E72B8ull, 0x5AD3182F70E5FDA3ull, 0x45F0BC1C7A8967ADull, 0x1A7B76D02F25FC9Eull, 0x18203C9C2DB056A2ull, 0x3BD803AB1D83AE38ull, 0x2FF841FB3B13D987ull, 0x3CF15A720DE2D912ull, 0x1124242504ACC82Bull, 0x27CCDA80CC895DAull, 0x1E7E029A46C1421Bull, 0x5DADBEEE73CF6DF6ull, 0x1DC8943A2AB13454ull, 0x5A80CD76429E4268ull, 0x382401E827383359ull, 0x50B3EBFB0E863B7Bull, 0xA96A6112B87042Aull, 0x7F6C391E5087622Dull, 0x26106BD719E7AFEFull, 0x7FAD5ECB3E30A873ull, 0x479806913B856276ull, 0x5BB456AB7790488Cull, 0x76993BFD18A5B11Dull, 0x573219F07BD6022ull, 0x1D52794807EFEF47ull, 0x1485F5FC3BD07BE3ull, 0x4EB131627233B4EBull, 0x2F9FE9D96C79C59Cull},
//		{0x1CE4E93F0A20B750ull, 0x2F1808045508EB27ull, 0x3158EAA97FCBF3FFull, 0x638F26A23BEF90BAull, 0x2B52F82962FB5FC1ull, 0xC76F2E751636400ull, 0x7CE30FB00C2451B2ull, 0xF940C73447B1641ull, 0x47A9B4286B48631Eull, 0x3C0B5ECD3E42F026ull, 0x3EE143C417E806Cull, 0x4600504821408D84ull, 0x496E6FB35A864645ull, 0x5D110967181FA115ull, 0x4CB9FB300CB0F341ull, 0x49966B1699EE46Full, 0x16D1AA9133B16EB5ull, 0x3EA7CF96482A953Aull, 0x337D62B42236F638ull, 0x41A25F45ED05ADDull, 0x53255F9109118DBull, 0x3033BEDD021565A9ull, 0x1CB56A8D3FC7CB50ull, 0x46907BEA645F1EB5ull, 0x2B102E6F029BDAB8ull, 0x22A20EDB2EFE42ABull, 0x441A5B2468A25F24ull, 0x503ED02F0D88CAD8ull, 0x4328A5692D4FD997ull, 0x25A86BED0FE2A099ull, 0x3A00CCD82A41D29Full, 0x7981850850D27769ull, 0x5DF341543829549Eull, 0x18FD0CA31170A409ull, 0x5A604AD61D173297ull, 0x7040FEE65F92A0D0ull, 0x2DA84B722074BDC4ull, 0x61A806794A5DB5FFull, 0x603C891428388264ull, 0x2EBCD4B40B4CB783ull, 0x2AD45D1C515EE390ull, 0x3A4AFA2E6EEEB840ull, 0x3A0142B40A89CA5Eull, 0x7C7783187D29E81Dull, 0x37D9A3F5221FEF06ull, 0xD0C88B671DA70CDull, 0x4C61C1A5068E0DBEull, 0x42ACE8362A5502F9ull, 0x3EB7625C5BA9F4D9ull, 0x3BC5A7021917AD32ull, 0x78C127702C06A5E9ull, 0x78AA4E02266972E2ull, 0x4C7B63AD5A52547Cull, 0x70C728E12CB7ECC1ull, 0x28AD6E01F83FD95ull, 0x3804A4452D5F33FCull, 0x70E2E125724F9E73ull, 0x1C4DEC3C2AE423D9ull, 0x7CD968D118C56F55ull, 0x280E0BF634B30CC6ull, 0x3AE55E5B351A94ACull, 0x268D7D9307472000ull, 0x3BA8A26A693A65C9ull, 0x319C22F97A6004C6ull},
//		{0x44E45AA26D61C9FCull, 0x1377B1F93DA58212ull, 0x19686FE50C21FFFBull, 0x640EF4F465E3D392ull, 0x6674547754D61DD5ull, 0x129BC05368FF2B57ull, 0x745A1B6B4AA06498ull, 0x165E5F53653CFC90ull, 0x3CF0030C32AC4B90ull, 0x1021206A39C96BDDull, 0x4B71BAE5382F2C60ull, 0x6E7C78A406571940ull, 0x6D49C10D1509F637ull, 0xD9E394028F26377ull, 0x7E445C013F3A5C39ull, 0x2352683E4328B6A3ull, 0x2C9C263536CA1A37ull, 0xCE38B64604961Aull, 0x42EC1A3264DD2DAAull, 0x2BE869AC29606EAAull, 0x39B34B803E842A00ull, 0x125F9A012E0D66EBull, 0x9248E9828BDF955ull, 0x134A637B461491A4ull, 0x5B6A44E5236B83E5ull, 0x7FDDFD8226DBFFCAull, 0x5B9AB0466E5A7626ull, 0x2D33190A48E47153ull, 0x3646C5D3AD1524Aull, 0x71D6D4CA01A8C85Eull, 0x7A0BAE8315293D08ull, 0x44D17F0226A7D4B9ull, 0x4BF3573F459FB7B8ull, 0x6CAC6AD30EDF7172ull, 0x2A7CE5621894D480ull, 0x383FE01C643030E2ull, 0x5718FE804A9F7A1Dull, 0x123D97CD603D8D18ull, 0x735D73722587FB49ull, 0x26521EBD4EC7B857ull, 0x48F37F2E26301C3Full, 0x75A3B821248E2F74ull, 0x148A926522D6D12Bull, 0x6D72A0C717EEFEC2ull, 0x5DA823755F497592ull, 0x1997C72157B3D1F9ull, 0x7472B29A5E694623ull, 0x7E5BA6B2406609DAull, 0x2408FDDB6B081185ull, 0x4F457B4C4E85E33Dull, 0x39CE60507855B68ull, 0x32B614205AB5E485ull, 0x5224D58544F3ABEDull, 0x3AF3719E458248F8ull, 0x6A7BA7366145905Bull, 0x144A014F336F2665ull, 0x775AC9A09EDB971ull, 0x57FD55D91C003EFFull, 0x2CC48A9C456FF6A1ull, 0x33EF3DC10A6CAE12ull, 0x24B96C334D8704E2ull, 0x6220800B192C1ECDull, 0x2BF04B05607C26BDull, 0x599228A74FF948E0ull},
//		{0x4B84384228D7A3F3ull, 0x1E7F2C1E4F211E48ull, 0x305CFF5B5135403Eull, 0x29D702CD0281D4E1ull, 0x1628EC2B64CA746Bull, 0x48041DD900A49362ull, 0x461004C65C4E1F28ull, 0x3413B9C74D85B160ull, 0x663BD8990C110FA0ull, 0x6985F05F13006336ull, 0x518106411D752E21ull, 0x1D6D1148763A7274ull, 0x6AFC33037F8D9153ull, 0xF66914216EC7E09ull, 0x6009B81068F8B9E9ull, 0x66E5C6E92B8DF052ull, 0x11D05DDD0564F307ull, 0x7AAF0E9A422D5D38ull, 0x569A334524861168ull, 0x44AF32196CC31F71ull, 0x95085D30CB34FF2ull, 0x6D67B2D34F608A9Aull, 0x69016F1B217B6C9Aull, 0x1CE63BFA4F3D47B4ull, 0x2D8C7C3A066C2C5Aull, 0x623DAAEA7F0D827Cull, 0x23E15A7B7FAABC32ull, 0x7547F4F00EDD8D7Eull, 0x7F384D8504AE8632ull, 0x25CA0B875F420595ull, 0x6DA7401C0CAFD271ull, 0xACFF5E87F779DF9ull, 0x1214C578057F0482ull, 0x41A4FB3168AEF8BEull, 0x2A0515EA06542D4Bull, 0x5572182F33559BBEull, 0x13077D3D42D9CB02ull, 0x2B626587C08EC58ull, 0x6455379C1F9C6252ull, 0x4B46340D11E1B3D6ull, 0x26088EAC2D83DEF7ull, 0x10EF365249E9E927ull, 0x2D2E9B2A06372B43ull, 0x58C776A62C66E8AFull, 0xAE5B1757E91822Dull, 0xBA8EE45788CF191ull, 0xB41549E1678E42Dull, 0x78048F8A1D561A17ull, 0x1BF7E8AF39A98ABCull, 0x60512D545FCFE9Aull, 0x3FFDB8075B772B04ull, 0x79529A5853053544ull, 0x1E50F6067C08C0B0ull, 0x4F0E219D02A62DA2ull, 0x1BA523021A5455AAull, 0x1487E17841ADB1AFull, 0x47D834A1257717CBull, 0xB979AD67506CFCBull, 0x2BAE430E645F117Cull, 0x216DB87B3693F483ull, 0x62F093AA2D16A6C0ull, 0x2F20E6156E31E848ull, 0x438F8AED2725759Full, 0xB88025F5F87739Cull},
//		{0x60CF005B118D1534ull, 0x2584723620CCB862ull, 0x6D0440381ED70C8Eull, 0x73D1EDA70B55363Eull, 0x1ADFCD3E42E00F44ull, 0xDFB63E03684F041ull, 0x5D3464EE22834559ull, 0x7832A1F0250C998Full, 0x47FA5D2403CA3CC6ull, 0x1A13695B73A8A032ull, 0x68294E433B8121D6ull, 0x2A3C94B54B19E1EDull, 0x6897C896595D7ACAull, 0x394BCA352C275383ull, 0x82F06A44D3CC95ull, 0xBAEC71F6151F0C5ull, 0x5660E1C931333956ull, 0x21EA92843652202ull, 0x500A45E475F096CFull, 0x4EBA58406AEA1323ull, 0x38D0A6135CB5BC21ull, 0x216F036416050B01ull, 0x7F39017A19A1A554ull, 0x3B11A49047335E9Eull, 0x1D6BE21A55250DEBull, 0x3ADBFED00595305Dull, 0x10A62FC165189385ull, 0x50AF124A793DF857ull, 0x3E760E5009FADC80ull, 0x25654BDA3EF8FEBAull, 0x4ECEA915311412FAull, 0x204AEF7F252F8ADEull, 0x62474C50226998A7ull, 0x6894ACE032519234ull, 0x185A2F76374F0521ull, 0x1D3BA557512AD589ull, 0x1404C1423EAAA8BBull, 0x672FE08A133DC2BCull, 0x584C4E0F2241851Bull, 0x5A71215A75B8302Aull, 0x77669306154D202Aull, 0x7B4D6087080CC2C8ull, 0x7A65B3AF4BFC72D2ull, 0x14ABB1F38DBC1FFull, 0x55F74F5226B006FAull, 0x77D4C0B924C5F867ull, 0x57C419F4181FB039ull, 0x49F583453A0B6644ull, 0x3A8948E0328A3026ull, 0x6C5CF87852E37857ull, 0x69D9354709989DD0ull, 0x240E4DE07DDDF689ull, 0x4843468B0B3E2E6Bull, 0x111BB945208F949Bull, 0x2D7FB3866B8CDA9Full, 0x1647C4C524E6468Cull, 0xD9FAC91195254Cull, 0x2CF309547B3FAE78ull, 0x5D91981E2E3DC474ull, 0x341B70783388E770ull, 0x54EDCB6E2BF03131ull, 0x584EDFD72CB1E562ull, 0x440FE16A2244631Dull, 0x66BD4BA67E992A4Bull},
//		{0x54CE9343531A441Eull, 0x517CA2A23EA7C88Aull, 0x5CB2E1EE758AF082ull, 0x3C85BF1324F6287Aull, 0xC91EED4DA17858ull, 0x4585BD152E48D273ull, 0x392E52F75BCD81DAull, 0x532F19003A084DC0ull, 0x6D62A72600222254ull, 0x3547FC384AF43F45ull, 0x2E5FE6C869636CB0ull, 0x7E7D26B5034DB236ull, 0x15539DE256CC068Dull, 0x2FFF979859637F4Cull, 0x791069AA16BCE33Eull, 0x57FCA9974DDEFCEDull, 0x69D7275D29794C39ull, 0xC86C577468A094Bull, 0x1F043CBC490C848Aull, 0x6B8031C51FCD5BA9ull, 0x16ADFCE23105EEDAull, 0x4E162E1D4FDC4FD9ull, 0xCD370B42145471Dull, 0x9E49D997A3617DBull, 0x216769713F2C99D1ull, 0x452A57204FC7503Aull, 0x2890068243A77DD5ull, 0x531502703DE3A464ull, 0x1A73846203149A09ull, 0x174723B01383EE0Cull, 0x19D17D476F43CD48ull, 0x6162EAF903A8A4A4ull, 0x18BD19816DE9B070ull, 0x4A32ADF037C1563Dull, 0x36F634FA35B2DFB5ull, 0x578EB1E74DA431DCull, 0x66B8CE9025A4E004ull, 0x1D8081B5738C3F44ull, 0x46EA272127651F4Eull, 0x6DC2571F68519092ull, 0x6691B92032ECAE3Full, 0x3818E0CC0F21BFA2ull, 0x76942C150B2DE33Dull, 0x4D0564061107B077ull, 0xE427D46644C87B6ull, 0x248B9E842813FA8Dull, 0x539054FE05EE897Dull, 0x2BBC9F326C4D6E80ull, 0x73D839EE75EF4D22ull, 0x240EC4BD2ACE6EE8ull, 0x2BA22CD77B9D76A4ull, 0x7872A0C5125AFB67ull, 0x214256A815F3227Aull, 0x5E73AAC682C7DC9ull, 0x3D5841C973A991CBull, 0x507E0E5C23E9FAE9ull, 0x2696400B0896EF28ull, 0x330BBA8B1D2A6C20ull, 0x13C4D26500111E91ull, 0x2E321C9722074FABull, 0x645DA64752BDBB1Bull, 0x4A1B4A3937EDFB46ull, 0x58AC449975D7E96Bull, 0x243B69C64C847E87ull},
//		{0x6BC7368D484A2E83ull, 0x7752ED6F17696364ull, 0x43E7A5286FC58E34ull, 0x29C45ECC6529FBD0ull, 0x5B8B0AF2FAB9978ull, 0x4D56799A4310F278ull, 0x23552B431DD487F6ull, 0x66FAED6149EB6B4Eull, 0x266B771E1A06A7ECull, 0x6715D76E3A304984ull, 0x1A17C67D1547F406ull, 0x5C37992F7E756CC4ull, 0x6805AF212652E368ull, 0x3663680A40B1F3BAull, 0x1C2ACCD35A9ED1D0ull, 0xD36724107F20360ull, 0x22E9005404895FB1ull, 0x1F5B66C566D0A57Cull, 0x744EEDE5491FC591ull, 0x4BFAA14C7A079E94ull, 0x78CB5F0919511AE6ull, 0x3D18910C1C208A4Cull, 0x3725A2DC24137E6Dull, 0x660BF59B5D9119FBull, 0x3E1A26594D21CD09ull, 0x17C1637F5831ECD6ull, 0x6269C10F73F8FCAEull, 0x56A7599B4A6F7031ull, 0x1A4BE0170D0AC1A5ull, 0xB2163EB3676ACEAull, 0x67A993761857D62Dull, 0x3E68B04B0A9293CAull, 0x1CE135DE5DC41710ull, 0x71633946113023C3ull, 0x26E3DCA13D5DDA92ull, 0xB37C2581FAF3BAAull, 0x56AEF57948505364ull, 0x3BCFC5F60DD49855ull, 0x6C63D1D221DBBB91ull, 0x6B65B2502A7DF82Bull, 0x6EFD889B032715CFull, 0x2AFE502516749AAull, 0x7720127E59573E9Dull, 0x1BD6B9DB116BF295ull, 0x6662004226F81DC7ull, 0x47E29F7F4E0B93B8ull, 0x3F4FF3F4064B4FCAull, 0x589E27825C3129D2ull, 0x640F66DA4A0160C8ull, 0x6D614D950AF3437Bull, 0x75F3B5B78990FEDull, 0x2AA27F255E0E30D4ull, 0x40E963526672451Cull, 0x6BE2C9292D4D3524ull, 0x84E00AD57487B7Aull, 0x57CB2D4F774B8948ull, 0x5A6F91495A7B1251ull, 0x48B2D2F3518FA3C7ull, 0x33D250EE64898CCEull, 0x62FB965C1A345131ull, 0xB81AA952ADE35DCull, 0x683FE4E94AD19E89ull, 0x312985A640DE0C6Cull, 0x2702C85B1538EC81ull},
//		{0xADF6D34146415F1ull, 0x202C2FFC123EA88Full, 0xCFD25DE4ACEAF22ull, 0x704CD9634DE68930ull, 0x3140F43E5C2FA28Dull, 0x7B33BE54398EF4EBull, 0x33781E0752FEEBA4ull, 0x30DA7E340DE7AF50ull, 0x2D79FDF5798D5127ull, 0x5F775318614C4EE4ull, 0x5E16DDF54272E974ull, 0x7B80A0156998888Bull, 0x6D511F5063C084FEull, 0x346A27141E7AA4F7ull, 0x249E916A5B6CEF70ull, 0x33B391782F7DFE9Full, 0x6FD1056153DFC174ull, 0x41BCA72E7CCE2B3Full, 0x1EAE709632098092ull, 0x4AB4B4704FEF64D4ull, 0xE39231F45E872C4ull, 0x97E59C041B14126ull, 0x18E75E683A58D7F4ull, 0x4F98F07646615C5Eull, 0x33E6291B2F10438Eull, 0x27ADAB4211FD0710ull, 0x71832D03232E4B57ull, 0x7B958F9B5ED44C53ull, 0x6EED0552FFFB6B0ull, 0x7D4EF14A2B8D61C0ull, 0xB6CA620310282C2ull, 0x5B0B605F7B3DAB81ull, 0x4E244371CC8078Dull, 0x780BD6C02390B4CDull, 0x4ED1881F42C08B30ull, 0x738019A25D0AAB3Eull, 0x8A8FDF57CFE7362ull, 0x1EBBEC6421905C5Dull, 0x37574B566E54DCDBull, 0x67F1B8BB6B3D7471ull, 0x1D6520690F9F63FDull, 0x7D3A7B810EE84D6Cull, 0x32CDAF5478D00B1Dull, 0x6DBC99C039BC7FAAull, 0x28CFC1CD6B0B8B0Aull, 0x6549E16A343C67EDull, 0x1C0E0DCD405541C9ull, 0x2F7A136E20F05204ull, 0x5D1D49562785EA2Eull, 0x448106D12BEED176ull, 0x6A46755F38012073ull, 0x8F97CB472EF7354ull, 0x34FF93D527B56919ull, 0x147FCFB16C56DF2Bull, 0x160A45F47C71886Dull, 0x5794539C336F665Dull, 0xC10EC6A54CECF1Eull, 0x4257B3CA3EDE9BBFull, 0x4D9EDA3B30144D8Aull, 0x789B1B69766E9C08ull, 0x1B1FD8945DE4FCD3ull, 0x2AAB03F5372DE661ull, 0x1E3A3E9C5A251763ull, 0x581E38657B5787F2ull},
//		{0x1AB01911C9F3F37ull, 0x274659686BF176F0ull, 0x54A05FAA303FD61Dull, 0x5EE0EA44099FF380ull, 0x57F53F367360B9F6ull, 0x75F6D2AB6DFF852Aull, 0x6FD242634D8B2648ull, 0x216EEB877BE32ECDull, 0x2259F56663C69F51ull, 0x3AC1CA8C6FF8CFA1ull, 0x13DAECDB335CE5F5ull, 0x66676BA92EFAC570ull, 0x1141E2C811126F9Eull, 0x6628ABD12F7C2164ull, 0x6B3787013E46E437ull, 0x2AD3A9576CE28892ull, 0x5AE6236E521A02BFull, 0x58D3FF832F868318ull, 0x259D8DC37B4E9C7ull, 0x392676985A4F1812ull, 0x2B15A3BD2F1D4944ull, 0x484E9D3C1AE7E620ull, 0x7CA86F8C69BD88C4ull, 0x16CB14EE1F0264F2ull, 0x4D842815518CDF7Aull, 0xEFB3493615F14F1ull, 0x4E9C5707562A03Cull, 0x1059DA61162BA838ull, 0x6750FDA76828632ull, 0x45A7C99D71AC96DBull, 0x34C96A69707B72F4ull, 0x5E8F1F6D0FAF8DD7ull, 0x429575B337631EF0ull, 0x3F3610F044EF4E90ull, 0x6F1808B8785C8788ull, 0x1F3E66A21A2DAC75ull, 0x2779D0CC678D03DFull, 0x3515929624224058ull, 0x514A8CA34BE0A784ull, 0x4324A54A1ECEB4B8ull, 0x1D6D86FE521FD9DDull, 0x2DC9A922574C6Eull, 0x47827A191087A40Aull, 0x3882F4A74DF789F3ull, 0x70A2A3D7E2ABE44ull, 0x3FA420CE3BD394A6ull, 0x6EA631381E33403Cull, 0x4B83227E313BA6EBull, 0x55965F2C0AB9336Eull, 0x762AF57B44AE67E4ull, 0x315BAF615695C1Eull, 0x5EDC145A2A8F8BC3ull, 0x7CF65FFD13F1A6F0ull, 0x4EB1CC1B4E40ECA0ull, 0x5FD24E7411D67166ull, 0x6D0FA1587D3FD572ull, 0x63F64B436D3D6B02ull, 0x1F9721E12B78C55Dull, 0x7DC50F0C581A1688ull, 0x79704F5004CF3949ull, 0x5644D4CC3914701Full, 0x40A2CDF044EB0604ull, 0x5747B05B0C25F06Eull, 0x7626ACEF2CDE0F87ull},
//	},
//	{
//		{0x16DF23DC6C51A26Bull, 0x718C776C19F4DED2ull, 0x1BAFE8950688BC6ull, 0x44846A957EB15E86ull, 0x645A32B6133636B1ull, 0x4CF24B26442C812Aull, 0x250CA8173A01EC7Eull, 0x416C569C0902F35Aull, 0x273F57806103787Dull, 0x347BB8B72504668Dull, 0x391D8F052DEC0808ull, 0x29D39FD60F6263D1ull, 0x670078276A766DC6ull, 0x544D69D53E482882ull, 0x769C5E344A7416C5ull, 0x6B2638090D7B8210ull, 0x36C5B9305CB2AF75ull, 0x277060E33880B7B9ull, 0x2D1B3B3B6BF4CB78ull, 0x3732163F11756DF1ull, 0x7F2B022904246165ull, 0x55A1EF1B2437AA40ull, 0x3E264DE3170E45B8ull, 0x2D3A9D9B6565A564ull, 0x7811BE3561B65652ull, 0xA6A0BF1312F4D3Bull, 0xFA25E5A343DABC7ull, 0x4091B10C76A2D681ull, 0x1EB4198E14DF1AE2ull, 0x34EAFF03155077C2ull, 0x5F5331A72011370Dull, 0x22CBF9D31618EAD7ull, 0x7CC3E6824A3C5AB6ull, 0x4E99A29029DF21BEull, 0x3631262E05CBB8CFull, 0x3B548FAF355C2858ull, 0x9F01A3410F67ECBull, 0x5993D29848166817ull, 0x2804C48306CE7033ull, 0x2D7C0D7B201682B8ull, 0x6884C68637E6196Cull, 0x5145CFF3782724E0ull, 0x6C23C53411D78100ull, 0x6EC9FB620AD7DEC2ull, 0x26B69BE223B4FA65ull, 0x202856840609CD89ull, 0x43C6317242F45057ull, 0x1C22B860408A17F5ull, 0xD30AB0D6ABC5AF0ull, 0x6A6939B34361D13Cull, 0x708813BF25BDC962ull, 0x78BDF9947A782DF3ull, 0x36B4482D5251CC2Cull, 0x428E960A5EB90CB0ull, 0x59203C60700AA386ull, 0x7ECF8F6941A502E6ull, 0x27F0BCF250155F5Cull, 0x39CC27C614148226ull, 0x61ECE05C28962328ull, 0x1EEC60E808A37C3Eull, 0x4C4B1D8E3F14B76Dull, 0xEAD49C710114F00ull, 0x20907C42AD00227ull, 0x509B66F50F39B2D2ull},
//		{0x158C5D173B04A0A8ull, 0x529B840E061470D6ull, 0x60C26A0B4B597DA2ull, 0x8C9EC91776B238ull, 0x1DAB49CE431B34D4ull, 0x762FBEE976CB862Eull, 0x3325D85A74FF4E52ull, 0x387089145B16954Cull, 0x4514ADAE723CB0DBull, 0x6F2B177327018E0Bull, 0x1AD2D4030E17785Bull, 0x2FA50A49671DF191ull, 0x4D2C2FC83E525411ull, 0x772F40924F35378Dull, 0x6922563847CAA787ull, 0x5E6EEA5F7EAEB350ull, 0x2CF4830310A6E6Dull, 0x4C324266391B23Bull, 0x7C63EC0F054FC2F0ull, 0x7B0864731A0F35DDull, 0x486AF7C47138235Cull, 0x10DABC0C7B90D01Eull, 0x663771AE494B4520ull, 0x56A7656A2B4C1F5Dull, 0x3B87F5FB45D27CDDull, 0x524DAD68565AC9FFull, 0x53E9F53901F2B7B1ull, 0x3D78BB9021162501ull, 0x40450BC234A7FC22ull, 0x704B5C8E296761FBull, 0x7C72A3AA4EBA46EDull, 0x2816154B7F41EBDAull, 0x7FC4B55A2CD93971ull, 0x62D39E157C28A169ull, 0x3228FC615DDC0288ull, 0x1637D7477A93F425ull, 0x4F1425E527129353ull, 0x7624C443354B9793ull, 0x705DD8734CCC29AEull, 0x6097B6F02BE5CE6Full, 0x129EA68B32E56458ull, 0x240986E66889BC4ull, 0x34D81C0A3FB953FEull, 0x79EC0C6751D27CCull, 0x7461502177EA1D54ull, 0x1E8489C770D3F3CBull, 0x46A46442469A9F12ull, 0x7015DFA54669199Cull, 0x7373D88452E97DBAull, 0x4291BB06259CD4E5ull, 0x30C5804258C9924Dull, 0x2030C90B7FD9A627ull, 0x7FDC25A016558D4Eull, 0x35253DBB7039FE13ull, 0x6321B6FC15BCF4ABull, 0x1C1FCC8275C05D88ull, 0x48A259041E6064F0ull, 0x5C48F94C7D7A750Eull, 0x5E19B8EF63E7BA12ull, 0x72979CDA527B0910ull, 0x5BD1D767111C26A2ull, 0x434EFCDB22763BA9ull, 0x57B6C5B43364DC80ull, 0x68DF55454B2A9E38ull},
//		{0x64E5A3A2B71104Bull, 0x70C7731E3713DA7Cull, 0x43AA29810F83C29ull, 0x36ED80A40416C838ull, 0x274DC9776C12BE5Full, 0x7450C64C0A6F8074ull, 0x1CFB30A107092CEull, 0x2FDDFC4A720C0Eull, 0x2ED0F7BF5C78D748ull, 0x47EC811C0CEAB0AEull, 0x4060915B3A841DF7ull, 0x5F65B9BE1C3268C2ull, 0x4BA0449922B4B699ull, 0x3EA8A46B23570A4Dull, 0x561993192787F9B0ull, 0x6E81A8865C67ED53ull, 0x52F909FC5F491BA4ull, 0x137BC7CF5733AC94ull, 0x704157CD4A694873ull, 0x5B4A74CD178F2144ull, 0x367C06D24F9B3B19ull, 0x21FEA1B8384BB9DDull, 0x600BCDE7222E7FB4ull, 0x2BDC5EB0EDCC5A6ull, 0x7EA756FD4AAA4708ull, 0x1BC776543F07E858ull, 0x52E64FF7B2D3012ull, 0x5B3A511A50CEA998ull, 0x1DE1E6AB19E2F585ull, 0x7425B3E573FB79C4ull, 0x416AEF3562A75C6Bull, 0x506367171463F931ull, 0x41F0780F63DF2EE7ull, 0x6B97A5C63231CFDCull, 0x2E48775A46E21A93ull, 0x49C0F12164C47E2Dull, 0x167D55AC6BBF92D9ull, 0x1D10380A76892393ull, 0xDEE128E1FCDFDF5ull, 0x565E93A0C95698Bull, 0x6A7844FD212D5F8Eull, 0x4B9D51E36FA6A9FCull, 0x1C5A8FA126D7A2FDull, 0x407553943A3C764Cull, 0x40BA9882349B077Aull, 0x2E37F011022587B7ull, 0x174263E57E9B5728ull, 0x168980E95932DBF5ull, 0x627A860F022126AFull, 0xB64ABD110C2FD6Aull, 0x4903414255259CF2ull, 0x75877B975F8096EEull, 0x40E52FCC1297B3A1ull, 0x5609BA814ED3425Aull, 0x3265B1965B6FA3BBull, 0x5B68ABE51CDDF694ull, 0x7C9D034A2705FDC8ull, 0xC84A09018F792EBull, 0x4DDDA0C54CF9F425ull, 0x533409370E983947ull, 0x194FB9F016BF948ull, 0x10BDC0FE18D75F84ull, 0x75071274741E7ull, 0x720A3B796281D680ull},
//		{0x296868967D6EE74Bull, 0x7344D3EA726BA9D8ull, 0x5294843D68CC4F81ull, 0x51EC40C61379B409ull, 0x7B64032227F5FB48ull, 0x624CF6632DC9B4B9ull, 0x3659F033DB5A248ull, 0x4AA7AB4D0002A24Dull, 0x64BBA010572C4BDDull, 0x18FA3538329940D5ull, 0x242640026C2E3E70ull, 0x41317A1C25BB3BA1ull, 0x6D9A37B851EF3B1Bull, 0x3E929B266DA18829ull, 0x79367D02309CD69Full, 0x50235EAA229EE599ull, 0x2E0BBDEA43683294ull, 0x150A8F7100A04228ull, 0x2C34821666F6D038ull, 0x1419F63127988538ull, 0xEECCB807666EC95ull, 0x556239F112526A83ull, 0x341C8EDD2009E53Eull, 0x12550CD118D82EEEull, 0x7736311C2B4F4209ull, 0x4B716FC31B5C711Eull, 0x177D80790CA2E9E0ull, 0x4117ACC00517B832ull, 0x5E9224FB7FAA47E6ull, 0x72B9405B57C8A1FDull, 0x30471E8542DC9F05ull, 0x7A6787965E52DC70ull, 0x644D19A0F721708ull, 0x5EF31E98327953B0ull, 0x7668E740730D14C9ull, 0x5A11D8E80555B2C0ull, 0x6974015E2F7412DAull, 0x17A81D431D90903Cull, 0x4F7DF81829FD2A14ull, 0x3668BF2A46B42934ull, 0x554C6C1E01DA2EEDull, 0x62109A536CC9EC97ull, 0xE7D18CD23284713ull, 0x71E1A4C96D0F3DC8ull, 0x22D28EF9649AE525ull, 0x44D7DFC65319AD7Eull, 0x2777842A3F3F675Cull, 0x316C89EE2DBC55C4ull, 0x4EB17E64105FA886ull, 0x6035A974451A65A4ull, 0x36CBD503A47825Dull, 0x4A7018646CE0BEAEull, 0x69BB9537621835A8ull, 0xA714EEA39398D4Full, 0xC155FBC40DA0E14ull, 0x7FEDB6846161CBDAull, 0x42B43D0261FE50D7ull, 0x4E2BB872513155CFull, 0x52697EA400D5D3Bull, 0x3E40939827F926E3ull, 0x24A842600318735Eull, 0x7B12D4614C1FC68Bull, 0x4257DABA2C7F5E50ull, 0x79DC1C4F1109591Full},
//		{0x3CDF06D65A11C5C4ull, 0x5623BEC3404BC426ull, 0x145948212093D728ull, 0x2D2C82D57E14DD58ull, 0x2AC0CD0379DD1BFull, 0x374E6AA70EC16C8Cull, 0x7877DFD4373C212Bull, 0x702338673B2C1CD6ull, 0x193A72023E4EF0D9ull, 0xC5D72A51E6109ECull, 0x7E5C4E144A9E063Dull, 0x465A30CF23049075ull, 0x4DB6799B416D0531ull, 0x6F245700100E5456ull, 0x6DEC63816900734Full, 0x2117AD752ACB6A57ull, 0x43123913773B6C38ull, 0x6B172E7E576B8134ull, 0x17CF43601843B153ull, 0x55805E8C1A7B5030ull, 0x4FE183120CCEC934ull, 0x293CBCBD485962E6ull, 0x440AEA5F195FF524ull, 0x3857FBC5D455C62ull, 0x57AEE5FD0FE2F262ull, 0x7BA6664E560B3411ull, 0x5A80F89F4200971Eull, 0x790FC4862837723Bull, 0x36D9C4F68341B86ull, 0x3845C6917159FFD0ull, 0x51348ED6595D7406ull, 0x1C256A271446C7E9ull, 0x5098E03E073C98A5ull, 0x6BB2491E6868239Full, 0x1F8049F84132A7AAull, 0x2E373CF6F61CD0Bull, 0x4E0170DE2C20308Cull, 0x37BB2FF1120C5B3Eull, 0x458025B03B40AFAEull, 0x6F51B7A01D2F0BADull, 0x4B23A2106AF81DEEull, 0x733A3FBF25A49AAFull, 0x2CF8B50C6C4A0445ull, 0x4DDC0CEA3066515Bull, 0x547E1FCC0621D37Bull, 0x21C0512B25B2AEA2ull, 0x5F7F47813DE5BB53ull, 0x39F9768B301827C0ull, 0x452253F825ABBFA9ull, 0x18804B5F64A29DF1ull, 0x66DE67541B63BF2Eull, 0x54046AFC34DFD832ull, 0x4783EFBB0BBF9AEDull, 0x46EC33700D04156Bull, 0x47004A9B363DEB10ull, 0x2A3321191223ECABull, 0x213608FF1D6D60D8ull, 0x37C8875B4E2EBE0Bull, 0x9B7651D05A49445ull, 0x7E950F675E3584E9ull, 0xBC667C120556092ull, 0x3E8338B6B45AF42ull, 0x5E3B1BE53DE1AA17ull, 0x1B5DD702235D6FDEull},
//		{0x638D69C033DE2261ull, 0x8000DCF4A6BD114ull, 0x4F41E1905C0478CBull, 0x7F4BA94716C5D14Bull, 0x67C413B84637DCB7ull, 0x23C9E6B62EC45E54ull, 0x7C75C7C84DFD07CFull, 0x40E84AFF1DABD0C7ull, 0x6B6A68A778B0D25Aull, 0x6BDA8ED27521CDC5ull, 0x7E5566A06A6F9E39ull, 0x535752AE0A1BCE61ull, 0xAC4FECC573F863Aull, 0x75617DA369001AB1ull, 0x1521305110BF54A6ull, 0xC5D8A8F78AE9A11ull, 0x449D7707145D985Eull, 0x431A6B2613DF5897ull, 0x706211294266146Dull, 0x2AA529E2582624E2ull, 0x89DF1244E6F1099ull, 0x6EA83360513B8ECull, 0x1C6C186847D2CE35ull, 0x22BF89B307D68110ull, 0x4083A0900E9A1886ull, 0x7CF84ED53ED90730ull, 0x7909B6BF504FA183ull, 0x48F4D59103CEB58Bull, 0x278F27BD3E565334ull, 0x6CCED03D3CB0580Eull, 0x4F15A7DA792C5ACCull, 0x355EF22013B31EE2ull, 0xD89F32B78795D46ull, 0x279277797DEC0454ull, 0x3ADF71B35237A15Cull, 0x56122936437D62D7ull, 0x20A6B1F55CFCAC6Cull, 0x48911BC43D12CA5Dull, 0x24CF7AA26B50A577ull, 0x44E94B6D65531B32ull, 0x79EABDFD41E19A42ull, 0x242C226272F474BDull, 0x12313BC66D20F7F3ull, 0x76C32A4839C06383ull, 0x2B774B276391FA85ull, 0x7670BB927A8CF302ull, 0x5CBE55522BCFADB2ull, 0xE4011E46A48487Dull, 0x24490AF835D2895Dull, 0x68344CD15F287CABull, 0x80A2AB93E467608ull, 0x22A5DF8228B0DCAEull, 0x1B4322746B36FB46ull, 0x65C3A70C40129D16ull, 0x5687A0BE2AACF279ull, 0x2565B84850725EBBull, 0x6C8E8CBC4991DAAAull, 0x4366D3787EBFC882ull, 0x36B2D29D3A29FDC1ull, 0x38802C05622A1DC5ull, 0x1DBBF8462EF0E797ull, 0x5CB710C77A7A4D98ull, 0x5AC095496AF722ABull, 0x64C296157F09A041ull},
//		{0x20C9AC084CF6E2E7ull, 0x5E321CEC28D3D6C2ull, 0xB3D58EF00D7FC6Full, 0x5184B37026807B63ull, 0x6C0EF7B537485A7Cull, 0x6693187A42969873ull, 0x61F54CF60BF8D0C2ull, 0x1308F72F4E83D9B2ull, 0x558AAB6D566FCAA7ull, 0x4D43A2340C3D7E0Aull, 0x1099C86805C3CE39ull, 0x6E679BCF2E55C0AFull, 0x34B4B5D14B1EAC96ull, 0x28D00E470F754B1Aull, 0x3615CF410D92A45Dull, 0xE7EEB5C56DF7B4Aull, 0x5A8987446CB10848ull, 0x7FB3520C65C6E033ull, 0x6D8904B75138057Cull, 0xC475B965997FC6Dull, 0x8805FF972DA7410ull, 0x1C2E94E06A75ACEFull, 0x7ED344D32F378C0Full, 0x38F986A1545DF040ull, 0x5A756B7063D28D5ull, 0x609B6E4A16411F1Full, 0xC00F70E4F030A1Aull, 0x4496DFCE40B5ACDFull, 0x1A21B6B06D66EE16ull, 0x502AF7FA503785F2ull, 0x7AF992735EA9E356ull, 0x2717013C558319B7ull, 0x4B5AEB9E26CA5348ull, 0x3B49F9EA38E3F056ull, 0x780258C447915580ull, 0x127BECC30082B8BDull, 0x3A6BC9912EAA81A3ull, 0x6AF865AC393F0E64ull, 0x5DE20DB323F1EC4Dull, 0xD9CFEA46389646Aull, 0x2A2F15226E386CEEull, 0x79CA838936300C31ull, 0x3D3B77083E616358ull, 0x76E5B910575D2DB9ull, 0x2BC8516E4710B10Aull, 0x2794B3AB26C1E3E1ull, 0x25BA94604EABB4E7ull, 0x7C44FD9871157FFFull, 0x7576082F378EF782ull, 0x29F970556D7860F3ull, 0x7F204D023C755D18ull, 0x6DFB19B1398C1693ull, 0x6B1FDEBB58F37F5Dull, 0x72CB24F74901EC6Eull, 0x7CE56BAB0068239Bull, 0x2C8B50D8271480CDull, 0x6EA0908A2655D462ull, 0x5D448CFE2BDC0792ull, 0x64B737BA542A460Full, 0x339354B107F8928ull, 0x1B3AF7192ACDE8F6ull, 0x37416D0940F58B7Aull, 0x79799DDD33866AA1ull, 0x320B0B796EEFA60Cull},
//		{0x6B1562235C047BCEull, 0x5C6807006A35AF25ull, 0x1879D8E64A6320B1ull, 0x23C1C5B90399B7A1ull, 0x2356A00E168CEAB0ull, 0x4C9BA410203C0BB9ull, 0x16F50E4C7926F4E8ull, 0x47508C8705959ED6ull, 0x1F7CC94A24951985ull, 0x3171A66804340104ull, 0x78BF5F9434AADBB4ull, 0x14B38A2C13FA56AEull, 0x5F78C4AA4BF4F735ull, 0x54EFE22858F26288ull, 0x7F7B61D606FAEDA1ull, 0x47E208946A90C3F9ull, 0x62FF696F244A0F94ull, 0x54C6731F7B794255ull, 0x6EAD3045788838D8ull, 0x7F12F9F61203D054ull, 0xF1523884BAE9E06ull, 0x323FDC0D260A31D4ull, 0x44D592EF79906894ull, 0x2B9FD0AA64525C39ull, 0x1E25821A5D117713ull, 0x68865D3E16E4E1AEull, 0x11BC52C77D39E76Aull, 0x2ADF385C71351771ull, 0x492EDEA07FCF1A84ull, 0x4A2779F948AA4076ull, 0x6CA08251209828Eull, 0x333B047069C97194ull, 0x365392220801778Full, 0x6542B3E92500C268ull, 0x89B0676455ADE0ull, 0x370492BC0F9ED3EFull, 0x30044BE669446EC9ull, 0x35A905C474D9DED5ull, 0x62D4D75E6148D66Eull, 0x592C3B0F00FA5978ull, 0x3E5A4D8141B2984Dull, 0x17DF3B265016A048ull, 0x3EEC7FB742BE7383ull, 0x414BB7BA081B5E57ull, 0x428D8E070B7331B3ull, 0x50C59ECE4957962Dull, 0x1D7CB4410400A33Eull, 0x332107C153D04664ull, 0xC021ACD1863BBABull, 0x78D108CC0C8BCB34ull, 0x7CB9698B2FD59B88ull, 0x1C2A9F232CBDB571ull, 0x191A0A5151D3A4E7ull, 0x219794477BEEE1AFull, 0x331C7B567AC3CF56ull, 0x7CE93B277176C8D7ull, 0x3C7667A314C8764Eull, 0x418D69207B62E75Aull, 0x5786E9D102D920DAull, 0x37E45B21A1477D8ull, 0xE4C528D5443E480ull, 0x636C0E052BC906CFull, 0x584487BE168D15C7ull, 0x7F994D336446A28Bull},
//		{0x2EF0D172786A55FFull, 0x70D26DBF2BAA3AFDull, 0x283FF1870CFD0CE2ull, 0x5867F06E4159FBD8ull, 0x5ED0B1CA79FF84B5ull, 0x3D48DD8811ED2D20ull, 0x74C3540B3A3218AFull, 0x363F5F73139BBAEull, 0x4EFA8EFD44F15F17ull, 0x2C9CA309268178CEull, 0x47CA7FF1301AE8BBull, 0x4095F0A75616D27Full, 0x45ECD3B2401FEACull, 0x1DFD94E5CA354F9ull, 0x3A8F147301792681ull, 0x40E9F784697FE5E5ull, 0x79E37C8031BC6543ull, 0x152A20E222236E07ull, 0x3EB972256D921151ull, 0x637D69DF1D8A23EFull, 0x6791960620C64767ull, 0x2F77510F5C54EA12ull, 0x5AF8601732DB4707ull, 0xD8EA5C029F2EF14ull, 0x77CCA61E3A2B48C9ull, 0x507467E33F972610ull, 0x6A463184110A588Aull, 0x15ADF88F6EA4FEBFull, 0x350C5736178DD1DDull, 0x4B4853B86F9B6BAAull, 0x1906F85E0C324B3Cull, 0x591B518F12EA74DEull, 0x3DEEB07F6E457272ull, 0x350DE2E57CA822A5ull, 0x5BD783C3188B4CC4ull, 0x1A324694436919C9ull, 0x3951942C49A997A4ull, 0x1FBE03DB1449F443ull, 0x7C84DEAB2D4CA99Cull, 0x3E3CE357745184C9ull, 0x6777F2650EB14B3Aull, 0x33E8AAD951BE23EAull, 0x1FBBA3C44996A368ull, 0x406322A954C7FAFBull, 0x612475450BAB7662ull, 0x446366A57A2B6DA3ull, 0x17DDC19E1D7EB834ull, 0xD15E28155CC721Eull, 0xBC42AA64223C566ull, 0x527494C3679BAE69ull, 0x5AAF122B6CA6DB57ull, 0x2B04C8331400A657ull, 0x365072FB4AC2CC0Eull, 0x284A9A9A32D551A6ull, 0x780F75AA66877DF1ull, 0x2726D6705F876810ull, 0x7538C92C5B0F8149ull, 0x31458BFA14F46CF0ull, 0x24A624B271A8AEA3ull, 0x69BC67EB05CA99F7ull, 0x7D5425052E1FCE90ull, 0x7FF6079B1531E6A4ull, 0x4B9E86C50D0BEA1Cull, 0x6AFE58C25762B16Bull},
//		{0x4F2FAF833D72ED85ull, 0x3EFE5FD529DEC1AEull, 0x2A19C8DC6A032808ull, 0x3DDF6805606A3BD8ull, 0x34C5F416662A029Full, 0x133F8D7E2CD569C1ull, 0x4CB180903A6663EEull, 0xC5CD1D141EA49BCull, 0x1575E5383DA25DCBull, 0x56DEB6AD3A1C09EAull, 0x2F4B0C6E409B1E98ull, 0x3FE6A3E12C9F3174ull, 0x6EBAED293FDCAB7Cull, 0x41D118183A5973EEull, 0x4CE895992CCF70DAull, 0x11BC25591C18451Cull, 0x6A425E5F50BA852Eull, 0x45F706CA145C273Bull, 0x3ABDAD3603D66ECFull, 0x74C663136F83A14Dull, 0x6A00716E0805F092ull, 0x1C590B0E36B1F1FEull, 0x426C548028B5DCDFull, 0x789C3BBB57E239B8ull, 0x66583AAA4F7AF268ull, 0x11FE43A215A34718ull, 0x1016110051E4E784ull, 0x4242788C7ED0FE29ull, 0x11C19300041390A4ull, 0x392A72175EAA2899ull, 0x30E3017E4AE69771ull, 0x7AC26DB51B255FDDull, 0x1BA11C9F40B9747Full, 0x2F818719565EC9D6ull, 0x448FE34E2447EA2Cull, 0x45E26B232E9054BCull, 0x2C4DDABE623B7631ull, 0x654246BB6EBA2F3Full, 0xAF153105DDE8276ull, 0x469C68F771498DBAull, 0x2D5974DE589AAC9Aull, 0x6ECD4D23D6F85DEull, 0x2A7F941E492F4D5Full, 0x3C4084083C41271Eull, 0x4D42DE03756AF61Full, 0x1AEB4FB87E25DF82ull, 0x40518D9015ADBD6Dull, 0x194B3F5F5BF2AA30ull, 0x566731ED48CCC678ull, 0x325174061AF7153Bull, 0x6D14B0A57833DF29ull, 0x498769F819628B63ull, 0x5A6F555A2EC9B0B3ull, 0x81CBAA26560A86Aull, 0xCA833294EB9239Aull, 0x56AA36243A01A807ull, 0x2753D0345D970AF6ull, 0x77712DE551D36452ull, 0x26C6585533B1B1EDull, 0xE148B7074093659ull, 0x291CA80D28FFDB28ull, 0x722F15DB696E359Dull, 0x3EAD98960B7A553Aull, 0x4560DFCD1514CA83ull},
//		{0x54471BB377B253D3ull, 0x300BDFBE415BCC58ull, 0x6FE632FC799349B6ull, 0x5ABE57BB4A558856ull, 0x285CFA6962DB125Eull, 0x2FB630C035052D92ull, 0x319435F8066066E4ull, 0x6F06D59958E8062Cull, 0x63F771DB6678037Full, 0x2ABB6A7E0ABDCA30ull, 0x1A29B56C38CFF5EEull, 0x7EC7008943465D79ull, 0x61CFD11770F61664ull, 0x2CB49317207D69ADull, 0x7C706B9F721572E4ull, 0x3592343050B78752ull, 0x69C7C6B8659E13EEull, 0x121353AA59ADF9B4ull, 0x5F315DA56CD1AB65ull, 0x2403820B078E580Eull, 0x4FACBDC353B9B2CBull, 0x3C9385A10140F3BBull, 0x5A1A19B02B9A5B3Aull, 0x5A28F9E73E118B8Bull, 0x12125EB904E46465ull, 0x48CF55BB2C3C1426ull, 0x3DB45A5447965645ull, 0x6F82719F1F842B6Bull, 0x388C6CA91C3704B6ull, 0x4001951834FCD848ull, 0xE4C779B7593C948ull, 0x5B45F9A78143E53ull, 0x5B31DD3617C7B344ull, 0x51C238073A633ADBull, 0x4995EAA75C5BA12ull, 0x41F192EA54461C6Dull, 0x497F6CDE7E85188Bull, 0x558710292399868Eull, 0x2A1F73C52FB00A10ull, 0x61AB12193C31D27Full, 0x34946E762A7A67D4ull, 0x686DE6A57248C8CAull, 0x7210BE1957F05844ull, 0x11CCF4352A9D2AC3ull, 0x74275CFB51CE894Dull, 0x5F9A030B0273D496ull, 0x47625295654E62A6ull, 0x7A8812E922942FCBull, 0x7D1615EA4C4A4AF0ull, 0x5CF76AA701AF7494ull, 0x421005031EE8FD91ull, 0x55F591020B8F71E1ull, 0x1D6E161C2B7CA12Bull, 0x2F28F86F478D89E1ull, 0x5B2CAB3B10D40A88ull, 0x3BF5C600FC119B1ull, 0x3B4E725C6C2D4305ull, 0x209E27B2D5F3076ull, 0x441D9B4A13D6D6B0ull, 0x57FC5B393844F845ull, 0x65A55FFD37965E44ull, 0x3AB8CCDB2D07B292ull, 0x1CE4C0EA3540DFC4ull, 0x4F9BE25E19FAD6D5ull},
//	},
//	{
//		{0x18B2AB42C934D05ull, 0x1BAA4B69439B2FB7ull, 0x4B7C4A96719FDC6Bull, 0x4F2AA19868EA60B2ull, 0x1D1C7D967E539A07ull, 0x3077EA93784928D2ull, 0xF27A48F343746F4ull, 0x80A42834A7616ECull, 0x206489F90A1424FFull, 0x77D5476264822543ull, 0x1DEAFBAF4FD1A29Bull, 0x1CC71D8803905BADull, 0x76800DF577FEA63ull, 0x30980E3F244CC1CAull, 0xCC0CA270033F09Dull, 0x3E47989F0E4BF4DCull, 0x2CC73DA259F1E408ull, 0x51E7249378438838ull, 0x4B91C0742111C62Cull, 0x612DE8EA68AE3E0Aull, 0x1F65603311A5D37Eull, 0x60F766DC2E8D04C3ull, 0x45DD1A726901A960ull, 0x79031BAF6641A46Bull, 0x7315CE5F70D86311ull, 0x4AC3C9AF1100CA0Eull, 0x40AA05AC678AE737ull, 0x149125BB4812068Bull, 0x3F0AD19B452933FBull, 0x6C5EC8554BCB9BC2ull, 0x455D24982AA660F4ull, 0x5A17909E7224623Bull, 0x49844FD2BFEB532ull, 0x6A67EA73502A0571ull, 0x4D107B5E4B95D35Eull, 0x38D8437B6C75DB91ull, 0x5D3BA6DC19CFAA58ull, 0x1B02E0542318C14Eull, 0x2D153B81405FC03ull, 0x95A65B975E72217ull, 0x4DE5F14541E2F68ull, 0x6E7EC25458864C0ull, 0x3BA916A01B7911E1ull, 0xD9A6B4C7AB3E83Bull, 0x60A245DC79F933A1ull, 0x467F83FD25FF6A74ull, 0x249F94962097149Cull, 0x1823CCAF2937D993ull, 0x4C95C9CE028BB723ull, 0x7961DF0419A6452Cull, 0x4E218A81323A227Full, 0x61C20BD2B5D315Dull, 0x4C09CCD7211F0112ull, 0x4E75F2AB4EDB208Full, 0x3524FD1557D05864ull, 0x44C242A63A035C2Aull, 0x2BEE87CD4BAA2ECCull, 0x7F8BC0EA67979E6Dull, 0x672340AD0D262C36ull, 0x624B86A847C58689ull, 0x71F5FD828CB0AA5ull, 0x6DC4F0FD2BBEF46Eull, 0x49621F4105E8BDADull, 0x54F6CE0115F7E90Full},
//		{0x87474D04E58AD05ull, 0x2F9E2E3B5695FF51ull, 0x92CF8435BA4EF9ull, 0x1F330AE4C9C9C5Cull, 0x56D9500B50692359ull, 0x1B77BCEB0BFE4D20ull, 0x28397BBD6039FF92ull, 0x4601A94A5428038Aull, 0x2BE42E5E458D6A35ull, 0x3BBFA1F713076F0Bull, 0x52B3966B1E0B289Full, 0x5ACCF59459D2F643ull, 0x46D633454891E691ull, 0x591EAB110385286ull, 0x4E7AA43E5A88B8B2ull, 0x26303B9656EF190Eull, 0x28E165B755CE69D1ull, 0x2D85185F2974353Cull, 0xB88B8CA2F78490Dull, 0x7610D198626208D5ull, 0x7FE16C6611888E83ull, 0x6E6055F6281AE824ull, 0x71C28E153461FF40ull, 0x7C42EBAE1DA6BC73ull, 0x79EF697538028DA6ull, 0x30AE2B7E4CA2FFE1ull, 0x560DB6450B7B2112ull, 0x2675F6241CE3E98Aull, 0x540D07A42C07E0D6ull, 0x2D1C3C112287ABE2ull, 0x6909988534C77A7ull, 0x7976C4F12F71FF40ull, 0x291AE17826FBDD50ull, 0x58E6347C34A39A43ull, 0x5674265E4EF70614ull, 0x1705A318565592C4ull, 0x607F94970565F90Eull, 0x7E707AE8524222ADull, 0x39C7F84F7AB36697ull, 0x6FE8DF2033B761C4ull, 0x32B5F43D20970A9Full, 0x5A61A508C3AA82ull, 0x2C122BB126D057CAull, 0x25A7940D001F3355ull, 0x52D838A052C3D01Eull, 0x22A6DF385968D228ull, 0x261047C51C1DA429ull, 0x8DAD1684F2B293Dull, 0x4319817961C105E4ull, 0x3CEC380198DA7D7ull, 0x30B80BF81AD46699ull, 0x6FE33A9C1137A090ull, 0x203A5FA76E53B584ull, 0x6379C33D5A0257F6ull, 0x69071C1B5362A25Dull, 0xDB9B9BB1BBD1058ull, 0x73F9ACFC0E141B60ull, 0x2480BADB200BD8AEull, 0x34E4732A4A284EE8ull, 0x202B0C0307BCABCAull, 0x1CEC1F0642D1EB3Bull, 0x61257DF342FC66CBull, 0x5EEF8F646A004F5Bull, 0x12279008220910DEull},
//		{0x4BC1554015F65389ull, 0x3B96B8B57C796138ull, 0x30CABA222B79F351ull, 0xDB101C8510519C9ull, 0x19CDA8D6712AC505ull, 0x2B0771C002D4C4F1ull, 0x448D676338C12B7Bull, 0x1E91D54A3887145Full, 0x46D546DB43129025ull, 0x5892ED0D7BB9BA06ull, 0xD3ADF0D78BDF911ull, 0x37665D02A26FE13ull, 0x3B8FE44C649BE3C3ull, 0x6D2364DE1A7F73B1ull, 0x4E9C331F7F4AF4E6ull, 0x3C88848F1A5D885Full, 0x1541486F781F3D44ull, 0x16D6E997460C0291ull, 0x239930962487EB60ull, 0x17111C5B3D66D96Cull, 0x15B2B06542188E1Bull, 0x403B9E5D5A4017C8ull, 0x7AD9B9965ECD73A7ull, 0x12C72C2841AF0071ull, 0x21E003CC6B5A1935ull, 0x3D68BA772F1AE2D9ull, 0x6418124640DF2048ull, 0x5941E0EC1FA7F693ull, 0x257B040B466545CAull, 0x3A276A447417372Aull, 0x45B03AB176AFEED3ull, 0xE74BF895AF18320ull, 0x6ECF2C17254BA921ull, 0x20FD85B212685CADull, 0x49D39481380EA20Dull, 0x4FCF36195F8644E6ull, 0x7A273028100AD477ull, 0x39C65CAF7500E9BEull, 0x6ED8481E4C8D88D7ull, 0x36AFEA2F10B84BEBull, 0x37E7A20C7418A4A7ull, 0x3FD32EC41BFFB453ull, 0x34F7C4EF19150FB1ull, 0x3BA7AAE65A72C8FAull, 0x5F7A557B75CF152Aull, 0x4E8A0025252A902Cull, 0x6C7F03FD5CFEBFAEull, 0x1C134D5B4E3014ull, 0x24A68CF211998FFull, 0x6DB68CC24C1DFD50ull, 0x59283B0C3D85C2DBull, 0x2BA44237534F6B34ull, 0x4D909752656A9EE6ull, 0x485054F23C68DF71ull, 0x31F827BD7F003F21ull, 0x4D212B5C69DFC9C9ull, 0x7318E3C80CF45A20ull, 0x5DF7E1C2810A8B7ull, 0x260969D141872902ull, 0x28371B20583BF4Dull, 0x37563E2C510D71D7ull, 0x2AAE4F7923D54229ull, 0x2E0C31852ACA62C6ull, 0x7F23723E30569A55ull},
//		{0x4BE3FBC56CD9FF00ull, 0x7C7497A5250C36D1ull, 0x2A5FC1DB2818D9DCull, 0x785BA20577F0592Eull, 0xD8378C240ABF6F7ull, 0x3459389F3F7BA07Full, 0x3FAC3619017A63FBull, 0x295B6A4932C519E1ull, 0xE6EBE1B2F3AE865ull, 0x5AD5C299347827EDull, 0x70C211685D59344Bull, 0x39FBE73A28184F94ull, 0x2E66A62264AA36B3ull, 0x4BED91BE5C72D7A7ull, 0xF74997A4B1103FCull, 0xCC971FC5B58953Full, 0x37EB02FC093E09A2ull, 0x64CC11624AC4D7ull, 0x3156E37E78C06E16ull, 0x5A3B1E053EDA5C41ull, 0x396C650E0E9456A4ull, 0x7E55FCC079189B27ull, 0x100EBA9F27B16709ull, 0x2BDDB5081E7D78BBull, 0x56EC4F6F06B377A1ull, 0x52F5A0A847AE60D7ull, 0x640CABEC0CF187E2ull, 0x6FC6B06B1273520Eull, 0x719BBE953BB44229ull, 0x6EE629B60110580Full, 0x6C546257BAF9BB2ull, 0x5C68ED4F3EB04921ull, 0x4EDA5545CCDB960ull, 0x20FB0DF9364488D3ull, 0x558E27767B362BFEull, 0x751EE5140EFA8C84ull, 0x9CA82A37374E1D4ull, 0x81327AB19D93D42ull, 0x1B2648DE33F0DCB4ull, 0x3856B5FD7212984Dull, 0x3AA454550B4C56A5ull, 0x39C0F9241EB10042ull, 0x183DDE872987A98Full, 0x3124525009D99D1Dull, 0x653BEBB9200A7C06ull, 0xAE9F52C6C0131DEull, 0x1BBA17B96752E27Bull, 0x2AB17B0020A7BD0Dull, 0x44209BDB4BAC88F9ull, 0x56EC45E019AEC352ull, 0x46E2B4F74C0B2AF4ull, 0x28A94FD650AD379Aull, 0x3F800CC930BC7782ull, 0x6A8674DD5AA655A7ull, 0x64AD543622DD2ADAull, 0x4CB8EDF41F51A88Bull, 0x2E2981800679E718ull, 0x3E02A8CD46676007ull, 0x300190A76F26FB1Eull, 0x5040FD24153D7C60ull, 0xF3177245B2AF251ull, 0x13EAE3F2AEB8EDDull, 0x427DD4CC2BF0293Full, 0x4B934BEB069E70A8ull},
//		{0x779CB238227F91CBull, 0x204D33FA3E7F672Full, 0x6E8ABCC048F683D0ull, 0xF2C9ECA2E0AC989ull, 0x79B2FB5279B313A7ull, 0x8B11F305E604F88ull, 0x1C903E81556A0D24ull, 0x7DB1F8144AB9C001ull, 0x5BE3F43C3BB4A0E1ull, 0x112120090BE584E3ull, 0x2ADB9BFF61621D2Dull, 0x212301443A0D1324ull, 0x3C8D0F7E2261AF83ull, 0x64F8A2017F0AE44Bull, 0x4E51D8C2308BEDECull, 0x5A954F345EE8AFAull, 0x530B7FB825F688EDull, 0x46DF22941963C78ull, 0x6EED0CBD139A90F3ull, 0x6FA1060168A00810ull, 0xD4DA49A78522531ull, 0x4700579829DDE31Cull, 0x4DBC325544B24FACull, 0x7497A31D29A02691ull, 0x66F08E05B8C326ull, 0x3585AB742B428C8Dull, 0x671AE05456A8ACB8ull, 0x654F9FB123A7EFD2ull, 0x790A5C3B4A4841B3ull, 0x22B2D41D475C34FDull, 0x7AD42F9F285C2910ull, 0xD4ABFF74DDFAF57ull, 0x4E52B1FD11B8B221ull, 0xF75EBCF3D3FBEBBull, 0x255343147F16F1D0ull, 0x25DFC6CB32A0E7AFull, 0x776917016CE01E63ull, 0x5C7ECACB45254956ull, 0x31926E1051166DE8ull, 0x6EC56FE731F95E9Eull, 0x56CF310F244B1B5Cull, 0x5D3BEB2B3DEA1163ull, 0x7AF3C814428B8ADDull, 0x6192013573FE2450ull, 0xCD3CC900444D553ull, 0x3B5A594D07A7FC2Full, 0x2CA0FE6348A51945ull, 0x5587AB877AF3B061ull, 0x5A5DCB6664FD9756ull, 0x38336F1C7FB10E7Aull, 0x641489275E1335E7ull, 0x3251F6295B7DA028ull, 0x4AF3544A0ED0C0F4ull, 0x20A2E97F7C85C25Aull, 0x5FE72EDD0F685966ull, 0x2E7F20F836B65FECull, 0x33B374C20BBB0C24ull, 0x74A0714F2EA73CD7ull, 0x4E46970156327284ull, 0x22A561275B1A6391ull, 0x5A7747D75DFFBA74ull, 0x62C25FC00718463Bull, 0x26A4D3B9384A0B47ull, 0x20BF69C01029F1Full},
//		{0x1D47A29E3A3F65B8ull, 0xB3AD9A015C2BC5ull, 0x18529B9F3305A3C3ull, 0x5CD9CBED6345EFE9ull, 0x41D664B87D7CB56Cull, 0x5FCBB24421BD9395ull, 0xCE50ED30E4AD33Cull, 0x5873F38140988395ull, 0x1A05DF604D1464D0ull, 0x6F3FC06C684C7661ull, 0x2346D75411E52193ull, 0x4366D9F27DBE1F2Cull, 0x6FE4DC08262939B3ull, 0x4D665671689AFC1ull, 0x5E7344FA06E25C03ull, 0x178C4EE17BBAE798ull, 0x4121C1BB183FFC7Bull, 0x7D17135D59745D5Aull, 0x4B45A03E59F0DF4Bull, 0x3CBA4D430D1C04F6ull, 0x576D94B71C85FF87ull, 0x2ED9988B6452A38Aull, 0x2AD0D2C4074D8C0Cull, 0x24EB272044D6B224ull, 0x5461F0DC142AE78Cull, 0x2D23288677A8C831ull, 0x26100920708A0278ull, 0x7566E75D15F4E528ull, 0x16B33C2B7A3D4CC4ull, 0x2C7E94E975268126ull, 0x11FA8C7440AE3CAull, 0x70E168BE42416A82ull, 0x5C4AE0456DF87C1Cull, 0x1BB5C7DC27908084ull, 0x47E95B675870151Full, 0x34AC857A1F56F01Eull, 0x74F614A763861E06ull, 0x3A993A91FC6E76Bull, 0x6AD3AA122894BAC9ull, 0x649D998F3F359AEFull, 0x3CBFA25511C0C215ull, 0x36DE632062CFAB75ull, 0x24AC48E2C454A7Dull, 0x78C4909D18FE00B9ull, 0x2682974125432587ull, 0xE2481DF27A24008ull, 0x694E09517F05EA9Eull, 0x69E3AA8A4598E997ull, 0x6CFE66BA05997266ull, 0x6D296A1B34E7C221ull, 0x5E09878521D5EF95ull, 0x543EB23F52FF9C2Cull, 0x55C0D9B57E845E8ull, 0x72C68397702FB7AEull, 0x7D00B157641D27ull, 0x2F65529D3D3CA307ull, 0x6924DF3C6643B5BDull, 0x200C4E7C6B6FA3CAull, 0x1289003A18D0DF1Aull, 0x46DA484390B977Bull, 0x3E1404A112922663ull, 0x60ADD78327620DF2ull, 0x119811014A91820Dull, 0x6CFAF7897E9677BBull},
//		{0x502AF4735A2461A4ull, 0x337E39DC2E347BF8ull, 0x7BFA513A07BCEC1Cull, 0x134182501565ED5ull, 0x5FA5320473FA9BBCull, 0x71861683602232B6ull, 0x4B5EB8E320EB6920ull, 0x1D5ED5BD34839820ull, 0x72F1EDD3D6B2439ull, 0x1FF33BEA19B81F17ull, 0x563C03532460E06Eull, 0x52C3B692145007F4ull, 0x36F306D233718E15ull, 0x3BB215E7488B17D3ull, 0x7E03102228AD0D70ull, 0x47218F8F4E2E0495ull, 0x2D16F157A9FC96Bull, 0x7C62808E7ECBC04Full, 0x25CB5877D9698B3ull, 0x221F246201E78Cull, 0x7191346F71A835A8ull, 0x42241A423CEFED53ull, 0x12939EC85F82EFFFull, 0x7173857319C2BDA6ull, 0x1CEE14381166C15Dull, 0x337ADCBD732A178Cull, 0x35C7A1CC063E9350ull, 0x77A1F806CBAA89Eull, 0x39B02165432C3567ull, 0x3545C07137B33188ull, 0x6BD942D87C675000ull, 0x5E1361D6EAAB1EDull, 0x7707196C0243B6ABull, 0x6D76723C7963CEF3ull, 0x7FDA4F5E6D989160ull, 0x5B65B67F716B83CEull, 0x5F40C7081D89D0C1ull, 0x2E5B712171D465D1ull, 0x7D0CC0C01FCEF694ull, 0xB97237719FAD4F9ull, 0x3135B7F13F120034ull, 0xD24EC8566FD59BDull, 0x45509384149F0C05ull, 0x53B8025B7F00B4EAull, 0x57CB416D08FDC2CDull, 0x36B3E67243A48445ull, 0x56512CD3C951C8Full, 0x324F36327C6C2C39ull, 0x3ED8D33B1FC5A86Eull, 0x75CFFB2D3EB32299ull, 0xD5E39CE5135B1ACull, 0x301EA6676C9F00D7ull, 0x6EBF826E5E7A1788ull, 0x5E7366A86BCC432Eull, 0x7E490E1C6A0A8A1Full, 0x5C718272F7EC60Eull, 0x291C8A5312EC04ACull, 0x167C1FCB6E6D1DD8ull, 0x278B10B26A342227ull, 0x6D6DD2C27F56521Full, 0x7331E4F42421B934ull, 0x42FAD6647896F7C1ull, 0x60B6D5C3754A0C96ull, 0x750323FB1F8FA8FEull},
//		{0x150FB5046AD31F28ull, 0x5E42CB98226DEED2ull, 0x3C08D0D40E6171FFull, 0xF0CEFA92AC85342ull, 0x6CDB89886D805651ull, 0x169496716B2497A4ull, 0x578AE0701C5BAE98ull, 0x1AA35DB200A76AC4ull, 0x2F47B345311F7D7Eull, 0x6F14889C56D2C3F7ull, 0x1B539FA55C825B5Eull, 0x562916160E858499ull, 0xA414921923EC7Aull, 0x71C7C5A615AEA55ull, 0xE6DF9107C1FA055ull, 0xEA9354237DAE14ull, 0x66F2BF7D5F2D5EECull, 0x45EB9CE622FB9052ull, 0x6D8ED0EB54F88C90ull, 0x4DC3E3945A6A5A73ull, 0x4278E2E164587A05ull, 0x458EF2181A03C352ull, 0xB4289E60324FCAull, 0x1AAB2E162FFBDBE3ull, 0x1151CD4809BFB6B2ull, 0x6CE9FDA2CA56CEDull, 0x664212105CF7B5F0ull, 0x3B2AF18666E626A2ull, 0x761BA26A42476DE1ull, 0x484110F704899B7Aull, 0x3E670E36492BA44Bull, 0x2807498E2559CDB4ull, 0x285903376DF2E674ull, 0x48555E0615E7D423ull, 0x42EB73041619419Aull, 0x70522E96056455E6ull, 0x7A71BBA035E120AEull, 0x1F6819387B25E43Eull, 0x161370793A13474Eull, 0x2B21C02127653DC1ull, 0x43D2FE0031F05FFBull, 0x540AAAAF2A151010ull, 0xEE815EB0F359C35ull, 0x10FB36B20503B855ull, 0x517D0A16593C47A9ull, 0x98D53CF0FE4184Dull, 0x2267EBF531949D5Dull, 0x353DE6014AC0EF2Cull, 0x1F8783D17D934407ull, 0x60A8C34F6272F6D6ull, 0x13AC85A150FAF1E6ull, 0x67D74CBC0E1E4141ull, 0x6DC1294073F65F4ull, 0x944257F1CEF830Dull, 0x4152AD423465E5A0ull, 0x4454C0CF0525AB42ull, 0x6656459B185F6B7Eull, 0x2F3ABB52753E5B86ull, 0x279507B34035F204ull, 0x7A4213DB791211CAull, 0x197239AD03CF67AAull, 0x8F62A173BDA25A2ull, 0x356405073E341018ull, 0x69B14CF54EB88D9ull},
//		{0x3BC7541F6743D81Eull, 0x375E7FAF4F73D9C0ull, 0x383ECA041F35CC6Bull, 0x5D921B023F1ADC99ull, 0x2675325F66D64081ull, 0x5C0A5FA667C7DFA1ull, 0x1B3C2622205F2075ull, 0x6CED8AE301926BBDull, 0x38BE8BF31C284635ull, 0x76D0C744605393A7ull, 0x5C5E38397112DB1Full, 0x5965A57175D071E6ull, 0x74E242CA625BCF88ull, 0x31AA97892A4647D1ull, 0x208FDFA03845AC58ull, 0x7F31D0AA5C5733BFull, 0x1F89847636905059ull, 0x2BCB0D7F57C84E7Bull, 0x55C61CC4095D2881ull, 0x16E32B147C3B4F23ull, 0x7033690372ED8ABAull, 0x64032EC40B6F8F25ull, 0x134CAB3050F0B9A7ull, 0xD01FAE24C0B3723ull, 0x6D18FFDC03D2C226ull, 0x2C5ECACA49773815ull, 0x74E59D4605C4703Bull, 0x3F47A9FC69C7E010ull, 0x68203FC370F24185ull, 0x140E27E108B01F63ull, 0x2937EDDD133FF88Cull, 0x6507532248C17253ull, 0x49D048E510D260A2ull, 0x2089C0CE1F9665AAull, 0x1A2F8923376CEBE2ull, 0x1BD1B4CD0A62F226ull, 0x2A5A769D7FD4E392ull, 0x15D2814B3DA721CDull, 0x50C59D3922D47C2Eull, 0x9B258F03DDE9D16ull, 0x26A73E54361123BBull, 0x755D52B1B8CDB9Aull, 0x3BD593F6469D7F27ull, 0x554BBAA23F5D3BAull, 0x378FC0AC1962E38Cull, 0x2CA5F31D60C7AE89ull, 0x2CA2DC1811AD4640ull, 0x298920DD767324FDull, 0x227FA6E24A12E1ABull, 0x16098AA73CAF3005ull, 0x17FCD8E31DB3F75ull, 0x4712222C2BDA442Bull, 0x31B023075CE4A377ull, 0x698165F80275C040ull, 0x7FB91FA57333BEE8ull, 0x40545D5626605DFAull, 0x2944E2A347AA3282ull, 0x41ED3994651A769Aull, 0xE47B1A94741F53Full, 0x9104A5445D77256ull, 0x60A4D8CB35B63D71ull, 0x269F20DF0D47B4E3ull, 0x476383B1502841BCull, 0x3BAD9E069E32A93ull},
//		{0x1A3B236819C46488ull, 0x26925A991BBAF0F6ull, 0x4B9FA3FD6DA47CC5ull, 0x479535217D4FC704ull, 0x4A89203C31169B19ull, 0x7FC587444A423FE2ull, 0x244A5A014019E49Bull, 0x70A29DDC4D8F3CA5ull, 0x7C4171D328FD770ull, 0x32A9B33F160BC8C6ull, 0x79D1CCAF3BB9FD93ull, 0x5BE33B1C5A76A57Aull, 0x71703B0402825BFCull, 0x67BE5A5D38D3BEB6ull, 0x52AA9DB86B79343Eull, 0x22B6E9496CE5C120ull, 0x53D98C6494943E2ull, 0x8A0B21650DD3CC3ull, 0x36EDC0A75035E737ull, 0x4E2D03C70176E0E4ull, 0x14C82504DF28B0Bull, 0x4BB920C62596DC52ull, 0xE0C6FA63C5BBEA2ull, 0x732618F715D086C3ull, 0x6EEB961225CFCC36ull, 0x2BDC4F8A68BD62C2ull, 0x6189C9C907BF8AA6ull, 0x4334083C52FA04CDull, 0xA41E6A22AF2629Aull, 0xBCDC3835CEC845Bull, 0x166B96D82E84ACCDull, 0x49D2457B1BA92F9Eull, 0x77CDF0AF5272F792ull, 0x6C866C612EBBB157ull, 0x22A8DEC93AB37028ull, 0x3032923B23F5611Aull, 0x8A5FB337BEBB301ull, 0x498C3D6C16B26ADAull, 0x384771A33CB25663ull, 0x2C82F19D273307B5ull, 0x62822299585F4127ull, 0xFF06A77440BEC62ull, 0x601ECBCE532472B4ull, 0x1705F12F6A60B270ull, 0x7E16D54E22D3B4B3ull, 0x474D36CB14826C26ull, 0x51586180111F7C47ull, 0x302B9BC44926522Full, 0x639273D91CB20825ull, 0x77E20386063B52A2ull, 0x5765784D281495C1ull, 0x2A30B3BC600B7380ull, 0x240048C273BCF128ull, 0x76BDDE5A5C47BA65ull, 0x306F478B2340CFF8ull, 0x37AC21B12F16A24ull, 0x7BA0111F136B2C92ull, 0x56FD56865BBEDCEDull, 0x668F9F466E0347B6ull, 0x461F8F5E64A67494ull, 0x10D6FC690D6CC629ull, 0x7928E0BA622F5DE9ull, 0x1E8C427029547C7Eull, 0x2B55B018021EB649ull},
//		{0x460684A32337B39Full, 0x85A08EC1D6BFCF0ull, 0x4B4C4960328ABCA8ull, 0x7D7770716F4C9223ull, 0x2647ADD174354ECBull, 0x4B944C8856B6F55Cull, 0x17761EC34F0F0EA3ull, 0x69A85F8113162FE3ull, 0x627A3B3640A5B607ull, 0x6ED50CD04909DA7Cull, 0x2EA8FDBD34F49C2Eull, 0x2DB04F113F7FFA26ull, 0x4261625826D92FCBull, 0x21AF580F60EDA4C8ull, 0x502DAC4A4D050828ull, 0x630C5B12163430EDull, 0x703CBBC76B6663FEull, 0x33A02DDE3B890527ull, 0x1DF120A631179E4Full, 0x2AD5974A4438CE77ull, 0x254CED1A7669E3D3ull, 0x1AEFC3D43CC30BDEull, 0x4578F27604982355ull, 0x4FD93BC127F32DACull, 0x453DD95C3EAE4891ull, 0x70FD082973E6D71Aull, 0x73A2E4C01EAD573Aull, 0x3366D14036044718ull, 0x4586870555162950ull, 0x16F1EBE015B4334Full, 0x221B317879FE46F2ull, 0x2BE8643D1257ED3Full, 0x6564AAF05F88921Bull, 0x4DE0F2660355CB97ull, 0x10A0306A78B689B1ull, 0x478E9A0E35ED1D84ull, 0x6F206D84627E5DE2ull, 0x72B0296234995FFAull, 0x6716813742896523ull, 0x5C8C8DA72C545A94ull, 0x137ADB54D8995D0ull, 0x203B31AE74DA9275ull, 0x6C36ED0A53A202EEull, 0x2ADED98D31BD740Full, 0x28B82C3E41D0C56Dull, 0x4771A75F4AD35DB6ull, 0x3BCF0C60735A0B9Cull, 0x5D2B4AF52133B750ull, 0x52E29DB72B0C3D5Cull, 0x248982E76382CE21ull, 0x23C2C70D6C181CF6ull, 0x196FEBA512E33491ull, 0x4E967AD80C201508ull, 0x477C948B35ACFC10ull, 0x4EA97A2B24092232ull, 0x620156A44FE127E0ull, 0x7192B802023C8852ull, 0x44BBBA555DC9A50Cull, 0x55DE8B406F9A93E2ull, 0xF87191C7E96B77Full, 0x316B595056F8C07Bull, 0x496A15356D3A65B0ull, 0x4A52CC172695602Bull, 0xE6E1D001D3569CEull},
//	},
//	{
//		{0x51A19D8732F79FE8ull, 0xB837EF75646494ull, 0x1F0FBCDE1A282394ull, 0x84799256DA637B6ull, 0x2648389C4FC42DB0ull, 0x235333C674F1B2C8ull, 0x73CD4FE305548A6Aull, 0x44D2DAA8656007E5ull, 0x79112BC098E94FEull, 0x4329ACF25D6F9DFDull, 0x792928E052B0C60Eull, 0x5C06557C2A948230ull, 0x29A9868925706AB1ull, 0x17CEE7E073FC52A0ull, 0x4C05CADC263D04E1ull, 0x1131BC6E1DA76863ull, 0x5934A4C911E9F45Dull, 0x130BCCF7784461A7ull, 0x2C1217F11B53661Cull, 0x65EA995D525A508Eull, 0x6B1793CD093DCD24ull, 0x474C03565EE4E3B0ull, 0xE92578E0C1EDDFEull, 0x4444EB9516236A4Bull, 0x15AD72FC076E9887ull, 0x739308480ED69BDDull, 0x5A1F5E954F995DC4ull, 0x396B1E0D03C8E51Eull, 0x7509C875513A05EEull, 0x77C537BE410F9352ull, 0x77770ACF08F6F42Cull, 0x5EB6FBB550ABAF98ull, 0x1AE0E88971C2C8ADull, 0x48F0113F46F3007Bull, 0xD162EC92EDAAA9Cull, 0x194D5109782DC296ull, 0x381877C06099545Full, 0x5712A64646AACF4Full, 0x6CB8325D1B5791DCull, 0x5CCE399A0265A55Aull, 0x22C62A63506141E2ull, 0x113C41377CE588F9ull, 0x1FFA9FA64AA75F44ull, 0xAE6E171504681Bull, 0x1BE165327873A5D6ull, 0x5613FB6D13587001ull, 0x16A9A0234CAF723ull, 0x64041F991C4B828Cull, 0x268DBFD02CF430D8ull, 0x633E830733A3EE99ull, 0x5BCEDB757C8BD410ull, 0x2BD1B13013E75335ull, 0x5D25286F02E45776ull, 0x5A92228449DD5ACCull, 0x1E3BE95237605C1Eull, 0x4C430026410213B6ull, 0x7C19E005D7F415Dull, 0x3DE79CAF27BC3DA6ull, 0x2826A0A23E960AC6ull, 0x3CC0A5C2440805D4ull, 0x3709B09C12D4A12Full, 0x576075D638744A9Full, 0x479F98523B64956Full, 0x54BFCD2B6E2D5822ull},
//		{0x6858C64837FE5032ull, 0x21D146BC4427A1BDull, 0x348A24424DA2F7ECull, 0x580EF4F211AF4CB1ull, 0x50874F6232A11777ull, 0x5B8CA77D6EC338B5ull, 0x6A01739527CFA7A4ull, 0x2FC54C6B71C31196ull, 0x54EE9016DACE91Aull, 0x197F4F3C2D7589A3ull, 0x2C42F3E0563FF4FEull, 0x717D8F78634CA47Dull, 0x6914962E48DE054Eull, 0x1BC0EF1C30B42E80ull, 0x4429ABD7080BC47ull, 0x1EE186A36C9B6105ull, 0x287F0C7940B2CD5Full, 0x30C302C25D0930BBull, 0xE55C54B08D1F7B5ull, 0x6EB87D6C5EDD14ADull, 0x3B730F2C4A4524E9ull, 0x4DA04D62257482C1ull, 0x7214CC8D7D6599CDull, 0x173794577763B58Full, 0x6B1282E730B6E394ull, 0x24D93F32175576C8ull, 0x6F6D8921656CEAAull, 0x7AA21B45700B6EC0ull, 0x5F34D3F816630A61ull, 0x20BF9D4163776EB6ull, 0x6E3C6A83FA123E4ull, 0x5012CFBB2F62D321ull, 0x53F14300D5D27Eull, 0xC6C03DC0EA9B68Eull, 0x9A7CA337B248148ull, 0x6D86CB3B451AD95Full, 0x4569A6313B27189Eull, 0x6A8F5C20377E72BFull, 0x388CB26B01C6F078ull, 0x2EE2284E239F3553ull, 0x327DD40C53BB6780ull, 0x3AF4AC1B3974AC9Eull, 0x6A12362B3596C760ull, 0x29801B5F49470A23ull, 0x4BF9D1C14A3FB8A0ull, 0x2CBE78D952DD9869ull, 0x9E0DC847CD14895ull, 0x2406B8A0A34CDC7ull, 0x7DA71B130EAC6F66ull, 0x18DE8455074EE546ull, 0x9D0F0AE06654F90ull, 0x4C69BEA54F3A96DFull, 0x418C682E36F91AC5ull, 0x6B9099E7A191A9Aull, 0x38C00B3D359B31ECull, 0x1DB84FED6B3DDF49ull, 0x956996D58ACFC08ull, 0x24B28BE87368CF98ull, 0xE43C3684E32A747ull, 0x3CAFD9BB5A3D9529ull, 0x18725FE7696E5295ull, 0x2D1B2D9222533C6Bull, 0x663F9B2A2F5B991Cull, 0x2C880A3263E6B63Dull},
//		{0x3E08088245668E87ull, 0x6B359B8347D8F930ull, 0x4BCBDE17379F5A28ull, 0x1713900F0D584646ull, 0x6E9874ED1DCC99AEull, 0x77160E02758802Bull, 0x5367CB9A2529B0CDull, 0x12965F745CBE6507ull, 0x7DD6ACD53748EB5Cull, 0x5027349F0C1A703Dull, 0x57B92A30CD70E5Bull, 0x665805661DEDF28Aull, 0x764560F0137332F8ull, 0x40412EF55C84FC1Aull, 0x42CECC146CC93927ull, 0x406BB25700D6D496ull, 0x322FC7AE2BA14DDAull, 0x48AFCDC67DFBA5C6ull, 0x6340A8025FC35DD5ull, 0xB53EC0C51D91CEFull, 0x7D8FF78312C54CECull, 0x79319D1A50F7C31Eull, 0x37EEFDB90BC7FC8Full, 0x2DB6282535C5AA8Eull, 0x4310E7EB7DDD5CC5ull, 0x41E01ACB488C7A8Full, 0xAB46B2028382031ull, 0x667A6D1900F9CC10ull, 0x3BAB532926BB9C0Full, 0x5D7EC82A7E7A1F3Dull, 0x1384D5361DEA7A81ull, 0x7F50F3D345B49CE5ull, 0x498BC85B4800C199ull, 0x43B042AB2CCC705Dull, 0x27C41F6E4F042EB7ull, 0x7EA58D4C255416F2ull, 0x61C97BA377D72A67ull, 0x764BDA1019B8795Cull, 0x39F26F624020235ull, 0x4F7E23EA46B00EE1ull, 0x21DF5EFA115E3EB5ull, 0xF3C89702C93CA1Aull, 0x39965EE675B6F68Aull, 0x2D8D962A7541B20Full, 0x1C7292990B0C5E54ull, 0x73BBD14C2FF767CFull, 0x28F6D8D5730CC51Full, 0x75AC04B47282A130ull, 0x3B0D86B8395C475Full, 0x1F4F118D62D1A626ull, 0x86076161DF49EDAull, 0x825BD186A29F1B9ull, 0x15CBC9417E719728ull, 0x3E26B15196AF037ull, 0x2273995E53608EFFull, 0x601AFF184452F858ull, 0x64BECDB46F578889ull, 0x70E6C2731E552C9Aull, 0x650E7F131E74589Dull, 0x1396DEA9018111ACull, 0x2980B6F20752AFF5ull, 0x3178797B52778FC7ull, 0x7A5F751427247E30ull, 0x44FA30F8356CFBCCull},
//		{0x6080C58F64494285ull, 0x183EA1F368E13BA6ull, 0x23DE15F20645F0Bull, 0x530B2D5F1809AAA0ull, 0x1ED5F63456ED9875ull, 0x31749AD741498F92ull, 0x2A4E2774118F99F0ull, 0x59C87EA0F0CF529ull, 0xE7227976834A5Dull, 0x2D6221C365F5A18Cull, 0x14F7A2FB40F9006Dull, 0x6776B3383E7859EDull, 0x484BB06218EF2CB3ull, 0x10EFE9B442AB2577ull, 0x4013AAE355EA1AACull, 0x7818214320947073ull, 0x3A335D321056C336ull, 0x975AC193C713E91ull, 0x30BB22425C80D978ull, 0x547AE9324F911876ull, 0x336E71ED05EF8409ull, 0x10DAA8085DBC9962ull, 0x177F1DF916772FF2ull, 0x6CC98E8B18664072ull, 0xCFA7A501A2BB04Eull, 0x7E5BE1FE21F21D4Bull, 0x5B24B0BB65D29536ull, 0x606A77382370611Eull, 0x7EC1C1EA715A60ECull, 0x661B86953ED56CCDull, 0x47447B995E33A7D8ull, 0x5F69DD400177D8CBull, 0x6E8A6B0F68DF8959ull, 0x3DE9175C1F458D51ull, 0x456062D21264008Eull, 0x6ED6A5C778CED4BFull, 0x185384987FB14DCFull, 0x568B6E212FD2A291ull, 0x16287DC14354FCACull, 0x4838E3042322F811ull, 0x5D80ACFB4694C502ull, 0x4515155C38A55DB6ull, 0x2C675A39257F8C94ull, 0x5C15BED42B291C23ull, 0x16D9ED8142314569ull, 0x69FE88F05E1E691Aull, 0x2064ED4249686631ull, 0x5F9641E50EEF5851ull, 0x3247EF8A1D7F5941ull, 0x2E34E5A277A8525Cull, 0x2FE359D01D0B8B69ull, 0x7077271C4836DE68ull, 0x1CBCD9384702953Dull, 0x780980F932E556F9ull, 0xA5791EA404263FDull, 0x56084F0B67D83EE5ull, 0x6D729001B1D6467ull, 0x207D9C9B333E8339ull, 0x409CF0FC7C935B70ull, 0x5E679F5C5776DE7Dull, 0x3EC4A0D94866284Cull, 0x359547975F298E1Bull, 0x11CE8E7D152B897Cull, 0x6E18E66C44167E08ull},
//		{0x32AAE2BD1C4DCC0Eull, 0x3BBED064628E3C8Dull, 0x395957772C35F780ull, 0x2AC51AF5561630AFull, 0x73388CBE22CE9BEFull, 0x8FB87A97D901EA8ull, 0x6310FFEC5F03D6B4ull, 0x65685D8D69E828ECull, 0x7A213B1B05E5FA28ull, 0x1D26AC253ABE2C17ull, 0x27955987B8E4B81ull, 0x12350A94413DF672ull, 0x43F473CE47CA522Bull, 0x2067848D55C3024Bull, 0x5CF5DBA70E806AFAull, 0x19D980530FA0BE65ull, 0x2ACE3708559850B8ull, 0x722EFAF264278E80ull, 0x1CE48381CF415E8ull, 0x3A3DBF2F7506D4F6ull, 0x3FC2B1D7433946D8ull, 0x7296F39E22D3B1C3ull, 0x223D1D8C57FF512Bull, 0xCBBDAB01C5E58A8ull, 0x5DE54B5429E286D5ull, 0x571C84BF605EA0ECull, 0x2570D25769518F54ull, 0x219C975E69654625ull, 0x311BE17F42041BECull, 0x3F2848700E11BD27ull, 0x508486E65901C8C4ull, 0x1DB27B8C7B52BDEEull, 0x2E9A197C0FE1767Eull, 0x5F7A4C6E306861B4ull, 0x2CD58C6619B80B9Eull, 0x256F36AB6C983E3Dull, 0x5CF1527618062A49ull, 0xF6BF0017F2E7003ull, 0x70057B751C27CAB1ull, 0x1B8CC8AB4DEAC6C9ull, 0x460A518672A94D6Aull, 0x2E4967B56B7B23DDull, 0x5BFADCBE4FE5FF14ull, 0x54E06A020D16BE3Eull, 0x11EA1B001408B273ull, 0x1B287B65626EA1E6ull, 0x6D0A7B3738DAF6F1ull, 0x5DC15FD41BA494B3ull, 0x48BC6D6F3D3BAC43ull, 0x4C0CF6677591F9D6ull, 0x56F3B7E1717C2D12ull, 0x622A381333E50A57ull, 0x982575C71962814ull, 0x33137A5A7987D2D1ull, 0xDBDF2C54EA04305ull, 0x4772999A53C8444Cull, 0x4149907075BC014Full, 0x3F4368291D446D2Eull, 0x45A200631423D22Cull, 0x2A5B2B6C578C1B63ull, 0x282C849F4583A6D1ull, 0x39FABD491536FFD6ull, 0x7E5E9DC217BC1D1Eull, 0x30DB9489471B0B32ull},
//		{0x54F7C9617CE88AF0ull, 0x3CAD05082BEB8142ull, 0x6E64B8031ED73D1Bull, 0x5FD08B9977E70F5Full, 0x106D653012E405F4ull, 0x716EE2301E2B57F5ull, 0x618448F938E17BCAull, 0x71F39C4122CDD969ull, 0x2E9D7D193137046Bull, 0x40124698743F7D7Dull, 0x455AD6976A6D7204ull, 0x4BCB98E06D875B36ull, 0x2FF118D605C6562Aull, 0x2BE5B0C2E4FB698ull, 0x1D8273483399EF95ull, 0x756AC1CA727A3CA9ull, 0x30827A853217C6D2ull, 0x1E65BDEB1EE73288ull, 0x50EF03EE7E364984ull, 0x16CE41E7615C691Eull, 0x111A4F78083D2417ull, 0x7F87C113729E9872ull, 0x411E9FE1717B5D55ull, 0x156C71DB6FBC1CFBull, 0x22B261C0557EB873ull, 0x63FB9A78680D3857ull, 0x3FEC2A782FC73358ull, 0x5594938D6FDD434Eull, 0x358D89825852EE99ull, 0x1E2CF9E6530FFCCAull, 0xBECDE2E1397BBB1ull, 0x458A39733C6F58B3ull, 0x45AF828363EFF75Eull, 0x5B568B3C169E8671ull, 0x622640E37224CD23ull, 0x77FAEF8F7340905Bull, 0x7A61F13B7782B0A3ull, 0x65DF28CD3B80911Cull, 0x68FE0DF87B4B9AA9ull, 0x2B3CAE170BB06FB8ull, 0x50CA531C0F38488Full, 0x73BDA80F10B67D94ull, 0x3EFF7BE849523B9Cull, 0x93C0E2748D056Aull, 0x21A52A351EC0BAC9ull, 0x479D02352D920863ull, 0x3258767A0D273BA8ull, 0x6A0161167807F8FDull, 0x711733074557EC52ull, 0xEA67F6F533D73EAull, 0x377CB97606A16EFEull, 0x467E044531DEAAB1ull, 0x7E241FA12C5D2D13ull, 0x6D5F3BCD67222D99ull, 0x27A8C7BC189BE9E5ull, 0x72D29D5178731AD8ull, 0x27D4327466904560ull, 0x929986D66D3AE5Cull, 0x2FE280FC09BD594Full, 0x5B60B3C75187AB31ull, 0x287E141822FDB5FCull, 0x7F19B3945AD68A92ull, 0x3024F1A4691B14ABull, 0x52DE8390213C24ABull},
//		{0x2E7300FD618502FFull, 0x7479989565EFBA73ull, 0x682671FD3AF79CDBull, 0x17CE6524664A919Full, 0x6754C9EE052DA0F2ull, 0x4D6CBF380EFD91AAull, 0x1DC98AD7403F5C8Aull, 0x770AC82459DBD4Bull, 0x26CFA1EA109A44EFull, 0x2C716BA856B222E7ull, 0x1A579E3F07D21F6Full, 0x2839CE1842D5B257ull, 0x2ACFD56B275381ADull, 0x1DAC3CEA5AF4C70Full, 0x106E9658708AC07Aull, 0x7C30EBBB3EE19755ull, 0x520FC37970AA8450ull, 0x24D151C93A363576ull, 0x2BA2212B3C9FB6EDull, 0x2080C71512F6EB19ull, 0x41CD57DF6DED864Eull, 0x21F47CC35F96E2B6ull, 0x2E2CE2D829652946ull, 0x2534A00254FC84C2ull, 0x39FF6E3551A60BAAull, 0x2BAEA7A954570C74ull, 0x59782B1953E875C2ull, 0x172CBECC04480084ull, 0x7B3BF76F34D8FBB6ull, 0x5F3CC7930BAA8DC7ull, 0x2563BC305B6DB34Eull, 0x4A8C251C77737FA9ull, 0x4C18379F6F5D76E5ull, 0x31A9B51F77BA58CAull, 0x2BFD2DD3522A7C35ull, 0xAB143E46DCA85B2ull, 0x401802832CA5C0A7ull, 0x4D6168696E44E55Bull, 0x560AE9ED7296086Bull, 0x43416A1D100A5823ull, 0x443C14156EF011C7ull, 0x646164971DB43F2Eull, 0x42D887897B8E2363ull, 0x21FC3FB23E147EF8ull, 0x30671F1901390745ull, 0x49BF0CBF55CADB49ull, 0x5CA6BA94144B31DBull, 0x4D3E5AF228BEF233ull, 0x3A8A8C17EE81012ull, 0x20794AFD2FA5D694ull, 0x51128C472B2A8EE1ull, 0x1D705C46112A8ECAull, 0x57D04F896AD1C4AFull, 0x7F6F74252DDB3976ull, 0x5D67CD1A42B0DE42ull, 0x3DE5919921A3E12Full, 0x31A0F0092246F631ull, 0x3F58205D74797792ull, 0x1DD519946154600Full, 0x328DF68A4E3C38AEull, 0x628D67557C4D0349ull, 0x240713F73F3421E9ull, 0x1098352571456EEAull, 0x67F3141C1440DDE6ull},
//		{0x702D7EFC086C5F19ull, 0x43E6B47A41400B43ull, 0x3396EDFB615710C0ull, 0x526A9A0D0B673D84ull, 0x4C28D57051DA0E32ull, 0x394276FA2990A28Aull, 0x148AEC7477280894ull, 0x4B3483BA462BDC7Eull, 0x196EFEC50A8CA417ull, 0x3AA5541037441859ull, 0x6BE104276D334A9Bull, 0x58051074E6E6B7Cull, 0x69804DE4298764FFull, 0xDA28D657A188309ull, 0x1ACCD3E97595A181ull, 0xE5960EF0AFA52E5ull, 0x7E02009A52401569ull, 0x4C3A5E283198EE95ull, 0x3397262A1EA4F835ull, 0x3D002C197FBFFB9Aull, 0x707F06677642A314ull, 0x29509E240509F2DBull, 0x6D6AABA8748521DEull, 0x4B35CF5906D9AA6Dull, 0x7F11C5F605DB236Aull, 0x3E1DC2C66AF2CA1Dull, 0x730E6E05439E13CEull, 0x396135995C8EBBE9ull, 0x6D2578CD4703C2FEull, 0x56A73EF307F24CB6ull, 0x3C99647F65009FE2ull, 0x12EC9F9B3A9B6519ull, 0x3740B54C5F26FDC3ull, 0x6C3453AF6AD7DB76ull, 0x7DCBF5F829347FC8ull, 0x6A97D7106E4AFC5Full, 0x1F7722DC13E87534ull, 0x7354EF3A0CE1CE84ull, 0x86D97133E8ABE94ull, 0x13BB78F1077F5D09ull, 0x4465E1FE51D93BB8ull, 0x7272272637745003ull, 0x15774F862BD35CBFull, 0x14030BEC029CC853ull, 0x72D71FBD6AAA4ADFull, 0xA8F15092F70843Cull, 0x4FAAEAC21D7BB4A4ull, 0x6A0BE95506EBA00Eull, 0x7CA2B26756403D04ull, 0x71C37B847A6EA85Full, 0x7F74BCCD5C5B5294ull, 0x68B9A4BE1EEBDFA9ull, 0x7043C7C85C0E93F8ull, 0x2BCDAE2E78B15EDBull, 0x1A99528C3F89271Full, 0x30BBE45EFF348Aull, 0x116262D772A2E30Aull, 0x1673848D26D9B25Dull, 0x1E763FC92A76907Aull, 0x29767AB0114D5F86ull, 0x1520DB5934058FB9ull, 0x40BDE3C264CBC61Bull, 0x5181445D2AC9CD18ull, 0x6BB766294E23F6C4ull},
//		{0x10A0A1C5D7AE1ADull, 0x48929F23007EC6E9ull, 0x39D63441314C43E1ull, 0x1F6AA6932A19FC0Aull, 0xD5AD7DA4B3854C1ull, 0x22CB5AE527F42A66ull, 0xAC17BE022FC16CAull, 0x6F35EF11C23DEB8ull, 0x159EF9D41D66E37Eull, 0x42FD91153415399Eull, 0x47DD73F86C740BC6ull, 0x456299245CFE4F52ull, 0x20799B7F06207CE7ull, 0x41CA156D71FADFDDull, 0x30EA49FF2D817B97ull, 0x401ED6A131F4541Bull, 0xAFC5D4408B175C5ull, 0x32731B0544D29186ull, 0x39FDB9A651DDC198ull, 0x6EEC8D9047589180ull, 0x1D16165911B7E875ull, 0x6F4CBBE727D79239ull, 0x34B3FF3F76401AD8ull, 0x43FB70F14A52F914ull, 0x13A6FE5606F90207ull, 0x7E6832B25B84724Full, 0x736D0DCD43CACBD6ull, 0x3882C1A113E6A94Cull, 0x49EB48BD7A4CD70Eull, 0x5E189297AD592BCull, 0x27CE52A546005FCBull, 0x2CC9E6D832CAAFEAull, 0x4EB1D5905F3D01DDull, 0x779D417008AF8F36ull, 0x311AC3756689CF00ull, 0x500820B74E30D9CEull, 0x7841B7753F54DC9Eull, 0x76086C072CF5B6B5ull, 0x3594F7763A03DCF9ull, 0x7748AFC9493BF5CCull, 0x40FCDF0075B0E27Bull, 0x24C0681B3469ECCDull, 0x397BAE515D4329BCull, 0x485096190366F70Full, 0x579000CB4E321F43ull, 0x7E3C89CB7F5E5370ull, 0x14327F0E2B0670A3ull, 0x3229035A62E4549Eull, 0xA43728029C644CAull, 0x6B93E3D43B5E35F5ull, 0x105013CA3B9C048Bull, 0x98F0FC30891CB40ull, 0x7AF0E1297F977BCBull, 0x358781F53085D89Full, 0x399B58C42CD031BEull, 0x79C1CE6C7A9837C4ull, 0x228114391E823687ull, 0x2F0224915BFCC28Aull, 0x7BC560447752BAAAull, 0x5F63B9995355610Full, 0x4584D9ED5DA04365ull, 0x52B3B47F59B758FBull, 0x8A6B40804DCB7DAull, 0x3C9BAD9912EA2689ull},
//		{0x2EA2FCA4282F916Eull, 0x4E485C7E3EF3106Full, 0x63CB95F957D76C42ull, 0x4784DBAF5EBC7723ull, 0x576EE80D7D0C5DA4ull, 0xF424FC2110A40D1ull, 0x29DC8F6209041E2Eull, 0xBA278954C5DA39Bull, 0x278654B63AA49D26ull, 0x285A6625234BB4FAull, 0x31F757D007BE1FBFull, 0x76A11609777C31BEull, 0x655E63244954CA88ull, 0x51338AB96E05172Cull, 0x4E3182620DCF3853ull, 0xEF3DB57CD47F07ull, 0x35FEC9C14F379A34ull, 0x3BC78F7619CA5FBAull, 0x270F0676034C6B25ull, 0x7886D6DD7E7DEE83ull, 0x58C8C907C926A0ull, 0xF882F542A35582Bull, 0x10CD44CE1B2AA7E9ull, 0x7692FBC638539984ull, 0x55CF450F1EED61EBull, 0x5B9F4E7E07C69CDFull, 0x26AB81AA52406487ull, 0x7F42CE9D0C09E4CEull, 0x1B952F1050765957ull, 0x7A0EFBFB69C6B172ull, 0x5E4591AA7AFE39B0ull, 0x669B307914445B6Bull, 0x4A35D3E42262BFEFull, 0x2E0EBB257144DA5Aull, 0x25AF2B1426959203ull, 0x6FC2C8DD2607F3DDull, 0x2E5EB8A37F4AF831ull, 0x503D4C083F2BFD71ull, 0x1A75A01A46D047CEull, 0x777F96F67044E529ull, 0x65BDA9BA531EE574ull, 0x780B82090C692B64ull, 0x255F49FC774E50A6ull, 0x1873103340F4790Cull, 0x47C4A9FD12820C2Eull, 0x2ABB2A7E260A3BA7ull, 0xD8045DE11565AF8ull, 0x3A4E971257B619C3ull, 0x33B91AE7685D5238ull, 0x48FAF41D596845FCull, 0xEF2E43B38BDBCFBull, 0x7F7039D93D519CDEull, 0x3808B52C4FAD85E2ull, 0x7C7D9A4F527E5547ull, 0x167DCDB073FD3145ull, 0x42C33A707C3B776Aull, 0x471C16BA3ACEBC79ull, 0x8A4A2CF6C7B60B6ull, 0x321D0D202117B302ull, 0x2D6FD9C279E1B71Dull, 0x3399BF30582B0440ull, 0x1FEBF2C5411A050Eull, 0x69815F385A3A89D7ull, 0x18D01ED11D3A7A20ull},
//		{0x4297DC0F61CB12EFull, 0x76A2C01C518AC04Aull, 0x1A88CFEA7612F9F5ull, 0xEDC5D2852918516ull, 0x45C07FD70B59F778ull, 0x250FDA5D5C3E4D88ull, 0x7F5728BD67D314CEull, 0x5879C4F246733F77ull, 0x22A1D147611E67C1ull, 0x32EEA02D54BEDE67ull, 0x2361AC3605E79EFull, 0x4EA0958535CFD9F3ull, 0x38897E306E8C884Aull, 0x76E9DF02220ADD68ull, 0x48C712210FB9FDD3ull, 0x3F4557880B5EEE31ull, 0x718510C235E817A4ull, 0x5CE9AE7B0C0DE0ACull, 0x2BFB119A6BC60BA4ull, 0x5E9F65C371BB9171ull, 0x7720031C03AF4020ull, 0x4DF9DEF976772BD9ull, 0x6B8254EE2673A3ECull, 0x3CEA6B510E242636ull, 0x7920BAD6FD90B7Eull, 0x62E3049D09C82671ull, 0x5037856E31839A22ull, 0x3F98006408C1039Eull, 0x2010226C3681DF66ull, 0x2ACBE10668D7348Eull, 0x463BDD3A6A11388Full, 0x743622BF37C0EDFCull, 0x1FF95033511FD13Aull, 0x43CECEA94BF461CDull, 0x3CE5DCDE226E346Cull, 0x3DAFF33F3405DFFAull, 0x261D748C0BA9D238ull, 0x2A7D0BD4119FC97Bull, 0x321D762467677725ull, 0x1FC3EFB139AF81D2ull, 0x574082A302A6F44Eull, 0x4377A84327780811ull, 0x342A8E71030FA8A7ull, 0x30390BAF543AB0DDull, 0x3991880E5B04ECB6ull, 0x3D11E56B7FCD6548ull, 0x451625453148082Aull, 0x378E5344650F7578ull, 0x267D9657B5D21EDull, 0x3103D7463F4DB643ull, 0x1DCB56596EB3CA85ull, 0x7353963E43E8CAE6ull, 0x7A5D9CBD1DD0A212ull, 0x558894612C7B12E2ull, 0x5381937754C8412ull, 0x662A94B45C789BDAull, 0x77F3786029A23CF7ull, 0x3F0A3EC2C1E06D1ull, 0x2CB1E59E3429AF9Bull, 0x58B7AF66436DACull, 0xF2E9C513D6A9D1Aull, 0x6610D2F45444C196ull, 0x6EB2A5451D9F2639ull, 0x3954370F711A7EAAull},
//	}, 
//};


BloomFilter::BloomFilter(uint64_t filterSize, int numHash, bool save, bool zero)
{
	this->filterSize = filterSize;
	this->numHash = numHash;
    saveAtExit = save;
	bits = new BitVector(filterSize);
}

BloomFilter::BloomFilter(uint64_t filterSize, int numHash, const char *loadPrefix)
{
	this->filterSize = filterSize;
	this->numHash = numHash;
    saveAtExit = false;
	bits = new BitVector(filterSize);
	saveAtExit = false;

	char name[127];
	sprintf(name, "%sbloom-%" PRId64 "-%d.dat", loadPrefix, filterSize, numHash);
	printf("Loading '%s'\n", name);
	bits->Load(name);
}

BloomFilter::BloomFilter(uint64_t numItems, double targetFalseRate, bool save, bool zero)
{
	double min_m = std::numeric_limits<double>::infinity();
	double min_k = 0.0;
	double curr_m = 0.0;
	double k = 1.0;
	
	while (k < 5) // limit to 4 hash functions
	{
		double numerator   = (- k * numItems);
		double denominator = std::log(1.0 - std::pow(targetFalseRate, 1.0 / k));
		curr_m = numerator / denominator;
		if (curr_m < min_m)
		{
			min_m = curr_m;
			min_k = k;
		}
		k += 1.0;
	}
	numHash = static_cast<unsigned int>(min_k);
	filterSize = static_cast<unsigned long long int>(min_m);
	saveAtExit = save;
	if (0)
	{
//		char name[127];
//		sprintf(name, "/tmp/bloom-%" PRId64 "-%d.dat", filterSize, numHash);
//		bits = new BitVector(filterSize, name, zero);
	}
	else {
		bits = new BitVector(filterSize);
	}
}

BloomFilter::~BloomFilter()
{
	if (saveAtExit)
	{
		char name[127];
		sprintf(name, "bloom-%" PRId64 "-%d.dat", filterSize, numHash);
		printf("Writing to '%s'\n", name);
		bits->Save(name);
	}
	delete bits;
	bits = 0;
}

void BloomFilter::Analyze()
{
	uint64_t entries = bits->GetSize();
	uint64_t setEntries = bits->GetNumSetBits();
	printf("%" PRId64 " of %" PRId64 " entries set. (%4.2f%%)\n", setEntries, entries, 100*double(setEntries)/double(entries));
}

void BloomFilter::Load()
{
	saveAtExit = false;
	char name[127];
	sprintf(name, "bloom-%" PRId64 "-%d.dat", filterSize, numHash);
	bits->Load(name);
}

void BloomFilter::Insert(uint64_t item)
{
	for (int x = 0; x < numHash; x++)
	{
		bits->SetTrue(Hash(item, x)%filterSize);
	}
}

bool BloomFilter::Contains(uint64_t item)
{
	for (int x = 0; x < numHash; x++)
	{
		if (!bits->Get(Hash(item, x)%filterSize))
			return false;
	}
	return true;
}

uint64_t BloomFilter::Hash(uint64_t value, int which)
{
	value ^= salt[which];
	uint64_t result = 0;
	for (int x = 0; x < 8; x++)
	{
		result ^= zobrist[x][(value)&0xFF];// [8 possible hashes][13x 5-bit segments][32 values for 5 bits]
		value >>= 8;
	}
//	for (int x = 0; x < 10; x++)
//	{
//		result ^= zobrist[which][x][(value>>(6*x))&0x3F];// [8 possible hashes][13x 5-bit segments][32 values for 5 bits]
//	}
	return result;
}
