// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: useless.cpp 938 2016-05-27 10:33:49Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "useless.h"
#include "common/option.h"
#include "search/transition.h"
#include "system/state.h"

using namespace std;

Useless::Useless(const Task* task, const Options* opts) :
    Heuristic(task, opts),
    abstr(task)
{}

int32_t Useless::isUseless(const State* state, const Transition* trans) {
    if (trans == NULL) {
        return INT_MAX;
    }
    const vector<bool>* abstracted = abstr.abstractSystem(trans);
    return evalAbstracted(state, *abstracted);
}

int32_t Useless::compute(const State* state) {
    bool notused;
    return compute(state, notused);
}

int32_t Useless::compute(const State* state, bool& useless) {
    static vector<bool> noAbstraction(abstr.getNrEdges(), false);
    useless = false;
    int32_t heur = evalAbstracted(state, noAbstraction);
    if (heur == INT_MAX) {
        return INT_MAX;
    }

    useless = (isUseless(state->predecessor, state->reachedby) <= heur);
    return heur;
}
