// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: system_abstractor.h 938 2016-05-27 10:33:49Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef USELESS_SYSTEM_ABSTRACTOR_H
#define USELESS_SYSTEM_ABSTRACTOR_H

#include <inttypes.h>
#include <vector>

class Edge;
class Task;
class Transition;

class SystemAbstractor {
private:
    void abstractEdges(const Edge* edge, std::vector<bool>& abstracted) const;
    void abstractIntegers(const Edge* edge, std::vector<bool>& abstracted) const;
    void abstractClocks(const Edge* edge, std::vector<bool>& abstracted) const;

    const std::vector<bool>* abstractSystem(const Edge* edge);
    const Task* task;
    const uint32_t nrEdges;
    std::vector<std::vector<bool>* > abstractedEdges;
public:
    SystemAbstractor(const Task* task);

    uint32_t getNrEdges() const {return nrEdges; }

    const std::vector<bool>* abstractSystem(const Transition* trans);
};

#endif /* SYSTEM_ABSTRACTOR_H */
