// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: gdu.h 938 2016-05-27 10:33:49Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef USELESS_GD_HEURISTIC_H
#define USELESS_GD_HEURISTIC_H

#include "ul_heuristic/useless.h"
#include <vector>

class State;
class GDSUMHeuristic;
class GDMAXHeuristic;

template<class gdheuristic>
class GDUselessHeuristic : public Useless {
protected:
    gdheuristic heuristic;

    virtual int32_t evalAbstracted(const State* state, const std::vector<bool>& abstracted) {
        heuristic.init(abstracted);
        return heuristic.eval(state);
    }

public:
    GDUselessHeuristic(const Task* task, const Options* opts) :
        Useless(task, opts),
        heuristic(task, opts)
    {}
};

typedef GDUselessHeuristic<GDSUMHeuristic> GDSUMUselessHeuristic;
typedef GDUselessHeuristic<GDMAXHeuristic> GDMAXUselessHeuristic;

#endif /* USELESS_GD_HEURISTIC_H */
