// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: tapl.cpp 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "system/system.h"
#include "system/target.h"
#include "system/task.h"
#include "system/parser.h"
#include "common/message.h"
#include <iostream>
#include <unistd.h>

using namespace std;

int main(int argc, char* argv[]) {
    bool oldSyntax = false;

    int c;
    while ((c = getopt(argc, argv, "s")) != -1) {
        switch (c) {
        case 's':
            oldSyntax = true;
            break;
        default:
            cout << "error: unknown option" << endl;
            break;
        }
    }
    if (argc - optind != 2) {
        error() << "not enough arguments" << endl;
    }

    Task* task = SystemParser::parser()(argv[optind], argv[optind + 1], oldSyntax);
    System* system = task->system;
    Target* target = task->target;

    cout << *system << endl << endl;
    cout << *target << endl;
}
