// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: safeabs.h 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SAFE_ABSTRACTOR_H
#define SAFE_ABSTRACTOR_H

#include "causalgraph/cg_variable.h"
#include "causalgraph/idmapper.h"

#include <vector>

class Task;

namespace cg {
class CausalGraph;
class CGVariable;
class CGOperator;
class DTG;
}

class SafeAbstractor {
private:
    void initCGVariables(const System* system);
    void initGlobalVariables(const System* system);
    void initLocalVariables(const System* system);
    void initCGOperators(const System* system);

    const Task* task;
    std::vector<cg::CGVariable*> variables;
    std::vector<cg::CGOperator*> operators;
    std::vector<cg::DTG*> dtgs;

    IDMapper local_to_global_id;

public:
    SafeAbstractor(const Task* task);
    void get_safe_variables(std::vector<cg::CGVariable*>& safevars);
};

#endif /* SAFE_ABSTRACTOR_H */
