// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: pdbgen.cpp 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "edge.h"
#include "explorer.h"
#include "graph.h"
#include "options.h"
#include "parser.h"
#include "tester.h"

#include "common/memstat.h"

#include <iostream>

using namespace std;

int main(int argc, char** argv) {
    option opts = parse_cmd(argc, argv);
    if (!opts.quiet) {
        MemStat::getMemStat();
    }
    if (opts.verbose) {
        opts.show();
    }
    Parser p;
    Explorer exp(p.parse(opts.input_filename.c_str()));
    exp.explore();
    exp.graph->show(opts.output_filename.c_str(), opts);
    if (opts.test) {
        GraphTester tester;
        tester.test(exp.graph);
    }
}
