// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: options.h 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <iosfwd>

struct option {
    std::string input_filename;
    std::string output_filename;
    bool quiet;
    bool include_dead_end;
    bool verbose;
    bool test;

    option() {
        input_filename = "/dev/stdin";
        output_filename = "";
        quiet = true;
        include_dead_end = false;
        verbose = false;
        test = false;
    }

    void print_help(int argc, char** argv) const;
    void show() const;
};

option parse_cmd(int argc, char** argv);

#endif /* OPTIONS_H */
