// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: options.cpp 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "options.h"
#include <iostream>
#include <unistd.h>
#include <cstdlib>

using namespace std;

void option::print_help(int, char** argv) const {
    cout << "Usage: " << argv[0] << " [options] input_file" << endl
         << "   options:" << endl
         << "      -h         print help" << endl
         << "      -m         print time/mem statistics" << endl
         << "      -o FILE    store PDB in FILE" << endl
         << "      -i         include dead end states in output" << endl
         << "      -v         be verbose" << endl
         << "      -t         run sanity checks on computed PDB (can take several minutes, even for small examples)" << endl;
}

void option::show() const {
    cout << "Used options:" << endl
         << "   report dead end states:  " << (include_dead_end ? "yes" : "no") << endl
         << "   include dead end states: " << (include_dead_end ? "yes" : "no") << endl;
}

option parse_cmd(int argc, char** argv) {
    option opts;
    int c;
    while ((c = getopt(argc, argv, "himo:vt")) != -1) {
        switch (c) {
        case 'h':
            opts.print_help(argc, argv);
            exit(EXIT_SUCCESS);
            break;
        case 'i':
            opts.include_dead_end = true;
            break;
        case 'm':
            opts.quiet = !opts.quiet;
            break;
        case 'v':
            opts.verbose = true;
            break;
        case 'o':
            opts.output_filename = optarg;
            break;
        case 't':
            opts.test = true;
            break;
        default:
            cerr << "Error: there is no option '-" << char(c) << "'" << endl;
            opts.print_help(argc, argv);
            exit(EXIT_FAILURE);
            break;
        }
    }
    for (int i = optind; i < argc; i++) {
        opts.input_filename = argv[i];
    }

    if (opts.output_filename == "") {
        cerr << "Error: no output file given." << endl;
        exit(EXIT_FAILURE);
    }

    return opts;
}
