// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: open.h 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef OPEN_H
#define OPEN_H

#include <deque>
#include <vector>
#include "edge.h"
#include "node.h"

class OpenQueue {
    std::deque<Node*> queue;
    std::vector<bool> members;
public:
    OpenQueue(int size) :
        queue(), members(size, false) {}

    void pop_front();
    void push_back(Node* node);
    Node* front() const;
    bool empty() const;
};

inline void OpenQueue::pop_front() {
    members[queue.front()->getId()] = false;
    queue.pop_front();
}

inline void OpenQueue::push_back(Node* node) {
    if (members[node->getId()] == false) {
        members[node->getId()] = true;
        queue.push_back(node);
    }
}

inline Node* OpenQueue::front() const {
    return queue.front();
}

inline bool OpenQueue::empty() const {
    return queue.empty();
}

#endif /* OPEN_H */
