// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: node.h 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef NODE_H
#define NODE_H

#include <ext/slist>
#include <string>
#include <iosfwd>

class Edge;

class Node {
public:
    typedef __gnu_cxx::slist<Edge*> edge_t;
    edge_t in;
    edge_t out;
    std::string label;
    int id;
    int distance;

    typedef edge_t::const_iterator const_iterator;
    typedef edge_t::iterator iterator;

    explicit Node(int id);
    void addIncoming(Edge* edge);
    void addOutgoing(Edge* edge);
    int getId() const {return id; }

    iterator begin() {return in.begin(); }
    iterator end() {return in.end(); }

    const_iterator begin() const {return in.begin(); }
    const_iterator end() const {return in.end(); }

    bool operator<(const Node& rhs) const {return label < rhs.label; }
    bool operator==(const Node& rhs) const {return id == rhs.id; }
    bool operator!=(const Node& rhs) const {return id != rhs.id; }
};

std::ostream& operator<<(std::ostream& o, const Node& n);

#endif /* NODE_H */
