// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: node.cpp 844 2011-10-13 22:05:28Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#include "node.h"
#include "edge.h"
#include <iostream>
#include <climits>
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH

using namespace std;

Node::Node(int id) :
    id(id),
    distance(INT_MAX)
{}

void Node::addIncoming(Edge* edge) {
    foreach(const Edge* e, in) {
	if (*edge == *e) {
	    return;
	}
    }
    in.push_front(edge);    
}

void Node::addOutgoing(Edge* edge) {
    foreach( const Edge* e, out) {
	if (*edge == *e) {
	    return;
	}
    }
    out.push_front(edge);    
}

ostream& operator<<(ostream& o, const Node& n) {
    return o << n.label;
}


